/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.dicom.CJKsupport;
import com.ge.med.terra.tap.util.dicom.DicomCharSet;
import com.ge.med.terra.tap.util.dicom.PersonName;
import com.ge.med.terra.tap.util.dicom.vr;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;

public class tagValue
implements Comparable,
Serializable {
    public int group;
    public int element;
    public long fileOffset;
    public int len;
    public int vrep;
    public String privateCID;
    public Object value;
    public byte[] valueAsBytes;
    public boolean littleEndian;
    public boolean fillValue = true;

    public tagValue() {
    }

    public tagValue(int g, int e) {
        this.group = g;
        this.element = e;
    }

    public tagValue(tagValue other) {
        this.group = other.group;
        this.element = other.element;
        this.fileOffset = other.fileOffset;
        this.len = other.len;
        this.vrep = other.vrep;
        this.privateCID = other.privateCID;
        this.value = other.value;
        this.valueAsBytes = other.valueAsBytes;
        this.littleEndian = other.littleEndian;
        this.fillValue = other.fillValue;
    }

    public long getOffset() {
        return this.fileOffset;
    }

    public void setOffset(long offset) {
        this.fileOffset = offset;
    }

    private static void clearData(Object[] tvArray) {
        if (null == tvArray) {
            return;
        }
        for (int i = 0; i < tvArray.length; ++i) {
            Object[] item = (Object[])tvArray[i];
            for (int j = 0; j < item.length; ++j) {
                tagValue elem = (tagValue)item[j];
                if (elem.vrep == 21329) {
                    tagValue.clearData((Object[])elem.value);
                } else {
                    elem.clearData();
                }
                item[j] = null;
            }
        }
    }

    public void clearData() {
        if (this.vrep == 21329) {
            tagValue.clearData((Object[])this.value);
        }
        this.group = 0;
        this.element = 0;
        this.fileOffset = 0L;
        this.len = 0;
        this.vrep = 0;
        this.privateCID = null;
        this.value = null;
        this.valueAsBytes = null;
        this.littleEndian = false;
        this.fillValue = true;
    }

    protected void prepareToFill() {
        this.fileOffset = 0L;
        this.len = 0;
        this.vrep = 0;
        this.value = null;
        this.valueAsBytes = null;
    }

    public static void copyFillData(tagValue src, tagValue dest) {
        dest.fileOffset = src.fileOffset;
        dest.len = src.len;
        dest.vrep = src.vrep;
        dest.value = src.value;
        dest.valueAsBytes = src.valueAsBytes;
        dest.littleEndian = src.littleEndian;
    }

    public PersonName getPersonName() {
        switch (this.vrep) {
            case 20558: {
                String str = this.value.toString();
                PersonName pn = new PersonName(str);
                return pn;
            }
        }
        throw new IllegalStateException("Unable to represent " + vr.toString(this.vrep) + " data element as a PersonName object.");
    }

    public void setData(byte[] data, int off, boolean littleEndian, String tag_8_5) {
        DicomCharSet[] dicomCharsets = DicomCharSet.getDicomCharSets(tag_8_5);
        this.setData(data, off, littleEndian, dicomCharsets);
    }

    public void setData(byte[] data, int off, boolean littleEndian, DicomCharSet[] dicomCharsets) {
        this.littleEndian = littleEndian;
        switch (this.vrep) {
            case 16724: {
                boolean useLegacyATFormat = Tap.getProperty("tap.dicom.tagvalue.uselegacyATformat", "false").equalsIgnoreCase("true");
                if (useLegacyATFormat) {
                    Integer[] tvalue = new Integer[this.len / 2];
                    int count = 0;
                    int incr = 0;
                    while (count < tvalue.length) {
                        int t1 = data[off + 0 + incr] & 0xFF;
                        int t2 = data[off + 1 + incr] & 0xFF;
                        tvalue[count++] = littleEndian ? new Integer(t1 | t2 << 8) : new Integer(t2 | t1 << 8);
                        incr += 2;
                    }
                    if (count == 1) {
                        this.value = tvalue[0];
                        break;
                    }
                    this.value = tvalue;
                    break;
                }
                int[] tvalue = new int[this.len / 2];
                int count = 0;
                int incr = 0;
                while (count < tvalue.length) {
                    int t1 = data[off + 0 + incr] & 0xFF;
                    int t2 = data[off + 1 + incr] & 0xFF;
                    tvalue[count++] = littleEndian ? t1 | t2 << 8 : t2 | t1 << 8;
                    incr += 2;
                }
                if (count == 1) {
                    this.value = tvalue[0];
                    break;
                }
                this.value = tvalue;
                break;
            }
            case 21836: {
                Long[] tvalue = new Long[this.len / 4];
                int count = 0;
                int incr = 0;
                while (count < tvalue.length) {
                    int t1 = data[off + 0 + incr] & 0xFF;
                    int t2 = data[off + 1 + incr] & 0xFF;
                    int t3 = data[off + 2 + incr] & 0xFF;
                    int t4 = data[off + 3 + incr] & 0xFF;
                    tvalue[count++] = littleEndian ? new Long(t1 | t2 << 8 | t3 << 16 | t4 << 24) : new Long(t4 | t3 << 8 | t2 << 16 | t1 << 24);
                    incr += 4;
                }
                if (count == 1) {
                    this.value = tvalue[0];
                    break;
                }
                this.value = tvalue;
                break;
            }
            case 21324: {
                Integer[] tvalue = new Integer[this.len / 4];
                int count = 0;
                int incr = 0;
                while (count < tvalue.length) {
                    int t1 = data[off + 0 + incr] & 0xFF;
                    int t2 = data[off + 1 + incr] & 0xFF;
                    int t3 = data[off + 2 + incr] & 0xFF;
                    int t4 = data[off + 3 + incr] & 0xFF;
                    tvalue[count++] = littleEndian ? new Integer(t1 | t2 << 8 | t3 << 16 | t4 << 24) : new Integer(t4 | t3 << 8 | t2 << 16 | t1 << 24);
                    incr += 4;
                }
                if (count == 1) {
                    this.value = tvalue[0];
                    break;
                }
                this.value = tvalue;
                break;
            }
            case 21331: {
                Integer[] tvalue = new Integer[this.len / 2];
                int count = 0;
                int incr = 0;
                while (count < tvalue.length) {
                    short t1 = (short)(data[off + 0 + incr] & 0xFF);
                    short t2 = (short)(data[off + 1 + incr] & 0xFF);
                    tvalue[count++] = littleEndian ? new Integer((short)(t1 | t2 << 8)) : new Integer((short)(t2 | t1 << 8));
                    incr += 2;
                }
                if (count == 1) {
                    this.value = tvalue[0];
                    break;
                }
                this.value = tvalue;
                break;
            }
            case 21843: {
                Integer[] tvalue = new Integer[this.len / 2];
                int count = 0;
                int incr = 0;
                while (count < tvalue.length) {
                    int t1 = data[off + 0 + incr] & 0xFF;
                    int t2 = data[off + 1 + incr] & 0xFF;
                    tvalue[count++] = littleEndian ? new Integer(t1 | t2 << 8) : new Integer(t2 | t1 << 8);
                    incr += 2;
                }
                if (count == 1) {
                    this.value = tvalue[0];
                    break;
                }
                this.value = tvalue;
                break;
            }
            case 17996: {
                Float[] tvalue = new Float[this.len / 4];
                int count = 0;
                int incr = 0;
                while (count < tvalue.length) {
                    int t1 = data[off + 0 + incr] & 0xFF;
                    int t2 = data[off + 1 + incr] & 0xFF;
                    int t3 = data[off + 2 + incr] & 0xFF;
                    int t4 = data[off + 3 + incr] & 0xFF;
                    tvalue[count++] = littleEndian ? new Float(Float.intBitsToFloat(t1 | t2 << 8 | t3 << 16 | t4 << 24)) : new Float(Float.intBitsToFloat(t4 | t3 << 8 | t2 << 16 | t1 << 24));
                    incr += 4;
                }
                if (count == 1) {
                    this.value = tvalue[0];
                    break;
                }
                this.value = tvalue;
                break;
            }
            case 20294: {
                ByteBuffer bb = ByteBuffer.wrap(data);
                if (littleEndian) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                } else {
                    bb.order(ByteOrder.BIG_ENDIAN);
                }
                float[] tvalue = new float[this.len / 4];
                bb.asFloatBuffer().get(tvalue, 0, tvalue.length);
                if (tvalue.length == 1) {
                    this.value = new Float(tvalue[0]);
                    break;
                }
                this.value = tvalue;
                break;
            }
            case 17988: {
                Double[] tvalue = new Double[this.len / 8];
                int count = 0;
                int incr = 0;
                while (count < tvalue.length) {
                    int i;
                    long l = 0L;
                    if (littleEndian) {
                        for (i = 0; i < 8; ++i) {
                            l |= (long)(data[off + i + incr] & 0xFF) << 8 * i;
                        }
                    } else {
                        for (i = 0; i < 8; ++i) {
                            l |= (long)(data[off + i + incr] & 0xFF) << 8 * (7 - i);
                        }
                    }
                    tvalue[count++] = new Double(Double.longBitsToDouble(l));
                    incr += 8;
                }
                if (count == 1) {
                    this.value = tvalue[0];
                    break;
                }
                this.value = tvalue;
                break;
            }
            case 20311: {
                int size = this.len / 2;
                short[] w = new short[size];
                this.value = w;
                if (littleEndian) {
                    for (int i = 0; i < size; ++i) {
                        int tmp = off + (i << 1);
                        w[i] = (short)((data[tmp + 1] & 0xFF) << 8 | data[tmp] & 0xFF);
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        int tmp = off + (i << 1);
                        w[i] = (short)((data[tmp] & 0xFF) << 8 | data[tmp + 1] & 0xFF);
                    }
                }
                break;
            }
            case 20290: {
                if (this.len == -1) break;
                byte[] b2 = new byte[this.len];
                this.value = b2;
                System.arraycopy(data, off, b2, 0, this.len);
                break;
            }
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21844: {
                byte[] buffer = new byte[this.len];
                System.arraycopy(data, off, buffer, 0, this.len);
                this.valueAsBytes = buffer;
                if (this.len == 0) {
                    this.value = "";
                    break;
                }
                this.value = CJKsupport.getUnicode(data, off, this.len, dicomCharsets);
                break;
            }
            default: {
                int count;
                if (this.len == 0) {
                    this.value = "";
                    break;
                }
                for (count = this.len - 1; count >= 0 && 0 == data[off + count]; --count) {
                }
                if (count >= 0) {
                    String charsetName = DicomCharSet.DEFAULT.getJavaCharsetName();
                    try {
                        this.value = new String(data, off, count + 1, charsetName).trim();
                    }
                    catch (UnsupportedEncodingException ueex) {
                        Tap.log.log(Level.WARNING, "Default charset " + charsetName + " not supported.");
                        this.value = "(ERROR)";
                    }
                    break;
                }
                this.value = "";
            }
        }
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public void setLittleEndian(boolean flag) {
        this.littleEndian = flag;
    }

    public boolean isFillValue() {
        return this.fillValue;
    }

    public void setFillValue(boolean flag) {
        this.fillValue = flag;
    }

    public final boolean is(int g, int e) {
        return this.group == g && this.element == e;
    }

    public int compareTo(Object o) {
        tagValue tv = (tagValue)o;
        if (this.group != tv.group) {
            return this.group - tv.group;
        }
        if (this.element != tv.element) {
            return this.element - tv.element;
        }
        return 0;
    }

    public static String atToString(int g, int e) {
        String sg = Integer.toHexString(g);
        sg = "0000".substring(sg.length()) + sg;
        String se = Integer.toHexString(e);
        se = "0000".substring(se.length()) + se;
        return "(0x" + sg + ",0x" + se + ")";
    }

    public String vrString() {
        return vr.toString(this.vrep);
    }

    public String toString() {
        String str = tagValue.atToString(this.group, this.element) + "[" + vr.toString(this.vrep) + "][len=" + this.len + "][off=" + this.fileOffset + "]=";
        try {
            switch (this.vrep) {
                case 16724: {
                    if (this.len == 2) {
                        return str + this.value;
                    }
                    str = str + "(.." + this.len / 4 + "..)=";
                    for (int i = 0; i < this.len / 2; i += 2) {
                        str = str + tagValue.atToString(((Integer[])this.value)[i], ((Integer[])this.value)[i + 1]);
                    }
                    return str;
                }
                case 17996: {
                    if (this.len == 4) {
                        return str + this.value;
                    }
                    return str + "(.." + this.len / 4 + "..)=" + ((Float[])this.value)[0] + "," + ((Float[])this.value)[1];
                }
                case 17988: {
                    if (this.len == 8) {
                        return str + this.value;
                    }
                    return str + "(.." + this.len / 8 + "..)=" + ((Double[])this.value)[0] + "," + ((Double[])this.value)[1];
                }
                case 21331: {
                    if (this.len == 2) {
                        return str + this.value;
                    }
                    return str + "(.." + this.len / 2 + "..)=" + ((Integer[])this.value)[0] + "," + ((Integer[])this.value)[1];
                }
                case 21843: {
                    if (this.len == 2) {
                        return str + this.value;
                    }
                    if (this.value instanceof Integer[]) {
                        return str + "(.." + this.len / 2 + "..)=" + ((Integer[])this.value)[0] + "," + ((Integer[])this.value)[1];
                    }
                    if (this.value instanceof Integer) {
                        return str + "(.." + this.len / 2 + "..)=" + (Integer)this.value + "," + (Integer)this.value;
                    }
                    return str + "(.." + this.len / 2 + "..)=" + this.value + "," + this.value;
                }
                case 21836: {
                    if (this.len == 4) {
                        return str + this.value;
                    }
                    return str + "(.." + this.len / 4 + "..)=" + ((Long[])this.value)[0] + "," + ((Long[])this.value)[1];
                }
                case 21324: {
                    if (this.len == 4) {
                        return str + this.value;
                    }
                    return str + "(.." + this.len / 4 + "..)=" + ((Integer[])this.value)[0] + "," + ((Integer[])this.value)[1];
                }
                case 21329: {
                    return str + "...";
                }
                case 20311: {
                    if (this.len > 30) {
                        return str + "(" + this.len + ")";
                    }
                    for (int i = 0; i < this.len / 2 - 1; ++i) {
                        str = str + ((short[])this.value)[i] + ",";
                    }
                    str = str + ((short[])this.value)[this.len / 2 - 1];
                    return str;
                }
                case 20290: {
                    if (this.len > 30) {
                        return str + "(.." + this.len + "..)";
                    }
                    for (int i = 0; i < this.len - 1; ++i) {
                        str = str + ((byte[])this.value)[i] + ",";
                    }
                    if (this.len > 0) {
                        str = str + ((byte[])this.value)[this.len - 1];
                    }
                    return str;
                }
            }
            return str + this.value;
        }
        catch (Exception e) {
            return str + this.value;
        }
    }
}

