/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.dicom.DicomBytesBuilder;
import com.ge.med.terra.tap.util.dicom.DicomCharSet;
import java.nio.charset.CharsetEncoder;

public class PersonName {
    public static final int GROUP_DELIM = 61;
    public static final int COMP_DELIM = 94;
    public static final int SPC = 32;
    public String familyName = "";
    public String givenName = "";
    public String middleName = "";
    public String prefix = "";
    public String suffix = "";
    public String familyNameIdeographic = "";
    public String givenNameIdeographic = "";
    public String middleNameIdeographic = "";
    public String prefixIdeographic = "";
    public String suffixIdeographic = "";
    public String familyNamePhonetic = "";
    public String givenNamePhonetic = "";
    public String middleNamePhonetic = "";
    public String prefixPhonetic = "";
    public String suffixPhonetic = "";
    private int currentGroupBeginIndex;
    private boolean clearTrailingCompDelims = Tap.getProperty("tap.dicom.pn.keepcompdelims", "false").equalsIgnoreCase("false");
    private boolean clearTrailingGroupDelims = Tap.getProperty("tap.dicom.pn.keepgroupdelims", "false").equalsIgnoreCase("false");

    public PersonName() {
    }

    public PersonName(String str) {
        if (null == str) {
            return;
        }
        int beginGroup = 0;
        int endGroup = 0;
        endGroup = this.indexOfEndGroup(beginGroup, str);
        if (endGroup > beginGroup) {
            this.familyName = this.extractComponent(str, endGroup);
            this.givenName = this.extractComponent(str, endGroup);
            this.middleName = this.extractComponent(str, endGroup);
            this.prefix = this.extractComponent(str, endGroup);
            this.suffix = this.extractComponent(str, endGroup);
        }
        if (str.length() <= endGroup) {
            return;
        }
        this.currentGroupBeginIndex = beginGroup = endGroup + 1;
        endGroup = this.indexOfEndGroup(beginGroup, str);
        if (endGroup > beginGroup) {
            this.familyNameIdeographic = this.extractComponent(str, endGroup);
            this.givenNameIdeographic = this.extractComponent(str, endGroup);
            this.middleNameIdeographic = this.extractComponent(str, endGroup);
            this.prefixIdeographic = this.extractComponent(str, endGroup);
            this.suffixIdeographic = this.extractComponent(str, endGroup);
        }
        if (str.length() <= endGroup) {
            return;
        }
        this.currentGroupBeginIndex = beginGroup = endGroup + 1;
        endGroup = this.indexOfEndGroup(beginGroup, str);
        if (endGroup > beginGroup) {
            this.familyNamePhonetic = this.extractComponent(str, endGroup);
            this.givenNamePhonetic = this.extractComponent(str, endGroup);
            this.middleNamePhonetic = this.extractComponent(str, endGroup);
            this.prefixPhonetic = this.extractComponent(str, endGroup);
            this.suffixPhonetic = this.extractComponent(str, endGroup);
        }
        this.currentGroupBeginIndex = 0;
    }

    public void keepTrailingComponentDelimiters() {
        this.clearTrailingCompDelims = false;
    }

    public void keepTrailingGroupDelimiters() {
        this.clearTrailingGroupDelims = false;
    }

    public String alphabeticComponentGroup() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.familyName);
        sb.append('^');
        sb.append(this.givenName);
        sb.append('^');
        sb.append(this.middleName);
        sb.append('^');
        sb.append(this.prefix);
        sb.append('^');
        sb.append(this.suffix);
        if (this.clearTrailingCompDelims) {
            this.removeTrailingDelims(94, sb);
        }
        return sb.toString();
    }

    public void setAlphabeticComponentGroup(String str) {
        int endGroup = str.length();
        this.familyName = this.extractComponent(str, endGroup);
        this.givenName = this.extractComponent(str, endGroup);
        this.middleName = this.extractComponent(str, endGroup);
        this.prefix = this.extractComponent(str, endGroup);
        this.suffix = this.extractComponent(str, endGroup);
        this.currentGroupBeginIndex = 0;
    }

    public String ideographicComponentGroup() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.familyNameIdeographic);
        sb.append('^');
        sb.append(this.givenNameIdeographic);
        sb.append('^');
        sb.append(this.middleNameIdeographic);
        sb.append('^');
        sb.append(this.prefixIdeographic);
        sb.append('^');
        sb.append(this.suffixIdeographic);
        this.removeTrailingDelims(94, sb);
        return sb.toString();
    }

    public void setIdeographicComponentGroup(String str) {
        int endGroup = str.length();
        this.familyNameIdeographic = this.extractComponent(str, endGroup);
        this.givenNameIdeographic = this.extractComponent(str, endGroup);
        this.middleNameIdeographic = this.extractComponent(str, endGroup);
        this.prefixIdeographic = this.extractComponent(str, endGroup);
        this.suffixIdeographic = this.extractComponent(str, endGroup);
        this.currentGroupBeginIndex = 0;
    }

    public String phoneticComponentGroup() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.familyNamePhonetic);
        sb.append('^');
        sb.append(this.givenNamePhonetic);
        sb.append('^');
        sb.append(this.middleNamePhonetic);
        sb.append('^');
        sb.append(this.prefixPhonetic);
        sb.append('^');
        sb.append(this.suffixPhonetic);
        this.removeTrailingDelims(94, sb);
        return sb.toString();
    }

    public void setPhoneticComponentGroup(String str) {
        int endGroup = str.length();
        this.familyNamePhonetic = this.extractComponent(str, endGroup);
        this.givenNamePhonetic = this.extractComponent(str, endGroup);
        this.middleNamePhonetic = this.extractComponent(str, endGroup);
        this.prefixPhonetic = this.extractComponent(str, endGroup);
        this.suffixPhonetic = this.extractComponent(str, endGroup);
        this.currentGroupBeginIndex = 0;
    }

    public byte[] getDicomBytes(DicomCharSet alphabeticCharset, DicomCharSet ideographicCharset, DicomCharSet phoneticCharset) throws IllegalStateException {
        String str = this.toDICOMString();
        DicomBytesBuilder dbb = new DicomBytesBuilder();
        if (null != str && 0 < str.length()) {
            int endIndex;
            int unicodeCodePoint;
            DicomCharSet currentDicomCharset;
            DicomCharSet defaultCharset = alphabeticCharset;
            DicomCharSet activeCharset = ideographicCharset;
            DicomCharSet newDicomCharset = currentDicomCharset = defaultCharset;
            CharsetEncoder defaultEnc = defaultCharset.getJavaCharset().newEncoder();
            int beginIndex = 0;
            int group = 1;
            for (endIndex = 0; endIndex < str.length(); endIndex += Character.charCount(unicodeCodePoint)) {
                char ch = str.charAt(endIndex);
                if ('=' == ch && ++group > 2) {
                    activeCharset = phoneticCharset;
                }
                newDicomCharset = defaultEnc.canEncode(ch) ? defaultCharset : activeCharset;
                if (0 < endIndex && currentDicomCharset != newDicomCharset) {
                    String substr = str.substring(beginIndex, endIndex);
                    dbb.append(substr, currentDicomCharset, defaultCharset, activeCharset);
                    beginIndex = endIndex;
                }
                currentDicomCharset = newDicomCharset;
                unicodeCodePoint = Character.codePointAt(str, endIndex);
            }
            String substr = str.substring(beginIndex, endIndex);
            dbb.append(substr, currentDicomCharset, defaultCharset, activeCharset);
            if (currentDicomCharset == activeCharset && DicomBytesBuilder.isSwitchToDefault((DicomCharSet)activeCharset)) {
                byte[] escapeSequence = DicomBytesBuilder.getEscapeSequence((DicomCharSet)activeCharset, (DicomCharSet)defaultCharset);
                dbb.append(escapeSequence);
            }
        }
        if ((dbb.length() & 1) != 0) {
            dbb.append(new byte[]{32});
        }
        return dbb.array();
    }

    public String toDICOMString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.alphabeticComponentGroup());
        sb.append('=');
        sb.append(this.ideographicComponentGroup());
        sb.append('=');
        sb.append(this.phoneticComponentGroup());
        if (this.clearTrailingGroupDelims) {
            this.removeTrailingDelims(61, sb);
        }
        return sb.toString();
    }

    public static String toFormattedString(String familyName, String givenName, String middleName, String prefix, String suffix) {
        StringBuffer sb = new StringBuffer();
        boolean useFormatWithSpace = Tap.getProperty("tap.dicom.pn.format.usespace", "false").equalsIgnoreCase("true");
        if (useFormatWithSpace) {
            String compDelim = " ";
            if ("".equals(middleName) && "".equals(prefix) && "".equals(suffix)) {
                boolean familyNameFirst = Tap.getProperty("tap.dicom.pn.format.usespace.familyfirst", "false").equalsIgnoreCase("true");
                if (familyNameFirst) {
                    sb.append(familyName);
                    sb.append(compDelim);
                    sb.append(givenName);
                } else {
                    sb.append(givenName);
                    sb.append(compDelim);
                    sb.append(familyName);
                }
            } else {
                if (!"".equals(prefix)) {
                    sb.append(compDelim);
                    sb.append(prefix);
                }
                if (!"".equals(givenName)) {
                    sb.append(compDelim);
                    sb.append(givenName);
                }
                if (!"".equals(middleName)) {
                    sb.append(compDelim);
                    sb.append(middleName);
                }
                if (!"".equals(familyName)) {
                    sb.append(compDelim);
                    sb.append(familyName);
                }
                if (!"".equals(suffix)) {
                    sb.append(compDelim);
                    sb.append(suffix);
                }
            }
        } else {
            String compDelim = ", ";
            sb.append(familyName);
            if (!"".equals(givenName)) {
                sb.append(compDelim);
                sb.append(givenName);
                if (!"".equals(middleName)) {
                    sb.append(" ");
                    sb.append(middleName);
                }
            } else if (!"".equals(middleName)) {
                sb.append(compDelim);
                sb.append(middleName);
            }
            if (!"".equals(suffix)) {
                sb.append(compDelim);
                sb.append(suffix);
            }
            if (!"".equals(prefix)) {
                sb.append(" (");
                sb.append(prefix);
                sb.append(")");
            }
        }
        return sb.toString().trim();
    }

    public String toFormattedStringAlphabetic() {
        return PersonName.toFormattedString(this.familyName, this.givenName, this.middleName, this.prefix, this.suffix);
    }

    public String toFormattedStringIdeographic() {
        return PersonName.toFormattedString(this.familyNameIdeographic, this.givenNameIdeographic, this.middleNameIdeographic, this.prefixIdeographic, this.suffixIdeographic);
    }

    public String toFormattedStringPhonetic() {
        return PersonName.toFormattedString(this.familyNamePhonetic, this.givenNamePhonetic, this.middleNamePhonetic, this.prefixPhonetic, this.suffixPhonetic);
    }

    public String toFormattedString() {
        if (this.ideographicHasContent()) {
            return this.toFormattedStringIdeographic();
        }
        if (this.phoneticHasContent()) {
            return this.toFormattedStringPhonetic();
        }
        if (this.alphabeticHasContent()) {
            return this.toFormattedStringAlphabetic();
        }
        return "";
    }

    public static String toFormattedString(String str) {
        PersonName pn = new PersonName(str);
        return pn.toFormattedString();
    }

    private int indexOfEndGroup(int beginGroupIndex, String personName) {
        return this.indexOf(61, beginGroupIndex, personName.length(), personName);
    }

    private int indexOfCompDelim(int beginGroupIndex, int endGroupIndex, String personName) {
        return this.indexOf(94, beginGroupIndex, endGroupIndex, personName);
    }

    private int indexOf(int ch, int fromIndex, int toIndex, String str) {
        for (int i = fromIndex; i < toIndex; ++i) {
            if (ch != str.charAt(i)) continue;
            return i;
        }
        return toIndex;
    }

    private String extractComponent(String str, int endGroupIndex) {
        if (this.currentGroupBeginIndex >= endGroupIndex) {
            return "";
        }
        int endIndex = this.indexOfCompDelim(this.currentGroupBeginIndex, endGroupIndex, str);
        String comp = endIndex > this.currentGroupBeginIndex ? str.substring(this.currentGroupBeginIndex, endIndex) : "";
        this.currentGroupBeginIndex = endIndex + 1;
        return comp;
    }

    private int removeTrailingDelims(int delimiter, StringBuffer sb) {
        int count = 0;
        while (delimiter == sb.charAt(sb.length() - 1)) {
            ++count;
            sb.deleteCharAt(sb.length() - 1);
            if (0 != sb.length()) continue;
            break;
        }
        return count;
    }

    public boolean alphabeticHasContent() {
        return this.groupHasContent(this.familyName, this.givenName, this.middleName, this.prefix, this.suffix);
    }

    public boolean ideographicHasContent() {
        return this.groupHasContent(this.familyNameIdeographic, this.givenNameIdeographic, this.middleNameIdeographic, this.prefixIdeographic, this.suffixIdeographic);
    }

    public boolean phoneticHasContent() {
        return this.groupHasContent(this.familyNamePhonetic, this.givenNamePhonetic, this.middleNamePhonetic, this.prefixPhonetic, this.suffixPhonetic);
    }

    private boolean groupHasContent(String comp1, String comp2, String comp3, String comp4, String comp5) {
        return !"".equals(comp1) || !"".equals(comp2) || !"".equals(comp3) || !"".equals(comp4) || !"".equals(comp5);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        PersonName person = (PersonName)obj;
        if (!this.familyName.equals(person.familyName)) {
            return false;
        }
        if (!this.familyNameIdeographic.equals(person.familyNameIdeographic)) {
            return false;
        }
        if (!this.familyNamePhonetic.equals(person.familyNamePhonetic)) {
            return false;
        }
        if (!this.givenName.equals(person.givenName)) {
            return false;
        }
        if (!this.givenNameIdeographic.equals(person.givenNameIdeographic)) {
            return false;
        }
        if (!this.givenNamePhonetic.equals(person.givenNamePhonetic)) {
            return false;
        }
        if (!this.middleName.equals(person.middleName)) {
            return false;
        }
        if (!this.middleNameIdeographic.equals(person.middleNameIdeographic)) {
            return false;
        }
        if (!this.middleNamePhonetic.equals(person.middleNamePhonetic)) {
            return false;
        }
        if (!this.prefix.equals(person.prefix)) {
            return false;
        }
        if (!this.prefixIdeographic.equals(person.prefixIdeographic)) {
            return false;
        }
        if (!this.prefixPhonetic.equals(person.prefixPhonetic)) {
            return false;
        }
        if (!this.suffix.equals(person.suffix)) {
            return false;
        }
        if (!this.suffixIdeographic.equals(person.suffixIdeographic)) {
            return false;
        }
        return this.suffixPhonetic.equals(person.suffixPhonetic);
    }

    public int hashCode() {
        int result = this.familyName.hashCode();
        result = 31 * result + this.givenName.hashCode();
        result = 31 * result + this.middleName.hashCode();
        result = 31 * result + this.prefix.hashCode();
        result = 31 * result + this.suffix.hashCode();
        result = 31 * result + this.familyNameIdeographic.hashCode();
        result = 31 * result + this.givenNameIdeographic.hashCode();
        result = 31 * result + this.middleNameIdeographic.hashCode();
        result = 31 * result + this.prefixIdeographic.hashCode();
        result = 31 * result + this.suffixIdeographic.hashCode();
        result = 31 * result + this.familyNamePhonetic.hashCode();
        result = 31 * result + this.givenNamePhonetic.hashCode();
        result = 31 * result + this.middleNamePhonetic.hashCode();
        result = 31 * result + this.prefixPhonetic.hashCode();
        result = 31 * result + this.suffixPhonetic.hashCode();
        return result;
    }

    public String toString() {
        return this.toDICOMString();
    }
}

