/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.dicom.DicomCharSet;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.GSPSComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import com.ge.med.terra.tap.version;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class GSPSComposite
extends DicomComposite {
    private static int instanceUID = 23;
    private final Date creationDate = Calendar.getInstance().getTime();
    private final XjTagValue[] tagsToFill = new XjTagValue[]{new XjTagValue(8, 5), new XjTagValue(16, 16), new XjTagValue(16, 32), new XjTagValue(16, 48), new XjTagValue(16, 64), new XjTagValue(16, 50), new XjTagValue(16, 4096), new XjTagValue(16, 4097), new XjTagValue(16, 8544), new XjTagValue(16, 16384), new XjTagValue(18, 16), new XjTagValue(18, 32), new XjTagValue(18, 33), new XjTagValue(18, 48), new XjTagValue(18, 49), new XjTagValue(18, 64), new XjTagValue(18, 66), new XjTagValue(32, 13), new XjTagValue(8, 32), new XjTagValue(8, 48), new XjTagValue(8, 144), new XjTagValue(32, 16), new XjTagValue(8, 80), new XjTagValue(8, 4224), new XjTagValue(18, 80), new XjTagValue(18, 81), new XjTagValue(64, 4097), new XjTagValue(64, 9), new XjTagValue(18, 96), new XjTagValue(8, 112), new XjTagValue(8, 128), new XjTagValue(8, 129), new XjTagValue(8, 4112), new XjTagValue(8, 4160), new XjTagValue(8, 4240), new XjTagValue(24, 4096), new XjTagValue(24, 4128), new XjTagValue(24, 4176), new XjTagValue(24, 4608), new XjTagValue(24, 4609), new XjTagValue(40, 4178), new XjTagValue(40, 4179), new XjTagValue(40, 4180)};

    public GSPSComposite() {
        String psCreator;
        Arrays.sort(this.tagsToFill);
        this.setValue(8, 22, "1.2.840.10008.5.1.4.1.1.11.1");
        this.setValue(8, 24, UidGenerator.newInstanceUID());
        this.setValue(8, 5, DicomCharSet.ISO_IR_100.getDefinedTerm());
        this.setDateValue(8, 18, this.creationDate);
        this.setTimeValue(8, 19, this.creationDate);
        this.setValue(8, 96, "PR");
        this.setValue(32, 14, UidGenerator.newInstanceUID());
        this.setValue(8, 4158, "Presentation Series");
        this.setDateValue(112, 130, this.creationDate);
        this.setTimeValue(112, 131, this.creationDate);
        this.setValue(32, 19, "" + instanceUID);
        ++instanceUID;
        this.setValue(112, 128, "GEHC_GSPS");
        this.setValue(112, 129, "Template GSPS");
        try {
            psCreator = InetAddress.getLocalHost().getHostName();
            if (psCreator.indexOf(".") != -1) {
                psCreator = psCreator.substring(0, psCreator.indexOf("."));
            }
        }
        catch (UnknownHostException ex) {
            psCreator = new version().getVersionString();
        }
        this.setValue(112, 132, psCreator);
    }

    public void fill(XjDicomObject obj) {
        obj.getValues(this.tagsToFill);
        this.setValues(this.tagsToFill);
        this.setValue(32, 17, GSPSComposite.getGSPSSeriesNo(obj));
    }

    public void fill(DMObject obj) {
        GSPSDicomObject ref = new GSPSDicomObject(obj);
        this.fill((XjDicomObject)ref);
    }

    private void setValues(XjTagValue[] tvs) {
        for (XjTagValue tv : tvs) {
            this.setValue(tv);
        }
    }

    private void setValue(XjTagValue tv) {
        if (null == tv.value) {
            this.removeTag(tv.group, tv.element);
        } else {
            this.setValue(tv.group, tv.element, tv.value);
        }
    }

    public static int getGSPSSeriesNo(DMObject refImage) {
        return GSPSComposite.getGSPSSeriesNo((String)refImage.getValue(32, 17));
    }

    public static int getGSPSSeriesNo(XjDicomObject refImage) {
        return GSPSComposite.getGSPSSeriesNo((String)refImage.getValue(32, 17));
    }

    public static int getGSPSSeriesNo(String seriesNo) {
        int gspsSeriesNo = Integer.parseInt(seriesNo) + 100000;
        return gspsSeriesNo;
    }

    public static void main(String[] args) {
        try {
            String[] stringArray;
            GSPSComposite gsps = new GSPSComposite();
            System.out.println("\nBasic GSPS Template\n");
            gsps.printDebugInfo(System.out);
            if (args.length == 0) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "file";
                stringArray = stringArray2;
                stringArray2[1] = "D:/data/test/i18n/Japanese2";
            } else {
                stringArray = args;
            }
            DMSession ses = new DMSession(stringArray);
            gsps.fill(ses.getChildren()[0]);
            System.out.println("\nAfter fill()\n");
            gsps.printDebugInfo(System.out);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

