/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.util.dicom.DicomData;
import com.ge.med.terra.tap.util.dicom.WrapperStream;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DicomComposite
extends DicomData {
    public static String TS_ELE = "1.2.840.10008.1.2.1";
    public static String TS_ILE = "1.2.840.10008.1.2";
    public static String TS_GEBE = "1.2.840.113619.5.2";
    private String type = "Composite";

    public void getValues(DMElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            elements[i].value = this.getValue(elements[i].group, elements[i].element);
        }
    }

    public String getString(int group, int element) {
        DicomObject dataset = this.obj;
        if (group == 2 && this.obj.getFileMetaInformation() != null) {
            dataset = this.obj.getFileMetaInformation();
        }
        return DicomData.getString(group, element, dataset);
    }

    protected void setValue(DMElement de) throws DMException {
        if (null == de.value) {
            this.removeTag(de.group, de.element);
        } else {
            super.setValue(de);
        }
    }

    public void setValue(int g, int e, int n, Object val) throws DMException {
        try {
            if (g == 2) {
                if (this.obj.getFileMetaInformation() != null) {
                    this.obj.getFileMetaInformation().set_ge(g, e, val);
                } else {
                    DicomObject filemetainfo = new DicomObject();
                    filemetainfo.set_ge(g, e, val);
                    this.obj.setFileMetaInformation(filemetainfo);
                }
            } else if (g == 8 && e == 22) {
                this.obj.set_ge(g, e, val);
                if (this.obj.getFileMetaInformation() != null) {
                    this.obj.getFileMetaInformation().set_ge(2, 2, val);
                }
            } else if (g == 8 && e == 24) {
                this.obj.set_ge(g, e, val);
                if (this.obj.getFileMetaInformation() != null) {
                    this.obj.getFileMetaInformation().set_ge(2, 3, val);
                }
            } else {
                super.setValue(g, e, n, val);
            }
        }
        catch (DicomException ex) {
            throw new DMException(ex.getMessage());
        }
    }

    public InputStream getInputStream() {
        return this.getInputStream(true, null);
    }

    public InputStream getInputStream(String transferSyntaxHint) {
        return this.getInputStream(true, transferSyntaxHint);
    }

    public InputStream getInputStream(boolean asPart10File) {
        return this.getInputStream(asPart10File, null);
    }

    public InputStream getInputStream(boolean asPart10File, String transferSyntaxHint) {
        return new WrapperStream(this.obj, transferSyntaxHint);
    }

    public void printDebugInfo(OutputStream out) throws IOException {
        this.obj.dumpVRs(out, true);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public DMTag[] getTags() {
        throw new UnsupportedOperationException("Method getTags() is unsupported.");
    }

    public void delete() {
        throw new UnsupportedOperationException("Method delete() is unsupported.");
    }

    public BufferedImage[] getPixelData(DMTag[] tags) {
        throw new UnsupportedOperationException("Method getPixelData() is unsupported.");
    }

    public String getID() {
        return (String)this.getValue(8, 24);
    }

    public DMiImage[] getImages(DMTag[] tags) {
        throw new UnsupportedOperationException("Method getImages() is unsupported.");
    }

    public String getFilePath() {
        throw new UnsupportedOperationException("Method getFilePath() is unsupported.");
    }

    public static void main(String[] args) {
        DicomComposite cmp = new DicomComposite();
        DicomData itm1 = new DicomData();
        DicomData itm2 = new DicomData();
        itm1.setValue(8, 4432, "DetachedStudyManagementSOPClass");
        itm1.setValue(8, 4437, "1.113654.3.13.1079");
        itm2.setValue(8, 4432, "DetachedStudyManagementSOPClass");
        itm2.setValue(8, 4437, "1.113654.3.13.1081");
        cmp.setValue(8, 4368, 0, itm1);
        cmp.setValue(8, 4368, 1, itm2);
        try {
            cmp.printDebugInfo(System.out);
            cmp.removeTag(8, 4368);
            cmp.setValue(8, 4368, 0, itm2);
            cmp.printDebugInfo(System.out);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }
}

