/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sessionFile;

import com.archimed.dicom.codec.Compression;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.dm.sessionFile.fileSequence;
import com.ge.med.terra.tap.dm.sessionFile.jport;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.PersonName;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;

public class dicomImageGen {
    private static dicomParser dp = new dicomParser();

    public static Object get(tagValue[] t, int g, int e) {
        for (int i = 0; i < t.length; ++i) {
            if (t[i].group != g || t[i].element != e) continue;
            return t[i].value;
        }
        return null;
    }

    private static BufferedImage getBufferedImage(int frameNo, byte[] compressedFrame, String transferSyntax, boolean littleEndian, String imgType, int bits, int w, int h, Hashtable prop) {
        try {
            byte[] uncompressedFrame;
            if (transferSyntax.indexOf(DMUtils.TS_JPEGLossless) != 0) {
                uncompressedFrame = Compression.decompressFrame(8197, compressedFrame, w, h);
            } else if (transferSyntax.indexOf(DMUtils.TS_RLELossless) != 0) {
                uncompressedFrame = Compression.decompressFrame(8198, compressedFrame, w, h);
            } else if (transferSyntax.indexOf(DMUtils.TS_JPEGBaseline) != 0) {
                uncompressedFrame = Compression.decompressFrame(8196, compressedFrame, w, h);
            } else {
                return null;
            }
            if (imgType.equals("MONOCHROME2") || imgType.equals("MONOCHROME1")) {
                if (bits == 16) {
                    ByteBuffer bff = ByteBuffer.wrap(uncompressedFrame);
                    if (littleEndian) {
                        bff.order(ByteOrder.LITTLE_ENDIAN);
                    } else {
                        bff.order(ByteOrder.BIG_ENDIAN);
                    }
                    ShortBuffer ib = bff.asShortBuffer();
                    short[] sbuffer = new short[uncompressedFrame.length / 2];
                    ib.get(sbuffer);
                    prop.put("0,1", new Integer(1 + frameNo));
                    return dicomImageGen.build16bitImage(w, h, sbuffer, 0, 0, (Hashtable)prop.clone());
                }
                prop.put("0,1", new Integer(1 + frameNo));
                return dicomImageGen.build8bitImage(w, h, uncompressedFrame, 0, (Hashtable)prop.clone());
            }
            if (imgType.equals("RGB")) {
                prop.put("0,1", new Integer(1 + frameNo));
                return dicomImageGen.buildRGBImage(w, h, uncompressedFrame, 0, (Hashtable)prop.clone());
            }
            System.out.println("Unsupported image type \"" + imgType + "\"");
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage[] getCompressedImages(String imageName, long pixOffset, int numFrames, int dimx, int dimy, String imgType, int bits, boolean littleEndian, String transferSyntax, Hashtable prop) {
        FileInputStream fis = null;
        try {
            int sizeOfGroupElemVrLen = 12;
            long offset = pixOffset + (long)sizeOfGroupElemVrLen;
            fis = new FileInputStream(new File(imageName));
            MappedByteBuffer mbb = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
            if (littleEndian) {
                mbb.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                mbb.order(ByteOrder.BIG_ENDIAN);
            }
            System.err.println("mbb.position===" + mbb.position());
            mbb.position((int)offset);
            int group = mbb.getShort() & 0xFFFF;
            int elem = mbb.getShort() & 0xFFFF;
            if (group == 65534 && elem == 57344) {
                BufferedImage[] bufferedImageArray;
                ArrayList<BufferedImage> al = new ArrayList<BufferedImage>();
                int len = mbb.getInt();
                System.err.println("len===" + len);
                if (len > 0) {
                    int[] tableValues = new int[len / 4];
                    for (int i = 0; i < tableValues.length; ++i) {
                        tableValues[i] = mbb.getInt();
                    }
                    int startingPos = mbb.position();
                    for (int i = 0; i < tableValues.length; ++i) {
                        mbb.position(startingPos + tableValues[i] + 4);
                        byte[] compressedFrame = new byte[mbb.getInt()];
                        mbb.get(compressedFrame);
                        al.add(dicomImageGen.getBufferedImage(i, compressedFrame, transferSyntax, littleEndian, imgType, bits, dimx, dimy, prop));
                    }
                } else {
                    int i = 0;
                    while (true) {
                        group = mbb.getShort() & 0xFFFF;
                        elem = mbb.getShort() & 0xFFFF;
                        if (group != 65534 || elem != 57344) break;
                        byte[] compressedFrame = new byte[mbb.getInt()];
                        mbb.get(compressedFrame);
                        al.add(dicomImageGen.getBufferedImage(i, compressedFrame, transferSyntax, littleEndian, imgType, bits, dimx, dimy, prop));
                        ++i;
                    }
                }
                if (al.size() == 0) {
                    bufferedImageArray = null;
                    return bufferedImageArray;
                }
                bufferedImageArray = al.toArray(new BufferedImage[al.size()]);
                return bufferedImageArray;
            }
            BufferedImage[] bufferedImageArray = null;
            return bufferedImageArray;
        }
        catch (Exception ex) {
            BufferedImage[] bufferedImageArray = null;
            return bufferedImageArray;
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    public static BufferedImage[] getImages(String imageName, DMTag[] dmtags) {
        try {
            int i;
            dp.clearFile();
            dp.setFile(imageName);
            int[][] tags = new int[][]{{2, 16}, {16, 16}, {40, 2}, {40, 4}, {40, 8}, {40, 16}, {40, 17}, {40, 18}, {40, 256}, {40, 257}, {40, 258}, {40, 259}, {32736, 16}};
            int extra = dmtags != null ? dmtags.length : 0;
            Object[] tget = new tagValue[tags.length + extra];
            for (i = 0; i < tags.length; ++i) {
                tget[i] = new tagValue(tags[i][0], tags[i][1]);
            }
            if (dmtags != null) {
                for (i = 0; i < dmtags.length; ++i) {
                    tget[tags.length + i] = new tagValue(dmtags[i].getGroup(), dmtags[i].getElement());
                }
                Arrays.sort(tget);
            }
            dp.fill((tagValue[])tget);
            dp.clearFile();
            String transferSyntax = ((String)dicomImageGen.get((tagValue[])tget, 2, 16)).trim();
            String imgType = ((String)dicomImageGen.get((tagValue[])tget, 40, 4)).trim();
            int dimy = (Integer)dicomImageGen.get((tagValue[])tget, 40, 16);
            int dimx = (Integer)dicomImageGen.get((tagValue[])tget, 40, 17);
            int pixRep = (Integer)dicomImageGen.get((tagValue[])tget, 40, 259);
            int frames = dicomImageGen.get((tagValue[])tget, 40, 8) != null ? Integer.parseInt((String)dicomImageGen.get((tagValue[])tget, 40, 8)) : 1;
            Hashtable<String, Object> prop = new Hashtable<String, Object>(1 + extra);
            try {
                prop.put("16,16", PersonName.toFormattedString(((String)dicomImageGen.get((tagValue[])tget, 16, 16)).trim()));
            }
            catch (Exception e) {
                System.out.println("Patient Name (0x0010,0x0010) not found!");
            }
            for (int i2 = 0; i2 < extra; ++i2) {
                Object value = dicomImageGen.get((tagValue[])tget, dmtags[i2].getGroup(), dmtags[i2].getElement());
                if (value == null) continue;
                if (value.getClass() == Object[].class) {
                    prop.put(dmtags[i2].getGroup() + "," + dmtags[i2].getElement(), new DMSequence(new fileSequence((Object[])value)));
                    continue;
                }
                prop.put(dmtags[i2].getGroup() + "," + dmtags[i2].getElement(), value);
            }
            if (transferSyntax.indexOf(DMUtils.TS_JPEGBaseline) != -1 || transferSyntax.indexOf(DMUtils.TS_JPEGLossless) != -1 || transferSyntax.indexOf(DMUtils.TS_RLELossless) != -1) {
                return dicomImageGen.getCompressedImages(imageName, ((tagValue)tget[tget.length - 1]).fileOffset, frames, dimx, dimy, imgType, (Integer)dicomImageGen.get((tagValue[])tget, 40, 256), ((tagValue)tget[tget.length - 1]).isLittleEndian(), transferSyntax, prop);
            }
            BufferedImage[] imgs = new BufferedImage[frames];
            int size = dimx * dimy;
            if (imgType.equals("MONOCHROME2") || imgType.equals("MONOCHROME1")) {
                if ((Integer)dicomImageGen.get((tagValue[])tget, 40, 256) == 16) {
                    short[] data = (short[])dicomImageGen.get((tagValue[])tget, 32736, 16);
                    for (int i3 = 0; i3 < frames; ++i3) {
                        short[] tmpData = new short[size];
                        if (data.length < size) {
                            System.err.println("Pixel data too short: " + data.length + " < " + size + ". Returning empty frame.");
                        } else {
                            System.arraycopy(data, i3 * size, tmpData, 0, size);
                        }
                        prop.put("0,1", new Integer(1 + i3));
                        imgs[i3] = dicomImageGen.build16bitImage(dimx, dimy, tmpData, 0, pixRep, (Hashtable)prop.clone());
                    }
                } else {
                    Object pixdata = dicomImageGen.get((tagValue[])tget, 32736, 16);
                    if (pixdata instanceof byte[]) {
                        byte[] data = (byte[])pixdata;
                        for (int i4 = 0; i4 < frames; ++i4) {
                            prop.put("0,1", new Integer(1 + i4));
                            imgs[i4] = dicomImageGen.build8bitImage(dimx, dimy, data, i4 * size, (Hashtable)prop.clone());
                        }
                    } else if (pixdata instanceof short[]) {
                        short[] data = (short[])pixdata;
                        for (int i5 = 0; i5 < frames; ++i5) {
                            byte[] fixData = new byte[size];
                            ShortBuffer fixBuffer = ByteBuffer.wrap(fixData).asShortBuffer();
                            fixBuffer.put(data, size * i5 / 2, size / 2);
                            prop.put("0,1", new Integer(1 + i5));
                            imgs[i5] = dicomImageGen.build8bitImage(dimx, dimy, fixData, 0, (Hashtable)prop.clone());
                        }
                    }
                }
            } else if (imgType.equals("RGB")) {
                Object pixData = dicomImageGen.get((tagValue[])tget, 32736, 16);
                byte[] data = null;
                data = pixData instanceof byte[] ? (byte[])pixData : SimpleUtilities.shortToByte((short[])pixData, dp.isGuessBigEndian());
                for (int i6 = 0; i6 < frames; ++i6) {
                    prop.put("0,1", new Integer(1 + i6));
                    imgs[i6] = dicomImageGen.buildRGBImage(dimx, dimy, data, i6 * size * 3, (Hashtable)prop.clone());
                }
            } else {
                System.out.println("Unsupported image type \"" + imgType + "\"");
            }
            return imgs;
        }
        catch (FileNotFoundException ex) {
            throw new DMException(ex);
        }
    }

    public static BufferedImage[] getImages(dicomParser dp, DMTag[] dmtags) {
        int i;
        int[][] tags = new int[][]{{2, 16}, {16, 16}, {40, 2}, {40, 4}, {40, 8}, {40, 16}, {40, 17}, {40, 18}, {40, 256}, {40, 257}, {40, 258}, {40, 259}, {32736, 16}};
        int extra = dmtags != null ? dmtags.length : 0;
        Object[] tget = new tagValue[tags.length + extra];
        for (i = 0; i < tags.length; ++i) {
            tget[i] = new tagValue(tags[i][0], tags[i][1]);
        }
        if (dmtags != null) {
            for (i = 0; i < dmtags.length; ++i) {
                tget[tags.length + i] = new tagValue(dmtags[i].getGroup(), dmtags[i].getElement());
            }
            Arrays.sort(tget);
        }
        dp.fill((tagValue[])tget);
        String transferSyntax = ((String)dicomImageGen.get((tagValue[])tget, 2, 16)).trim();
        String imgType = ((String)dicomImageGen.get((tagValue[])tget, 40, 4)).trim();
        int dimy = (Integer)dicomImageGen.get((tagValue[])tget, 40, 16);
        int dimx = (Integer)dicomImageGen.get((tagValue[])tget, 40, 17);
        int pixRep = (Integer)dicomImageGen.get((tagValue[])tget, 40, 259);
        int frames = dicomImageGen.get((tagValue[])tget, 40, 8) != null ? Integer.parseInt((String)dicomImageGen.get((tagValue[])tget, 40, 8)) : 1;
        Hashtable<String, Object> prop = new Hashtable<String, Object>(1 + extra);
        try {
            prop.put("16,16", PersonName.toFormattedString(((String)dicomImageGen.get((tagValue[])tget, 16, 16)).trim()));
        }
        catch (Exception e) {
            System.out.println("Patient Name (0x0010,0x0010) not found!");
        }
        for (int i2 = 0; i2 < extra; ++i2) {
            Object value = dicomImageGen.get((tagValue[])tget, dmtags[i2].getGroup(), dmtags[i2].getElement());
            if (value == null) continue;
            if (value.getClass() == Object[].class) {
                prop.put(dmtags[i2].getGroup() + "," + dmtags[i2].getElement(), new DMSequence(new fileSequence((Object[])value)));
                continue;
            }
            prop.put(dmtags[i2].getGroup() + "," + dmtags[i2].getElement(), value);
        }
        BufferedImage[] imgs = new BufferedImage[frames];
        int size = dimx * dimy;
        if (transferSyntax.indexOf(DMUtils.TS_JPEGBaseline) != -1 || transferSyntax.indexOf(DMUtils.TS_JPEGLossless) != -1 || transferSyntax.indexOf(DMUtils.TS_RLELossless) != -1) {
            System.err.println("Compressed images not supported. Returning empty frame(s).");
            for (int i3 = 0; i3 < frames; ++i3) {
                byte[] tmpData = new byte[size];
                imgs[i3] = dicomImageGen.build8bitImage(dimx, dimy, tmpData, 0, (Hashtable)prop.clone());
            }
            return imgs;
        }
        if (imgType.equals("MONOCHROME2") || imgType.equals("MONOCHROME1")) {
            Integer v = (Integer)dicomImageGen.get((tagValue[])tget, 40, 256);
            if (v == null || v == 16) {
                short[] data = (short[])dicomImageGen.get((tagValue[])tget, 32736, 16);
                for (int i4 = 0; i4 < frames; ++i4) {
                    short[] tmpData = new short[size];
                    if (data.length < size) {
                        System.err.println("Pixel data too short: " + data.length + " < " + size + ". Returning empty frame.");
                    } else {
                        System.arraycopy(data, i4 * size, tmpData, 0, size);
                    }
                    prop.put("0,1", new Integer(1 + i4));
                    imgs[i4] = dicomImageGen.build16bitImage(dimx, dimy, tmpData, 0, pixRep, (Hashtable)prop.clone());
                }
            } else {
                Object pixdata = dicomImageGen.get((tagValue[])tget, 32736, 16);
                if (pixdata instanceof byte[]) {
                    byte[] data = (byte[])pixdata;
                    for (int i5 = 0; i5 < frames; ++i5) {
                        prop.put("0,1", new Integer(1 + i5));
                        imgs[i5] = dicomImageGen.build8bitImage(dimx, dimy, data, i5 * size, (Hashtable)prop.clone());
                    }
                } else if (pixdata instanceof short[]) {
                    short[] data = (short[])pixdata;
                    for (int i6 = 0; i6 < frames; ++i6) {
                        byte[] fixData = new byte[size];
                        ShortBuffer fixBuffer = ByteBuffer.wrap(fixData).asShortBuffer();
                        fixBuffer.put(data, size * i6 / 2, size / 2);
                        prop.put("0,1", new Integer(1 + i6));
                        imgs[i6] = dicomImageGen.build8bitImage(dimx, dimy, fixData, 0, (Hashtable)prop.clone());
                    }
                }
            }
        } else if (imgType.equals("RGB")) {
            Object pixData = dicomImageGen.get((tagValue[])tget, 32736, 16);
            byte[] data = null;
            data = pixData instanceof byte[] ? (byte[])pixData : SimpleUtilities.shortToByte((short[])pixData, dp.isGuessBigEndian());
            for (int i7 = 0; i7 < frames; ++i7) {
                prop.put("0,1", new Integer(1 + i7));
                imgs[i7] = dicomImageGen.buildRGBImage(dimx, dimy, data, i7 * size * 3, (Hashtable)prop.clone());
            }
        } else {
            System.out.println("Unsupported image type \"" + imgType + "\"");
        }
        return imgs;
    }

    public static BufferedImage buildRGBImage(int dimx, int dimy, byte[] data, int offset, Hashtable properties) {
        DataBufferByte dbs = new DataBufferByte(data, dimx * dimy * 3, offset);
        int[] bandOffsets = new int[]{0, 1, 2};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx * 3, 3, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[]{8, 8, 8};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 0);
        try {
            properties.put("PROPERTY_HASH", properties.keys());
        }
        catch (Exception e) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        return img;
    }

    public static BufferedImage build16bitImage(int dimx, int dimy, short[] data, int offset, Hashtable properties) {
        return dicomImageGen.build16bitImage(dimx, dimy, data, offset, 0, properties);
    }

    public static BufferedImage build16bitImage(int dimx, int dimy, short[] data, int offset, int pixRep, Hashtable properties) {
        DataBufferUShort dbs = new DataBufferUShort(data, dimx * dimy, offset);
        int[] bandOffsets = new int[]{0};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx, 1, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[]{16};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 1);
        try {
            properties.put("PROPERTY_HASH", properties.keys());
        }
        catch (Exception e) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        return img;
    }

    public static BufferedImage build8bitImage(int dimx, int dimy, byte[] data, int offset, Hashtable properties) {
        DataBufferByte dbs = new DataBufferByte(data, dimx * dimy, offset);
        int[] bandOffsets = new int[]{0};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx, 1, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[]{8};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 0);
        try {
            properties.put("PROPERTY_HASH", properties.keys());
        }
        catch (Exception e) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        return img;
    }

    public static BufferedImage build32bitImage(int dimx, int dimy, int[] data, int offset, Hashtable properties) {
        DataBufferInt dbs = new DataBufferInt(data, dimx * dimy, offset);
        int[] bandOffsets = new int[]{0};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx, 1, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[]{32};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 3);
        try {
            properties.put("PROPERTY_HASH", properties.keys());
        }
        catch (Exception e) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        return img;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        String[] str = args;
        dicomParser dp = new dicomParser();
        BufferedImage[] imgs = null;
        for (int i = 0; i < str.length; ++i) {
            try {
                dp.setFile(str[i]);
                imgs = dicomImageGen.getImages(dp, null);
                dp.clearFile();
                jport.display((BufferedImage[])imgs);
                continue;
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }
}

