/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.peerutils;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMSystem;
import com.ge.med.terra.tap.dm.peerutils.CommonSystem;
import com.ge.med.terra.tap.print.PrintableUMAIPrintService;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DefaultSystem
extends CommonSystem {
    protected DMObject[] currentSelection = null;
    protected Comparator comp = new Comparator(){

        public int compare(Object o1, Object o2) {
            return this.compare((DMObject)o1, (DMObject)o2);
        }

        public int compare(DMObject n1, DMObject n2) {
            int s2;
            int s1;
            if (!n1.getType().endsWith(n2.getType())) {
                return 0;
            }
            if (n1.getType().equalsIgnoreCase("patient")) {
                String name1 = (String)n1.getValue(16, 16);
                String name2 = (String)n2.getValue(16, 16);
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return 1;
                }
                if (name2 == null) {
                    return -1;
                }
                return name1.compareTo(name2);
            }
            if (n1.getType().equalsIgnoreCase("study")) {
                String studyId1 = (String)n1.getValue(32, 16);
                String studyId2 = (String)n2.getValue(32, 16);
                if (studyId1 == null && studyId2 == null) {
                    return 0;
                }
                if (studyId1 == null) {
                    return 1;
                }
                if (studyId2 == null) {
                    return -1;
                }
                return studyId1.compareTo(studyId2);
            }
            if (n1.getType().equalsIgnoreCase("series")) {
                int s22;
                int s12;
                String seriesNo1 = (String)n1.getValue(32, 17);
                String seriesNo2 = (String)n2.getValue(32, 17);
                if (seriesNo1 == null && seriesNo2 == null) {
                    return 0;
                }
                if (seriesNo1 == null) {
                    return 1;
                }
                if (seriesNo2 == null) {
                    return -1;
                }
                try {
                    s12 = Integer.parseInt(seriesNo1.toString());
                }
                catch (NumberFormatException ex) {
                    s12 = 0;
                }
                try {
                    s22 = Integer.parseInt(seriesNo2.toString());
                }
                catch (NumberFormatException ex) {
                    s22 = 0;
                }
                return s12 - s22;
            }
            String imageNo1 = (String)n1.getValue(32, 19);
            String imageNo2 = (String)n2.getValue(32, 19);
            if (imageNo1 == null && imageNo2 == null) {
                return 0;
            }
            if (imageNo1 == null) {
                return 1;
            }
            if (imageNo2 == null) {
                return -1;
            }
            try {
                s1 = Integer.parseInt(imageNo1.toString());
            }
            catch (NumberFormatException ex) {
                s1 = 0;
            }
            try {
                s2 = Integer.parseInt(imageNo2.toString());
            }
            catch (NumberFormatException ex) {
                s2 = 0;
            }
            return s1 - s2;
        }
    };
    int height;
    int width;
    int off;
    Component[] panels;
    JFrame cozyFrame = null;
    JFrame mainFrame = null;
    JPanel parentPanel = new JPanel();
    JPanel leftPanel = new JPanel();
    JPanel rightPanel = new JPanel();
    JPanel leftBottomPanel = new JPanel();
    Integer port = null;
    JPanel[] displayArea;
    boolean isMulti;
    int current;
    CardLayout cardLayout = new CardLayout();

    public void init(String appname, Properties prop, String[] args) {
        if (args == null || args.length < 2) {
            Tap.log.log(Level.WARNING, "Could not initialize DefaultSystem.  No Session Params are given");
            throw new RuntimeException("Could not initialize DefaultSystem.  No Session Params are given");
        }
        super.init(appname, prop, args);
        this.systemProperty.setProperty("gspsCapable", "true");
        this.systemProperty.setProperty("screenSaveCapable", "true");
        this.systemProperty.setProperty("printServiceCapable", "true");
        this.systemProperty.setProperty("getBrowserSelectionCapable", "true");
        this.systemProperty.setProperty("setBrowserSelectionCapable", "true");
        this.systemProperty.setProperty("dbObjectLockUnlockCapable", "false");
        this.systemProperty.setProperty("systemLoggingCapable", "true");
        this.systemProperty.setProperty("layoutControlAndDisplayAreaCapable", "true");
        this.systemProperty.setProperty("installWatchDogCapable", "true");
        String[] sessionArgs = null;
        if (args.length > 2) {
            sessionArgs = new String[args.length - 2];
            for (int i = 0; i < sessionArgs.length; ++i) {
                sessionArgs[i] = args[i + 2];
            }
        }
        this.createLogHandler();
        this.dmss = new DMSession(args[0], args[1], sessionArgs);
        this.initObjects();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.height = screenSize.height;
        this.width = screenSize.width;
        if (this.width > 2000) {
            this.width /= 2;
            this.off = this.width;
        }
    }

    private void initObjects() {
        this.currentSelection = new DMObject[3];
        System.err.println("***********************setting up the object tree***********************");
        DMObject[] patients = this.dmss.getChildren();
        ArrayList<DMObject> al = new ArrayList<DMObject>();
        for (int i = 0; i < patients.length; ++i) {
            DMObject[] studies = patients[i].getRelated("Study");
            for (int j = 0; j < studies.length; ++j) {
                al.add(studies[j]);
            }
        }
        DMObject[] exams = al.toArray(new DMObject[al.size()]);
        Arrays.sort(exams, this.comp);
        this.currentSelection[1] = exams[0];
        for (int i = 0; i < patients.length; ++i) {
            DMObject[] studies = patients[i].getRelated("Study");
            boolean found = false;
            for (int j = 0; j < studies.length; ++j) {
                if (!studies[j].equals(exams[0])) continue;
                this.currentSelection[0] = patients[i];
                found = true;
                break;
            }
            if (found) break;
        }
        DMObject[] series = exams[0].getRelated("Series");
        Arrays.sort(series, this.comp);
        this.currentSelection[2] = series[0];
    }

    private void createLogHandler() {
        Logger appLogger = Logger.getLogger(this.appname);
        String userHome = System.getProperty("user.home");
        String logHandler = null;
        boolean appendMode = true;
        if (this.systemProperty != null) {
            String openMode = this.systemProperty.getProperty("LOG_APPEND", "YES");
            if (!openMode.equals("YES")) {
                appendMode = false;
            }
            logHandler = this.systemProperty.getProperty("Log_Handler");
        }
        if (userHome != null) {
            userHome = userHome + File.separator;
            userHome = userHome + this.appname + ".xml";
        } else {
            userHome = this.appname + ".xml";
        }
        File logFile = new File(userHome);
        if (logFile.exists()) {
            try {
                if (new FileOutputStream(userHome).getChannel().tryLock() == null) {
                    throw new RuntimeException("LogFile is Locked");
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            FileHandler file = new FileHandler(userHome, appendMode);
            appLogger.addHandler(file);
            System.err.println("in DefaultSystem...created LogHandler.....name==" + userHome);
            appLogger.setUseParentHandlers(false);
        }
        catch (IOException ex) {
            Tap.log.log(Level.WARNING, "Could not create application logFile", ex);
            appLogger.setUseParentHandlers(true);
        }
        if (logHandler != null) {
            try {
                Class<?> cl = null;
                cl = Class.forName(logHandler);
                appLogger.addHandler((Handler)cl.newInstance());
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Could not create application Log via " + logHandler);
            }
        }
    }

    public DMObject[] getSelection() {
        return this.currentSelection;
    }

    public void setSelection(DMObject[] dmos) {
        if (dmos == null || dmos.length == 0) {
            return;
        }
        String level = dmos[0].getType();
        DMObject[] newSelection = new DMObject[dmos.length];
        for (int i = 0; i < dmos.length; ++i) {
            if (!dmos[i].getType().equalsIgnoreCase(level)) {
                IllegalArgumentException ex = new IllegalArgumentException("dmos level should be the same");
                Tap.log.log(Level.WARNING, "dmos level should be the same", ex);
                throw ex;
            }
            newSelection[i] = dmos[i];
        }
        this.currentSelection = newSelection;
    }

    private DMObject[] getSiblings(DMObject dmo) {
        DMObject[] patients = this.dmss.getChildren();
        Arrays.sort(patients, this.comp);
        if (dmo.getType().equalsIgnoreCase("Study")) {
            ArrayList<DMObject> al = new ArrayList<DMObject>();
            for (int i = 0; i < patients.length; ++i) {
                DMObject[] exams = patients[i].getRelated("Study");
                for (int j = 0; j < exams.length; ++j) {
                    al.add(exams[j]);
                }
            }
            DMObject[] exams = al.toArray(new DMObject[al.size()]);
            Arrays.sort(exams, this.comp);
            return exams;
        }
        if (dmo.getType().equalsIgnoreCase("Series")) {
            ArrayList<DMObject> al = new ArrayList<DMObject>();
            for (int i = 0; i < patients.length; ++i) {
                DMObject[] exams1 = patients[i].getRelated("Study");
                for (int j = 0; j < exams1.length; ++j) {
                    al.add(exams1[j]);
                }
            }
            DMObject[] exams = al.toArray(new DMObject[al.size()]);
            for (int i = 0; i < exams.length; ++i) {
                DMObject[] series = exams[i].getRelated("Series");
                for (int j = 0; j < series.length; ++j) {
                    if (!series[j].equals(dmo)) continue;
                    Arrays.sort(series, this.comp);
                    return series;
                }
            }
        } else if (dmo.getType().equalsIgnoreCase("Patient")) {
            DMObject[] pats = this.dmss.getChildren();
            Arrays.sort(pats, this.comp);
        }
        return null;
    }

    public DMObject getNextInBrowser(DMObject dmo, boolean reverse) {
        if (this.dmss == null) {
            return null;
        }
        if (dmo.getType().equalsIgnoreCase("Patient") || dmo.getType().equalsIgnoreCase("Study") || dmo.getType().equalsIgnoreCase("Series")) {
            DMObject[] siblings = this.getSiblings(dmo);
            if (null != siblings) {
                for (int i = 0; i < siblings.length; ++i) {
                    if (!siblings[i].equals(dmo)) continue;
                    if (reverse) {
                        if (i == 0) {
                            return siblings[siblings.length - 1];
                        }
                        return siblings[i - 1];
                    }
                    if (i == siblings.length - 1) {
                        return siblings[0];
                    }
                    return siblings[i + 1];
                }
            }
        } else if (dmo.getType().equalsIgnoreCase("Image")) {
            IllegalArgumentException ex = new IllegalArgumentException("Cannot use image or patient level objects");
            Tap.log.log(Level.WARNING, "Cannot use image or patient level objects", ex);
            throw ex;
        }
        IllegalArgumentException ex = new IllegalArgumentException("Invalid DMObject");
        Tap.log.log(Level.WARNING, "Invalid DMObject", ex);
        throw ex;
    }

    public String getSystemName() {
        return "Windows";
    }

    public String send(String msg) {
        try {
            if (msg.equals("open_filmComposer")) {
                System.err.println("in openFilmComposer");
                ((PrintableUMAIPrintService)this.getPrintService()).openFilmComposer();
                return "OK";
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "send command failed", ex);
            throw new RuntimeException(ex);
        }
        return "Unkown Command";
    }

    public int spaceReserve(long space) {
        RuntimeException ex = new RuntimeException("Method spaceReserve(long space) not supported");
        Tap.log.log(Level.WARNING, "Method spaceReserve(long space) not supported", ex);
        throw ex;
    }

    public void spaceRelease(int handle) {
        RuntimeException ex = new RuntimeException("Method spaceRelease(int handle) not supported");
        Tap.log.log(Level.WARNING, "Method spaceRelease(int handle) not supported", ex);
        throw ex;
    }

    public DMSession getLocalDB() {
        return this.dmss;
    }

    public static void main(String[] args) {
        DMSystem dmsys = DMSystem.getDMSystem("windows");
        dmsys.init("me", null, args);
        DMObject[] dmos = dmsys.getSelection();
        for (int i = 0; i < dmos.length; ++i) {
            System.err.println("dmos[" + i + "]===" + dmos[i]);
        }
    }

    public void setRepresentativeDMObjet(DMObject dmo) {
        this.dmo = dmo;
    }

    public DMObject getRepresentativeDMObjet() {
        return this.dmo;
    }

    public PrintService getPrintService() {
        DocFlavor flavor = new DocFlavor("application/x-java-" + this.getSystemName() + "-printable-print-service", "java.awt.print.Printable");
        PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, null);
        if (services.length > 0) {
            return services[0];
        }
        Tap.log.log(Level.WARNING, "No PrintService available");
        return null;
    }

    public void manageDeskTop(Component[] panels, String deskTop) {
        this.panels = panels;
        for (int i = 0; i < panels.length; ++i) {
            panels[i].setVisible(true);
        }
    }

    public void positionSplashScreen(Component splashScreen) {
        Dimension screenS = splashScreen.getSize();
        splashScreen.setBounds(this.width / 2 - screenS.width / 2, this.height / 2 - screenS.height / 2, screenS.width, screenS.height);
        splashScreen.setBackground(new Color(186, 190, 204));
    }

    public void setControlAndDisplayAreaBounds(JPanel controlArea, JPanel[] displayArea) {
        this.mainFrame = new JFrame();
        this.cozyFrame = new JFrame();
        this.displayArea = displayArea;
        if (this.displayArea.length > 1) {
            int i;
            String screenMode = this.systemProperty.getProperty("ScreenMode");
            if (screenMode != null && screenMode.equalsIgnoreCase("Single")) {
                this.rightPanel.setLayout(new GridLayout(1, displayArea.length));
                for (i = 0; i < displayArea.length; ++i) {
                    this.rightPanel.add(displayArea[i]);
                }
            } else {
                this.isMulti = true;
                this.current = 0;
                this.rightPanel.setLayout(this.cardLayout);
                for (i = 0; i < displayArea.length; ++i) {
                    this.rightPanel.add((Component)displayArea[i], Integer.toString(i));
                }
                this.cardLayout.show(this.rightPanel, new Integer(this.current).toString());
            }
        } else if (this.displayArea.length == 1) {
            this.rightPanel.setLayout(new BorderLayout());
            this.rightPanel.add((Component)displayArea[0], "Center");
        }
        DefaultCozybar cozybar = this.isMulti ? new DefaultCozybar(true) : new DefaultCozybar(false);
        this.cozyFrame.setContentPane(cozybar);
        this.parentPanel.setLayout(new BorderLayout());
        this.leftPanel.setLayout(new BorderLayout());
        this.leftPanel.add((Component)cozybar, "North");
        this.leftPanel.add((Component)this.leftBottomPanel, "Center");
        this.leftBottomPanel.setLayout(new BorderLayout());
        this.leftBottomPanel.add((Component)controlArea, "Center");
        cozybar.setPreferredSize(new Dimension(256, 60));
        this.parentPanel.add((Component)this.rightPanel, "Center");
        this.parentPanel.add((Component)this.leftPanel, "West");
        this.leftPanel.setPreferredSize(new Dimension(256, this.height));
        this.mainFrame.setContentPane(this.parentPanel);
        this.mainFrame.setBounds(0, 0, this.width, this.height);
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.setTitle(this.appname + " on DefaultSystem");
        this.mainFrame.setVisible(true);
        this.port = new Integer((1000 + Math.abs(this.appname.hashCode())) % 10000);
        try {
            Socket pi = new Socket("127.0.0.1", (int)this.port);
            DataOutputStream oss = new DataOutputStream(pi.getOutputStream());
            oss.writeBytes("show\n");
            oss.close();
            System.err.println("show message sent");
            System.exit(0);
        }
        catch (IOException ex1) {
            Tap.log.log(Level.INFO, "No Hide registered", ex1);
            Thread t = new Thread(){

                public void run() {
                    try {
                        ServerSocket listen = new ServerSocket(DefaultSystem.this.port);
                        System.err.println("server started");
                        block2: while (true) {
                            Socket s = listen.accept();
                            System.err.println("accepted....");
                            BufferedReader is = new BufferedReader(new InputStreamReader(s.getInputStream()));
                            while (true) {
                                String request;
                                if ((request = is.readLine()) == null) continue block2;
                                if (request.equals("show")) {
                                    DefaultSystem.this.mainFrame.setVisible(true);
                                    continue;
                                }
                                if (!request.equals("hide")) continue;
                                DefaultSystem.this.mainFrame.setVisible(false);
                            }
                            break;
                        }
                    }
                    catch (IOException ex) {
                        Tap.log.log(Level.WARNING, "Hide|Show server exception", ex);
                        return;
                    }
                }
            };
            t.start();
            Tap.log.log(Level.INFO, "Hide|Show server started");
        }
    }

    public boolean isSupportedSystem() {
        return true;
    }

    private class DefaultCozybar
    extends JPanel {
        JPanel jPanel1 = new JPanel();
        BorderLayout borderLayout1 = new BorderLayout();
        JButton openFC = new JButton();
        JButton browser = new JButton();
        JButton next = new JButton();
        GridLayout gridLayout = new GridLayout(1, 3);
        JPanel up = new JPanel();
        JPanel down = new JPanel();
        JPanel left = new JPanel();
        JPanel right = new JPanel();

        public DefaultCozybar(boolean isMultiple) {
            try {
                this.myInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.openFC.setFocusPainted(false);
            this.browser.setFocusPainted(false);
            this.next.setFocusPainted(false);
            if (isMultiple) {
                this.next.setIcon(new ImageIcon(DefaultSystem.class.getResource("icons/nextScreen16.PNG")));
                this.jPanel1.add((Component)this.next, null);
                this.next.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            }
            this.openFC.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.browser.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        }

        private void myInit() throws Exception {
            this.setLayout(this.borderLayout1);
            this.openFC.setMaximumSize(new Dimension(65, 45));
            this.openFC.setMinimumSize(new Dimension(65, 45));
            this.openFC.setIcon(new ImageIcon(this.getClass().getResource("icons/iconewfilmer1.gif")));
            this.openFC.setSelected(false);
            this.browser.setIcon(new ImageIcon(this.getClass().getResource("icons/icopatientlist1.gif")));
            this.jPanel1.setLayout(this.gridLayout);
            this.add((Component)this.jPanel1, "Center");
            this.jPanel1.add((Component)this.browser, null);
            this.jPanel1.add((Component)this.openFC, null);
            this.setBackground(new Color(186, 193, 218));
            this.up.setBackground(null);
            this.down.setBackground(null);
            this.left.setBackground(null);
            this.right.setBackground(null);
            this.jPanel1.setBackground(null);
            this.up.setSize(10, 5);
            this.down.setSize(10, 5);
            this.left.setSize(10, 10);
            this.right.setSize(10, 10);
            this.add((Component)this.up, "North");
            this.add((Component)this.down, "South");
            this.add((Component)this.left, "West");
            this.add((Component)this.right, "East");
        }
    }
}

