/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.archive;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.archive.ArchiveSession;
import com.ge.med.terra.tap.dm.archive.ArchiveTagValue;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tag;
import com.ge.med.terra.tap.util.dicom.tagValue;
import com.ge.med.terra.tap.util.dicom.vr;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DicomCompositeArchive {
    private static final char MULTI_DELIM_CHAR = '\\';
    private static final String[] LEVELS = new String[]{"PATIENT", "STUDY", "SERIES", "IMAGE"};
    private static final String TOP_LEVEL_DIR = "DICOM";
    private static dicomParser parser = new dicomParser();
    private static tagValue[] imageTags = new tagValue[]{new tagValue(4, 5392), new tagValue(4, 5393), new tagValue(4, 5394)};
    private final tagValue[][] ieTags = new tagValue[4][];
    private final tagValue[] patientIDTags = new tagValue[]{new tagValue(16, 32), new tagValue(16, 48)};
    private final tagValue[] studyIDTags = new tagValue[]{new tagValue(32, 13)};
    private final tagValue[] seriesIDTags = new tagValue[]{new tagValue(32, 14)};
    private final tagValue[] imageIDTags = new tagValue[]{new tagValue(4, 5393)};
    private final tagValue[][] idTags = new tagValue[][]{this.patientIDTags, this.studyIDTags, this.seriesIDTags, this.imageIDTags};
    private int[] ieNumbers = new int[]{0, 0, 0, 0};
    private File dicomFile;
    private ArchiveSession thisSess;
    private int streamEnd;
    private String imagePath = "DICOM";
    private int offsetToChild = 0;
    private int offsetToNextSibling = 0;
    private int childOffset = 0;
    private int siblingOffset = 0;
    private boolean newWrite = true;
    private long patientOffset = 0L;
    private long studyOffset = 0L;
    private long seriesOffset = 0L;
    private long imageOffset = 0L;

    public DicomCompositeArchive(ArchiveSession ses, File dFile, tag[][] tags, MappedByteBuffer stream, int firstRec) {
        this.thisSess = ses;
        this.dicomFile = dFile;
        this.fillInKeyTags(tags);
        this.streamEnd = stream.position();
        this.insertIE(stream, stream.position(), firstRec, 0);
    }

    private void fillInKeyTags(tag[][] tags) {
        for (int i = 0; i < LEVELS.length; ++i) {
            this.ieTags[i] = new tagValue[tags[i].length];
            for (int j = 0; j < tags[i].length; ++j) {
                this.ieTags[i][j] = new tagValue(tags[i][j].group, tags[i][j].element);
                this.ieTags[i][j].vrep = dicomParser.getDictionary().getVR(tags[i][j].group, tags[i][j].element);
            }
            this.getValues(this.ieTags[i]);
            this.getValues(this.idTags[i]);
        }
        tagValue[] parseTags = new tagValue[]{new tagValue(2, 2), new tagValue(2, 3), new tagValue(2, 16)};
        this.getValues(parseTags);
        DicomCompositeArchive.copyTags(parseTags, imageTags);
        parseTags = new tagValue[]{parseTags[1]};
        DicomCompositeArchive.copyTags(parseTags, this.imageIDTags);
    }

    private static void copyTags(tagValue[] parseTags, tagValue[] destTags) {
        for (int i = 0; i < parseTags.length; ++i) {
            destTags[i].len = parseTags[i].len;
            destTags[i].value = parseTags[i].value;
            destTags[i].vrep = dicomParser.getDictionary().getVR(parseTags[i].group, parseTags[i].element);
        }
    }

    private Vector<ArchiveTagValue> readItem(MappedByteBuffer out) {
        Vector<ArchiveTagValue> vc = new Vector<ArchiveTagValue>();
        int group = out.getShort() & 0xFFFF;
        int element = out.getShort() & 0xFFFF;
        if (group == 65534 && element == 57344) {
            int len = out.getInt() & 0xFFFFFFFF;
            group = out.getShort() & 0xFFFF;
            element = out.getShort() & 0xFFFF;
            while (group != 65534 && element != 57357 || group != 65534 && element != 57344) {
                vc.add(new ArchiveTagValue(group, element, out));
                if (group == 4 && element == 5120) {
                    this.offsetToNextSibling = out.position() - 4;
                }
                if (group == 4 && element == 5152) {
                    this.offsetToChild = out.position() - 4;
                }
                if (!out.hasRemaining()) break;
                group = out.getShort() & 0xFFFF;
                element = out.getShort() & 0xFFFF;
            }
            if (out.hasRemaining()) {
                out.getInt();
            }
        } else {
            throw new IllegalStateException("DICOMDIR stream is not at the end of a sequence");
        }
        if (vc.size() == 0) {
            throw new IllegalStateException("Unable to find any directory record items");
        }
        return vc;
    }

    private void insertIE(MappedByteBuffer out, long patientOffset, long old, int level) {
        if (level > 3) {
            return;
        }
        try {
            if (patientOffset == old) {
                if (this.newWrite) {
                    out.position(out.position() - 8);
                    int g = out.getShort() & 0xFFFF;
                    int e = out.getShort() & 0xFFFF;
                    if (g == 65534 && e == 57565) {
                        out.position(out.position() - 4);
                    } else {
                        out.position(out.position() + 4);
                    }
                    this.newWrite = false;
                }
                ArchiveTagValue.itemStart.write(out);
                new ArchiveTagValue(4, 5120, "UL", (long)this.siblingOffset).write(out);
                this.offsetToNextSibling = out.position() - 4;
                new ArchiveTagValue(4, 5136, "US", 65535).write(out);
                new ArchiveTagValue(4, 5152, "UL", (long)this.childOffset).write(out);
                this.offsetToChild = out.position() - 4;
                new ArchiveTagValue(4, 5168, "CS", LEVELS[level]).write(out);
                int n = level;
                this.ieNumbers[n] = this.ieNumbers[n] + 1;
                if (level == 3) {
                    this.imagePath = TOP_LEVEL_DIR;
                    for (int levelCount = 0; levelCount <= level; ++levelCount) {
                        this.imagePath = this.imagePath + File.separator + LEVELS[levelCount].substring(0, 2) + Integer.toString(this.ieNumbers[levelCount]);
                    }
                    String imagePathTagValue = this.imagePath.replace(File.separatorChar, '\\');
                    new ArchiveTagValue(4, 5376, "CS", imagePathTagValue).write(out);
                    for (int tagNum = 0; tagNum < imageTags.length; ++tagNum) {
                        this.writeTag(imageTags[tagNum], out);
                    }
                }
                for (int tagNum = 0; tagNum < this.ieTags[level].length; ++tagNum) {
                    this.writeTag(this.ieTags[level][tagNum], out);
                }
                ArchiveTagValue.itemEnd.write(out);
                if (level == 3) {
                    ArchiveTagValue.seqEnd.write(out);
                }
                int currentOffset = out.position();
                out.position(this.offsetToChild);
                out.putInt(currentOffset);
                out.position(currentOffset);
                this.insertIE(out, out.position(), out.position(), level + 1);
            } else {
                out.position((int)old);
                Vector<ArchiveTagValue> vec = this.readItem(out);
                boolean theSame = true;
                for (int i = 0; i < this.idTags[level].length; ++i) {
                    tagValue tg1 = this.idTags[level][i];
                    boolean found = false;
                    for (int j = 0; j < vec.size(); ++j) {
                        ArchiveTagValue tg = vec.get(j);
                        if (tg1.group == tg.group && tg1.element == tg.element) {
                            found = true;
                            if (!this.compareValue(tg1, tg)) {
                                theSame = false;
                                break;
                            }
                        }
                        if (found) break;
                    }
                    if (!theSame) break;
                }
                for (int j = 0; j < vec.size(); ++j) {
                    ArchiveTagValue tg = vec.get(j);
                    if (tg.group == 4 && tg.element == 5120) {
                        this.siblingOffset = ((Long)tg.value).intValue();
                        continue;
                    }
                    if (tg.group != 4 || tg.element != 5152) continue;
                    this.childOffset = ((Long)tg.value).intValue();
                }
                int n = level;
                this.ieNumbers[n] = this.ieNumbers[n] + 1;
                if (theSame) {
                    this.fillInLevelOffset(level, old);
                    out.position(this.childOffset);
                    this.insertIE(out, this.streamEnd, out.position(), level + 1);
                } else {
                    if (this.siblingOffset == 0) {
                        out.position(this.offsetToNextSibling);
                        ArchiveTagValue.writeUnsignedInt(this.streamEnd - 8, out);
                        out.position(this.streamEnd);
                    } else {
                        out.position(this.siblingOffset);
                    }
                    this.insertIE(out, this.streamEnd, out.position(), level);
                }
            }
        }
        catch (IOException ex) {
        }
        catch (ReadOnlyBufferException robex) {
            Tap.log.warning("Incomplete or corrupt data set.  Attempted to update a read-only archive.");
        }
    }

    private boolean compareValue(tagValue t1, tagValue t2) {
        if (t1.vrep != t2.vrep) {
            return false;
        }
        return t1.value.equals(t2.value);
    }

    private void writeTag(tagValue value, MappedByteBuffer stream) {
        try {
            if (value.value instanceof String) {
                if (value.vrep == 0) {
                    value.vrep = dicomParser.getDictionary().getVR(value.group, value.element);
                }
                new ArchiveTagValue(value.group, value.element, vr.toString(value.vrep), (String)value.value).write(stream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void getValues(tagValue[] list) {
        try {
            if (this.dicomFile.getName() != null) {
                parser.setFile(this.dicomFile.getAbsolutePath());
            }
            parser.fill(list);
            parser.clearFile();
        }
        catch (FileNotFoundException ex) {
            Tap.log.log(Level.WARNING, "Error loading values for tags: ", ex);
        }
    }

    private void fillInLevelOffset(int level, long old) {
        if (level == 0) {
            this.patientOffset = old;
        } else if (level == 1) {
            this.studyOffset = old;
        } else if (level == 2) {
            this.seriesOffset = old;
        } else if (level == 3) {
            this.imageOffset = old;
        }
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public long getPatientOffset() {
        return this.patientOffset;
    }

    public long getStudyOffset() {
        return this.studyOffset;
    }

    public long getSeriesOffset() {
        return this.seriesOffset;
    }

    public long getImageOffset() {
        return this.imageOffset;
    }
}

