/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.archive;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.archive.ArchiveComposite;
import com.ge.med.terra.tap.dm.archive.ArchiveSession;
import com.ge.med.terra.tap.dm.archive.ArchiveTagValue;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.sessionFile.fileImage;
import com.ge.med.terra.tap.dm.sessionFile.fileImageManager;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class ArchiveObject
implements DMiObject,
DMTagValueInterface {
    private long offset = -1L;
    private String type;
    private ArchiveComposite repComposite = null;
    private ArchiveSession session = null;

    public ArchiveObject(String type, File path, ArchiveSession ses, long offset) {
        if (type == null) {
            throw new DMException("Illegal arguments to ArchiveObject Constructor");
        }
        this.type = type;
        this.session = ses;
        this.offset = offset;
    }

    public void setLock(int lockType) {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    public int getLock() {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    public String getType() {
        return this.type;
    }

    public Object getValue(DMTag t) {
        return this.getRepComposite().getValue(t);
    }

    public void getValues(DMElement[] elements) {
        this.getRepComposite().getValues(elements);
    }

    public void setValues(DMElement[] elements) {
        if (this.session.readOnlyArchive) {
            throw new RuntimeException("Can't update: READ-ONLY Media");
        }
        throw new UnsupportedOperationException("Method setValues() not yet implemented.");
    }

    public DMiComposite[] getComposites(DMQuery q) {
        if (this.type.equalsIgnoreCase("image")) {
            return new ArchiveComposite[]{this.getRepComposite()};
        }
        ArchiveSession.ArchiveNode[] nodes = this.session.getAllImageNodes(this.session.readItem(this.offset));
        if (null == nodes) {
            return new ArchiveComposite[0];
        }
        DMiComposite[] comps = new ArchiveComposite[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            comps[i] = new ArchiveComposite(new File(nodes[i].getImagePath()), this.session);
        }
        this.repComposite = comps[0];
        return comps;
    }

    public ArchiveComposite getRepComposite() {
        File fl;
        if (this.repComposite != null && (fl = new File(this.repComposite.getFilePath())).exists()) {
            return this.repComposite;
        }
        ArchiveSession.ArchiveNode node1 = this.session.readItem(this.offset);
        ArchiveSession.ArchiveNode node = this.session.getRepImageNode(node1);
        this.repComposite = new ArchiveComposite(new File(node.getImagePath()), this.session);
        tagValue[] tvs = node.tvs;
        for (int i = 0; i < tvs.length; ++i) {
            if (tvs[i].group == 4) continue;
            this.repComposite.elemCache.put(new DMTag(tvs[i].group, tvs[i].element), tvs[i]);
        }
        return this.repComposite;
    }

    public int getNumberOfComposites(DMQuery q) {
        return this.getComposites(q).length;
    }

    private int getLevelNumber(String levelString) {
        if (levelString.equalsIgnoreCase("patient")) {
            return 0;
        }
        if (levelString.equalsIgnoreCase("study")) {
            return 1;
        }
        if (levelString.equalsIgnoreCase("series")) {
            return 2;
        }
        if (levelString.equalsIgnoreCase("image")) {
            return 3;
        }
        return -1;
    }

    public DMiObject[] getRelated(String ieType, DMQuery q) {
        final ArrayList list = new ArrayList();
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            public boolean gotOne(DMiObject ob) {
                list.add(ob);
                return true;
            }
        };
        this.getRelated(ieType, q, rcvr);
        return list.toArray(new DMiObject[0]);
    }

    public void getRelated(String type, DMQuery q, DMiObjectReceiver cb) {
        int queryLevel;
        int myLevel = this.getLevelNumber(this.type);
        if (myLevel == (queryLevel = this.getLevelNumber(type))) {
            if (q != null ? q.valid(this) && !cb.gotOne(this) : !cb.gotOne(this)) {
                return;
            }
        } else if (queryLevel > myLevel) {
            ArchiveSession.ArchiveNode node = this.session.readItem(this.offset);
            ArchiveSession.ArchiveNode[] nodes = this.session.getChildNodes(node, type);
            for (int i = 0; i < nodes.length; ++i) {
                ArchiveObject obj = new ArchiveObject(type, null, this.session, nodes[i].myOffset);
                if (!(q != null ? q.valid(obj) && !cb.gotOne(obj) : !cb.gotOne(obj))) continue;
                return;
            }
        } else {
            ArchiveSession.ArchiveNode node = this.session.readItem(this.offset);
            ArchiveSession.ArchiveNode parentNode = this.session.getParentNodes(node, type);
            if (null == parentNode) {
                return;
            }
            ArchiveObject obj = new ArchiveObject(type, null, this.session, parentNode.myOffset);
            if (q != null ? q.valid(obj) && !cb.gotOne(obj) : !cb.gotOne(obj)) {
                return;
            }
        }
    }

    public int getNumberOfRelated(String ieType, DMQuery q) {
        return this.getRelated(ieType, q).length;
    }

    void deleteDir(String level, String fileName) {
    }

    private void deletePatient(ArchiveSession.ArchiveNode node) {
        boolean deleteAll = false;
        if ((long)this.session.initFileLength == node.myOffset) {
            if (node.nextSibling != 0L) {
                this.session.reWriteOffsetPatientOffset((int)node.nextSibling);
            } else {
                this.session.reWriteOffsetPatientOffset(this.session.initFileLength);
                deleteAll = true;
                this.session.actualFileLength = this.session.initFileLength;
            }
        } else {
            ArchiveSession.ArchiveNode[] sibNodes = this.session.getSiblingNodeA(node);
            if (null != sibNodes) {
                for (int i = 0; i < sibNodes.length; ++i) {
                    if (sibNodes[i].nextSibling != node.myOffset) continue;
                    sibNodes[i].nextSibling = node.nextSibling;
                    sibNodes[i].writeNextSiblingToDICOMDIR();
                    break;
                }
            }
        }
        this.deleteFile(node);
        if (deleteAll) {
            this.session.mb.position(this.session.initFileLength + 8);
            try {
                ArchiveTagValue.seqEnd.write(this.session.mb);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void deleteFile(ArchiveSession.ArchiveNode node) {
        int i;
        ArchiveObject obj = new ArchiveObject(node.level, null, this.session, node.myOffset);
        DMiComposite[] cmps = obj.getComposites(null);
        System.err.println("session.dir===" + this.session.dir);
        Vector<MovedFile> moved = new Vector<MovedFile>();
        int baseIndex = this.session.dir.getAbsolutePath().length();
        boolean fileMove = true;
        for (i = 0; i < cmps.length; ++i) {
            File oldFile;
            String imageName = cmps[i].getFilePath();
            String mvFile = this.session.dir.getAbsolutePath() + File.separator + "REMOVE" + imageName.substring(baseIndex, imageName.length());
            File finalFile = new File(mvFile);
            File parentFile = finalFile.getParentFile();
            if (null != parentFile && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!(oldFile = new File(imageName)).renameTo(finalFile)) {
                fileMove = false;
                break;
            }
            moved.add(new MovedFile(oldFile, finalFile));
        }
        if (fileMove) {
            int levelIndex = -1;
            String fileName = cmps[0].getFilePath();
            while ((levelIndex = fileName.lastIndexOf(File.separator)) >= 0) {
                File file = new File(fileName.substring(0, levelIndex));
                file.delete();
                fileName = fileName.substring(0, levelIndex);
            }
            SimpleUtilities.deleteFilesRecursively(new File(this.session.dir.getAbsolutePath() + File.separator + "REMOVE"));
        } else {
            for (i = 0; i < moved.size(); ++i) {
                MovedFile f = (MovedFile)moved.get(i);
                f.oldFile.renameTo(f.newFile);
            }
        }
    }

    public void delete() {
        System.err.println("in delete...");
        if (this.session.readOnlyArchive) {
            throw new RuntimeException("Can't Delete: ReadOnly Media");
        }
        ArchiveSession.ArchiveNode node = this.session.readItem(this.offset);
        if (node.level.equalsIgnoreCase("patient")) {
            this.deletePatient(node);
            return;
        }
        ArchiveSession.ArchiveNode pnode = this.getParentNode(node);
        if (node.nextSibling > 0L) {
            if (pnode != null) {
                int i;
                ArchiveSession.ArchiveNode[] nodes = this.session.getChildNodes(pnode);
                boolean found = false;
                for (i = 0; i < nodes.length; ++i) {
                    if (nodes[i].nextSibling != this.offset) continue;
                    found = true;
                    break;
                }
                if (found) {
                    nodes[i].nextSibling = node.nextSibling;
                    nodes[i].writeNextSiblingToDICOMDIR();
                    this.deleteFile(node);
                    return;
                }
                pnode.firstChild = node.nextSibling;
                pnode.writeChildToDICOMDIR();
                this.deleteFile(node);
                return;
            }
        } else if (pnode != null) {
            int i;
            ArchiveSession.ArchiveNode[] nodes = this.session.getChildNodes(pnode);
            boolean found = false;
            for (i = 0; i < nodes.length; ++i) {
                if (nodes[i].nextSibling != this.offset) continue;
                found = true;
                break;
            }
            if (found) {
                nodes[i].nextSibling = 0L;
                nodes[i].writeNextSiblingToDICOMDIR();
                this.deleteFile(node);
                return;
            }
        }
        if (pnode != null) {
            System.err.println("in delete ....pnode is not null ....mb.position===" + this.session.mb.position());
            new ArchiveObject(pnode.level, null, this.session, pnode.myOffset).delete();
        }
    }

    ArchiveSession.ArchiveNode getParentNode(ArchiveSession.ArchiveNode node) {
        if (node.level.equalsIgnoreCase("patient")) {
            return null;
        }
        if (node.level.equalsIgnoreCase("study")) {
            return this.session.getParentNodes(node, "patient");
        }
        if (node.level.equalsIgnoreCase("series")) {
            return this.session.getParentNodes(node, "study");
        }
        if (node.level.equalsIgnoreCase("image")) {
            return this.session.getParentNodes(node, "series");
        }
        return null;
    }

    public DMTag[] getTags() {
        return this.getRepComposite().getTags();
    }

    public BufferedImage[] getPixelData(DMTag[] tags) {
        DMiComposite[] comp = this.getComposites(null);
        ArrayList<BufferedImage> al = new ArrayList<BufferedImage>(comp.length);
        for (int i = 0; i < comp.length; ++i) {
            BufferedImage[] imgs = comp[i].getPixelData(tags);
            for (int k = 0; k < imgs.length; ++k) {
                al.add(imgs[k]);
            }
        }
        return al.toArray(new BufferedImage[al.size()]);
    }

    public void attach() {
    }

    public void detach() {
    }

    public String getID() {
        return Long.toString(this.offset);
    }

    public DMiImage[] getImages(DMTag[] tags) {
        fileImageManager.getInstance().setPause(true);
        DMiComposite[] comp = this.getComposites(null);
        ArrayList<fileImage> al = new ArrayList<fileImage>(comp.length);
        for (int i = 0; i < comp.length; ++i) {
            fileImage[] imgs = fileImage.getImages(comp[i], tags);
            if (imgs == null) continue;
            for (int k = 0; k < imgs.length; ++k) {
                al.add(imgs[k]);
            }
        }
        fileImageManager.getInstance().setPause(false);
        return al.toArray(new DMiImage[al.size()]);
    }

    private class MovedFile {
        public File oldFile;
        public File newFile;

        public MovedFile(File o, File n) {
            this.oldFile = o;
            this.newFile = n;
        }
    }
}

