/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XpFreeHandRoi
extends XpStatisticsRoi
implements Serializable {
    private static final boolean debug = false;
    private static final int SUBSAMPLE = 20;
    private transient XpHandle drawHandle = null;
    private transient Rectangle2D rect = null;
    private transient Rectangle2D drect = null;
    private double tx = 0.0;
    private double ty = 0.0;
    private transient GeneralPath debugContains = null;
    private transient GeneralPath drawShape = null;
    private transient GeneralPath modelShape = null;
    private transient Point2D tmpPoint1 = new Point2D.Double();
    private transient List mdList = new ArrayList(512);
    private transient List containsList = new ArrayList(512);
    private int containsListLen = 0;
    private transient Point2D lastDrawPt = new Point2D.Double();
    private transient Point2D lastPt = new Point2D.Double();
    private transient Point2D startMouse = new Point2D.Double();
    private transient Point2D startTx = new Point2D.Double();

    public XpFreeHandRoi(double x, double y) {
        super(new GeneralPath());
        this.drawShape = new GeneralPath();
        this.modelShape = (GeneralPath)this.getModelShape();
        this.rect = new Rectangle2D.Double(x, y, 5.0, 5.0);
        this.drect = (Rectangle2D)this.rect.clone();
        this.lastPt.setLocation(x, y);
        this.drawHandle = new XpHandle((XpAnchorable)this, 0, 16);
        this.drawHandle.setFilled(false);
        this.drawHandle.setLocation(this.lastPt);
        this.add(this.drawHandle);
        this.setHandlePolicy(0);
    }

    public Object clone() {
        XpFreeHandRoi ccr = new XpFreeHandRoi(0.0, 0.0);
        this.copyObject(ccr);
        return ccr;
    }

    public boolean addPoint(double x, double y) {
        XpImage img = this.getImage();
        GeneralPath gp = (GeneralPath)this.getModelShape();
        if (img != null && gp != null) {
            int w = img.getSlice().width;
            int h = img.getSlice().height;
            double X1 = 0.0;
            double Y1 = 0.0;
            double X2 = w;
            double Y2 = h;
            Rectangle2D domain = this.getDomain();
            if (domain != null) {
                X1 = domain.getX();
                Y1 = domain.getY();
                X2 = X1 + domain.getWidth();
                Y2 = Y1 + domain.getHeight();
            }
            byte type = 0;
            if (x >= X1 && y >= Y1 && x < X2 && y < Y2) {
                if (this.mdList.size() > 0) {
                    gp.lineTo((float)x, (float)y);
                    type = 1;
                } else {
                    gp.moveTo((float)x, (float)y);
                }
                this.addPoint(x, y, type);
            }
            return true;
        }
        return false;
    }

    protected void copyObject(Object o) {
        XpFreeHandRoi fh = (XpFreeHandRoi)o;
        super.copyObject(fh);
        fh.rect = (Rectangle2D)this.rect.clone();
        fh.drect = (Rectangle2D)this.drect.clone();
        fh.tx = this.tx;
        fh.ty = this.ty;
        fh.drawShape = (GeneralPath)this.drawShape.clone();
        int idx = 0;
        float[] _reg = new float[2];
        fh.modelShape.reset();
        PathIterator pi = this.modelShape.getPathIterator(null, 1.0);
        while (!pi.isDone()) {
            pi.currentSegment(_reg);
            float x = _reg[0];
            float y = _reg[1];
            int segType = pi.getWindingRule();
            switch (segType) {
                case 0: {
                    fh.modelShape.moveTo(x, y);
                    break;
                }
                case 1: {
                    if (idx > 0) {
                        fh.modelShape.lineTo(x, y);
                        break;
                    }
                    fh.modelShape.moveTo(x, y);
                    break;
                }
            }
            ++idx;
            pi.next();
        }
        fh.drawHandle.setLocation(this.drawHandle.getX(), this.drawHandle.getY());
        fh.drawHandle.setFilled(this.drawHandle.isFilled());
        fh.lastDrawPt.setLocation(this.lastDrawPt);
        fh.lastPt.setLocation(this.lastPt);
        for (int i = 0; i < this.mdList.size(); ++i) {
            DrawDescriptor dd = (DrawDescriptor)this.mdList.get(i);
            DrawDescriptor ndd = new DrawDescriptor();
            ndd.type = dd.type;
            ndd.x = dd.x;
            ndd.y = dd.y;
            fh.mdList.add(ndd);
        }
    }

    public boolean containsROI(XpVisualComponent vc, int x, int y) {
        Rectangle2D bounds;
        if (this.isDragByRoiLabel() && (bounds = this.getRoiLabelBounds()) != null && bounds.contains(x, y)) {
            return true;
        }
        boolean bb = this.drect.contains(x, y);
        if (bb) {
            return this.containedDrawShape(x, y);
        }
        return false;
    }

    public final Shape getDrawShape() {
        this.updateDrawShape();
        return this.drawShape;
    }

    public void render(XpVisualComponent vc, Graphics2D g) {
        super.render(vc, g);
        this.drawRoiId(vc, g, this.get(0));
    }

    public void anchorDragged(MouseEvent e, CPoint drag, Object source) {
        XpHandle xph = (XpHandle)source;
        this.getImagePoint(e.getX(), e.getY(), this.tmpPoint1);
        double x = this.tmpPoint1.getX() - this.tx;
        double y = this.tmpPoint1.getY() - this.ty;
        GeneralPath gp = (GeneralPath)this.getModelShape();
        if (xph == this.drawHandle) {
            XpImage img = this.getImage();
            int w = img.getSlice().width;
            int h = img.getSlice().height;
            double X1 = 0.0;
            double Y1 = 0.0;
            double X2 = w;
            double Y2 = h;
            Rectangle2D domain = this.getDomain();
            if (domain != null) {
                X1 = domain.getX();
                Y1 = domain.getY();
                X2 = X1 + domain.getWidth();
                Y2 = Y1 + domain.getHeight();
            }
            if (x < X1) {
                x = X1;
            }
            if (y < Y1) {
                y = Y1;
            }
            if (x >= X2) {
                x = X2 - 1.0;
            }
            if (y >= Y2) {
                y = Y2 - 1.0;
            }
            gp.lineTo((float)x, (float)y);
            this.addPoint(x, y, (byte)1);
            this.syncModel();
        }
        super.anchorDragged(e, drag, source);
    }

    public void anchorPressed(MouseEvent e, Object source) {
        XpHandle xph = (XpHandle)source;
        this.getImagePoint(e.getX(), e.getY(), this.tmpPoint1);
        double x = this.tmpPoint1.getX() - this.tx;
        double y = this.tmpPoint1.getY() - this.ty;
        this.startMouse.setLocation(x, y);
        if (xph == this.drawHandle) {
            this.addPoint(x, y);
        }
        super.anchorPressed(e, source);
    }

    public void roiDragged(MouseEvent e) {
        double transy;
        double transx;
        XpVisualComponent vc = (XpVisualComponent)e.getSource();
        if (!this.isSelected()) {
            return;
        }
        int modifiers = e.getModifiers();
        boolean mbutton1 = 0 != (modifiers & 0x10);
        boolean shift = 0 != (modifiers & 1);
        this.getImagePoint(e.getX(), e.getY(), this.tmpPoint1);
        double x = this.tmpPoint1.getX();
        double y = this.tmpPoint1.getY();
        double dx = x - this.startMouse.getX();
        double dy = y - this.startMouse.getY();
        if (mbutton1 && this.bbInside(transx = this.startTx.getX() + dx, transy = this.startTx.getY() + dy)) {
            this.tx = transx;
            this.ty = transy;
            this.drawHandle.setLocation(this.lastPt.getX() + this.tx, this.lastPt.getY() + this.ty);
            this.updateDrawRect();
            vc.repaint();
        }
        this.notifyDragged();
    }

    public void roiPressed(MouseEvent e) {
        super.roiPressed(e);
        int modifiers = e.getModifiers();
        boolean mbutton1 = 0 != (modifiers & 0x10);
        boolean shift = 0 != (modifiers & 1);
        this.getImagePoint(e.getX(), e.getY(), this.tmpPoint1);
        double x = this.tmpPoint1.getX();
        double y = this.tmpPoint1.getY();
        this.startTx.setLocation(this.tx, this.ty);
        this.startMouse.setLocation(x, y);
        this.notifyPressed();
    }

    private void addPoint(double x, double y, byte type) {
        DrawDescriptor dd = new DrawDescriptor();
        this.mdList.add(dd);
        dd.type = type;
        dd.x = x;
        dd.y = y;
        this.lastPt.setLocation(x, y);
        this.drawHandle.setLocation(this.lastPt.getX() + this.tx, this.lastPt.getY() + this.ty);
        double x1 = this.rect.getX();
        double y1 = this.rect.getY();
        double x2 = x1 + this.rect.getWidth();
        double y2 = y1 + this.rect.getHeight();
        if (x < x1) {
            x1 = x;
        }
        if (x > x2) {
            x2 = x;
        }
        if (y < y1) {
            y1 = y;
        }
        if (y > y2) {
            y2 = y;
        }
        double w = Math.abs(x1 - x2);
        double h = Math.abs(y1 - y2);
        this.rect.setFrame(x1, y1, w, h);
        this.updateDrawRect();
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new FreeHandCreator();
        }
        return null;
    }

    private boolean bbInside(double transx, double transy) {
        double x1 = this.rect.getX() + transx;
        double y1 = this.rect.getY() + transy;
        double x2 = x1 + this.rect.getWidth();
        double y2 = y1 + this.rect.getHeight();
        XpImage img = this.getImage();
        int w = img.getSlice().width;
        int h = img.getSlice().height;
        double X1 = 0.0;
        double Y1 = 0.0;
        double X2 = w;
        double Y2 = h;
        Rectangle2D domain = this.getDomain();
        if (domain != null) {
            X1 = domain.getX();
            Y1 = domain.getY();
            X2 = X1 + domain.getWidth();
            Y2 = Y1 + domain.getHeight();
        }
        return x1 >= X1 && y1 >= Y1 && x1 < X2 && y1 < Y2 && x2 >= X1 && y2 >= Y1 && x2 < X2 && y2 < Y2;
    }

    private void updateDrawRect() {
        double x1 = this.rect.getX() + this.tx;
        double y1 = this.rect.getY() + this.ty;
        double w = this.rect.getWidth();
        double h = this.rect.getHeight();
        double x2 = x1 + w;
        double y2 = y1 + h;
        this.getDisplayPoint(x1, y1, this.tmpPoint1);
        x1 = this.tmpPoint1.getX();
        y1 = this.tmpPoint1.getY();
        this.getDisplayPoint(x2, y2, this.tmpPoint1);
        x2 = this.tmpPoint1.getX();
        y2 = this.tmpPoint1.getY();
        double x = x2 < x1 ? x2 : x1;
        double y = y2 < y1 ? y2 : y1;
        double nw = Math.abs(x2 - x1);
        double nh = Math.abs(y2 - y1);
        this.drect.setFrame(x, y, nw, nh);
    }

    private boolean containedDrawShape(int x, int y) {
        if (this.containsListLen > 1) {
            Point2D prev = (Point2D)this.containsList.get(0);
            for (int i = 1; i < this.containsListLen; ++i) {
                Point2D p = (Point2D)this.containsList.get(i);
                if (XpGeomUtils.containsCoord(x, y, prev, p, 4)) {
                    return true;
                }
                prev = p;
            }
        }
        return false;
    }

    private void addToContainmentList(float x, float y, int idx) {
        int len = this.containsList.size();
        Point2D p = null;
        if (idx < len) {
            p = (Point2D)this.containsList.get(idx);
        } else {
            int n = idx - len + 1;
            for (int i = 0; i < n; ++i) {
                p = new Point2D.Double();
                this.containsList.add(p);
            }
        }
        if (p != null) {
            p.setLocation(x, y);
        }
    }

    private void updateDrawShape() {
        int size = this.mdList.size();
        Shape rs = this.getModelShape();
        boolean moveTo = false;
        this.drawShape.reset();
        float prevX = -999999.0f;
        float prevY = -999999.0f;
        this.containsListLen = 0;
        if (size == 0) {
            double x = this.drawHandle.getX();
            double y = this.drawHandle.getY();
            this.getDisplayPoint(x, y, this.tmpPoint1);
            float xx = (float)this.tmpPoint1.getX();
            float yy = (float)this.tmpPoint1.getY();
            this.lastDrawPt.setLocation(xx, yy);
            return;
        }
        for (int i = 0; i < size; ++i) {
            DrawDescriptor dd = (DrawDescriptor)this.mdList.get(i);
            double x = dd.x + this.tx;
            double y = dd.y + this.ty;
            this.getDisplayPoint(x, y, this.tmpPoint1);
            float xx = (float)this.tmpPoint1.getX();
            float yy = (float)this.tmpPoint1.getY();
            this.lastDrawPt.setLocation(xx, yy);
            if (dd.type == 0) {
                this.drawShape.moveTo(xx, yy);
                this.addToContainmentList(xx, yy, this.containsListLen++);
                prevX = xx;
                prevY = yy;
                continue;
            }
            this.drawShape.lineTo(xx, yy);
            int manhattanDist = (int)(Math.abs(prevX - xx) + Math.abs(prevY - yy));
            if (manhattanDist <= 20 && this.containsListLen >= 10) continue;
            this.addToContainmentList(xx, yy, this.containsListLen++);
            prevX = xx;
            prevY = yy;
        }
    }

    public final GSPSGraphic gspsDescription() {
        int len = this.mdList.size();
        Point2D[] pts = new Point2D[len];
        for (int i = 0; i < len; ++i) {
            DrawDescriptor p = (DrawDescriptor)this.mdList.get(i);
            pts[i] = new Point2D.Double(p.x, p.y);
        }
        XpRoiHandleContainer.GraphicDescriptor description = new XpRoiHandleContainer.GraphicDescriptor("POLYLINE", pts);
        return description;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        try {
            s.writeDouble(this.rect.getX());
            s.writeDouble(this.rect.getY());
            s.writeDouble(this.rect.getWidth());
            s.writeDouble(this.rect.getHeight());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
            this.rect = new Rectangle2D.Double(s.readDouble(), s.readDouble(), s.readDouble(), s.readDouble());
            this.drect = (Rectangle2D)this.rect.clone();
            this.tmpPoint1 = new Point2D.Double();
            this.lastDrawPt = new Point2D.Double();
            this.lastPt = new Point2D.Double();
            this.startMouse = new Point2D.Double();
            this.startTx = new Point2D.Double();
            this.mdList = new ArrayList(512);
            this.containsList = new ArrayList(512);
            this.setRoiShapeModel(new RoiShapeModel(new GeneralPath()));
            this.drawShape = new GeneralPath();
            this.modelShape = (GeneralPath)this.getModelShape();
            this.lastPt.setLocation(this.rect.getX(), this.rect.getY());
            this.drawHandle = new XpHandle((XpAnchorable)this, 0, 16);
            this.drawHandle.setFilled(false);
            this.drawHandle.setLocation(this.lastPt);
            this.add(this.drawHandle);
            this.setHandlePolicy(0);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private class DrawDescriptor {
        public byte type;
        public double x;
        public double y;

        private DrawDescriptor() {
        }
    }

    private static class FreeHandCreator
    extends XpRoiComponentCreator {
        private XpFreeHandRoi tr = null;
        private CPoint dispPt = new CPoint(1);
        private CPoint imgPt = new CPoint(0);

        private FreeHandCreator() {
        }

        public RoiActor getRoiActor(double x, double y) {
            this.tr = new XpFreeHandRoi(x, y);
            return this.tr;
        }

        public void mousePressed(MouseEvent me) {
            XpVisualComponent vc = (XpVisualComponent)me.getSource();
            int modifiers = me.getModifiers();
            int mbutton1 = modifiers & 0x10;
            int x = me.getX();
            int y = me.getY();
            if (mbutton1 != 0) {
                if (this.tr == null) {
                    this.dropRoi(me);
                }
                if (this.tr != null) {
                    this.dispPt.set(x, y, 0.0);
                    CTransform mat = vc.getTransform((byte)1, (byte)0);
                    mat.transform(this.dispPt, this.imgPt);
                    this.tr.addPoint(this.imgPt.x, this.imgPt.y);
                    this.tr.setSelected(true);
                }
                vc.repaint();
            }
        }

        public void mouseDragged(MouseEvent me) {
            XpVisualComponent vc = (XpVisualComponent)me.getSource();
            int modifiers = me.getModifiers();
            int mbutton1 = modifiers & 0x10;
            int mbutton2 = modifiers & 8;
            int x = me.getX();
            int y = me.getY();
            if (mbutton1 != 0 && this.tr != null) {
                CPoint img_pt = this.getImgPt(vc, x, y);
                this.tr.anchorDragged(me, img_pt, this.tr.get(0));
                this.tr.syncModel();
                vc.repaint();
            }
        }
    }
}

