/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render.remote;

import com.ge.med.idc.RemoteImage;
import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.jami.CodecUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.image.XjMedicalImage;
import com.ge.med.terra.jami.remote.RmServerDataManager;
import com.ge.med.terra.jami.render.remote.RemoteRoiStatistics;
import com.ge.med.terra.jami.roi.JamiRoiStatistics;
import com.ge.med.terra.jami.roi.RoiStatistics;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.clientServer.XmBasicService;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class XmImageSet
extends XmBasicService {
    private static final byte BUILD_CMD = 0;
    private static final byte GET_VALUE_CMD = 1;
    private static final byte GET_HEIGHT_CMD = 2;
    private static final byte GET_WIDTH_CMD = 3;
    private static final byte GET_PATH_CMD = 4;
    private static final byte GET_OFFSET_CMD = 5;
    private static final byte GET_STATS_CMD = 6;
    private static final byte GET_PIXELS_CMD = 7;
    private static final byte NUM_METHODS = 8;
    private static final byte RET_TYPE_OBJ = 0;
    private static final byte RET_TYPE_STRING = 1;
    private static final byte RET_TYPE_INT = 2;
    private static final String[] methodNames = new String[8];
    private XmImage[] images;
    private XjImage[] imgs;
    private XpMedicalImage[] medimgs;
    private RoiStatistics[] rmstats;
    private int id;
    private int numImgs;
    private byte[] stats_ret;
    private byte[] roi_args;
    private byte[] pixels_ret;

    public byte[] buildImages(byte[] data) {
        String path = CodecUtils.getString(data, 0);
        System.err.println("XmImageSet.buildImages(): Path: " + path);
        DMSession ses = new DMSession(new String[]{"file", path});
        DMObject[] dmo = ses.getRelated("series");
        this.imgs = dmo[0].getImages(null);
        this.sortImages(this.imgs);
        this.medimgs = XjMedicalImage.createImages(this.imgs);
        this.numImgs = this.imgs.length;
        this.rmstats = new RoiStatistics[this.numImgs];
        this.id = RmServerDataManager.instance().addDataObject(this.medimgs);
        byte[] ret = new byte[8];
        CodecUtils.putInt(ret, 0, this.id);
        CodecUtils.putInt(ret, 4, this.numImgs);
        return ret;
    }

    public byte[] getValue(byte[] data) {
        int element;
        int group;
        if (this.imgs == null) {
            return null;
        }
        int id = CodecUtils.getInt(data, 0);
        Object o = this.imgs[id].getValue(group = CodecUtils.getInt(data, 4), element = CodecUtils.getInt(data, 8));
        if (o instanceof String) {
            String val = (String)o;
            byte[] ret = new byte[CodecUtils.getStringLengthInBytes(val) + 1];
            ret[0] = 1;
            CodecUtils.putString(ret, 1, val);
            return ret;
        }
        if (o instanceof Integer) {
            int val = (Integer)o;
            byte[] ret = new byte[5];
            ret[0] = 2;
            CodecUtils.putInt(ret, 1, val);
            return ret;
        }
        byte[] oarr = CodecUtils.objectToBytes(o);
        byte[] ret = new byte[oarr.length + 1];
        ret[0] = 0;
        System.arraycopy(oarr, 0, ret, 1, oarr.length);
        return ret;
    }

    public byte[] getValues(byte[] data) {
        if (this.imgs == null) {
            return null;
        }
        int id = CodecUtils.getInt(data, 0);
        int group = CodecUtils.getInt(data, 4);
        int element = CodecUtils.getInt(data, 8);
        XjTagValue xjtv = new XjTagValue();
        xjtv.group = group;
        xjtv.element = element;
        this.imgs[id].getValues(new XjTagValue[]{xjtv});
        byte[] objbytes = null;
        objbytes = xjtv.value instanceof String ? ((String)xjtv.value).getBytes() : CodecUtils.objectToBytes(xjtv.value);
        byte[] ret = new byte[14 + objbytes.length + 1];
        CodecUtils.putBoolean(ret, 0, xjtv.littleEndian);
        CodecUtils.putBoolean(ret, 1, xjtv.noValue);
        CodecUtils.putLong(ret, 2, xjtv.offset);
        CodecUtils.putInt(ret, 10, xjtv.vr);
        ret[14] = xjtv.value instanceof String ? (byte)1 : 0;
        System.arraycopy(objbytes, 0, ret, 15, objbytes.length);
        return ret;
    }

    public byte[] getHeight(byte[] data) {
        if (this.imgs == null) {
            return null;
        }
        int id = CodecUtils.getInt(data, 0);
        int h = this.imgs[id].getHeight();
        CodecUtils.putInt(data, 0, h);
        return data;
    }

    public byte[] getWidth(byte[] data) {
        if (this.imgs == null) {
            return null;
        }
        int id = CodecUtils.getInt(data, 0);
        int w = this.imgs[id].getWidth();
        CodecUtils.putInt(data, 0, w);
        return data;
    }

    public byte[] getFilePath(byte[] data) {
        if (this.imgs == null) {
            return null;
        }
        int id = CodecUtils.getInt(data, 0);
        String path = this.imgs[id].getFilePath();
        byte[] ret = new byte[CodecUtils.getStringLengthInBytes(path)];
        CodecUtils.putString(ret, 0, path);
        return ret;
    }

    public byte[] getPixelOffset(byte[] data) {
        if (this.imgs == null) {
            return null;
        }
        int id = CodecUtils.getInt(data, 0);
        long offset = this.imgs[id].getPixelOffset();
        byte[] ret = new byte[8];
        CodecUtils.putLong(ret, 0, offset);
        return ret;
    }

    public XmImageSet() {
        XmImageSet.methodNames[0] = "buildImages";
        XmImageSet.methodNames[1] = "getValue";
        XmImageSet.methodNames[2] = "getHeight";
        XmImageSet.methodNames[3] = "getWidth";
        XmImageSet.methodNames[4] = "getFilePath";
        XmImageSet.methodNames[5] = "getPixelOffset";
        XmImageSet.methodNames[6] = "getStatistics";
        XmImageSet.methodNames[7] = "getPixels";
        this.setMethods(methodNames);
        this.images = null;
        this.imgs = null;
        this.medimgs = null;
        this.rmstats = null;
        this.id = 0;
        this.numImgs = 0;
        this.stats_ret = new byte[80];
        this.roi_args = new byte[128];
        this.pixels_ret = new byte[16];
    }

    public XmImageSet(XmSession xms, String imgPath) {
        XmImageSet.methodNames[0] = "buildImages";
        XmImageSet.methodNames[1] = "getValue";
        XmImageSet.methodNames[2] = "getHeight";
        XmImageSet.methodNames[3] = "getWidth";
        XmImageSet.methodNames[4] = "getFilePath";
        XmImageSet.methodNames[5] = "getPixelOffset";
        XmImageSet.methodNames[6] = "getStatistics";
        XmImageSet.methodNames[7] = "getPixels";
        this.setMethods(methodNames);
        this.images = null;
        this.imgs = null;
        this.medimgs = null;
        this.rmstats = null;
        this.id = 0;
        this.numImgs = 0;
        this.stats_ret = new byte[80];
        this.roi_args = new byte[128];
        this.pixels_ret = new byte[16];
        super.installInto(xms);
        this.numImgs = this.build(imgPath);
    }

    public int getNumImages() {
        return this.numImgs;
    }

    public int getImageSetID() {
        return this.id;
    }

    public Object getValue(int id, int group, int element) {
        byte[] data = new byte[12];
        CodecUtils.putInt(data, 0, id);
        CodecUtils.putInt(data, 4, group);
        CodecUtils.putInt(data, 8, element);
        byte[] ret = this.callSync((byte)1, data);
        Object val = null;
        if (ret != null) {
            if (ret[0] == 0) {
                val = CodecUtils.bytesToObject(ret, 1, ret.length - 1);
            } else if (ret[0] == 1) {
                val = CodecUtils.getString(ret, 1);
            } else if (ret[0] == 2) {
                val = new Integer(CodecUtils.getInt(ret, 1));
            }
        }
        return val;
    }

    public int getWidth(int id) {
        byte[] data = new byte[4];
        CodecUtils.putInt(data, 0, id);
        byte[] ret = this.callSync((byte)3, data);
        return CodecUtils.getInt(ret, 0);
    }

    public int getHeight(int id) {
        byte[] data = new byte[4];
        CodecUtils.putInt(data, 0, id);
        byte[] ret = this.callSync((byte)2, data);
        return CodecUtils.getInt(ret, 0);
    }

    public String getFilePath(int id) {
        byte[] data = new byte[4];
        CodecUtils.putInt(data, 0, id);
        byte[] ret = this.callSync((byte)4, data);
        return CodecUtils.getString(ret, 0);
    }

    public long getPixelOffset(int id) {
        byte[] data = new byte[4];
        CodecUtils.putInt(data, 0, id);
        byte[] ret = this.callSync((byte)5, data);
        return CodecUtils.getLong(ret, 0);
    }

    private int build(String path) {
        byte[] buf = new byte[CodecUtils.getStringLengthInBytes(path)];
        CodecUtils.putString(buf, 0, path);
        try {
            byte[] ret = this.callSync((byte)0, buf);
            this.id = CodecUtils.getInt(ret, 0);
            this.numImgs = CodecUtils.getInt(ret, 4);
            this.images = new XmImage[this.numImgs];
            for (int i = 0; i < this.numImgs; ++i) {
                this.images[i] = new XmImage(this, i);
            }
            return this.numImgs;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public byte[] getStatistics(byte[] data) {
        Shape[] shape = new Shape[1];
        double[] angle = new double[1];
        int id = CodecUtils.getInt(data, 0);
        int newOffset = RemoteRoiStatistics.decode(data, 4, shape, angle);
        if (this.rmstats[id] == null) {
            this.rmstats[id] = new JamiRoiStatistics();
            this.rmstats[id].setImage(this.medimgs[id]);
        }
        XpPixelStatistics ps = this.rmstats[id].getPixelStatistics(shape[0], angle[0]);
        double area = this.rmstats[id].getArea(shape[0], angle[0]);
        double length = this.rmstats[id].getLength(shape[0], angle[0]);
        CodecUtils.putDouble(this.stats_ret, 0, ps.min);
        CodecUtils.putDouble(this.stats_ret, 8, ps.max);
        CodecUtils.putDouble(this.stats_ret, 16, ps.sum);
        CodecUtils.putDouble(this.stats_ret, 24, ps.sumSq);
        CodecUtils.putDouble(this.stats_ret, 32, ps.mean);
        CodecUtils.putDouble(this.stats_ret, 40, ps.variance);
        CodecUtils.putDouble(this.stats_ret, 48, ps.npixels);
        CodecUtils.putDouble(this.stats_ret, 56, area);
        CodecUtils.putDouble(this.stats_ret, 64, length);
        return this.stats_ret;
    }

    private double[] getStatistics(int id, Shape s, double angle) {
        double[] ret = new double[10];
        try {
            CodecUtils.putInt(this.roi_args, 0, id);
            int toffset = RemoteRoiStatistics.encode(s, angle, this.roi_args, 4);
            byte[] bret = this.callSync((byte)6, this.roi_args);
            int offset = 0;
            int i = 0;
            while (i < ret.length) {
                ret[i] = CodecUtils.getDouble(bret, offset);
                ++i;
                offset += 8;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public byte[] getPixels(byte[] data) {
        int h;
        int id = CodecUtils.getInt(data, 0);
        int x = CodecUtils.getInt(data, 4);
        int y = CodecUtils.getInt(data, 8);
        int w = CodecUtils.getInt(data, 12);
        int len = w * (h = CodecUtils.getInt(data, 16)) * 4;
        if (this.pixels_ret.length != len) {
            this.pixels_ret = new byte[len];
        }
        return this.pixels_ret;
    }

    private void getPixels(int id, int x, int y, int w, int h, int[] pixels) {
    }

    public XjImage[] getImages() {
        return this.images;
    }

    private void sortImages(XjImage[] imgs) {
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                return this.compare((XjImage)o1, (XjImage)o2);
            }

            public int compare(XjImage n1, XjImage n2) {
                Object obj1 = n1.getValue(32, 19);
                Object obj2 = n2.getValue(32, 19);
                int first = 0;
                int second = 0;
                if (obj1 instanceof String) {
                    try {
                        first = Integer.parseInt((String)obj1);
                    }
                    catch (NumberFormatException ex) {
                        first = 0;
                    }
                }
                if (obj2 instanceof String) {
                    try {
                        second = Integer.parseInt((String)obj2);
                    }
                    catch (NumberFormatException ex) {
                        second = 0;
                    }
                }
                if (first > second) {
                    return 1;
                }
                if (first < second) {
                    return -1;
                }
                return 0;
            }
        };
        Arrays.sort(imgs, comp);
    }

    public static void main(String[] args) {
        XmSession xms = new XmSession(args == null || args.length == 0 ? "127.0.0.1" : args[0], 7483);
        XmImageSet set = new XmImageSet(xms, "D://images//CTScan");
        XjImage[] imgs = set.getImages();
        System.err.println("#Images=" + imgs.length);
        System.err.println("FilePath=" + imgs[0].getFilePath());
        System.err.println("Height=" + imgs[0].getHeight());
        System.err.println("Width=" + imgs[0].getWidth());
        System.err.println("PixelOffset=" + imgs[0].getPixelOffset());
        System.err.println("(0x28,0x10)=" + imgs[0].getValue(40, 16));
        System.err.println("(0x10,0x10)=" + imgs[0].getValue(16, 16));
    }

    public class XmImage
    implements RemoteImage {
        private Map tagCache = new HashMap();
        private XmImageSet parent = null;
        private int id = 0;
        private int width = -1;
        private int height = -1;
        private String filePath = null;
        private long pixelOffset = -1L;

        public XmImage(XmImageSet parent, int id) {
            this.parent = parent;
            this.id = id;
        }

        public String getRemoteDescriptor() {
            String dicom_cmp = this.getFilePath();
            int remoteSeparatorChar = dicom_cmp.lastIndexOf(47) >= 0 ? 47 : 92;
            int lastIndex = dicom_cmp.lastIndexOf(remoteSeparatorChar);
            String remoteDir = dicom_cmp.substring(0, lastIndex >= 0 ? lastIndex : dicom_cmp.length());
            return remoteDir;
        }

        public double[] getStatistics(Shape s, double angle) {
            return this.parent.getStatistics(this.id, s, angle);
        }

        public int[] getPixels(int x, int y, int w, int h, int[] pixels) {
            if (pixels == null) {
                pixels = new int[w * h];
            }
            this.parent.getPixels(this.id, x, y, w, h, pixels);
            return pixels;
        }

        public String getFilePath() {
            if (this.filePath == null) {
                this.filePath = this.parent.getFilePath(this.id);
            }
            return this.filePath;
        }

        public int getHeight() {
            if (this.height < 0) {
                this.height = this.parent.getHeight(this.id);
            }
            return this.height;
        }

        public RenderedImage getImageData() {
            throw new UnsupportedOperationException();
        }

        public long getPixelOffset() {
            if (this.pixelOffset < 0L) {
                this.pixelOffset = this.parent.getPixelOffset(this.id);
            }
            return this.pixelOffset;
        }

        public int getWidth() {
            if (this.width < 0) {
                this.width = this.parent.getWidth(this.id);
            }
            return this.width;
        }

        public Object getValue(int group, int element) {
            if (group == 39321) {
                return new Integer(this.id);
            }
            if (group == 39320) {
                return new Integer(this.parent.getImageSetID());
            }
            String key = "" + group + "," + element;
            if (this.tagCache.containsKey(key)) {
                return this.tagCache.get(key);
            }
            Object value = this.parent.getValue(this.id, group, element);
            this.tagCache.put("" + group + "," + element, value);
            return value;
        }

        public int getValues(XjTagValue[] tv) {
            for (int i = 0; i < tv.length; ++i) {
                Object value = this.getValue(tv[i].group, tv[i].element);
                if (value == null) continue;
                tv[i].value = value;
            }
            return tv.length;
        }
    }
}

