/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.platform.dm.XpDMSessionProvider;
import com.ge.med.terra.jami.render.PixelWindowing;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpJPipeline;
import com.ge.med.terra.tap.util.tport.color.ColorTable;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import javax.swing.JFrame;

public abstract class XpOffscreenRenderer {
    private static final double EPSILON = 0.009;
    private static final int TABLE_SIZE = 65536;
    protected int[] colorTable = new int[65536];
    private PixelWindowing pw = new PixelWindowing();
    private AffineTransform tx = null;
    private XpImagePixelAttributes ipa = new XpImagePixelAttributes();
    private XpImage image = null;
    private int owidth = 0;
    private int oheight = 0;
    private XpGeomUtils geomUtils = new XpGeomUtils();
    private int iwidth = 0;
    private int iheight = 0;
    private double ww = 0.0;
    private double wl = 0.0;
    private boolean ivideo = false;
    private IndexColorModel icm = null;
    private boolean doPixelTransfer = true;
    private int bitsAllocated = 0;
    private int bitsStored = 0;
    private int pixelRepresentation = 1;
    private int pixelPaddingValue = 0;
    private XpDicomElement[] pixvalues = new XpDicomElement[]{new XpDicomElement(40, 256), new XpDicomElement(40, 257), new XpDicomElement(40, 259), new XpDicomElement(40, 288)};
    private double[] ident = new double[6];

    public XpOffscreenRenderer(int owidth, int oheight) {
        this.owidth = owidth;
        this.oheight = oheight;
        this.tx = new AffineTransform();
        this.tx.setToIdentity();
    }

    public abstract int[] getRaster();

    public final XpImagePixelAttributes getImagePixelAttributes() {
        return this.ipa;
    }

    public final void setImagePixelAttributes(XpImagePixelAttributes ipa) {
        this.ipa = ipa;
        if (this.ww != ipa.getWindowWidth() || this.wl != ipa.getWindowLevel() || this.ivideo != ipa.isVideoInverted() || this.icm != ipa.getColormap()) {
            this.doPixelTransfer = true;
            this.ww = ipa.getWindowWidth();
            this.wl = ipa.getWindowLevel();
            this.ivideo = ipa.isVideoInverted();
            this.icm = ipa.getColormap();
        }
    }

    public final boolean isPixelTransfer() {
        return this.doPixelTransfer;
    }

    protected void setPixelTransfer(boolean doPixelTransfer) {
        this.doPixelTransfer = doPixelTransfer;
    }

    protected PixelWindowing getPixelWindowing() {
        return this.pw;
    }

    public final XpImage getImage() {
        return this.image;
    }

    public final void setImage(XpImage image) {
        this.image = image;
        if (image != null) {
            this.iwidth = image.getSlice().width;
            this.iheight = image.getSlice().height;
            boolean loadBitsAlloc = false;
            boolean loadBitsStored = false;
            boolean loadPixelRep = false;
            boolean loadPixelPadding = false;
            if (image instanceof XpDicomObject) {
                XpDicomObject dobj = (XpDicomObject)((Object)image);
                loadBitsAlloc = dobj.getValue(this.pixvalues[0]) == 0;
                loadBitsStored = dobj.getValue(this.pixvalues[1]) == 0;
                loadPixelRep = dobj.getValue(this.pixvalues[2]) == 0;
                boolean bl = loadPixelPadding = dobj.getValue(this.pixvalues[3]) == 0;
                if (loadBitsAlloc) {
                    String bits_alloc = "" + this.pixvalues[0].value;
                    try {
                        this.bitsAllocated = Integer.parseInt(bits_alloc);
                        if (this.bitsAllocated <= 0) {
                            loadBitsAlloc = false;
                        }
                    }
                    catch (NumberFormatException ne) {
                        loadBitsAlloc = false;
                    }
                }
                if (loadBitsStored) {
                    String bits_stored = "" + this.pixvalues[1].value;
                    try {
                        this.bitsStored = Integer.parseInt(bits_stored);
                        if (this.bitsStored <= 0) {
                            loadBitsStored = false;
                        }
                    }
                    catch (NumberFormatException ne) {
                        loadBitsStored = false;
                    }
                }
                if (loadPixelRep) {
                    try {
                        this.pixelRepresentation = Integer.parseInt("" + this.pixvalues[2].value);
                    }
                    catch (NumberFormatException ne) {
                        loadPixelRep = false;
                    }
                }
                if (loadPixelPadding) {
                    try {
                        this.pixelPaddingValue = Integer.parseInt("" + this.pixvalues[3].value);
                    }
                    catch (NumberFormatException ne) {
                        loadPixelPadding = false;
                    }
                }
            }
            if (!loadBitsAlloc) {
                this.bitsAllocated = -1;
            }
            if (!loadBitsStored) {
                this.bitsStored = -1;
            }
            if (!loadPixelRep) {
                this.pixelRepresentation = 1;
            }
            if (!loadPixelPadding) {
                this.pixelPaddingValue = -2000;
            }
            this.newImage();
        }
    }

    public final void setImage(XpImage image, AffineTransform at) {
        this.setImage(image);
        this.tx = at;
    }

    public final AffineTransform getAffineTransform() {
        return this.tx;
    }

    protected boolean isIdentity(AffineTransform at) {
        at.getMatrix(this.ident);
        boolean id = true;
        id = id && Math.abs(this.ident[0] - 1.0) < 0.009;
        id = id && Math.abs(this.ident[1]) < 0.009;
        id = id && Math.abs(this.ident[2]) < 0.009;
        id = id && Math.abs(this.ident[3] - 1.0) < 0.009;
        id = id && Math.abs(this.ident[4] - 1.0) < 0.009;
        id = id && Math.abs(this.ident[5] - 1.0) < 0.009;
        return id;
    }

    public final void setImage(XpImage image, Point2D UL, Point2D UR, Point2D BR) {
        this.setImage(image);
        this.geomUtils.calcAffineTransform(UL, UR, BR, this.iwidth, this.iheight, this.owidth, this.oheight, this.tx);
    }

    public final int getWidth() {
        return this.owidth;
    }

    public final int getHeight() {
        return this.oheight;
    }

    public final int getInputWidth() {
        return this.iwidth;
    }

    public final int getInputHeight() {
        return this.iheight;
    }

    public abstract short[] getLuminanceRaster();

    public abstract int getLuminanceRasterWidth();

    public abstract int getLuminanceRasterHeight();

    protected final void calcInverse(AffineTransform src, AffineTransform dest) {
        this.geomUtils.calcInverse(src, dest);
    }

    protected static double min(double a, double b2) {
        if (a < b2) {
            return a;
        }
        return b2;
    }

    protected static double max(double a, double b2) {
        if (a > b2) {
            return a;
        }
        return b2;
    }

    public abstract void render(Object var1);

    protected abstract void newImage();

    public void refresh() {
    }

    protected final void shortToARGB(short[] sData, int offset, int len, int[] colorTable, int[] pixels) {
        int bpp = this.getBitsStored();
        int msk = (1 << bpp) - 1;
        int endOffset = offset + len;
        int dlen = pixels.length;
        int pixIdx = 0;
        int idx = 0;
        int destIdx = 0;
        try {
            if (sData != null) {
                destIdx = 0;
                int i = offset;
                while (i < endOffset) {
                    idx = i;
                    int v = sData[i] & msk;
                    pixIdx = v & 0xFFFF;
                    int pixVal = colorTable[pixIdx];
                    pixels[destIdx] = pixVal & 0xFFFFFFFF;
                    ++i;
                    ++destIdx;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aiob) {
            int dataLen = sData.length;
            XpLog.logger().severe("Invalid Array Index= [" + dataLen + "," + pixIdx + "," + idx + "] Length= [" + colorTable.length + "," + len + "," + dlen + "]");
        }
    }

    public int getBitsAllocated() {
        RenderedImage inputImage;
        if (this.bitsAllocated < 0 && (inputImage = this.image.getPixelData()) != null) {
            int[] cc = inputImage.getColorModel().getComponentSize();
            this.bitsAllocated = cc[0];
        }
        return this.bitsAllocated;
    }

    public int getBitsStored() {
        RenderedImage inputImage;
        if (this.bitsStored < 0 && (inputImage = this.image.getPixelData()) != null) {
            int[] cc = inputImage.getColorModel().getComponentSize();
            this.bitsStored = cc[0];
        }
        return this.bitsStored;
    }

    public int getPixelRepresentation() {
        return this.pixelRepresentation;
    }

    public int getPixelPaddingValue() {
        return this.pixelPaddingValue;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Offscreen rendering");
        XpDMSessionProvider dmsp = new XpDMSessionProvider(new String[]{"file", args[0]});
        XpMedicalImage[] imgs = dmsp.getImages();
        double wl = imgs[0].getDefaultWindowLevel();
        double ww = imgs[0].getDefaultWindowWidth();
        BufferedImage bi = new BufferedImage(512, 512, 2);
        int[] outdata = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
        ARGBAffineWWWL or = new ARGBAffineWWWL(outdata, bi.getWidth(), bi.getHeight());
        XpImagePixelAttributes ipa = or.getImagePixelAttributes();
        ipa.setWindowing(ww, wl);
        int[] cMap = ColorTable.getColorTable((String)"hot");
        ipa.setColormap(cMap);
        or.setImagePixelAttributes(ipa);
        Point2D.Double ul = new Point2D.Double(-100.0, -100.0);
        Point2D.Double ur = new Point2D.Double(300.0, -100.0);
        Point2D.Double br = new Point2D.Double(300.0, 300.0);
        or.setImage(imgs[0], ul, ur, br);
        ((XpOffscreenRenderer)or).render(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        XpImageUtils.ImagePanel jp = new XpImageUtils.ImagePanel(bi);
        frame.setLocation(100, 100);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(jp);
        frame.pack();
        frame.setVisible(true);
    }

    public static class ARGBAffineWWWL
    extends XpOffscreenRenderer {
        private short[] drawable = null;
        private int[] outbuffer = null;
        private double[] tx = new double[6];
        private double[] itx = new double[6];
        private AffineTransform inverse = new AffineTransform();
        private Point2D iul = new Point2D.Double(0.0, 0.0);
        private Point2D ibl = new Point2D.Double(0.0, 0.0);
        private Point2D iur = new Point2D.Double(0.0, 0.0);
        private Point2D ibr = new Point2D.Double(0.0, 0.0);
        private Point2D tx_iul = new Point2D.Double();
        private Point2D tx_ibl = new Point2D.Double();
        private Point2D tx_iur = new Point2D.Double();
        private Point2D tx_ibr = new Point2D.Double();
        private boolean do_tx = true;

        public ARGBAffineWWWL(int owidth, int oheight) {
            super(owidth, oheight);
            this.outbuffer = new int[owidth * oheight];
        }

        public ARGBAffineWWWL(int[] outbuffer, int owidth, int oheight) {
            super(owidth, oheight);
            this.outbuffer = outbuffer;
        }

        protected void newImage() {
            int owidth = this.getWidth();
            int oheight = this.getHeight();
            this.drawable = new short[owidth * oheight];
        }

        public int[] getRaster() {
            return this.outbuffer;
        }

        public short[] getLuminanceRaster() {
            return this.drawable;
        }

        public int getLuminanceRasterWidth() {
            return this.getWidth();
        }

        public int getLuminanceRasterHeight() {
            return this.getHeight();
        }

        public void refresh() {
            super.refresh();
            this.do_tx = true;
            this.setPixelTransfer(true);
        }

        public final void render(Object interpolationHint) {
            boolean doPixelTransfer = this.isPixelTransfer();
            XpImagePixelAttributes ipa = this.getImagePixelAttributes();
            XpImage image = this.getImage();
            int owidth = this.getWidth();
            int oheight = this.getHeight();
            PixelWindowing pw = this.getPixelWindowing();
            double ww = ipa.getWindowWidth();
            double wl = ipa.getWindowLevel();
            double slope = image.getRescaleSlope();
            double intercept = image.getRescaleIntercept();
            if (this.do_tx) {
                this.renderLuminance(interpolationHint);
                this.do_tx = false;
            }
            if (doPixelTransfer) {
                this.setPixelTransfer(false);
                pw.fillColorTable(ww, wl, ipa.isVideoInverted(), ipa.getColormap(), this.colorTable, slope, intercept, this.getPixelRepresentation());
                int len = owidth * oheight;
                this.shortToARGB(this.drawable, 0, len, this.colorTable, this.outbuffer);
            }
        }

        private void renderLuminance(Object interpolationHint) {
            double yy;
            AffineTransform at = this.getAffineTransform();
            int inWidth = this.getInputWidth();
            int inHeight = this.getInputHeight();
            int outWidth = this.getWidth();
            int outHeight = this.getHeight();
            BufferedImage img = (BufferedImage)this.getImage().getPixelData();
            DataBufferUShort dbus = (DataBufferUShort)img.getRaster().getDataBuffer();
            short[] sdata = dbus.getData();
            int offset = dbus.getOffset();
            double miny = 0.0;
            double maxy = 0.0;
            double minx = 0.0;
            double maxx = 0.0;
            int iminy = 0;
            int imaxy = 0;
            int iminx = 0;
            int imaxx = 0;
            int w = inWidth;
            int h = inHeight;
            short background = sdata[0];
            boolean identity = this.isIdentity(at);
            at.getMatrix(this.tx);
            this.calcInverse(at, this.inverse);
            this.inverse.getMatrix(this.itx);
            double dx = this.itx[0] * 1.0 + this.itx[2] * 0.0;
            double dy = this.itx[1] * 1.0 + this.itx[3] * 0.0;
            double angle = Math.acos((dx * 1.0 + dy * 0.0) / Math.sqrt(dx * dx + dy * dy));
            double deg = Math.toDegrees(angle) * 10000.0;
            int ideg = (int)deg;
            boolean uprightFlag = ideg % 3600000 == 0;
            int pixelRepresentation = this.getPixelRepresentation();
            int img_bpp = this.getBitsStored();
            this.ibl.setLocation(0.0, h);
            this.iur.setLocation(w, 0.0);
            this.ibr.setLocation(w, h);
            at.transform(this.iul, this.tx_iul);
            double xx = this.tx_iul.getX();
            miny = yy = this.tx_iul.getY();
            maxy = yy;
            minx = xx;
            maxx = xx;
            at.transform(this.ibl, this.tx_ibl);
            xx = this.tx_ibl.getX();
            yy = this.tx_ibl.getY();
            miny = ARGBAffineWWWL.min(miny, yy);
            maxy = ARGBAffineWWWL.max(maxy, yy);
            minx = ARGBAffineWWWL.min(minx, xx);
            maxx = ARGBAffineWWWL.max(maxx, xx);
            at.transform(this.iur, this.tx_iur);
            xx = this.tx_iur.getX();
            yy = this.tx_iur.getY();
            miny = ARGBAffineWWWL.min(miny, yy);
            maxy = ARGBAffineWWWL.max(maxy, yy);
            minx = ARGBAffineWWWL.min(minx, xx);
            maxx = ARGBAffineWWWL.max(maxx, xx);
            at.transform(this.ibr, this.tx_ibr);
            xx = this.tx_ibr.getX();
            yy = this.tx_ibr.getY();
            miny = ARGBAffineWWWL.min(miny, yy);
            maxy = ARGBAffineWWWL.max(maxy, yy);
            minx = ARGBAffineWWWL.min(minx, xx);
            maxx = ARGBAffineWWWL.max(maxx, xx);
            miny = ARGBAffineWWWL.max(miny, 0.0);
            iminy = (int)miny;
            maxy = ARGBAffineWWWL.min(maxy, outHeight - 1);
            imaxy = (int)maxy;
            minx = ARGBAffineWWWL.max(minx, 0.0);
            iminx = (int)minx;
            maxx = ARGBAffineWWWL.min(maxx, outWidth - 1);
            imaxx = (int)maxx;
            if (interpolationHint == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                XpJPipeline.doNearestNeighborShortToShort(this.itx, sdata, offset, w, h, pixelRepresentation, img_bpp, this.drawable, outWidth, outHeight, iminx, imaxx, iminy, imaxy, background);
            } else if (uprightFlag) {
                if (identity && sdata.length == this.drawable.length) {
                    System.arraycopy(sdata, offset, this.drawable, 0, sdata.length);
                } else {
                    Arrays.fill(this.drawable, background);
                    XpJPipeline.doBilinearShortToShortUpright(this.tx, this.itx, sdata, offset, w, h, pixelRepresentation, img_bpp, this.drawable, outWidth, outHeight, background);
                }
            } else {
                XpJPipeline.doBilinearShortToShort(this.itx, sdata, offset, w, h, pixelRepresentation, img_bpp, this.drawable, outWidth, outHeight, iminx, imaxx, iminy, imaxy, background);
            }
        }
    }

    public static class ARGBWWWLAffine
    extends XpOffscreenRenderer {
        private int[] drawable = null;
        private int[] outbuffer = null;
        private double[] tx = new double[6];
        private double[] itx = new double[6];
        private AffineTransform inverse = new AffineTransform();
        private Point2D iul = new Point2D.Double(0.0, 0.0);
        private Point2D ibl = new Point2D.Double(0.0, 0.0);
        private Point2D iur = new Point2D.Double(0.0, 0.0);
        private Point2D ibr = new Point2D.Double(0.0, 0.0);
        private Point2D tx_iul = new Point2D.Double();
        private Point2D tx_ibl = new Point2D.Double();
        private Point2D tx_iur = new Point2D.Double();
        private Point2D tx_ibr = new Point2D.Double();

        public ARGBWWWLAffine(int owidth, int oheight) {
            super(owidth, oheight);
            this.outbuffer = new int[owidth * oheight];
        }

        public ARGBWWWLAffine(int[] outbuffer, int owidth, int oheight) {
            super(owidth, oheight);
            this.outbuffer = outbuffer;
        }

        protected void newImage() {
            int w = this.getInputWidth();
            int h = this.getInputHeight();
            this.drawable = new int[w * h];
        }

        public int[] getRaster() {
            return this.outbuffer;
        }

        public short[] getLuminanceRaster() {
            XpImage image = this.getImage();
            BufferedImage img = (BufferedImage)image.getPixelData();
            DataBufferUShort dbus = (DataBufferUShort)img.getRaster().getDataBuffer();
            return dbus.getData();
        }

        public int getLuminanceRasterWidth() {
            return this.getImage().getSlice().width;
        }

        public int getLuminanceRasterHeight() {
            return this.getImage().getSlice().height;
        }

        public final void render(Object interpolationHint) {
            boolean doPixelTransfer = this.isPixelTransfer();
            XpImagePixelAttributes ipa = this.getImagePixelAttributes();
            XpImage image = this.getImage();
            int iwidth = this.getInputWidth();
            int iheight = this.getInputHeight();
            PixelWindowing pw = this.getPixelWindowing();
            if (doPixelTransfer) {
                this.setPixelTransfer(false);
                pw.fillColorTable(ipa.getWindowWidth(), ipa.getWindowLevel(), ipa.isVideoInverted(), ipa.getColormap(), this.colorTable, image.getRescaleSlope(), image.getRescaleIntercept(), this.getPixelRepresentation());
                BufferedImage img = (BufferedImage)image.getPixelData();
                DataBufferUShort dbus = (DataBufferUShort)img.getRaster().getDataBuffer();
                short[] sdata = dbus.getData();
                int len = iwidth * iheight;
                int offset = dbus.getOffset();
                this.shortToARGB(sdata, offset, len, this.colorTable, this.drawable);
            }
            this.renderImageWWWLAffine(interpolationHint);
        }

        private void renderImageWWWLAffine(Object interpolationHint) {
            double yy;
            AffineTransform at = this.getAffineTransform();
            int inWidth = this.getInputWidth();
            int inHeight = this.getInputHeight();
            int outWidth = this.getWidth();
            int outHeight = this.getHeight();
            double miny = 0.0;
            double maxy = 0.0;
            double minx = 0.0;
            double maxx = 0.0;
            int iminy = 0;
            int imaxy = 0;
            int iminx = 0;
            int imaxx = 0;
            int w = inWidth;
            int h = inHeight;
            at.getMatrix(this.tx);
            this.calcInverse(at, this.inverse);
            this.inverse.getMatrix(this.itx);
            double dx = this.itx[0] * 1.0 + this.itx[2] * 0.0;
            double dy = this.itx[1] * 1.0 + this.itx[3] * 0.0;
            double angle = Math.acos((dx * 1.0 + dy * 0.0) / Math.sqrt(dx * dx + dy * dy));
            double deg = Math.toDegrees(angle) * 10000.0;
            int ideg = (int)deg;
            boolean uprightFlag = ideg % 900000 == 0;
            this.ibl.setLocation(0.0, h);
            this.iur.setLocation(w, 0.0);
            this.ibr.setLocation(w, h);
            at.transform(this.iul, this.tx_iul);
            double xx = this.tx_iul.getX();
            miny = yy = this.tx_iul.getY();
            maxy = yy;
            minx = xx;
            maxx = xx;
            at.transform(this.ibl, this.tx_ibl);
            xx = this.tx_ibl.getX();
            yy = this.tx_ibl.getY();
            miny = ARGBWWWLAffine.min(miny, yy);
            maxy = ARGBWWWLAffine.max(maxy, yy);
            minx = ARGBWWWLAffine.min(minx, xx);
            maxx = ARGBWWWLAffine.max(maxx, xx);
            at.transform(this.iur, this.tx_iur);
            xx = this.tx_iur.getX();
            yy = this.tx_iur.getY();
            miny = ARGBWWWLAffine.min(miny, yy);
            maxy = ARGBWWWLAffine.max(maxy, yy);
            minx = ARGBWWWLAffine.min(minx, xx);
            maxx = ARGBWWWLAffine.max(maxx, xx);
            at.transform(this.ibr, this.tx_ibr);
            xx = this.tx_ibr.getX();
            yy = this.tx_ibr.getY();
            miny = ARGBWWWLAffine.min(miny, yy);
            maxy = ARGBWWWLAffine.max(maxy, yy);
            minx = ARGBWWWLAffine.min(minx, xx);
            maxx = ARGBWWWLAffine.max(maxx, xx);
            miny = ARGBWWWLAffine.max(miny, 0.0);
            iminy = (int)miny;
            maxy = ARGBWWWLAffine.min(maxy, outHeight - 1);
            imaxy = (int)maxy;
            minx = ARGBWWWLAffine.max(minx, 0.0);
            iminx = (int)minx;
            maxx = ARGBWWWLAffine.min(maxx, outWidth - 1);
            imaxx = (int)maxx;
            if (interpolationHint == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                XpJPipeline.doNearestNeighborINT_RGB(this.itx, this.drawable, w, h, this.outbuffer, outWidth, outHeight, iminx, imaxx, iminy, imaxy, 0);
            } else if (uprightFlag) {
                XpJPipeline.doBilinearToINT_RGBUpright(this.tx, this.itx, this.drawable, 0, w, h, this.outbuffer, outWidth, outHeight, this.iul, this.ibl, this.iur, this.ibr, 0);
            } else {
                XpJPipeline.doBilinearToINT_RGB(this.itx, this.drawable, w, h, this.outbuffer, outWidth, outHeight, iminx, imaxx, iminy, imaxy, 0);
            }
        }
    }
}

