/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.render.XpImageDrawable;
import com.ge.med.terra.jami.render.XpJImage2DRenderer;
import com.ge.med.terra.jami.render.XpJPipeline;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;

public class XpLuminanceVolatileCachePipeline
extends XpJPipeline {
    private int outWidth = 0;
    private int outHeight = 0;
    private int iWidth;
    private int iHeight;
    private VolatileImage viewportCache = null;
    private boolean cacheRender = false;
    private AffineTransform inverse = new AffineTransform();
    private GraphicsConfiguration gc = null;

    private VolatileImage createVolatileCache(int width, int height) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        this.gc = gd.getDefaultConfiguration();
        int accelMemory = gd.getAvailableAcceleratedMemory();
        VolatileImage vi = this.gc.createCompatibleVolatileImage(width, height);
        ImageCapabilities ic = vi.getCapabilities();
        System.out.println("Accelerated Memory: " + accelMemory);
        System.out.println("Accelerated=" + ic.isAccelerated() + " |  Is Volatile=" + ic.isTrueVolatile());
        return vi;
    }

    protected void renderImage(Graphics2D g2, Rectangle viewport, XpJImage2DRenderer r, AffineTransform tx) {
        XpImageDrawable drawable = r.getDrawable();
        if (drawable == null) {
            return;
        }
        if (this.outWidth != viewport.width || this.outHeight != viewport.height) {
            this.outWidth = viewport.width;
            this.outHeight = viewport.height;
            this.viewportCache = this.createVolatileCache(this.outWidth, this.outHeight);
            this.setChangeRender(true);
        }
        if (r.isComputePixelTransfer()) {
            r.computePixelTransfer();
            r.setComputePixelTransfer(false);
        }
        BufferedImage image = drawable.getBufferedImage();
        do {
            int valCode;
            if ((valCode = this.viewportCache.validate(this.gc)) == 2) {
                this.viewportCache = this.createVolatileCache(this.outWidth, this.outHeight);
            }
            if (!this.isChangeRender() && valCode == 0) continue;
            Graphics2D bg2 = (Graphics2D)this.viewportCache.getGraphics();
            bg2.setBackground(Color.black);
            bg2.clearRect(0, 0, this.outWidth, this.outHeight);
            bg2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            bg2.drawRenderedImage(image, tx);
        } while (this.viewportCache.contentsLost());
        g2.drawImage(this.viewportCache, 0, 0, null);
    }
}

