/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.image.XpImageData;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpDrawableFactory;
import com.ge.med.terra.jami.render.XpImage2DRenderer;
import com.ge.med.terra.jami.render.XpImageDrawable;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpJPipeline;
import com.ge.med.terra.jami.render.XpPixels;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class XpJImage2DRenderer
extends XpImage2DRenderer {
    private static final int TABLE_SIZE = 65536;
    private int[] colorTable = new int[65536];
    private XpImageDrawable drawable = null;
    private XpPixels sourcePixels = new XpPixels();
    private RenderedImage srcImage = null;
    private boolean compPixelTransfer = true;
    private boolean compColorTable = true;
    private XpJPipeline genericPipeline = new XpJPipeline.GenericPipeline();
    private XpJPipeline luminancePipeline = null;
    private XpJPipeline currPipeline = null;
    private double currWW;
    private double currWL;
    private XpColorOverlay currOverlay = null;
    private int overlayState = 0;
    private boolean invVideo = false;
    private IndexColorModel colortable = null;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private double currPanX;
    private double currPanY;
    private double currAngle;
    private double currZoom;
    private boolean currFlip;
    private boolean currFVP;

    public XpJImage2DRenderer() {
        String pipelineName = XpPropertiesManager.getProperty("jami.jpipeline", "com.ge.med.terra.jami.render.XpJPipeline$LuminanceCachePipeline");
        Class<?> pipeCl = null;
        try {
            pipeCl = Class.forName(pipelineName);
            XpLog.logger().config("Using java pipeline = " + pipelineName);
        }
        catch (ClassNotFoundException ex) {
            String defaultPipeline = "com.ge.med.terra.jami.render.XpJPipeline$LuminanceCachePipeline";
            XpLog.logger().severe("Pipeline class not found : " + pipelineName);
            XpLog.logger().severe("Will use default pipeline: " + defaultPipeline);
        }
        this.initRenderer(pipeCl);
    }

    public XpJImage2DRenderer(Class pipeCl) {
        this.initRenderer(pipeCl);
    }

    private void initRenderer(Class pipeCl) {
        this.currPanY = 0.0;
        this.currPanX = 0.0;
        this.currAngle = 0.0;
        this.currZoom = 1.0;
        this.currFlip = false;
        if (pipeCl == null) {
            pipeCl = XpJPipeline.LuminanceCachePipeline.class;
        }
        this.currPipeline = this.luminancePipeline = XpJImage2DRenderer.createPipeline(pipeCl);
    }

    public final XpImageDrawable getDrawable() {
        if (this.drawable == null && this.srcImage != null) {
            XpDrawableFactory drwFactory = this.getDrawableFactory();
            int bpp = this.getBitsStored();
            this.drawable = drwFactory.createDrawable(bpp, this.srcImage.getWidth(), this.srcImage.getHeight());
        }
        return this.drawable;
    }

    public final boolean isComputePixelTransfer() {
        return this.compPixelTransfer;
    }

    public final void setComputePixelTransfer(boolean compPixelTransfer) {
        this.compPixelTransfer = compPixelTransfer;
    }

    public void newImageCB(RenderedImage image) {
        this.srcImage = image;
        this.loadRenderedImage(this.srcImage);
    }

    protected void cleanImage() {
        this.srcImage = null;
        this.sourcePixels.clear();
    }

    private void loadRenderedImage(RenderedImage bi) {
        RenderedImage inputImage = bi;
        int w = inputImage.getWidth();
        int h = inputImage.getHeight();
        int targetDrawableType = -1;
        int[] cc = inputImage.getColorModel().getComponentSize();
        int nChannels = cc.length;
        int bpp0 = this.getBitsStored();
        int bitsAlloc = cc[0];
        XpDrawableFactory drwFactory = this.getDrawableFactory();
        if (nChannels == 1 && bpp0 <= 16) {
            DataBuffer buffer = XpImageData.getDataBuffer(inputImage);
            int offset = buffer.getOffset();
            int length = buffer.getSize();
            boolean invalidDrawable = false;
            targetDrawableType = drwFactory.getDrawableType(bpp0, w, h);
            if (bitsAlloc > 8) {
                short[] shortData = null;
                if (buffer instanceof DataBufferUShort) {
                    DataBufferUShort dbus = (DataBufferUShort)buffer;
                    shortData = dbus.getData();
                    this.sourcePixels.setData(shortData, 2, bpp0, offset, length);
                } else {
                    DataBufferShort dbs = (DataBufferShort)buffer;
                    shortData = dbs.getData();
                    this.sourcePixels.setData(shortData, 1, bpp0, offset, length);
                }
                if (this.drawable != null) {
                    if (targetDrawableType != this.drawable.getBufferedImageType()) {
                        invalidDrawable = true;
                    } else if (this.drawable.getWidth() != w || this.drawable.getHeight() != h) {
                        invalidDrawable = true;
                    }
                } else {
                    invalidDrawable = true;
                }
            } else if (bitsAlloc == 8) {
                DataBufferByte bb = (DataBufferByte)buffer;
                this.sourcePixels.setData(bb.getData(), bpp0, offset, length);
                if (this.drawable != null) {
                    if (this.drawable.getBufferedImageType() != targetDrawableType) {
                        invalidDrawable = true;
                    } else if (this.drawable.getWidth() != w || this.drawable.getHeight() != h) {
                        invalidDrawable = true;
                    }
                } else {
                    invalidDrawable = true;
                }
            }
            if (invalidDrawable) {
                this.drawable = drwFactory.createDrawable(bpp0, w, h);
            }
            this.currPipeline = this.luminancePipeline;
        } else {
            this.currPipeline = this.genericPipeline;
        }
        this.setComputePixelTransfer(true);
        double rs = this.getRescaleSlope();
        double ri = this.getRescaleIntercept();
        if (this.rescaleSlope != rs || this.rescaleIntercept != ri) {
            this.compColorTable = true;
            this.rescaleSlope = rs;
            this.rescaleIntercept = ri;
        }
        this.currPipeline.setChangeRender(true);
        this.currPipeline.setChangeAffine(true);
    }

    public final void setChangeRender() {
        this.currPipeline.setChangeRender(true);
    }

    public void newImageRenderAttributesCB(XpImageRenderAttributes attr) {
        if (!attr.equalsPixelTransfer(this.currWW, this.currWL, this.invVideo, this.colortable, this.currOverlay) || this.isPixelTransferDirty()) {
            this.setComputePixelTransfer(true);
            this.setPixelTransferDirty(false);
            this.compColorTable = true;
            this.currPipeline.setChangeRender(true);
        } else if (this.currOverlay != null && this.overlayState != this.currOverlay.state()) {
            this.setComputePixelTransfer(true);
            this.currPipeline.setChangeRender(true);
        }
        this.currWW = attr.getWindowWidth();
        this.currWL = attr.getWindowLevel();
        this.invVideo = attr.isVideoInverted();
        this.colortable = attr.getColormap();
        this.currOverlay = attr.getColorOverlay();
        if (this.currOverlay != null) {
            this.overlayState = this.currOverlay.state();
        }
        if (this.currPanX != attr.getPanX() || this.currPanY != attr.getPanY() || this.currAngle != attr.getImageOrientation().getAngle() || this.currZoom != attr.getZoom() || this.currFlip != attr.getImageOrientation().getFlip() || this.currFVP != this.getFitToViewport()) {
            this.currPipeline.setChangeRender(true);
            this.currPipeline.setChangeAffine(true);
        }
        this.currPanX = attr.getPanX();
        this.currPanY = attr.getPanY();
        this.currAngle = attr.getImageOrientation().getAngle();
        this.currZoom = attr.getZoom();
        this.currFlip = attr.getImageOrientation().getFlip();
        this.currFVP = this.getFitToViewport();
    }

    protected final void computePixelTransfer() {
        XpImageRenderAttributes ira = this.getAttributes();
        if (this.compColorTable) {
            this.fillColorTable(ira, this.colorTable);
            this.compColorTable = false;
        }
        this.drawable.pixelTransfer(this.sourcePixels, this.colorTable, ira);
    }

    public final void render(Graphics graphics, Rectangle viewport) {
        Graphics2D g2 = (Graphics2D)graphics;
        Object iHint = this.getInterpolationHint();
        if (iHint != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, iHint);
        }
        AffineTransform tx = this.getAffineTransform();
        this.currPipeline.doRender(g2, viewport, this, tx);
    }

    public void dispose() {
        if (this.luminancePipeline != null) {
            this.luminancePipeline.dispose();
        }
        if (this.genericPipeline != null) {
            this.genericPipeline.dispose();
        }
        this.drawable = null;
    }

    private static XpJPipeline createPipeline(Class cl) {
        XpJPipeline pipeline = null;
        if (cl != null) {
            try {
                Class<?>[] paramType = null;
                Constructor c = cl.getConstructor(paramType);
                if (c != null) {
                    Object[] args = null;
                    pipeline = (XpJPipeline)c.newInstance(args);
                }
            }
            catch (NoSuchMethodException nsme) {
                nsme.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (InstantiationException ie) {
                ie.printStackTrace();
            }
        }
        return pipeline;
    }
}

