/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.image.XpBufferedImage;
import com.ge.med.terra.jami.platform.dm.XpDMSessionProvider;
import com.ge.med.terra.jami.render.XpImage2DRenderer;
import com.ge.med.terra.jami.render.XpImageDrawable;
import com.ge.med.terra.jami.render.XpJImage2DRenderer;
import com.ge.med.terra.jami.render.XpJPipeline;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;
import javax.swing.JFrame;

public class Bicubic {
    public static final int SHIFT = 14;
    public static final int SCALE = 16384;
    public static final int MASK = 16383;
    private static final double A = -0.5;
    private static final double A_PLUS2 = 1.5;
    private static final double A_PLUS3 = 2.5;
    private static XpGeomUtils gu = new XpGeomUtils();
    public static int[] ctable = null;

    public static double cubic(double x) {
        double x2 = x * x;
        double x3 = x2 * x;
        double y = 0.0;
        if (x >= 0.0 && x < 1.0) {
            y = 1.5 * x3 - 2.5 * x2 + 1.0;
        } else if (x >= 1.0 && x < 2.0) {
            y = -0.5 * x3 - -2.5 * x2 + -4.0 * x - -2.0;
        }
        return y;
    }

    private static void buildTable(int[] cubicTable) {
        for (int i = 0; i < cubicTable.length; ++i) {
            double x = (double)i / 16384.0;
            double cvalue = Bicubic.cubic(x);
            cubicTable[i] = (int)(cvalue * 16384.0);
        }
    }

    public final void shortToshort(double[] tx, double[] itx, short[] input, int ioffset, int iw, int ih, short[] output, int ow, int oh, int xstart, int ystart, int width, int height, int stepx, int stepy) {
        int x_end;
        int y_end;
        int x_start;
        int y_start;
        int m00 = (int)(itx[0] * 16384.0);
        int m10 = (int)(itx[1] * 16384.0);
        int m01 = (int)(itx[2] * 16384.0);
        int m11 = (int)(itx[3] * 16384.0);
        int m02 = (int)(itx[4] * 16384.0);
        int m12 = (int)(itx[5] * 16384.0);
        double xdir_x = itx[0] * 1.0 + itx[2] * 0.0;
        double xdir_y = itx[1] * 1.0 + itx[3] * 0.0;
        int ixdir_x = (int)((double)stepx * xdir_x * 16384.0);
        int ixdir_y = (int)((double)stepx * xdir_y * 16384.0);
        Point2D.Double p = new Point2D.Double();
        int PAD = 3;
        boolean START = true;
        ((Point2D)p).setLocation(1.0, 1.0);
        double xxul = tx[0] * ((Point2D)p).getX() + tx[2] * ((Point2D)p).getY() + tx[4];
        double yyul = tx[1] * ((Point2D)p).getX() + tx[3] * ((Point2D)p).getY() + tx[5];
        double dx1 = xxul;
        double dy1 = yyul;
        double dx2 = xxul;
        double dy2 = yyul;
        ((Point2D)p).setLocation(1.0, ih - 1 - 3);
        double xxbl = tx[0] * ((Point2D)p).getX() + tx[2] * ((Point2D)p).getY() + tx[4];
        double yybl = tx[1] * ((Point2D)p).getX() + tx[3] * ((Point2D)p).getY() + tx[5];
        dx1 = Math.min(dx1, xxbl);
        dx2 = Math.max(dx2, xxbl);
        dy1 = Math.min(dy1, yybl);
        dy2 = Math.max(dy2, yybl);
        ((Point2D)p).setLocation(iw - 1 - 3, 1.0);
        double xxur = tx[0] * ((Point2D)p).getX() + tx[2] * ((Point2D)p).getY() + tx[4];
        double yyur = tx[1] * ((Point2D)p).getX() + tx[3] * ((Point2D)p).getY() + tx[5];
        dx1 = Math.min(dx1, xxur);
        dx2 = Math.max(dx2, xxur);
        dy1 = Math.min(dy1, yyur);
        dy2 = Math.max(dy2, yyur);
        ((Point2D)p).setLocation(iw - 1 - 3, ih - 1 - 3);
        double xxbr = tx[0] * ((Point2D)p).getX() + tx[2] * ((Point2D)p).getY() + tx[4];
        double yybr = tx[1] * ((Point2D)p).getX() + tx[3] * ((Point2D)p).getY() + tx[5];
        dx1 = Math.min(dx1, xxbr);
        dx2 = Math.max(dx2, xxbr);
        dy1 = Math.min(dy1, yybr);
        dy2 = Math.max(dy2, yybr);
        int x1 = (int)Math.max(Math.ceil(dx1), 0.0);
        int x2 = (int)Math.min(Math.floor(dx2), (double)(ow - 2));
        int y1 = (int)Math.max(Math.ceil(dy1), 0.0);
        int y2 = (int)Math.min(Math.floor(dy2), (double)(oh - 2));
        if (y2 < 0 || x2 < 0 || x1 >= ow || y1 >= oh) {
            return;
        }
        for (y_start = ystart; y_start < y1; y_start += stepy) {
        }
        for (x_start = xstart; x_start < x1; x_start += stepx) {
        }
        int yend = Math.min(ystart + height, oh);
        int xend = Math.min(xstart + width, ow);
        for (y_end = yend; y_end > y2; y_end -= stepy) {
        }
        for (x_end = xend; x_end > x2; x_end -= stepx) {
        }
        int lastX = 0;
        int lastY = 0;
        for (int y = y_start; y < y_end; y += stepy) {
            int offset = y * ow;
            int pos_x = m00 * x_start + m01 * y + m02;
            int pos_y = m10 * x_start + m11 * y + m12;
            lastY = y;
            for (int x = x_start; x < x_end; x += stepx) {
                int xc = pos_x >> 14;
                int yc = pos_y >> 14;
                int yoffset = ioffset + yc * iw;
                int yoffset0 = yoffset - iw;
                int yoffset1 = yoffset;
                int yoffset2 = yoffset + iw;
                int yoffset3 = yoffset2 + iw;
                int xfrac = pos_x & 0x3FFF;
                int yfrac = pos_y & 0x3FFF;
                int xfrac_1 = 16384 - xfrac;
                int yfrac_1 = 16384 - yfrac;
                short v00 = input[yoffset0 + xc - 1];
                short v01 = input[yoffset0 + xc];
                short v02 = input[yoffset0 + xc + 1];
                short v03 = input[yoffset0 + xc + 2];
                short v10 = input[yoffset1 + xc - 1];
                short v11 = input[yoffset1 + xc];
                short v12 = input[yoffset1 + xc + 1];
                short v13 = input[yoffset1 + xc + 2];
                short v20 = input[yoffset2 + xc - 1];
                short v21 = input[yoffset2 + xc];
                short v22 = input[yoffset2 + xc + 1];
                short v23 = input[yoffset2 + xc + 2];
                short v30 = input[yoffset3 + xc - 1];
                short v31 = input[yoffset3 + xc];
                short v32 = input[yoffset3 + xc + 1];
                short v33 = input[yoffset3 + xc + 2];
                int k0 = ctable[xfrac];
                int k1 = ctable[xfrac + 16384];
                int k2 = ctable[xfrac_1];
                int k3 = ctable[xfrac_1 + 16384];
                int v0 = k0 * v01 + k1 * v00 + k2 * v02 + k3 * v03 >> 14;
                int v1 = k0 * v11 + k1 * v10 + k2 * v12 + k3 * v13 >> 14;
                int v2 = k0 * v21 + k1 * v20 + k2 * v22 + k3 * v23 >> 14;
                int v3 = k0 * v31 + k1 * v30 + k2 * v32 + k3 * v33 >> 14;
                int v = ctable[yfrac] * v1 + ctable[yfrac + 16384] * v0 + ctable[yfrac_1] * v2 + ctable[yfrac_1 + 16384] * v3 >> 14;
                output[offset + x] = (short)v;
                pos_x += ixdir_x;
                pos_y += ixdir_y;
                lastX = x;
            }
        }
        XpImage2DRenderer.fillBorderLinear(itx, input, ioffset, iw, ih, output, ow, oh, xdir_x, xdir_y, stepx, stepy, xstart, ystart, xend, yend, x_start, x_end, y_start, y_end, lastX, lastY);
    }

    public final void shortToshortXZ(double[] tx, double[] itx, short[] input, int ioffset, int dx, int dy, int dz, short[] output, int ow, int oh, int xstart, int ystart, int width, int height, int stepx, int stepy) {
        int x_end;
        int y_end;
        int x_start;
        int y_start;
        int pgsize = dx * dy;
        int m00 = (int)(itx[0] * 16384.0);
        int m10 = (int)(itx[1] * 16384.0);
        int m01 = (int)(itx[2] * 16384.0);
        int m11 = (int)(itx[3] * 16384.0);
        int m02 = (int)(itx[4] * 16384.0);
        int m12 = (int)(itx[5] * 16384.0);
        double xdir_x = itx[0] * 1.0 + itx[2] * 0.0;
        double xdir_y = itx[1] * 1.0 + itx[3] * 0.0;
        int ixdir_x = (int)((double)stepx * xdir_x * 16384.0);
        int ixdir_y = (int)((double)stepx * xdir_y * 16384.0);
        Point2D.Double p = new Point2D.Double();
        int PAD = 2;
        ((Point2D)p).setLocation(2.0, 2.0);
        double xxul = tx[0] * ((Point2D)p).getX() + tx[2] * ((Point2D)p).getY() + tx[4];
        double yyul = tx[1] * ((Point2D)p).getX() + tx[3] * ((Point2D)p).getY() + tx[5];
        double dx1 = xxul;
        double dy1 = yyul;
        double dx2 = xxul;
        double dy2 = yyul;
        ((Point2D)p).setLocation(2.0, dz - 1 - 2);
        double xxbl = tx[0] * ((Point2D)p).getX() + tx[2] * ((Point2D)p).getY() + tx[4];
        double yybl = tx[1] * ((Point2D)p).getX() + tx[3] * ((Point2D)p).getY() + tx[5];
        dx1 = Math.min(dx1, xxbl);
        dx2 = Math.max(dx2, xxbl);
        dy1 = Math.min(dy1, yybl);
        dy2 = Math.max(dy2, yybl);
        ((Point2D)p).setLocation(dx - 1 - 2, 2.0);
        double xxur = tx[0] * ((Point2D)p).getX() + tx[2] * ((Point2D)p).getY() + tx[4];
        double yyur = tx[1] * ((Point2D)p).getX() + tx[3] * ((Point2D)p).getY() + tx[5];
        dx1 = Math.min(dx1, xxur);
        dx2 = Math.max(dx2, xxur);
        dy1 = Math.min(dy1, yyur);
        dy2 = Math.max(dy2, yyur);
        ((Point2D)p).setLocation(dx - 1 - 2, dz - 1 - 2);
        double xxbr = tx[0] * ((Point2D)p).getX() + tx[2] * ((Point2D)p).getY() + tx[4];
        double yybr = tx[1] * ((Point2D)p).getX() + tx[3] * ((Point2D)p).getY() + tx[5];
        dx1 = Math.min(dx1, xxbr);
        dx2 = Math.max(dx2, xxbr);
        dy1 = Math.min(dy1, yybr);
        dy2 = Math.max(dy2, yybr);
        int x1 = (int)Math.max(Math.ceil(dx1), 0.0);
        int x2 = (int)Math.min(Math.floor(dx2), (double)(ow - 2));
        int y1 = (int)Math.max(Math.ceil(dy1), 0.0);
        int y2 = (int)Math.min(Math.floor(dy2), (double)(oh - 2));
        if (y2 < 0 || x2 < 0 || x1 >= ow || y1 >= oh) {
            return;
        }
        for (y_start = ystart; y_start < y1; y_start += stepy) {
        }
        for (x_start = xstart; x_start < x1; x_start += stepx) {
        }
        int yend = Math.min(ystart + height, oh);
        int xend = Math.min(xstart + width, ow);
        for (y_end = yend; y_end > y2; y_end -= stepy) {
        }
        for (x_end = xend; x_end > x2; x_end -= stepx) {
        }
        int lastX = 0;
        int lastY = 0;
        for (int y = y_start; y < y_end; y += stepy) {
            int offset = y * ow;
            int pos_x = m00 * x_start + m01 * y + m02;
            int pos_z = m10 * x_start + m11 * y + m12;
            lastY = y;
            for (int x = x_start; x < x_end; x += stepx) {
                int xc = pos_x >> 14;
                int zc = pos_z >> 14;
                int zoffset = ioffset + zc * pgsize;
                int zoffset0 = zoffset - pgsize;
                int zoffset1 = zoffset;
                int zoffset2 = zoffset + pgsize;
                int zoffset3 = zoffset2 + pgsize;
                int xfrac = pos_x & 0x3FFF;
                int zfrac = pos_z & 0x3FFF;
                int xfrac_1 = 16384 - xfrac;
                int zfrac_1 = 16384 - zfrac;
                short v00 = input[zoffset0 + xc - 1];
                short v01 = input[zoffset0 + xc];
                short v02 = input[zoffset0 + xc + 1];
                short v03 = input[zoffset0 + xc + 2];
                short v10 = input[zoffset1 + xc - 1];
                short v11 = input[zoffset1 + xc];
                short v12 = input[zoffset1 + xc + 1];
                short v13 = input[zoffset1 + xc + 2];
                short v20 = input[zoffset2 + xc - 1];
                short v21 = input[zoffset2 + xc];
                short v22 = input[zoffset2 + xc + 1];
                short v23 = input[zoffset2 + xc + 2];
                short v30 = input[zoffset3 + xc - 1];
                short v31 = input[zoffset3 + xc];
                short v32 = input[zoffset3 + xc + 1];
                short v33 = input[zoffset3 + xc + 2];
                int k0 = ctable[xfrac];
                int k1 = ctable[xfrac + 16384];
                int k2 = ctable[xfrac_1];
                int k3 = ctable[xfrac_1 + 16384];
                int v0 = k0 * v01 + k1 * v00 + k2 * v02 + k3 * v03 >> 14;
                int v1 = k0 * v11 + k1 * v10 + k2 * v12 + k3 * v13 >> 14;
                int v2 = k0 * v21 + k1 * v20 + k2 * v22 + k3 * v23 >> 14;
                int v3 = k0 * v31 + k1 * v30 + k2 * v32 + k3 * v33 >> 14;
                int v = ctable[zfrac] * v1 + ctable[zfrac + 16384] * v0 + ctable[zfrac_1] * v2 + ctable[zfrac_1 + 16384] * v3 >> 14;
                output[offset + x] = (short)v;
                pos_x += ixdir_x;
                pos_z += ixdir_y;
                lastX = x;
            }
        }
        Bicubic.fillBorderLinearXZ(itx, input, ioffset, dx, dy, dz, output, ow, oh, xdir_x, xdir_y, stepx, stepy, xstart, ystart, xend, yend, x_start, x_end, y_start, y_end, lastX, lastY);
    }

    public static void fillBorderLinearXZ(double[] itx, short[] input, int ioffset, int dimX, int dimY, int dimZ, short[] output, int ow, int oh, double xvec_x, double xvec_y, int stepx, int stepy, int xstart, int ystart, int xend, int yend, int xborder0, int xborder1, int yborder0, int yborder1, int lastX, int lastY) {
        int sampleX;
        int xx;
        int zoffset;
        int sampleZ;
        int zz;
        double val;
        double dz;
        double dx;
        int zc;
        int xc;
        double izc;
        double ixc;
        int x;
        double pos_z;
        double pos_x;
        int offset;
        int y;
        int pgsize = dimX * dimY;
        double d00 = itx[0];
        double d10 = itx[1];
        double d01 = itx[2];
        double d11 = itx[3];
        double d02 = itx[4];
        double d12 = itx[5];
        double xdir_x = xvec_x * (double)stepx;
        double xdir_y = xvec_y * (double)stepx;
        double[][] weights = new double[2][2];
        for (y = yborder0 - stepy; y >= ystart; y -= stepy) {
            offset = y * ow;
            pos_x = d00 * (double)xstart + d01 * (double)y + d02;
            pos_z = d10 * (double)xstart + d11 * (double)y + d12;
            for (x = xstart; x < xend; x += stepx) {
                if (pos_x >= 0.0 && pos_x < (double)dimX && pos_z >= 0.0 && pos_z < (double)dimZ) {
                    ixc = Math.abs(pos_x);
                    izc = Math.abs(pos_z);
                    xc = (int)ixc;
                    zc = (int)izc;
                    dx = ixc - (double)xc;
                    dz = izc - (double)zc;
                    weights[0][0] = 1.0 - dx - dz + dx * dz;
                    weights[0][1] = dx - dx * dz;
                    weights[1][0] = dz - dx * dz;
                    weights[1][1] = dx * dz;
                    val = 0.0;
                    for (zz = 0; zz < 2; ++zz) {
                        sampleZ = zc + zz;
                        if (sampleZ < 0 || sampleZ >= dimZ) continue;
                        zoffset = ioffset + sampleZ * pgsize;
                        for (xx = 0; xx < 2; ++xx) {
                            sampleX = xc + xx;
                            if (sampleX < 0 || sampleX >= dimX) continue;
                            val += (double)input[zoffset + sampleX] * weights[zz][xx];
                        }
                    }
                    output[offset + x] = (short)val;
                }
                pos_x += xdir_x;
                pos_z += xdir_y;
            }
        }
        for (y = lastY + stepy; y < yend; y += stepy) {
            offset = y * ow;
            pos_x = d00 * (double)xstart + d01 * (double)y + d02;
            pos_z = d10 * (double)xstart + d11 * (double)y + d12;
            for (x = xstart; x < xend; x += stepx) {
                if (pos_x > -1.0 && pos_x < (double)dimX && pos_z > -1.0 && pos_z < (double)dimZ) {
                    ixc = Math.abs(pos_x);
                    izc = Math.abs(pos_z);
                    xc = (int)ixc;
                    zc = (int)izc;
                    dx = ixc - (double)xc;
                    dz = izc - (double)zc;
                    weights[0][0] = 1.0 - dx - dz + dx * dz;
                    weights[0][1] = dx - dx * dz;
                    weights[1][0] = dz - dx * dz;
                    weights[1][1] = dx * dz;
                    val = 0.0;
                    for (zz = 0; zz < 2; ++zz) {
                        sampleZ = zc + zz;
                        if (sampleZ < 0 || sampleZ >= dimZ) continue;
                        zoffset = ioffset + sampleZ * pgsize;
                        for (xx = 0; xx < 2; ++xx) {
                            sampleX = xc + xx;
                            if (sampleX < 0 || sampleX >= dimX) continue;
                            val += (double)input[zoffset + sampleX] * weights[zz][xx];
                        }
                    }
                    output[offset + x] = (short)val;
                }
                pos_x += xdir_x;
                pos_z += xdir_y;
            }
        }
        for (y = yborder0; y < yborder1; y += stepy) {
            offset = y * ow;
            int xs0 = xborder0 - stepx;
            double pos_x2 = d00 * (double)xs0 + d01 * (double)y + d02;
            double pos_z2 = d10 * (double)xs0 + d11 * (double)y + d12;
            for (int x2 = xs0; x2 >= xstart; x2 -= stepx) {
                if (pos_x2 >= 0.0 && pos_x2 < (double)dimX && pos_z2 >= 0.0 && pos_z2 < (double)dimZ) {
                    double ixc2 = Math.abs(pos_x2);
                    double izc2 = Math.abs(pos_z2);
                    int xc2 = (int)ixc2;
                    int zc2 = (int)izc2;
                    double dx2 = ixc2 - (double)xc2;
                    double dz2 = izc2 - (double)zc2;
                    weights[0][0] = 1.0 - dx2 - dz2 + dx2 * dz2;
                    weights[0][1] = dx2 - dx2 * dz2;
                    weights[1][0] = dz2 - dx2 * dz2;
                    weights[1][1] = dx2 * dz2;
                    double val2 = 0.0;
                    for (int zz2 = 0; zz2 < 2; ++zz2) {
                        int sampleZ2 = zc2 + zz2;
                        if (sampleZ2 < 0 || sampleZ2 >= dimZ) continue;
                        int zoffset2 = ioffset + sampleZ2 * pgsize;
                        for (int xx2 = 0; xx2 < 2; ++xx2) {
                            int sampleX2 = xc2 + xx2;
                            if (sampleX2 < 0 || sampleX2 >= dimX) continue;
                            val2 += (double)input[zoffset2 + sampleX2] * weights[zz2][xx2];
                        }
                    }
                    output[offset + x2] = (short)val2;
                }
                pos_x2 -= xdir_x;
                pos_z2 -= xdir_y;
            }
            int xs1 = lastX + stepx;
            pos_x2 = d00 * (double)xs1 + d01 * (double)y + d02;
            pos_z2 = d10 * (double)xs1 + d11 * (double)y + d12;
            for (int x3 = xs1; x3 < xend; x3 += stepx) {
                int xc3 = (int)pos_x2;
                int zc3 = (int)pos_z2;
                double dx3 = pos_x2 - (double)xc3;
                double dz3 = pos_z2 - (double)zc3;
                weights[0][0] = 1.0 - dx3 - dz3 + dx3 * dz3;
                weights[0][1] = dx3 - dx3 * dz3;
                weights[1][0] = dz3 - dx3 * dz3;
                weights[1][1] = dx3 * dz3;
                if (xc3 >= 0 && xc3 < dimX && zc3 >= 0 && zc3 < dimZ) {
                    double val3 = 0.0;
                    for (int zz3 = 0; zz3 < 2; ++zz3) {
                        int sampleZ3 = zc3 + zz3;
                        if (sampleZ3 < 0 || sampleZ3 >= dimZ) continue;
                        int zoffset3 = ioffset + sampleZ3 * pgsize;
                        for (int xx3 = 0; xx3 < 2; ++xx3) {
                            int sampleX3 = xc3 + xx3;
                            if (sampleX3 < 0 || sampleX3 >= dimX) continue;
                            val3 += (double)input[zoffset3 + sampleX3] * weights[zz3][xx3];
                        }
                    }
                    output[offset + x3] = (short)val3;
                }
                pos_x2 += xdir_x;
                pos_z2 += xdir_y;
            }
        }
    }

    public final void doBicubicARGBToARGB(double[] tx, double[] itx, int[] input, int ioffset, int iw, int ih, int[] output, int ow, int oh, int background) {
        long t1 = System.currentTimeMillis();
        Point2D.Double iul = new Point2D.Double();
        Point2D.Double ibl = new Point2D.Double();
        Point2D.Double iur = new Point2D.Double();
        Point2D.Double ibr = new Point2D.Double();
        ((Point2D)iul).setLocation(0.0, 0.0);
        ((Point2D)ibl).setLocation(0.0, ih - 1);
        ((Point2D)iur).setLocation(iw - 1, 0.0);
        ((Point2D)ibr).setLocation(iw - 1, ih - 1);
        double xxul = tx[0] * ((Point2D)iul).getX() + tx[2] * ((Point2D)iul).getY() + tx[4];
        double yyul = tx[1] * ((Point2D)iul).getX() + tx[3] * ((Point2D)iul).getY() + tx[5];
        int x1 = (int)xxul;
        int y1 = (int)yyul;
        int x2 = (int)xxul;
        int y2 = (int)yyul;
        double xxbl = tx[0] * ((Point2D)ibl).getX() + tx[2] * ((Point2D)ibl).getY() + tx[4];
        double yybl = tx[1] * ((Point2D)ibl).getX() + tx[3] * ((Point2D)ibl).getY() + tx[5];
        x1 = Math.min(x1, (int)xxbl);
        x2 = Math.max(x2, (int)xxbl);
        y1 = Math.min(y1, (int)yybl);
        y2 = Math.max(y2, (int)yybl);
        double xxur = tx[0] * ((Point2D)iur).getX() + tx[2] * ((Point2D)iur).getY() + tx[4];
        double yyur = tx[1] * ((Point2D)iur).getX() + tx[3] * ((Point2D)iur).getY() + tx[5];
        x1 = Math.min(x1, (int)xxur);
        x2 = Math.max(x2, (int)xxur);
        y1 = Math.min(y1, (int)yyur);
        y2 = Math.max(y2, (int)yyur);
        double xxbr = tx[0] * ((Point2D)ibr).getX() + tx[2] * ((Point2D)ibr).getY() + tx[4];
        double yybr = tx[1] * ((Point2D)ibr).getX() + tx[3] * ((Point2D)ibr).getY() + tx[5];
        x1 = Math.min(x1, (int)xxbr);
        x2 = Math.max(x2, (int)xxbr);
        y1 = Math.min(y1, (int)yybr);
        y2 = Math.max(y2, (int)yybr);
        x1 = Math.max(x1, 0);
        x2 = Math.min(x2, ow - 2);
        y1 = Math.max(y1, 0);
        y2 = Math.min(y2, oh - 2);
        Arrays.fill(output, background);
        if (y2 < 0 || x2 < 0 || x1 >= ow || y1 >= oh) {
            return;
        }
        for (int y = y1; y < y2; ++y) {
            int offset = y * ow;
            for (int x = x1; x < x2; ++x) {
                double xx = itx[0] * (double)x + itx[2] * (double)y + itx[4];
                double yy = itx[1] * (double)x + itx[3] * (double)y + itx[5];
                int xc = (int)xx;
                int yc = (int)yy;
                int yoffset0 = ioffset + (yc - 1) * iw;
                int yoffset1 = ioffset + yc * iw;
                int yoffset2 = ioffset + (yc + 1) * iw;
                int yoffset3 = ioffset + (yc + 2) * iw;
                double xfrac = xx - (double)xc;
                double yfrac = yy - (double)yc;
                double xfrac_1 = 1.0 - xfrac;
                double yfrac_1 = 1.0 - yfrac;
                int v00 = 0;
                int v01 = 0;
                int v02 = 0;
                int v03 = 0;
                int v10 = 0;
                int v11 = 0;
                int v12 = 0;
                int v13 = 0;
                int v20 = 0;
                int v21 = 0;
                int v22 = 0;
                int v23 = 0;
                int v30 = 0;
                int v31 = 0;
                int v32 = 0;
                int v33 = 0;
                if (xc >= 1 && xc < iw - 2 && yc >= 1 && yc < ih - 2) {
                    v00 = input[yoffset0 + xc - 1] & 0xFF;
                    v01 = input[yoffset0 + xc] & 0xFF;
                    v02 = input[yoffset0 + xc + 1] & 0xFF;
                    v03 = input[yoffset0 + xc + 2] & 0xFF;
                    v10 = input[yoffset1 + xc - 1] & 0xFF;
                    v11 = input[yoffset1 + xc] & 0xFF;
                    v12 = input[yoffset1 + xc + 1] & 0xFF;
                    v13 = input[yoffset1 + xc + 2] & 0xFF;
                    v20 = input[yoffset2 + xc - 1] & 0xFF;
                    v21 = input[yoffset2 + xc] & 0xFF;
                    v22 = input[yoffset2 + xc + 1] & 0xFF;
                    v23 = input[yoffset2 + xc + 2] & 0xFF;
                    v30 = input[yoffset3 + xc - 1] & 0xFF;
                    v31 = input[yoffset3 + xc] & 0xFF;
                    v32 = input[yoffset3 + xc + 1] & 0xFF;
                    v33 = input[yoffset3 + xc + 2] & 0xFF;
                }
                double v0 = Bicubic.cubic(xfrac) * (double)v01 + Bicubic.cubic(xfrac + 1.0) * (double)v00 + Bicubic.cubic(xfrac_1) * (double)v02 + Bicubic.cubic(xfrac_1 + 1.0) * (double)v03;
                double v1 = Bicubic.cubic(xfrac) * (double)v11 + Bicubic.cubic(xfrac + 1.0) * (double)v10 + Bicubic.cubic(xfrac_1) * (double)v12 + Bicubic.cubic(xfrac_1 + 1.0) * (double)v13;
                double v2 = Bicubic.cubic(xfrac) * (double)v21 + Bicubic.cubic(xfrac + 1.0) * (double)v20 + Bicubic.cubic(xfrac_1) * (double)v22 + Bicubic.cubic(xfrac_1 + 1.0) * (double)v23;
                double v3 = Bicubic.cubic(xfrac) * (double)v31 + Bicubic.cubic(xfrac + 1.0) * (double)v30 + Bicubic.cubic(xfrac_1) * (double)v32 + Bicubic.cubic(xfrac_1 + 1.0) * (double)v33;
                double v = Bicubic.cubic(yfrac) * v1 + Bicubic.cubic(yfrac + 1.0) * v0 + Bicubic.cubic(yfrac_1) * v2 + Bicubic.cubic(yfrac_1 + 1.0) * v3;
                int ival = v > 255.0 ? 255 : (int)v;
                ival = v < 0.0 ? 0 : ival;
                output[offset + x] = 0xFF000000 | ival << 16 | ival << 8 | ival;
            }
        }
    }

    public final void doIBicubicARGBToARGB(double[] tx, double[] itx, int[] input, int ioffset, int iw, int ih, int[] output, int ow, int oh, int background) {
        int inputY;
        int inputX;
        long t1 = System.currentTimeMillis();
        int m00 = (int)(itx[0] * 16384.0);
        int m10 = (int)(itx[1] * 16384.0);
        int m01 = (int)(itx[2] * 16384.0);
        int m11 = (int)(itx[3] * 16384.0);
        int m02 = (int)(itx[4] * 16384.0);
        int m12 = (int)(itx[5] * 16384.0);
        Point2D.Double iul = new Point2D.Double();
        Point2D.Double ibl = new Point2D.Double();
        Point2D.Double iur = new Point2D.Double();
        Point2D.Double ibr = new Point2D.Double();
        ((Point2D)iul).setLocation(0.0, 0.0);
        ((Point2D)ibl).setLocation(0.0, ih - 1);
        ((Point2D)iur).setLocation(iw - 1, 0.0);
        ((Point2D)ibr).setLocation(iw - 1, ih - 1);
        double xxul = tx[0] * ((Point2D)iul).getX() + tx[2] * ((Point2D)iul).getY() + tx[4];
        double yyul = tx[1] * ((Point2D)iul).getX() + tx[3] * ((Point2D)iul).getY() + tx[5];
        int x1 = (int)xxul;
        int y1 = (int)yyul;
        int x2 = (int)xxul;
        int y2 = (int)yyul;
        double xxbl = tx[0] * ((Point2D)ibl).getX() + tx[2] * ((Point2D)ibl).getY() + tx[4];
        double yybl = tx[1] * ((Point2D)ibl).getX() + tx[3] * ((Point2D)ibl).getY() + tx[5];
        x1 = Math.min(x1, (int)xxbl);
        x2 = Math.max(x2, (int)xxbl);
        y1 = Math.min(y1, (int)yybl);
        y2 = Math.max(y2, (int)yybl);
        double xxur = tx[0] * ((Point2D)iur).getX() + tx[2] * ((Point2D)iur).getY() + tx[4];
        double yyur = tx[1] * ((Point2D)iur).getX() + tx[3] * ((Point2D)iur).getY() + tx[5];
        x1 = Math.min(x1, (int)xxur);
        x2 = Math.max(x2, (int)xxur);
        y1 = Math.min(y1, (int)yyur);
        y2 = Math.max(y2, (int)yyur);
        double xxbr = tx[0] * ((Point2D)ibr).getX() + tx[2] * ((Point2D)ibr).getY() + tx[4];
        double yybr = tx[1] * ((Point2D)ibr).getX() + tx[3] * ((Point2D)ibr).getY() + tx[5];
        x1 = Math.min(x1, (int)xxbr);
        x2 = Math.max(x2, (int)xxbr);
        y1 = Math.min(y1, (int)yybr);
        y2 = Math.max(y2, (int)yybr);
        x1 = Math.max(x1, 0);
        x2 = Math.min(x2, ow - 2);
        y1 = Math.max(y1, 0);
        y2 = Math.min(y2, oh - 2);
        int outX = 0;
        int outY = 0;
        boolean found = false;
        for (outY = y1; outY <= y2; ++outY) {
            for (outX = x1; outX <= x2; ++outX) {
                inputX = m00 * outX + m01 * outY + m02 >> 14;
                inputY = m10 * outX + m11 * outY + m12 >> 14;
                if (inputX < 1 || inputY < 1 || inputX >= iw - 2 || inputY >= ih - 2) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        x1 = outX;
        y1 = outY;
        found = false;
        for (outY = y2; outY >= y1; --outY) {
            for (outX = x2; outX >= x1; --outX) {
                inputX = m00 * outX + m01 * outY + m02 >> 14;
                inputY = m10 * outX + m11 * outY + m12 >> 14;
                if (inputX < 1 || inputY < 1 || inputX >= iw - 2 || inputY >= ih - 2) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        x2 = outX;
        y2 = outY;
        Arrays.fill(output, background);
        if (y2 < 0 || x2 < 0 || x1 >= ow || y1 >= oh) {
            return;
        }
        for (int y = y1; y < y2; ++y) {
            int offset = y * ow;
            int tr_1 = m01 * y + m02;
            int tr_2 = m11 * y + m12;
            for (int x = x1; x < x2; ++x) {
                int tx_x = m00 * x + tr_1;
                int tx_y = m10 * x + tr_2;
                int xc = tx_x >> 14;
                int yc = tx_y >> 14;
                if (xc < 1 || xc >= iw - 2 || yc < 1 || yc >= ih - 2) continue;
                int yoffset0 = ioffset + (yc - 1) * iw;
                int yoffset1 = ioffset + yc * iw;
                int yoffset2 = ioffset + (yc + 1) * iw;
                int yoffset3 = ioffset + (yc + 2) * iw;
                int xfrac = tx_x & 0x3FFF;
                int yfrac = tx_y & 0x3FFF;
                int xfrac_1 = 16384 - xfrac;
                int yfrac_1 = 16384 - yfrac;
                int v00 = input[yoffset0 + xc - 1] & 0xFF;
                int v01 = input[yoffset0 + xc] & 0xFF;
                int v02 = input[yoffset0 + xc + 1] & 0xFF;
                int v03 = input[yoffset0 + xc + 2] & 0xFF;
                int v10 = input[yoffset1 + xc - 1] & 0xFF;
                int v11 = input[yoffset1 + xc] & 0xFF;
                int v12 = input[yoffset1 + xc + 1] & 0xFF;
                int v13 = input[yoffset1 + xc + 2] & 0xFF;
                int v20 = input[yoffset2 + xc - 1] & 0xFF;
                int v21 = input[yoffset2 + xc] & 0xFF;
                int v22 = input[yoffset2 + xc + 1] & 0xFF;
                int v23 = input[yoffset2 + xc + 2] & 0xFF;
                int v30 = input[yoffset3 + xc - 1] & 0xFF;
                int v31 = input[yoffset3 + xc] & 0xFF;
                int v32 = input[yoffset3 + xc + 1] & 0xFF;
                int v33 = input[yoffset3 + xc + 2] & 0xFF;
                int v0 = ctable[xfrac] * v01 + ctable[xfrac + 16384] * v00 + ctable[xfrac_1] * v02 + ctable[xfrac_1 + 16384] * v03;
                int v1 = ctable[xfrac] * v11 + ctable[xfrac + 16384] * v10 + ctable[xfrac_1] * v12 + ctable[xfrac_1 + 16384] * v13;
                int v2 = ctable[xfrac] * v21 + ctable[xfrac + 16384] * v20 + ctable[xfrac_1] * v22 + ctable[xfrac_1 + 16384] * v23;
                int v3 = ctable[xfrac] * v31 + ctable[xfrac + 16384] * v30 + ctable[xfrac_1] * v32 + ctable[xfrac_1 + 16384] * v33;
                int v = ctable[yfrac] * (v1 >>= 14) + ctable[yfrac + 16384] * (v0 >>= 14) + ctable[yfrac_1] * (v2 >>= 14) + ctable[yfrac_1 + 16384] * (v3 >>= 14);
                int ival = (v >>= 14) > 255 ? 255 : v;
                ival = v < 0 ? 0 : ival;
                output[offset + x] = 0xFF000000 | ival << 16 | ival << 8 | ival;
            }
        }
    }

    public static void main(String[] args) {
        Bicubic b2 = new Bicubic();
        XpDMSessionProvider dmsp = new XpDMSessionProvider(new String[]{"file", args[0]});
        JFrame jf = new JFrame("Bicubic");
        XpImageViewport iv = new XpImageViewport();
        XpMedicalImage[] imgs = dmsp.getImages();
        BufferedImage bimg = (BufferedImage)imgs[imgs.length >> 1].getPixelData();
        int w = 1024;
        int h = 1024;
        int imgWidth = bimg.getWidth();
        int imgHeight = bimg.getHeight();
        short[] data = ((DataBufferUShort)bimg.getRaster().getDataBuffer()).getData();
        BufferedImage outimg = new BufferedImage(1024, 1024, 11);
        short[] outdata = ((DataBufferUShort)outimg.getRaster().getDataBuffer()).getData();
        XpBufferedImage medimg = new XpBufferedImage(outimg, -1024.0, 1.0);
        iv.setImages(new XpMedicalImage[]{medimg});
        AffineTransform at = new AffineTransform();
        at.setToIdentity();
        at.translate(512.0, 512.0);
        at.scale(1536.0 / (double)imgWidth, 1536.0 / (double)imgHeight);
        at.translate((double)(-imgWidth) * 0.5, (double)(-imgHeight) * 0.5);
        double[] tx = new double[6];
        double[] itx = new double[6];
        at.getMatrix(tx);
        AffineTransform inv = null;
        try {
            inv = at.createInverse();
            inv.getMatrix(itx);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        System.err.println(">>>> " + imgWidth + " " + imgHeight + " " + 1024 + " " + 1024);
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < 128; ++i) {
            b2.shortToshort(tx, itx, data, 0, imgWidth, imgHeight, outdata, 1024, 1024, 0, 0, 1023, 1023, 1, 1);
        }
        long t = System.currentTimeMillis() - t0;
        System.err.println(">>> time = " + (double)t / 128.0);
        iv.setWindowing(750.0, 150.0);
        jf.setContentPane(iv);
        iv.setPreferredSize(new Dimension(784, 784));
        jf.pack();
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }

    static {
        ctable = new int[32769];
        Bicubic.buildTable(ctable);
    }

    public static class IRenderer
    extends XpJImage2DRenderer {
        public IRenderer() {
            super(LuminanceIBicubic.class);
            this.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
    }

    public static class Renderer
    extends XpJImage2DRenderer {
        public Renderer() {
            super(LuminanceBicubic.class);
            this.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
    }

    public static class LuminanceIBicubic
    extends BicubicPipeline {
        public void affineMap(double[] tx, double[] itx, int[] input, int ioffset, int iw, int ih, int[] output, int ow, int oh, int background) {
            this.bc.doIBicubicARGBToARGB(tx, itx, input, ioffset, iw, ih, output, ow, oh, background);
        }
    }

    public static class LuminanceBicubic
    extends BicubicPipeline {
        public void affineMap(double[] tx, double[] itx, int[] input, int ioffset, int iw, int ih, int[] output, int ow, int oh, int background) {
            this.bc.doBicubicARGBToARGB(tx, itx, input, ioffset, iw, ih, output, ow, oh, background);
        }
    }

    private static abstract class BicubicPipeline
    extends XpJPipeline {
        protected Bicubic bc = new Bicubic();
        private int outWidth = 0;
        private int outHeight = 0;
        private int inWidth;
        private int inHeight;
        private BufferedImage cacheImage = null;
        private AffineTransform inverse = new AffineTransform();
        private double[] md = new double[6];
        private double[] imd = new double[6];
        public int BG_VAL = -16777216;

        protected void renderImage(Graphics2D g2, Rectangle viewport, XpJImage2DRenderer r, AffineTransform tx) {
            XpImageDrawable drawable = r.getDrawable();
            if (drawable == null) {
                return;
            }
            if (this.outWidth != viewport.width || this.outHeight != viewport.height) {
                this.outWidth = viewport.width;
                this.outHeight = viewport.height;
                this.cacheImage = new BufferedImage(this.outWidth, this.outHeight, 2);
                this.setChangeRender(true);
            }
            BufferedImage image = drawable.getBufferedImage();
            int w = image.getWidth();
            int h = image.getHeight();
            if (this.inWidth != w || this.inHeight != h) {
                this.inWidth = w;
                this.inHeight = h;
            }
            if (r.isComputePixelTransfer()) {
                r.computePixelTransfer();
                r.setComputePixelTransfer(false);
            }
            tx.getMatrix(this.md);
            gu.calcInverse(tx, this.inverse);
            this.inverse.getMatrix(this.imd);
            if (w == this.outWidth && h == this.outHeight && this.md[0] == 1.0 && this.md[1] == 0.0 && this.md[2] == 0.0 && this.md[3] == 1.0) {
                int itx = (int)this.md[4];
                int ity = (int)this.md[5];
                g2.drawImage((Image)image, itx, ity, null);
                return;
            }
            Object iHint = r.getInterpolationHint();
            if (this.isChangeRender() && iHint == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                this.calcInverse(tx, this.inverse);
                this.inverse.getMatrix(this.imd);
                tx.getMatrix(this.md);
                DataBuffer db = image.getRaster().getDataBuffer();
                int[] input = ((DataBufferInt)db).getData();
                int[] output = ((DataBufferInt)this.cacheImage.getRaster().getDataBuffer()).getData();
                this.affineMap(this.md, this.imd, input, 0, w, h, output, this.outWidth, this.outHeight, this.BG_VAL);
            }
            r.applyClip(g2);
            if (iHint == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                g2.drawImage((Image)this.cacheImage, 0, 0, null);
            } else {
                g2.drawRenderedImage(image, tx);
            }
            r.clearClip(g2);
        }

        public abstract void affineMap(double[] var1, double[] var2, int[] var3, int var4, int var5, int var6, int[] var7, int var8, int var9, int var10);
    }
}

