/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.platform.dm;

import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.tap.dm.DMImage;
import java.awt.image.RenderedImage;
import java.util.StringTokenizer;

public class XpMedicalDmImage
implements XpMedicalImage {
    private DMImage dmi = null;
    private XpSlice _slice = null;
    private double deflevel = 0.0;
    private double defwidth = 0.0;
    private double rescaleIntercept = 0.0;
    private double rescaleSlope = 1.0;
    private double azimuth = 0.0;
    private boolean loadedDefWL = false;
    private boolean loadedDefWW = false;
    private double[] minmax = new double[2];
    private boolean init = false;
    private boolean loadedSlope = false;
    private boolean loadedIntercept = false;

    public XpMedicalDmImage(DMImage dmi) {
        this.dmi = dmi;
    }

    protected void setDefaultWindowLevel(double wl) {
        this.deflevel = wl;
        this.loadedDefWL = true;
    }

    protected void setDefaultWindowWidth(double ww) {
        this.defwidth = ww;
        this.loadedDefWW = true;
    }

    protected void setRescaleSlope(double rs) {
        this.rescaleSlope = rs;
        this.loadedSlope = true;
    }

    protected void setRescaleIntercept(double ri) {
        this.rescaleIntercept = ri;
        this.loadedIntercept = true;
    }

    protected void initImage() {
        StringTokenizer st;
        String snum;
        StringTokenizer st2;
        if (this.init) {
            return;
        }
        this._slice = new XpSlice(this);
        Object obj = null;
        if (!this.loadedDefWL) {
            obj = this.dmi.getValue(40, 4176);
            if (obj instanceof String) {
                st2 = new StringTokenizer((String)obj, "\\");
                try {
                    this.setDefaultWindowLevel(Float.parseFloat(st2.nextToken()));
                }
                catch (NumberFormatException e) {
                    XpLog.warning("Invalid tag in image (0x0028,0x1050)");
                }
            } else if (obj instanceof Integer) {
                this.setDefaultWindowLevel(((Integer)obj).intValue());
            }
        }
        if (!this.loadedDefWW) {
            obj = this.dmi.getValue(40, 4177);
            if (obj instanceof String) {
                st2 = new StringTokenizer((String)obj, "\\");
                try {
                    this.setDefaultWindowWidth(Float.parseFloat(st2.nextToken()));
                }
                catch (NumberFormatException e) {
                    XpLog.warning("Invalid tag in image (0x0028,0x1051)");
                }
            } else if (obj instanceof Integer) {
                this.setDefaultWindowWidth(((Integer)obj).intValue());
            }
        }
        if (this.defwidth == 0.0 && this.deflevel == 0.0) {
            this.loadedDefWW = false;
            this.loadedDefWL = false;
        }
        if (!this.loadedIntercept) {
            obj = this.dmi.getValue(40, 4178);
            if (obj instanceof String) {
                snum = (String)obj;
                if (snum.length() <= 0) {
                    snum = "0";
                }
                st = new StringTokenizer(snum, "\\");
                try {
                    this.setRescaleIntercept(Double.parseDouble(st.nextToken()));
                }
                catch (NumberFormatException e) {
                    XpLog.warning("Invalid tag in image (0x0028,0x1052)");
                }
            } else if (obj instanceof Number) {
                this.setRescaleIntercept(((Number)obj).doubleValue());
            }
        }
        if (!this.loadedSlope) {
            obj = this.dmi.getValue(40, 4179);
            if (obj instanceof String) {
                snum = (String)obj;
                if (snum.length() <= 0) {
                    snum = "1";
                }
                st = new StringTokenizer(snum, "\\");
                try {
                    this.setRescaleSlope(Double.parseDouble(st.nextToken()));
                }
                catch (NumberFormatException e) {
                    XpLog.warning("Invalid tag in image (0x0028,0x1053)");
                }
            } else if (obj instanceof Number) {
                this.setRescaleSlope(((Number)obj).doubleValue());
            }
        }
        if (this.rescaleSlope == 0.0) {
            this.rescaleSlope = 1.0;
        }
        this.loadedIntercept = true;
        this.loadedSlope = true;
        this.azimuth = XpImageUtils.gehcAzimuth(this);
        this.init = true;
    }

    public RenderedImage getPixelData() {
        return this.dmi.getPixelData();
    }

    public XpSlice getSlice() {
        this.initImage();
        return this._slice;
    }

    public double getDefaultWindowWidth() {
        this.initImage();
        if (!this.loadedDefWW) {
            int subsample = 17;
            if (this._slice.width <= 128 && this._slice.height <= 128) {
                subsample = 5;
            }
            XpImageUtils.getMinMax(this, subsample, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.defwidth;
    }

    public double getDefaultWindowLevel() {
        this.initImage();
        if (!this.loadedDefWL) {
            int subsample = 16;
            if (this._slice.width <= 128 && this._slice.height <= 128) {
                subsample = 4;
            }
            XpImageUtils.getMinMax(this, subsample, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.deflevel;
    }

    public double getPixelDimensionX() {
        return this.getSlice().pixelSizeX;
    }

    public double getPixelDimensionY() {
        return this.getSlice().pixelSizeY;
    }

    public int getValue(XpDicomElement value) {
        value.value = value.group == 0 ? this.dmi.getProperty("" + value.group + "," + value.element) : this.dmi.getValue(value.group, value.element);
        if (value.value != null) {
            return 0;
        }
        return 1;
    }

    public int getValues(XpDicomElement[] values) {
        int notLoaded = 0;
        for (int i = 0; i < values.length; ++i) {
            int result = this.getValue(values[i]);
            if (result != 1) continue;
            ++notLoaded;
        }
        return notLoaded;
    }

    public final DMImage getDMImage() {
        return this.dmi;
    }

    public double getRescaleIntercept() {
        this.initImage();
        return this.rescaleIntercept;
    }

    public double getRescaleSlope() {
        this.initImage();
        return this.rescaleSlope;
    }

    public final double getAzimuth() {
        this.initImage();
        return this.azimuth;
    }

    public static XpMedicalImage[] wrapDMImages(DMImage[] dmi) {
        XpMedicalImage[] imgs = new XpMedicalImage[dmi.length];
        for (int i = 0; i < dmi.length; ++i) {
            imgs[i] = new XpMedicalDmImage(dmi[i]);
        }
        return imgs;
    }
}

