/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.platform.dm;

import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.jami.XpCPI;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.CPICapable;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiSeqItem;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.DicomData;
import com.ge.med.terra.tap.util.dicom.GSPSComposite;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpDMgsps {
    private static boolean debug = XpPropertiesManager.getProperty("jami.gsps.debug") != null;
    private static dicomParser theDP = new dicomParser();
    private static XpDicomElement seriesNo = new XpDicomElement(32, 17);
    private static XpDicomElement imageNo = new XpDicomElement(32, 19);
    private static XpDicomElement sopCUID = new XpDicomElement(8, 22);
    private static XpDicomElement sopUID = new XpDicomElement(8, 24);
    private static XpDicomElement seriesInstUID = new XpDicomElement(32, 14);
    private XpDicomElement ppsInfo = new XpDicomElement(8, 4369);
    private GSPSComposite dmc = null;

    public XpDMgsps(XpViewport xv) {
        XpMedicalImage[] imgs = xv.getImages();
        XpCPI cpi = ((CPICapable)((Object)xv)).getCPI();
        this.init(imgs, cpi, null);
    }

    public XpDMgsps(XpMedicalImage[] imgs, XpCPI cpi, DMObject refObject) {
        this.init(imgs, cpi, refObject);
    }

    public XpDMgsps(XpViewport xv, DMObject refObject) {
        XpMedicalImage[] imgs = xv.getImages();
        XpCPI cpi = ((CPICapable)((Object)xv)).getCPI();
        this.init(imgs, cpi, refObject);
    }

    private void init(XpMedicalImage[] imgs, XpCPI cpi, DMObject refObject) {
        this.dmc = new GSPSComposite();
        if (null == refObject) {
            GSPSDicomObject ref = new GSPSDicomObject(imgs[0]);
            this.dmc.fill(ref);
        } else {
            this.dmc.fill(refObject);
        }
        this.fillPresentationState(imgs, cpi, refObject);
    }

    public static void setDebug(boolean db) {
        debug = db;
    }

    private void setValue(int group, int element, Object value) {
        this.dmc.setValue(group, element, value);
    }

    private void setValue(int group, int element, int i, DicomData value) {
        this.dmc.setValue(group, element, i, value);
    }

    private void setDateValue(int group, int element, Date date) {
        this.dmc.setDateValue(group, element, date);
    }

    private void setTimeValue(int group, int element, Date time) {
        this.dmc.setTimeValue(group, element, time);
    }

    public InputStream getGSPS() {
        InputStream is = this.dmc.getInputStream(false, DicomComposite.TS_ELE);
        return is;
    }

    public InputStream getGSPS(XpDicomElement[] overrides) {
        for (int i = 0; i < overrides.length; ++i) {
            Object obj = this.dmc.getValue(overrides[i].group, overrides[i].element);
            if (obj == null) continue;
            this.setValue(overrides[i].group, overrides[i].element, overrides[i].value);
        }
        return this.getGSPS();
    }

    private static tagValue getTagValue(tagValue[] tvs, int group, int element) {
        for (int i = 0; i < tvs.length; ++i) {
            if (tvs[i].group != group || tvs[i].element != element) continue;
            return tvs[i];
        }
        return null;
    }

    private static String[] getStringVals(String str) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, "\\");
        while (st.hasMoreTokens()) {
            String stVal = st.nextToken();
            l.add(stVal);
        }
        int len = l.size();
        if (len > 0) {
            String[] vals = new String[len];
            for (int i = 0; i < len; ++i) {
                String stVal;
                vals[i] = stVal = (String)l.get(i);
            }
            return vals;
        }
        return null;
    }

    public static String[] getSOPInstanceUids(InputStream is) {
        return null;
    }

    public static XpCPI getCPI(InputStream is) {
        tagValue tag2;
        XpCPI cpi = new XpCPI();
        if (debug) {
            XpLog.logger().info("-----------------PARSING GSPS object------------------");
        }
        try {
            theDP.clearFile();
            theDP.setFile(is);
        }
        catch (FileNotFoundException ex) {
            System.err.println("ERROR OPENING FILE...");
            return null;
        }
        int NTAGS = 17;
        Object[] tvs = new tagValue[NTAGS];
        tvs[0] = new tagValue(24, 5632);
        tvs[1] = new tagValue(24, 5634);
        tvs[2] = new tagValue(24, 5636);
        tvs[3] = new tagValue(24, 5638);
        tvs[4] = new tagValue(24, 5640);
        tvs[5] = new tagValue(24, 5648);
        tvs[6] = new tagValue(24, 5650);
        tvs[7] = new tagValue(24, 5664);
        tvs[8] = new tagValue(24, 5666);
        tvs[9] = new tagValue(40, 12560);
        tvs[10] = new tagValue(112, 1);
        tvs[11] = new tagValue(112, 65);
        tvs[12] = new tagValue(112, 66);
        tvs[13] = new tagValue(112, 90);
        tvs[14] = new tagValue(112, 96);
        tvs[15] = new tagValue(8272, 16);
        tvs[16] = new tagValue(8272, 32);
        Arrays.sort(tvs);
        theDP.fill((tagValue[])tvs);
        if (debug) {
            for (int i = 0; i < tvs.length; ++i) {
                XpLog.logger().info("tagValue[" + i + "]=" + ((tagValue)tvs[i]).value);
            }
        }
        tagValue tv = null;
        List daList = cpi.getDisplayedArea();
        tv = XpDMgsps.getTagValue((tagValue[])tvs, 112, 90);
        Object[] values = null;
        if (tv != null) {
            values = (Object[])tv.value;
        }
        if (values != null) {
            if (debug) {
                XpLog.logger().info("READ GSPS: ** DISPLAYED AREA MODULE ** [" + values.length + "]");
            }
            for (int i = 0; i < values.length; ++i) {
                Object[] tags = (Object[])values[i];
                XpCPI.DisplayedArea da = new XpCPI.DisplayedArea();
                daList.add(da);
                for (int j = 0; j < tags.length; ++j) {
                    double zoom;
                    double y;
                    tagValue tag3 = (tagValue)tags[j];
                    if (tag3.group == 8 && tag3.element == 4416) {
                        Object[] rimgs = (Object[])tag3.value;
                        for (int k = 0; k < rimgs.length; ++k) {
                            Object[] rimgVals = (Object[])rimgs[k];
                            XpCPI.GSPSFrame frame = new XpCPI.GSPSFrame();
                            for (int a = 0; a < rimgVals.length; ++a) {
                                tagValue tagVal = (tagValue)rimgVals[a];
                                if (tagVal.group == 8 && tagVal.element == 4432) {
                                    frame.SOPClassUID = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group == 8 && tagVal.element == 4437) {
                                    frame.SOPInstanceUID = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group != 8 || tagVal.element != 4448) continue;
                                frame.ReferencedFrameNum = new Integer("" + tagVal.value);
                            }
                            da.refImgSequence.add(frame);
                        }
                        continue;
                    }
                    if (tag3.group == 112 && tag3.element == 82) {
                        Integer[] tlhc = (Integer[])tag3.value;
                        double x = tlhc[0].intValue();
                        y = tlhc[1].intValue();
                        da.tlDisplay.setLocation(x, y);
                        if (!debug) continue;
                        XpLog.logger().info("READ GSPS: " + i + " TLHC=" + da.tlDisplay);
                        continue;
                    }
                    if (tag3.group == 112 && tag3.element == 83) {
                        Integer[] brhc = (Integer[])tag3.value;
                        double x = brhc[0].intValue();
                        y = brhc[1].intValue();
                        da.brDisplay.setLocation(x, y);
                        if (!debug) continue;
                        XpLog.logger().info("READ GSPS: " + i + " BRHC=" + da.brDisplay);
                        continue;
                    }
                    if (tag3.group == 112 && tag3.element == 256) {
                        da.presSize = "" + tag3.value;
                        continue;
                    }
                    if (tag3.group == 112 && tag3.element == 257) {
                        String[] pps = XpDMgsps.getStringVals("" + tag3.value);
                        double x = new Double(pps[0]);
                        y = new Double(pps[1]);
                        da.presPixelSpacing.setLocation(x, y);
                        continue;
                    }
                    if (tag3.group == 112 && tag3.element == 258) {
                        String[] ppa = XpDMgsps.getStringVals("" + tag3.value);
                        double x = new Double(ppa[0]);
                        y = new Double(ppa[1]);
                        da.presPixelAspectRatio.setLocation(x, y);
                        continue;
                    }
                    if (tag3.group != 112 || tag3.element != 259) continue;
                    da.pixelMagnificationRatio = zoom = new Double("" + tag3.value).doubleValue();
                    if (!debug) continue;
                    XpLog.logger().info("READ GSPS: ** " + i + " zoom=" + zoom);
                }
                if (!debug) continue;
                XpLog.logger().info("----------");
            }
            if (debug) {
                XpLog.logger().info("---------------------------------------------");
            }
        }
        List gaList = cpi.getGraphicAnnotation();
        tv = XpDMgsps.getTagValue((tagValue[])tvs, 112, 1);
        values = null;
        if (tv != null) {
            values = (Object[])tv.value;
        }
        if (values != null) {
            if (debug) {
                XpLog.logger().info("READ GSPS: ** GRAPHIC ANNOTATION MODULE **");
            }
            XpCPI.GraphicLayer roiLayer = new XpCPI.GraphicLayer("ROI layer");
            for (int i = 0; i < values.length; ++i) {
                Object[] tags = (Object[])values[i];
                XpCPI.GraphicAnnotation ga = new XpCPI.GraphicAnnotation(roiLayer);
                gaList.add(ga);
                for (int j = 0; j < tags.length; ++j) {
                    int k;
                    tagValue tag4 = (tagValue)tags[j];
                    if (tag4.group == 8 && tag4.element == 4416) {
                        Object[] rimgs = (Object[])tag4.value;
                        for (k = 0; k < rimgs.length; ++k) {
                            Object[] rimgVals = (Object[])rimgs[k];
                            XpCPI.GSPSFrame frame = new XpCPI.GSPSFrame();
                            for (int a = 0; a < rimgVals.length; ++a) {
                                tagValue tagVal = (tagValue)rimgVals[a];
                                if (tagVal.group == 8 && tagVal.element == 4432) {
                                    frame.SOPClassUID = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group == 8 && tagVal.element == 4437) {
                                    frame.SOPInstanceUID = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group != 8 || tagVal.element != 4448) continue;
                                frame.ReferencedFrameNum = new Integer("" + tagVal.value);
                            }
                            ga.refImgSequence.add(frame);
                        }
                        continue;
                    }
                    if (tag4.group == 112 && tag4.element == 2) {
                        ga.grxLayer.layerDescription = "" + tag4.value;
                        continue;
                    }
                    if (tag4.group == 112 && tag4.element == 8) {
                        Object[] tobjs = (Object[])tag4.value;
                        for (k = 0; k < tobjs.length; ++k) {
                            Object[] tobjVals = (Object[])tobjs[k];
                            XpCPI.TextObject to = new XpCPI.TextObject();
                            ga.textSequence.add(to);
                            boolean tlbb = false;
                            boolean brbb = false;
                            double tlbbX = 0.0;
                            double tlbbY = 0.0;
                            double brbbX = 0.0;
                            double brbbY = 0.0;
                            for (int a = 0; a < tobjVals.length; ++a) {
                                Float[] vals;
                                String units;
                                tagValue tagVal = (tagValue)tobjVals[a];
                                if (tagVal.group == 112 && tagVal.element == 3) {
                                    units = "" + tagVal.value;
                                    if (units.equals("PIXEL")) {
                                        to.bboxUnits = 0;
                                        continue;
                                    }
                                    if (!units.equals("DISPLAY")) continue;
                                    to.bboxUnits = (byte)3;
                                    continue;
                                }
                                if (tagVal.group == 112 && tagVal.element == 4) {
                                    units = "" + tagVal.value;
                                    if (units.equals("PIXEL")) {
                                        to.anchorUnits = 0;
                                        continue;
                                    }
                                    if (!units.equals("DISPLAY")) continue;
                                    to.anchorUnits = (byte)3;
                                    continue;
                                }
                                if (tagVal.group == 112 && tagVal.element == 6) {
                                    to.textValue = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group == 112 && tagVal.element == 16) {
                                    tlbb = true;
                                    vals = (Float[])tagVal.value;
                                    tlbbX = vals[0].floatValue();
                                    tlbbY = vals[1].floatValue();
                                    continue;
                                }
                                if (tagVal.group == 112 && tagVal.element == 17) {
                                    brbb = true;
                                    vals = (Float[])tagVal.value;
                                    brbbX = vals[0].floatValue();
                                    brbbY = vals[1].floatValue();
                                    continue;
                                }
                                if (tagVal.group == 112 && tagVal.element == 18) {
                                    to.bboxJustification = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group == 112 && tagVal.element == 20) {
                                    vals = (Float[])tagVal.value;
                                    to.anchorPoint.setLocation(vals[0].floatValue(), vals[1].floatValue());
                                    continue;
                                }
                                if (tagVal.group != 112 || tagVal.element != 21) continue;
                                String stVal = "" + tagVal.value;
                                to.anchorVisibility = stVal.equals("Y");
                                if (!debug) continue;
                                XpLog.logger().info("GSPS: Anchor Visibility -- " + to.anchorVisibility + " [" + stVal + "]");
                            }
                            if (!tlbb || !brbb) continue;
                            double w = Math.abs(brbbX - tlbbX);
                            double h = Math.abs(brbbY - tlbbY);
                            to.boundingBox.setRect(tlbbX, tlbbY, w, h);
                        }
                        continue;
                    }
                    if (tag4.group != 112 || tag4.element != 9) continue;
                    Object[] gobjs = (Object[])tag4.value;
                    for (k = 0; k < gobjs.length; ++k) {
                        Object[] gobjVals = (Object[])gobjs[k];
                        XpCPI.GraphicObject go = new XpCPI.GraphicObject();
                        ga.graphicSequence.add(go);
                        int nPts = -1;
                        for (int a = 0; a < gobjVals.length; ++a) {
                            tagValue tagVal = (tagValue)gobjVals[a];
                            if (tagVal.group == 112 && tagVal.element == 5) {
                                String units = "" + tagVal.value;
                                if (units.equals("PIXEL")) {
                                    go.graphicUnits = 0;
                                    continue;
                                }
                                if (!units.equals("DISPLAY")) continue;
                                go.graphicUnits = 1;
                                continue;
                            }
                            if (tagVal.group == 112 && tagVal.element == 32) {
                                go.graphicDim = new Integer("" + tagVal.value);
                                continue;
                            }
                            if (tagVal.group == 112 && tagVal.element == 33) {
                                nPts = new Integer("" + tagVal.value);
                                continue;
                            }
                            if (tagVal.group == 112 && tagVal.element == 34) {
                                Float[] vals = (Float[])tagVal.value;
                                int nPoints = vals.length / 2;
                                for (int b2 = 0; b2 < nPoints; ++b2) {
                                    Point2D.Double p = new Point2D.Double(vals[2 * b2].floatValue(), vals[2 * b2 + 1].floatValue());
                                    go.graphicData.add(p);
                                }
                                continue;
                            }
                            if (tagVal.group == 112 && tagVal.element == 35) {
                                go.graphicType = "" + tagVal.value;
                                continue;
                            }
                            if (tagVal.group != 112 || tagVal.element != 36) continue;
                            String stVal = "" + tagVal.value;
                            go.filled = stVal.equals("Y");
                        }
                    }
                }
            }
            if (debug) {
                XpLog.logger().info("---------------------------------------------");
            }
        }
        XpCPI.SpatialTransformation st = cpi.getSpatialTransformation();
        tv = XpDMgsps.getTagValue((tagValue[])tvs, 112, 65);
        if (tv != null && tv.value != null) {
            String flip = "" + tv.value;
            st.flipHorizontal = flip.toUpperCase().equals("Y");
            if (debug) {
                XpLog.logger().info("READ GSPS: Flip    : " + flip);
            }
        }
        if ((tv = XpDMgsps.getTagValue((tagValue[])tvs, 112, 66)) != null && tv.value != null) {
            String rot = "" + tv.value;
            if (debug) {
                XpLog.logger().info("READ GSPS: Rotation: " + rot);
            }
            int angle = Integer.parseInt(rot);
            st.angle = angle;
            st.angle = Math.toRadians(st.angle);
        }
        List softList = cpi.getSoftcopyVoiLut();
        tv = XpDMgsps.getTagValue((tagValue[])tvs, 40, 12560);
        values = null;
        if (tv != null) {
            values = (Object[])tv.value;
        }
        if (values != null) {
            if (debug) {
                XpLog.logger().info("READ GSPS: ** SOFTCOPY VOI LUT MODULE **");
            }
            for (int i = 0; i < values.length; ++i) {
                Object[] tags = (Object[])values[i];
                XpCPI.SoftcopyVoiLut svl = new XpCPI.SoftcopyVoiLut();
                softList.add(svl);
                for (int j = 0; j < tags.length; ++j) {
                    tag2 = (tagValue)tags[j];
                    if (tag2.group == 8 && tag2.element == 4416) {
                        Object[] rimgs = (Object[])tag2.value;
                        for (int k = 0; k < rimgs.length; ++k) {
                            Object[] rimgVals = (Object[])rimgs[k];
                            XpCPI.GSPSFrame frame = new XpCPI.GSPSFrame();
                            for (int a = 0; a < rimgVals.length; ++a) {
                                tagValue tagVal = (tagValue)rimgVals[a];
                                if (tagVal.group == 8 && tagVal.element == 4432) {
                                    frame.SOPClassUID = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group == 8 && tagVal.element == 4437) {
                                    frame.SOPInstanceUID = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group != 8 || tagVal.element != 4448) continue;
                                frame.ReferencedFrameNum = new Integer("" + tagVal.value);
                            }
                            svl.refImgSequence.add(frame);
                        }
                        continue;
                    }
                    if (tag2.group == 40 && tag2.element == 12304) continue;
                    if (tag2.group == 40 && tag2.element == 4176) {
                        svl.windowCenter = new Double("" + tag2.value);
                        svl.wwwlSpecified = true;
                        if (!debug) continue;
                        XpLog.logger().info("*** " + i + " wl=" + svl.windowCenter);
                        continue;
                    }
                    if (tag2.group == 40 && tag2.element == 4177) {
                        svl.windowWidth = new Double("" + tag2.value);
                        svl.wwwlSpecified = true;
                        if (!debug) continue;
                        XpLog.logger().info("*** " + i + " ww=" + svl.windowWidth);
                        continue;
                    }
                    if (tag2.group != 40 || tag2.element != 4181) continue;
                    svl.wwwlExplanation = "" + tag2.value;
                }
            }
            if (debug) {
                XpLog.logger().info("---------------------------------------------");
            }
        }
        XpCPI.SoftcopyPresentationLut spl = cpi.getSoftcopyPresentationLut();
        tv = XpDMgsps.getTagValue((tagValue[])tvs, 8272, 16);
        if (tv != null && (values = (Object[])tv.value) != null) {
            if (debug) {
                XpLog.logger().info("READ GSPS: ** SOFTCOPY PRESENTATION MODULE **");
            }
            for (int i = 0; i < values.length; ++i) {
                Object[] tags = (Object[])values[i];
                for (int j = 0; j < tags.length; ++j) {
                    Integer[] vals;
                    tag2 = (tagValue)tags[j];
                    if (tag2.group == 40 && tag2.element == 12290) {
                        vals = (Integer[])tag2.value;
                        spl.lutDescriptor = vals;
                        continue;
                    }
                    if (tag2.group == 40 && tag2.element == 12291) {
                        spl.lutExplanation = "" + tag2.value;
                        continue;
                    }
                    if (tag2.group != 40 || tag2.element != 12294) continue;
                    vals = (Integer[])tag2.value;
                    spl.lutData = vals;
                }
            }
        }
        if ((tv = XpDMgsps.getTagValue((tagValue[])tvs, 8272, 32)) != null && tv.value != null) {
            String pLutShape = "" + tv.value;
            if (debug) {
                XpLog.logger().info("READ GSPS: pLutShape - " + pLutShape);
            }
            spl.pLutShape = pLutShape;
        }
        tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5632);
        XpCPI.DisplayShutter ds = null;
        if (tv != null && tv.value != null) {
            ds = new XpCPI.DisplayShutter();
            cpi.setDisplayShutter(ds, 0);
            ds.shutterShape = "" + tv.value;
            if (ds.shutterShape.equals("RECTANGULAR")) {
                double ulX = 0.0;
                double ulY = 0.0;
                double brX = 0.0;
                double brY = 0.0;
                tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5634);
                if (tv != null && tv.value != null) {
                    ulX = new Double("" + tv.value);
                }
                if ((tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5636)) != null && tv.value != null) {
                    brX = new Double("" + tv.value);
                }
                if ((tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5638)) != null && tv.value != null) {
                    ulY = new Double("" + tv.value);
                }
                if ((tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5640)) != null && tv.value != null) {
                    brY = new Double("" + tv.value);
                }
                ds.rectULPoint.setLocation(ulX, ulY);
                ds.rectBRPoint.setLocation(brX, brY);
            } else if (ds.shutterShape.equals("CIRCULAR")) {
                tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5648);
                if (tv != null && tv.value != null) {
                    String[] ivals = XpDMgsps.getStringVals("" + tv.value);
                    double x = new Double(ivals[0]);
                    double y = new Double(ivals[1]);
                    ds.circularCenter.setLocation(x, y);
                }
                if ((tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5650)) != null && tv.value != null) {
                    ds.circularRadius = new Double("" + tv.value);
                }
            } else if (ds.shutterShape.equals("POLYGONAL")) {
                tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5664);
                ds.polygonalVertices = new ArrayList();
                if (tv != null && tv.value != null) {
                    String[] ivals = XpDMgsps.getStringVals("" + tv.value);
                    for (int i = 0; i < ivals.length; i += 2) {
                        double y = new Double(ivals[i]);
                        double x = new Double(ivals[i + 1]);
                        Point2D.Double p = new Point2D.Double(x, y);
                        ds.polygonalVertices.add(p);
                    }
                }
            }
            tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5666);
            if (tv != null && tv.value != null) {
                ds.shutterPValue = new Integer("" + tv.value);
            }
        }
        theDP.clearFile();
        return cpi;
    }

    private static String[] dicomPtIS(Point2D p) {
        int x = (int)p.getX();
        int y = (int)p.getY();
        return new String[]{"" + x, "" + y};
    }

    private static String[] dicomPtDS(Point2D p) {
        return new String[]{"" + p.getX(), "" + p.getY()};
    }

    private static Float[] dicomPtJF(Point2D p) {
        return new Float[]{new Float((float)p.getX()), new Float((float)p.getY())};
    }

    private static Long[] dicomPtJL(Point2D p) {
        return new Long[]{new Long((long)p.getX()), new Long((long)p.getY())};
    }

    private static void fillRefImageSequence(DicomData dd, List<XpCPI.GSPSFrame> l, boolean isMultiFrame) {
        for (int j = 0; j < l.size(); ++j) {
            XpCPI.GSPSFrame frame = l.get(j);
            DicomData imgItem = new DicomData();
            imgItem.setValue(8, 4432, frame.SOPClassUID);
            imgItem.setValue(8, 4437, frame.SOPInstanceUID);
            if (isMultiFrame) {
                imgItem.setValue(8, 4448, "" + frame.ReferencedFrameNum);
            }
            dd.setValue(8, 4416, j, imgItem);
        }
    }

    private static String getGrxUnits(byte csystem) {
        if (csystem == 3) {
            return "DISPLAY";
        }
        return "PIXEL";
    }

    private static boolean isMultiFrame(XpMedicalImage[] imgs) {
        boolean multiFrame = false;
        int len = imgs.length;
        if (len > 1) {
            XpMedicalImage mi1 = imgs[0];
            XpMedicalImage mi2 = imgs[1];
            mi1.getValue(sopUID);
            String sopuid1 = "" + XpDMgsps.sopUID.value;
            mi2.getValue(sopUID);
            String sopuid2 = "" + XpDMgsps.sopUID.value;
            if (sopuid1.equals(sopuid2)) {
                multiFrame = true;
            }
        }
        return multiFrame;
    }

    private void fillPresentationState(XpMedicalImage[] imgs, XpCPI cpi, DMObject refObject) {
        double degangle;
        XpCPI.GraphicAnnotation ga;
        int res;
        Object obj;
        if (cpi == null) {
            return;
        }
        Point2D.Double temp = new Point2D.Double();
        boolean multiFrame = XpDMgsps.isMultiFrame(imgs);
        XpMedicalImage src = imgs[0];
        DicomData refImgItem = new DicomData();
        for (int j = 0; j < imgs.length; ++j) {
            DicomData imgItem = new DicomData();
            imgs[j].getValue(sopUID);
            imgs[j].getValue(sopCUID);
            imgItem.setValue(8, 4432, XpDMgsps.sopCUID.value);
            imgItem.setValue(8, 4437, XpDMgsps.sopUID.value);
            if (multiFrame) {
                imgItem.setValue(8, 4448, "" + j);
            }
            refImgItem.setValue(8, 4416, j, imgItem);
        }
        if (refObject == null) {
            src.getValue(seriesInstUID);
            obj = XpDMgsps.seriesInstUID.value;
        } else {
            obj = refObject.getValue(XpDMgsps.seriesInstUID.group, XpDMgsps.seriesInstUID.element);
        }
        refImgItem.setValue(32, 14, obj);
        this.setValue(8, 4373, refImgItem);
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int cnt = 0;
        for (int k = 0; k < imgs.length && (res = imgs[k].getValue(imageNo)) == 0; ++k) {
            ++cnt;
            int val = 0;
            String intStr = ("" + XpDMgsps.imageNo.value).trim();
            if (intStr.length() > 0) {
                val = Integer.parseInt(intStr);
            }
            if (val < min) {
                min = val;
            }
            if (val <= max) continue;
            max = val;
        }
        String psDescription = "";
        if (src.getValue(seriesNo) == 0) {
            psDescription = psDescription + "SE " + XpDMgsps.seriesNo.value + " ";
        }
        if (cnt == imgs.length) {
            psDescription = psDescription + "IM " + min + " TO " + max;
        }
        this.setValue(112, 129, psDescription);
        boolean disablePPS = false;
        int res2 = src.getValue(this.ppsInfo);
        if (res2 == 0) {
            Object value = this.ppsInfo.value;
            if (value != null && value instanceof DMiSequence) {
                DMiSequence rscs = (DMiSequence)this.ppsInfo.value;
                DMiSeqItem item = rscs.getItem(0);
                String str = (String)item.getValue(new DMTag(8, 4437));
                if (str == null || str.length() == 0) {
                    disablePPS = true;
                }
            } else {
                disablePPS = true;
            }
        }
        if (debug) {
            XpLog.logger().info("** disablePPS = " + disablePPS);
        }
        if (!disablePPS) {
            String newSeriesUID = (String)this.dmc.getValue(32, 14);
            DicomData seqObj = new DicomData();
            seqObj.setValue(8, 4432, "1.2.840.10008.3.1.2.3.3");
            if (debug) {
                XpLog.logger().info("XpDMgsps: Setting ppsUID to ====" + newSeriesUID);
            }
            seqObj.setValue(8, 4437, newSeriesUID);
            this.setValue(8, 4369, seqObj);
            Number seriesNumber = (Number)this.dmc.getValue(32, 17);
            String ppsID = seriesNumber == null ? "" : "" + seriesNumber;
            this.setValue(64, 595, ppsID);
            this.setValue(64, 597, "");
            Date ppsDate = new Date();
            this.setDateValue(64, 580, ppsDate);
            this.setTimeValue(64, 581, ppsDate);
        }
        List daList = cpi.getDisplayedArea();
        for (int i = 0; i < daList.size(); ++i) {
            XpCPI.DisplayedArea da = (XpCPI.DisplayedArea)daList.get(i);
            List l = da.refImgSequence;
            DicomData daItem = new DicomData();
            XpDMgsps.fillRefImageSequence(daItem, l, multiFrame);
            if (debug) {
                XpLog.logger().info("WRITE GSPS: tl=" + da.tlDisplay + "   br=" + da.brDisplay);
            }
            daItem.setValue(112, 82, XpDMgsps.dicomPtJL(da.tlDisplay));
            daItem.setValue(112, 83, XpDMgsps.dicomPtJL(da.brDisplay));
            daItem.setValue(112, 256, da.presSize);
            daItem.setValue(112, 257, XpDMgsps.dicomPtDS(da.presPixelSpacing));
            if (da.presPixelAspectRatio.getX() != 0.0 || da.presPixelAspectRatio.getY() != 0.0) {
                daItem.setValue(112, 258, XpDMgsps.dicomPtIS(da.presPixelAspectRatio));
            }
            daItem.setValue(112, 259, new Float(da.pixelMagnificationRatio));
            this.setValue(112, 90, i, daItem);
        }
        List gaList = cpi.getGraphicAnnotation();
        for (int i = 0; i < gaList.size(); ++i) {
            ga = (XpCPI.GraphicAnnotation)gaList.get(i);
            List l = ga.refImgSequence;
            DicomData gaItem = new DicomData();
            XpDMgsps.fillRefImageSequence(gaItem, l, multiFrame);
            gaItem.setValue(112, 2, ga.grxLayer.layerDescription);
            List textSeq = ga.textSequence;
            for (int j = 0; j < textSeq.size(); ++j) {
                String value;
                XpCPI.TextObject to = (XpCPI.TextObject)textSeq.get(j);
                DicomData textItem = new DicomData();
                textItem.setValue(112, 3, XpDMgsps.getGrxUnits(to.bboxUnits));
                textItem.setValue(112, 4, XpDMgsps.getGrxUnits(to.anchorUnits));
                textItem.setValue(112, 6, to.textValue);
                double x = to.boundingBox.getX();
                double y = to.boundingBox.getY();
                double w = to.boundingBox.getWidth();
                double h = to.boundingBox.getHeight();
                ((Point2D)temp).setLocation(x, y);
                textItem.setValue(112, 16, XpDMgsps.dicomPtJF(temp));
                ((Point2D)temp).setLocation(x + w, y + h);
                textItem.setValue(112, 17, XpDMgsps.dicomPtJF(temp));
                textItem.setValue(112, 18, to.bboxJustification);
                textItem.setValue(112, 20, XpDMgsps.dicomPtJF(to.anchorPoint));
                String string = value = to.anchorVisibility ? "Y" : "N";
                if (debug) {
                    XpLog.logger().info("GSPS: Anchor visibility -- " + value + "  [" + to.anchorVisibility + "]");
                }
                textItem.setValue(112, 21, value);
                gaItem.setValue(112, 8, j, textItem);
            }
            List goSeq = ga.graphicSequence;
            for (int j = 0; j < goSeq.size(); ++j) {
                XpCPI.GraphicObject go = (XpCPI.GraphicObject)goSeq.get(j);
                DicomData goItem = new DicomData();
                goItem.setValue(112, 5, XpDMgsps.getGrxUnits(go.graphicUnits));
                goItem.setValue(112, 32, "" + go.graphicDim);
                goItem.setValue(112, 33, "" + go.graphicData.size());
                int len = go.graphicData.size();
                Float[] fdata = new Float[2 * len];
                for (int k = 0; k < len; ++k) {
                    Point2D p = (Point2D)go.graphicData.get(k);
                    fdata[2 * k] = new Float(p.getX());
                    fdata[2 * k + 1] = new Float(p.getY());
                }
                goItem.setValue(112, 34, fdata);
                goItem.setValue(112, 35, go.graphicType);
                String val = go.filled ? "Y" : "N";
                goItem.setValue(112, 36, val);
                gaItem.setValue(112, 9, j, goItem);
            }
            this.setValue(112, 1, i, gaItem);
        }
        int size = gaList.size();
        if (size > 0 && (ga = (XpCPI.GraphicAnnotation)gaList.get(0)) != null) {
            DicomData graphicLayer = new DicomData();
            graphicLayer.setValue(112, 2, ga.grxLayer.layerDescription);
            graphicLayer.setValue(112, 98, "1");
            graphicLayer.setValue(112, 102, "65535");
            Integer[] vals = new Integer[]{new Integer(65535), new Integer(65535), new Integer(65535)};
            graphicLayer.setValue(112, 103, vals);
            graphicLayer.setValue(112, 104, "GEHC Graphic Layer Module");
            this.setValue(112, 96, 0, graphicLayer);
        }
        XpCPI.SpatialTransformation st = cpi.getSpatialTransformation();
        for (degangle = Math.toDegrees(st.angle); degangle < 0.0; degangle += 360.0) {
        }
        int div = (int)(degangle / 90.0);
        int angle = (div %= 4) * 90;
        if (angle != 0 || st.flipHorizontal) {
            this.setValue(112, 66, "" + angle);
            String val = st.flipHorizontal ? "Y" : "N";
            this.setValue(112, 65, val);
            if (debug) {
                XpLog.logger().info("WRITE GSPS: Saving angle=" + angle + "  flip=" + val);
            }
        }
        List softList = cpi.getSoftcopyVoiLut();
        for (int i = 0; i < softList.size(); ++i) {
            XpCPI.SoftcopyVoiLut sa = (XpCPI.SoftcopyVoiLut)softList.get(i);
            List l = sa.refImgSequence;
            DicomData soItem = new DicomData();
            XpDMgsps.fillRefImageSequence(soItem, l, multiFrame);
            if (debug) {
                XpLog.logger().info("WRITE GSPS: ww/wl: (" + sa.windowWidth + "," + sa.windowCenter + ")");
            }
            soItem.setValue(40, 4176, "" + sa.windowCenter);
            soItem.setValue(40, 4177, "" + sa.windowWidth);
            soItem.setValue(40, 4181, "" + sa.wwwlExplanation);
            this.setValue(40, 12560, i, soItem);
        }
        XpCPI.SoftcopyPresentationLut spl = cpi.getSoftcopyPresentationLut();
        if (spl.lutData != null) {
            DicomData plutItem = new DicomData();
            if (debug) {
                XpLog.logger().info("Saving Presentation LUT: " + spl.lutExplanation + "  [" + spl.lutData.length + "]");
            }
            plutItem.setValue(40, 12290, spl.lutDescriptor);
            plutItem.setValue(40, 12291, spl.lutExplanation);
            plutItem.setValue(40, 12294, spl.lutData);
            this.setValue(8272, 16, 0, plutItem);
        }
        this.setValue(8272, 32, spl.pLutShape);
        XpCPI.DisplayShutter ds = cpi.getDisplayShutter(0);
        if (ds == null) {
            ds = cpi.getDisplayShutter(1);
        }
        if (ds != null) {
            this.setValue(24, 5632, ds.shutterShape);
            if (ds.shutterShape.equals("RECTANGULAR")) {
                this.setValue(24, 5634, "" + (int)ds.rectULPoint.getX());
                this.setValue(24, 5636, "" + (int)ds.rectBRPoint.getX());
                this.setValue(24, 5638, "" + (int)ds.rectULPoint.getY());
                this.setValue(24, 5640, "" + (int)ds.rectBRPoint.getY());
            } else if (ds.shutterShape.equals("CIRCULAR")) {
                this.setValue(24, 5648, XpDMgsps.dicomPtIS(ds.circularCenter));
                this.setValue(24, 5650, "" + (int)ds.circularRadius);
            } else if (ds.shutterShape.equals("POLYGONAL")) {
                List l = ds.polygonalVertices;
                int len = l.size();
                String[] idata = new String[len * 2];
                for (int i = 0; i < len; ++i) {
                    Point2D p = (Point2D)l.get(i);
                    idata[2 * i] = "" + (int)p.getY();
                    idata[2 * i + 1] = "" + (int)p.getX();
                }
                this.setValue(24, 5664, idata);
            }
            this.setValue(24, 5666, "" + ds.shutterPValue);
        }
    }

    public static int getGSPSSeriesNo(XpDicomObject refImage) {
        refImage.getValue(seriesNo);
        int gspsSeriesNo = Integer.parseInt((String)XpDMgsps.seriesNo.value) + 100000;
        return gspsSeriesNo;
    }

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        if (args.length == 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "file";
            stringArray = stringArray2;
            stringArray2[1] = "D:/data/test/i18n/Japanese2/i147503.NMDC.62102";
        } else {
            stringArray = args;
        }
        String[] sargs = stringArray;
        String msg = "Creating DMSession with args:";
        for (int i = 0; i < sargs.length; ++i) {
            msg = msg + " \"" + sargs[i] + "\"";
        }
        System.out.println(msg);
        DMSession dms = new DMSession(sargs);
        DMObject[] studies = dms.getRelated("study");
        int nStudies = studies.length;
        System.out.println("Found " + nStudies + " stud" + (nStudies == 1 ? "y" : "ies"));
        DMTag[] dmTags = null;
        if (nStudies > 0) {
            DMObject[][] series = new DMObject[nStudies][];
            for (int examNo = 0; examNo < nStudies; ++examNo) {
                series[examNo] = studies[examNo].getRelated("series");
                int ns = series[examNo].length;
                for (int seriesNo = 0; seriesNo < ns; ++seriesNo) {
                    DMObject main = series[examNo][seriesNo];
                    DMImage[] dmimgs = main.getImages(dmTags);
                    int nImages = dmimgs.length;
                    XpMedicalImage[] mdi = new XpMedicalImage[nImages];
                    for (int i = 0; i < nImages; ++i) {
                        mdi[i] = new XpMedicalDmImage(dmimgs[i]);
                    }
                    System.out.println("DMSession: Loading study/series: " + examNo + "/" + seriesNo + "   [" + mdi.length + " image" + (mdi.length == 1 ? "]" : "s]"));
                    XpImageViewport xpiv = new XpImageViewport();
                    xpiv.setPreferredSize(new Dimension(512, 512));
                    xpiv.setImages(mdi);
                    DicomData data = new DicomData();
                    data.read(xpiv.getGSPS());
                    data.printDebugInfo(System.out);
                }
            }
        }
    }

    private static class GSPSDicomObject
    implements XjDicomObject {
        private XpDicomObject ref;

        public GSPSDicomObject(XpDicomObject src) {
            this.ref = src;
        }

        public Object getValue(int group, int element) {
            XpDicomElement value = new XpDicomElement(group, element);
            this.ref.getValue(value);
            return value.value;
        }

        public int getValues(XjTagValue[] tvs) {
            int counter = 0;
            for (int i = 0; i < tvs.length; ++i) {
                tvs[i].value = this.getValue(tvs[i].group, tvs[i].element);
                if (null == tvs[i].value) continue;
                ++counter;
            }
            return counter;
        }
    }
}

