/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.platform.dm;

import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.autoviewer.XpAutoViewport;
import com.ge.med.terra.jami.autoviewer.XpAvTimer;
import com.ge.med.terra.jami.autoviewer.XpMedicalImageFilter;
import com.ge.med.terra.jami.autoviewer.XpMedicalImageListener;
import com.ge.med.terra.jami.autoviewer.XpRTImageProvider;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class DMAutoViewerDemo
extends JPanel {
    private XpAutoViewport av = new XpAutoViewport(100);
    private XpRTImageProvider rtip = null;
    private JPanel imagePanel = new JPanel();
    private JPanel controlPanel = new JPanel();
    private JButton backButton = new JButton();
    private JButton forwardButton = new JButton();
    private JButton sortButton = new JButton();
    private JButton filterButton = new JButton();
    private JButton installButton = new JButton();
    private JButton exitButton = new JButton();
    private boolean filterEnabled = false;
    private XpMedicalImageFilter miFilter = new XpMedicalImageFilter(){

        public boolean filter(XpMedicalImage mi) {
            boolean ret = mi.getDefaultWindowLevel() > 500.0;
            return ret;
        }
    };
    private Comparator miComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (((XpMedicalImage)o1).getDefaultWindowLevel() < ((XpMedicalImage)o2).getDefaultWindowLevel()) {
                return -1;
            }
            if (((XpMedicalImage)o1).getDefaultWindowLevel() > ((XpMedicalImage)o2).getDefaultWindowLevel()) {
                return 1;
            }
            return 0;
        }
    };
    private int index = 0;
    private String sourcePath = "";
    private XpAvTimer avTimer = null;

    public DMAutoViewerDemo(String path) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sourcePath = path;
        this.rtip = new XpRTImageProvider("tap", new String[]{"file", this.sourcePath});
        this.rtip.addMedicalImageListener((XpMedicalImageListener)this.av);
        this.add((Component)this.av);
        this.av.enableAutoWWWL(true);
        this.avTimer = new XpAvTimer(200, this.av, this.rtip);
        this.avTimer.start();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("AutoViewer Demo");
        String loadPath = null;
        if (args.length > 0) {
            loadPath = args[0];
        }
        DMAutoViewerDemo sid = new DMAutoViewerDemo(loadPath);
        frame.setBounds(100, 100, 512, 512);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(sid);
        frame.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.imagePanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.backButton.setText("Previous");
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DMAutoViewerDemo.this.backButton_actionPerformed(e);
            }
        });
        this.forwardButton.setText("Next");
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DMAutoViewerDemo.this.forwardButton_actionPerformed(e);
            }
        });
        this.sortButton.setText("Sort");
        this.sortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DMAutoViewerDemo.this.sortButton_actionPerformed(e);
            }
        });
        this.filterButton.setText("Enable Filter");
        this.filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DMAutoViewerDemo.this.filterButton_actionPerformed(e);
            }
        });
        this.installButton.setText("Install");
        this.installButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DMAutoViewerDemo.this.installButton_actionPerformed(e);
            }
        });
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DMAutoViewerDemo.this.exitButton_actionPerformed(e);
            }
        });
        this.add((Component)this.imagePanel, "Center");
        this.imagePanel.add((Component)this.av, "Center");
        this.controlPanel.add((Component)this.backButton, null);
        this.controlPanel.add((Component)this.forwardButton, null);
        this.controlPanel.add((Component)this.sortButton, null);
        this.controlPanel.add((Component)this.filterButton, null);
        this.controlPanel.add((Component)this.exitButton, null);
        this.controlPanel.add((Component)this.installButton, null);
        this.add((Component)this.controlPanel, "South");
    }

    private void backButton_actionPerformed(ActionEvent e) {
        this.av.backward();
    }

    private void forwardButton_actionPerformed(ActionEvent e) {
        this.av.forward();
    }

    private void sortButton_actionPerformed(ActionEvent e) {
        this.av.sortImages(this.miComparator);
    }

    private void filterButton_actionPerformed(ActionEvent e) {
        boolean bl = this.filterEnabled = !this.filterEnabled;
        if (this.filterEnabled) {
            this.av.enableFilter(this.miFilter);
            this.filterButton.setText("Disable Filter");
        } else {
            this.av.disableFilter();
            this.filterButton.setText("Enable Filter");
        }
    }

    private void exitButton_actionPerformed(ActionEvent e) {
        this.avTimer.stopRunning();
        this.avTimer.print();
        System.exit(0);
    }

    private void installButton_actionPerformed(ActionEvent e) {
        DMSession src_session = new DMSession(new String[]{"file", this.sourcePath});
        DMObject[] dmo_array = src_session.getChildren();
        DMSession dst_session = new DMSession(new String[]{"file", this.sourcePath});
        AutoLoad al = new AutoLoad(dmo_array[0], dst_session);
        al.start();
    }

    class AutoLoad
    extends Timer {
        DMObject[] dmo_array;
        DMSession dst_session;
        int count;
        long lasttime;

        public AutoLoad(DMObject dmo, DMSession ses) {
            super(30, null);
            this.count = 0;
            this.lasttime = 0L;
            int delay = 30;
            String strDelay = System.getProperty("ImageDelay");
            if (strDelay != null) {
                delay = Integer.parseInt(strDelay);
            }
            this.setDelay(delay);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    long time;
                    AutoLoad.this.lasttime = time = System.currentTimeMillis();
                    AutoLoad.this.sendOne();
                }
            });
            this.dmo_array = dmo.getRelated("Study")[0].getRelated("series")[0].getRelated("Image");
            this.dst_session = ses;
        }

        public void sendOne() {
            try {
                this.dst_session.install(this.dmo_array[this.count].getComposites()[0].getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++this.count;
            if (this.count >= this.dmo_array.length) {
                this.stop();
            }
        }
    }
}

