/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.XjMemVolume;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CTransform;
import java.util.StringTokenizer;

public class XjVolumeUtils {
    public static final double ZERO = 1.0E-10;

    public static double calculateTilt(XjVolumeGeometry vol) {
        double[] dir_x = vol.getXDirectionRAS(null);
        double[] dir_y = vol.getYDirectionRAS(null);
        double[] dir_z = vol.getZDirectionRAS(null);
        int[] dims = vol.getVolumeDimensions(null);
        double tilt = 0.0;
        double ras_spx = JnVector3d.length(dir_x);
        double ras_spy = JnVector3d.length(dir_y);
        double ras_spz = JnVector3d.length(dir_z);
        double ras_dx = ras_spx * (double)dims[0];
        double ras_dy = ras_spy * (double)dims[1];
        double ras_dz = ras_spz * (double)dims[2];
        if (ras_dx > 0.0 && ras_dy > 0.0 && ras_dz > 0.0) {
            double ang = Math.asin(JnVector3d.cross(dir_y, dir_z).length() / (ras_spy * ras_spz)) - 1.5707963267948966;
            tilt = Math.toDegrees(ang);
        }
        if (Math.abs(tilt) < 0.1) {
            tilt = 0.0;
        }
        return tilt;
    }

    public static double getViewStepSize(CTransform jn_ras2vox, JnVector3d v, double ras_spx, double ras_spy, double ras_spz) {
        double[] zero_tx = new double[]{0.0, 0.0, 0.0};
        double[] view = new double[]{v.x, v.y, v.z};
        jn_ras2vox.transform(view);
        jn_ras2vox.transform(zero_tx);
        JnVector3d.sub(view, zero_tx, view);
        JnVector3d.normalize(view);
        double x = Math.abs(view[0]);
        double y = Math.abs(view[1]);
        double z = Math.abs(view[2]);
        double stepSize = Math.min(ras_spx, ras_spz);
        if (x < 1.0E-10 && y < 1.0E-10) {
            stepSize = ras_spz;
        } else if (x < 1.0E-10 && z < 1.0E-10) {
            stepSize = ras_spy;
        } else if (y < 1.0E-10 && z < 1.0E-10) {
            stepSize = ras_spx;
        }
        return stepSize;
    }

    public static void calculateVoxelRASTransform(XjVolumeGeometry xj_vol, JnMatrix4d vox2ras, JnMatrix4d ras2vox) {
        double[] vol_origin = new double[3];
        double[] dir_x = new double[3];
        double[] dir_y = new double[3];
        double[] dir_z = new double[3];
        XjVolumeUtils.getVolGeometry(xj_vol, vol_origin, dir_x, dir_y, dir_z);
        vox2ras.set(dir_x[0], dir_y[0], dir_z[0], vol_origin[0], dir_x[1], dir_y[1], dir_z[1], vol_origin[1], dir_x[2], dir_y[2], dir_z[2], vol_origin[2], 0.0, 0.0, 0.0, 1.0);
        ras2vox.invert(vox2ras);
    }

    public static void calculateVoxelRASTransform(XjVolumeGeometry xj_vol, CTransform vox2ras, CTransform ras2vox) {
        double[] vol_origin = new double[3];
        double[] dir_x = new double[3];
        double[] dir_y = new double[3];
        double[] dir_z = new double[3];
        XjVolumeUtils.getVolGeometry(xj_vol, vol_origin, dir_x, dir_y, dir_z);
        vox2ras.set(dir_x[0], dir_y[0], dir_z[0], vol_origin[0], dir_x[1], dir_y[1], dir_z[1], vol_origin[1], dir_x[2], dir_y[2], dir_z[2], vol_origin[2], 0.0, 0.0, 0.0, 1.0);
        vox2ras.inverse(ras2vox);
    }

    private static void getVolGeometry(XjVolumeGeometry xj_vol, double[] vol_origin, double[] dir_x, double[] dir_y, double[] dir_z) {
        xj_vol.getRASOfOrigin(vol_origin);
        xj_vol.getXDirectionRAS(dir_x);
        xj_vol.getYDirectionRAS(dir_y);
        xj_vol.getZDirectionRAS(dir_z);
        vol_origin[0] = vol_origin[0] - dir_x[0] * 0.5 - dir_y[0] * 0.5;
        vol_origin[1] = vol_origin[1] - dir_x[1] * 0.5 - dir_y[1] * 0.5;
        vol_origin[2] = vol_origin[2] - dir_x[2] * 0.5 - dir_y[2] * 0.5;
    }

    public static boolean isInVolume(XjVolumeGeometry xj_vol, double[] ras) {
        JnMatrix4d ras2vox = new JnMatrix4d();
        JnMatrix4d vox2ras = new JnMatrix4d();
        XjVolumeUtils.calculateVoxelRASTransform(xj_vol, vox2ras, ras2vox);
        double[] pt = new double[]{ras[0], ras[1], ras[2]};
        int[] dims = xj_vol.getVolumeDimensions(null);
        ras2vox.transform(pt);
        return pt[0] > 0.0 && pt[0] < (double)(dims[0] - 1) && pt[1] > 0.0 && pt[1] < (double)(dims[1] - 1) && pt[2] > 0.0 && pt[2] < (double)(dims[2] - 1);
    }

    public static double calcVolumeRescaleSlope(XjVolumeInfo vol) {
        double rs = 1.0;
        String modality = "" + vol.getValue(8, 96);
        if (modality.equals("PT")) {
            int[] dims = vol.getVolumeDimensions(null);
            int dz = dims[2];
            for (int i = 0; i < dz; ++i) {
                Object o = vol.getVSliceValue(i, 40, 4179);
                double d = 1.0;
                d = o instanceof String ? Double.parseDouble((String)o) : ((Number)o).doubleValue();
                if (i == 0) {
                    rs = d;
                    continue;
                }
                if (!(rs < d)) continue;
                rs = d;
            }
        } else {
            Object o = vol.getValue(40, 4179);
            double d = 1.0;
            if (o instanceof String) {
                d = Double.parseDouble((String)o);
            } else if (o instanceof Number) {
                d = ((Number)o).doubleValue();
            }
            rs = d;
        }
        return rs;
    }

    public static double calcVolumeRescaleIntercept(XjVolumeInfo vol) {
        double rescaleIntercept = 0.0;
        Object obj = vol.getValue(40, 4178);
        if (obj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)obj, "\\");
            rescaleIntercept = Double.parseDouble(st.nextToken());
        } else if (obj instanceof Number) {
            rescaleIntercept = ((Number)obj).doubleValue();
        }
        return rescaleIntercept;
    }

    public static double calcVolumeDefWW(XjVolumeInfo vol) {
        double ww = 0.0;
        Object obj = vol.getValue(40, 4177);
        if (obj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)obj, "\\");
            ww = Double.parseDouble(st.nextToken());
        } else if (obj instanceof Number) {
            ww = ((Number)obj).doubleValue();
        }
        return ww;
    }

    public static double calcVolumeDefWL(XjVolumeInfo vol) {
        double wl = 0.0;
        Object obj = vol.getValue(40, 4176);
        if (obj instanceof String) {
            StringTokenizer st = new StringTokenizer((String)obj, "\\");
            wl = Double.parseDouble(st.nextToken());
        } else if (obj instanceof Number) {
            wl = ((Number)obj).doubleValue();
        }
        return wl;
    }

    public static XjMemVolume createVolume(XjVolumeInfo vol_info, short[] data, int offset, int pixelType) {
        return new XjShortLinearVolume(vol_info, data, offset, pixelType);
    }

    public static XjMemVolume createVolume(short[] data, int offset, int pixelType, int[] dims, double[] spacing) {
        return new XjShortSimpleVolume(data, offset, pixelType, dims, spacing);
    }

    public static XjMemVolume createVolume(short[] data, int offset, int pixelType, int bpp, int[] dims, double[] spacing, double[] origin, double[] xdir, double[] ydir, double[] zdir) {
        return new XjShortSimpleVolume(data, offset, pixelType, bpp, dims, spacing, origin, xdir, ydir, zdir);
    }

    private static class XjShortUpsampledVolume2X
    implements XjMemVolume {
        private short[] data = null;
        private int offset;
        private XjVolumeInfo volInfo = null;

        public XjShortUpsampledVolume2X(XjVolumeInfo volInfo, short[] data, int offset) {
            this.volInfo = volInfo;
            this.offset = offset;
            this.data = data;
        }

        public Object getSliceData(int sliceNo) {
            return this.data;
        }

        public int getSliceOffset(int sliceNo) {
            int[] dims = this.getVolumeDimensions(null);
            int pgsize = dims[0] * dims[1];
            return this.offset + sliceNo * pgsize;
        }

        public boolean isContiguous() {
            return true;
        }

        public int getBitsPerVoxel() {
            return this.volInfo.getBitsPerVoxel();
        }

        public int getPixelType() {
            return this.volInfo.getPixelType();
        }

        public String getRelatedComposite() {
            return this.volInfo.getRelatedComposite();
        }

        public Object getVSliceValue(int sliceNo, int group, int element) {
            return this.volInfo.getVSliceValue(0, group, element);
        }

        public Object getValue(int group, int element) {
            return this.volInfo.getValue(group, element);
        }

        public int getValues(XjTagValue[] tv) {
            return this.volInfo.getValues(tv);
        }

        public double[] getRASOfOrigin(double[] ras_ulc) {
            double[] v = this.volInfo.getRASOfOrigin(ras_ulc);
            double[] xdir_original = this.volInfo.getXDirectionRAS(null);
            double[] ydir_original = this.volInfo.getYDirectionRAS(null);
            v[0] = v[0] - xdir_original[0] * 0.25 - ydir_original[0] * 0.25;
            v[1] = v[1] - xdir_original[1] * 0.25 - ydir_original[1] * 0.25;
            v[2] = v[2] - xdir_original[2] * 0.25 - ydir_original[2] * 0.25;
            return v;
        }

        public int[] getVolumeDimensions(int[] dims) {
            int[] v = this.volInfo.getVolumeDimensions(dims);
            v[0] = v[0] * 2;
            v[1] = v[1] * 2;
            v[2] = v[2] * 2 - 1;
            return v;
        }

        public double[] getXDirectionRAS(double[] ras_dx) {
            double[] v = this.volInfo.getXDirectionRAS(ras_dx);
            v[0] = v[0] * 0.5;
            v[1] = v[1] * 0.5;
            v[2] = v[2] * 0.5;
            return v;
        }

        public double[] getYDirectionRAS(double[] ras_dy) {
            double[] v = this.volInfo.getYDirectionRAS(ras_dy);
            v[0] = v[0] * 0.5;
            v[1] = v[1] * 0.5;
            v[2] = v[2] * 0.5;
            return v;
        }

        public double[] getZDirectionRAS(double[] ras_dz) {
            double[] v = this.volInfo.getZDirectionRAS(ras_dz);
            v[0] = v[0] * 0.5;
            v[1] = v[1] * 0.5;
            v[2] = v[2] * 0.5;
            return v;
        }
    }

    private static class XjShortSimpleVolume
    implements XjMemVolume {
        private short[] data = null;
        private int offset = 0;
        private int pixelType = 0;
        private int bpp = 16;
        private int[] dims = new int[3];
        private double[] spacing = new double[3];
        private double[] origin = new double[3];
        private double[] xdir = new double[3];
        private double[] ydir = new double[3];
        private double[] zdir = new double[3];

        public XjShortSimpleVolume(short[] data, int offset, int pixelType, int[] dims, double[] spacing) {
            this.offset = offset;
            this.data = data;
            this.pixelType = pixelType;
            System.arraycopy(spacing, 0, this.spacing, 0, 3);
            System.arraycopy(dims, 0, this.dims, 0, 3);
            this.origin[0] = spacing[0] * 0.5;
            this.origin[1] = spacing[1] * 0.5;
            this.origin[2] = 0.0;
            this.xdir[0] = spacing[0];
            this.xdir[1] = 0.0;
            this.xdir[2] = 0.0;
            this.ydir[0] = 0.0;
            this.ydir[1] = spacing[1];
            this.ydir[2] = 0.0;
            this.zdir[0] = 0.0;
            this.zdir[1] = 0.0;
            this.zdir[2] = spacing[2];
        }

        public XjShortSimpleVolume(short[] data, int offset, int pixelType, int bpp, int[] dims, double[] spacing, double[] origin, double[] xdir, double[] ydir, double[] zdir) {
            this.offset = offset;
            this.data = data;
            this.pixelType = pixelType;
            System.arraycopy(spacing, 0, this.spacing, 0, 3);
            System.arraycopy(dims, 0, this.dims, 0, 3);
            this.bpp = bpp;
            this.origin[0] = origin[0];
            this.origin[1] = origin[1];
            this.origin[2] = origin[2];
            this.xdir[0] = xdir[0];
            this.xdir[1] = xdir[1];
            this.xdir[2] = xdir[2];
            this.ydir[0] = ydir[0];
            this.ydir[1] = ydir[1];
            this.ydir[2] = ydir[2];
            this.zdir[0] = zdir[0];
            this.zdir[1] = zdir[1];
            this.zdir[2] = zdir[2];
        }

        public String getRelatedComposite() {
            return null;
        }

        public Object getVSliceValue(int sliceNo, int group, int element) {
            return this.getValue(group, element);
        }

        public Object getValue(int group, int element) {
            if (group == 24 && element == 4384) {
                return null;
            }
            if (group == 40 && element == 4176) {
                return new Double(400.0);
            }
            if (group == 40 && element == 4177) {
                return new Double(800.0);
            }
            if (group == 40 && element == 4178) {
                return new Double(0.0);
            }
            if (group == 40 && element == 4179) {
                return new Double(1.0);
            }
            Object value = "XXXXX";
            switch (group) {
                case 8: {
                    if (element == 32) {
                        value = "2/14/2009";
                        break;
                    }
                    if (element == 34) {
                        value = "2/14/2009";
                        break;
                    }
                    if (element == 48) {
                        value = "9:01:24";
                        break;
                    }
                    if (element == 50) {
                        value = "9:05:47";
                        break;
                    }
                    if (element == 96) {
                        value = "CS";
                        break;
                    }
                    if (element == 112) {
                        value = "GE Power Tools";
                        break;
                    }
                    if (element == 128) {
                        value = "Jami Hospital";
                        break;
                    }
                    if (element == 4112) {
                        value = "Device Model";
                        break;
                    }
                    if (element == 4144) {
                        value = "Scan Job";
                        break;
                    }
                    if (element != 4240) break;
                    value = "Imager 2000";
                    break;
                }
                case 16: {
                    if (element == 16) {
                        value = "Joe Test";
                        break;
                    }
                    if (element == 32) {
                        value = "12345";
                        break;
                    }
                    if (element == 48) {
                        value = "5/20/1956";
                        break;
                    }
                    if (element == 64) {
                        value = "M";
                        break;
                    }
                    if (element == 4112) {
                        value = "32";
                        break;
                    }
                    if (element != 4144) break;
                    value = "190";
                    break;
                }
                case 32: {
                    if (element == 16) {
                        value = "88";
                        break;
                    }
                    if (element == 17) {
                        value = "1";
                        break;
                    }
                    if (element != 19) break;
                    value = "1";
                    break;
                }
                case 40: {
                    if (element == 16) {
                        value = "" + this.dims[0];
                        break;
                    }
                    if (element == 17) {
                        value = "" + this.dims[1];
                        break;
                    }
                    if (element != 259) break;
                    value = 0;
                }
            }
            return value;
        }

        public int getValues(XjTagValue[] tv) {
            for (int i = 0; i < tv.length; ++i) {
                tv[i].value = this.getValue(tv[i].group, tv[i].element);
            }
            return tv.length;
        }

        public double[] getRASOfOrigin(double[] ras_ulc) {
            double[] v = ras_ulc;
            if (v == null) {
                v = new double[]{this.origin[0], this.origin[1], this.origin[2]};
            }
            return v;
        }

        public int[] getVolumeDimensions(int[] dims) {
            int[] v = dims;
            if (v == null) {
                v = new int[]{this.dims[0], this.dims[1], this.dims[2]};
            }
            return v;
        }

        public double[] getXDirectionRAS(double[] ras_dx) {
            double[] v = ras_dx;
            if (v == null) {
                v = new double[]{this.xdir[0], this.xdir[1], this.xdir[2]};
            }
            return v;
        }

        public double[] getYDirectionRAS(double[] ras_dy) {
            double[] v = ras_dy;
            if (v == null) {
                v = new double[]{this.ydir[0], this.ydir[1], this.ydir[2]};
            }
            return v;
        }

        public double[] getZDirectionRAS(double[] ras_dz) {
            double[] v = ras_dz;
            if (v == null) {
                v = new double[]{this.zdir[0], this.zdir[1], this.zdir[2]};
            }
            return v;
        }

        public Object getSliceData(int sliceNo) {
            return this.data;
        }

        public int getSliceOffset(int sliceNo) {
            int pgsize = this.dims[0] * this.dims[1];
            return this.offset + sliceNo * pgsize;
        }

        public boolean isContiguous() {
            return true;
        }

        public int getBitsPerVoxel() {
            return this.bpp;
        }

        public int getPixelType() {
            return this.pixelType;
        }
    }

    private static class XjShortLinearVolume
    extends XjProxyVolume {
        private short[] data = null;
        private int offset = 0;
        private int pixelType = 0;

        public XjShortLinearVolume(XjVolumeInfo volInfo, short[] data, int offset, int pixelType) {
            super(volInfo);
            this.offset = offset;
            this.data = data;
            this.pixelType = pixelType;
        }

        public Object getSliceData(int sliceNo) {
            return this.data;
        }

        public int getSliceOffset(int sliceNo) {
            int[] dims = this.getVolumeDimensions(null);
            int pgsize = dims[0] * dims[1];
            return this.offset + sliceNo * pgsize;
        }

        public boolean isContiguous() {
            return true;
        }

        public int getBitsPerVoxel() {
            return 16;
        }

        public int getPixelType() {
            return this.pixelType;
        }
    }

    private static abstract class XjProxyVolume
    implements XjMemVolume {
        private XjVolumeInfo volInfo = null;

        public XjProxyVolume(XjVolumeInfo volInfo) {
            this.volInfo = volInfo;
        }

        public String getRelatedComposite() {
            return this.volInfo.getRelatedComposite();
        }

        public Object getVSliceValue(int sliceNo, int group, int element) {
            return this.volInfo.getVSliceValue(sliceNo, group, element);
        }

        public Object getValue(int group, int element) {
            return this.volInfo.getValue(group, element);
        }

        public int getValues(XjTagValue[] tv) {
            return this.volInfo.getValues(tv);
        }

        public double[] getRASOfOrigin(double[] ras_ulc) {
            return this.volInfo.getRASOfOrigin(ras_ulc);
        }

        public int[] getVolumeDimensions(int[] dims) {
            return this.volInfo.getVolumeDimensions(dims);
        }

        public double[] getXDirectionRAS(double[] ras_dx) {
            return this.volInfo.getXDirectionRAS(ras_dx);
        }

        public double[] getYDirectionRAS(double[] ras_dy) {
            return this.volInfo.getYDirectionRAS(ras_dy);
        }

        public double[] getZDirectionRAS(double[] ras_dz) {
            return this.volInfo.getZDirectionRAS(ras_dz);
        }
    }
}

