/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.XjVolume;
import com.ge.med.terra.jami.j3d.OrientationCubeVc;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DControlPanel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.ViewResetAction;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class T3DTester
extends JPanel {
    private T3DComponent t3dComponent = null;
    private T3DViewport vp = null;
    private XjVolume vol = null;
    JTabbedPane ctrl;
    JPanel browsePane;
    T3DControlPanel viewPane = new T3DControlPanel();
    JPanel processingPane;
    JLabel origInfo = new JLabel();
    JLabel xvInfo = new JLabel();
    JLabel yvInfo = new JLabel();
    JLabel zvInfo = new JLabel();
    JTextField eyex = new JTextField();
    JTextField eyey = new JTextField();
    JTextField eyez = new JTextField();
    JTextField lookx = new JTextField();
    JTextField looky = new JTextField();
    JTextField lookz = new JTextField();
    JTextField upx = new JTextField();
    JTextField upy = new JTextField();
    JTextField upz = new JTextField();
    JTextField vcFront = new JTextField();
    JTextField vcBack = new JTextField();
    JTextField vh = new JTextField();
    JTextField asp = new JTextField();
    JTextField seriesPath = new JTextField();

    private void loadVolume(String[] params) {
        if (params != null) {
            DMSession dms = new DMSession(params);
            DMObject[] dmo = dms.getRelated("series");
            this.vol = DMVolume.buildVolume((String)"DMObjectVolume", (Object[])new Object[]{dmo[0]});
            this.vp.setVolume(this.vol);
            this.viewPane.setVolume(this.vol);
        }
    }

    public T3DTester(final String[] params) {
        this.setLayout(new BorderLayout());
        this.vp = new T3DViewport();
        this.t3dComponent = this.vp.getT3DComponent();
        this.vp.setRenderStyle("REFORMAT");
        this.vp.setPreferredSize(new Dimension(512, 512));
        this.vp.getT3DComponent().add(new OrientationCubeVc(this.vp.getT3DComponent()));
        this.add((Component)this.vp, "Before");
        JToolBar tb = new JToolBar();
        ViewResetAction sAction = new ViewResetAction("S");
        ViewResetAction iAction = new ViewResetAction("I");
        ViewResetAction aAction = new ViewResetAction("A");
        ViewResetAction pAction = new ViewResetAction("P");
        ViewResetAction lAction = new ViewResetAction("L");
        ViewResetAction rAction = new ViewResetAction("R");
        sAction.setTarget(this.t3dComponent);
        iAction.setTarget(this.t3dComponent);
        aAction.setTarget(this.t3dComponent);
        pAction.setTarget(this.t3dComponent);
        lAction.setTarget(this.t3dComponent);
        rAction.setTarget(this.t3dComponent);
        JButton sB = new JButton(sAction);
        JButton iB = new JButton(iAction);
        JButton aB = new JButton(aAction);
        JButton pB = new JButton(pAction);
        JButton lB = new JButton(lAction);
        JButton rB = new JButton(rAction);
        tb.add(sB);
        tb.add(iB);
        tb.add(aB);
        tb.add(pB);
        tb.add(lB);
        tb.add(rB);
        tb.addSeparator();
        final JToggleButton ctrlToggle = new JToggleButton("Control", true);
        this.buildControlPanel();
        this.add((Component)this.ctrl, "After");
        ctrlToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                T3DTester.this.ctrl.setVisible(ctrlToggle.isSelected());
            }
        });
        tb.add(ctrlToggle);
        this.add((Component)tb, "First");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                T3DTester.this.loadVolume(params);
            }
        });
    }

    private void buildControlPanel() {
        this.ctrl = new JTabbedPane();
        this.buildBrowsePanel();
        this.ctrl.addTab("File", this.browsePane);
        this.ctrl.addTab("T3D View", this.viewPane);
        this.viewPane.setT3D(this.t3dComponent);
        this.buildSegPanel();
        this.ctrl.addTab("Analyze", this.processingPane);
    }

    private void buildBrowsePanel() {
        this.browsePane = new JPanel(new BorderLayout(10, 10));
        JPanel south = new JPanel(new FlowLayout(2));
        JButton loadDataButton = new JButton("Load Series");
        JButton saveStButton = new JButton("Save State");
        JButton restoreStButton = new JButton("Restore State");
        south.add(loadDataButton);
        south.add(saveStButton);
        south.add(restoreStButton);
        this.browsePane.add((Component)south, "Last");
        final JFileChooser browser = new JFileChooser("/thesource/images");
        browser.setDialogType(1);
        browser.setControlButtonsAreShown(false);
        browser.setPreferredSize(new Dimension(256, 256));
        browser.setDialogTitle("");
        browser.setFileSelectionMode(2);
        this.browsePane.add(browser);
        loadDataButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String path = browser.getSelectedFile().getAbsolutePath();
                File selection = new File(path);
                if (!selection.isDirectory()) {
                    path = path.substring(0, path.indexOf(selection.getName()));
                }
                System.out.println("Loading " + path);
                T3DTester.this.loadVolume(new String[]{"file", path});
            }
        });
        saveStButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InputStream is = T3DTester.this.vp.getT3DState();
                try {
                    FileOutputStream os = new FileOutputStream(browser.getCurrentDirectory().getAbsolutePath() + File.separator + "t3d.xml");
                    byte[] buf = new byte[1024];
                    int n = 0;
                    while ((n = is.read(buf)) > 0) {
                        ((OutputStream)os).write(buf, 0, n);
                    }
                    ((OutputStream)os).close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        restoreStButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    FileInputStream is = new FileInputStream(browser.getSelectedFile());
                    T3DTester.this.vp.setT3DState(is);
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void buildSegPanel() {
        this.processingPane = new JPanel();
        JButton bbox = new JButton("Bounding Box");
        bbox.setEnabled(false);
        this.processingPane.add(bbox);
        bbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("T3D Manual Tester");
        String[] params = null;
        if (args.length > 0) {
            params = new String[]{"file", args[0]};
        }
        T3DTester demo = new T3DTester(params);
        frame.setLocation(0, 0);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(demo);
        frame.pack();
        frame.setVisible(true);
    }
}

