/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.DefaultCursor3DModel;
import com.ge.med.terra.jami.j3d.DefaultSlabLocationRangeModel;
import com.ge.med.terra.jami.j3d.OrientationCubeVc;
import com.ge.med.terra.jami.j3d.RetargetableMouseController;
import com.ge.med.terra.jami.j3d.SlabLocationRangeModel;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DTrackball;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.ViewResetAction;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class T3DScrollController {
    private SlabLocationRangeModel locationModel_;
    private T3DCapable renderer_;
    private Cursor3DModel refPoint_;
    protected PropertyChangeListener orientationChangeListener_;
    private ChangeListener refPointListener_;
    protected ChangeListener locationListener_;

    public T3DScrollController(T3DCapable renderer, SlabLocationRangeModel locationModel, Cursor3DModel refPoint) {
        this.locationModel_ = locationModel;
        this.renderer_ = renderer;
        this.refPoint_ = refPoint;
        if (this.locationModel_ != null && this.refPoint_ != null && this.renderer_ != null) {
            this.locationModel_.addChangeListener(this.getLocationListener());
            this.refPoint_.addChangeListener(this.getReferencePointListener());
            this.renderer_.addPropertyChangeListener("camera", this.getOrientationChangeListener());
        }
    }

    private PropertyChangeListener getOrientationChangeListener() {
        if (this.orientationChangeListener_ == null) {
            this.orientationChangeListener_ = new OrientationChangeListener();
        }
        return this.orientationChangeListener_;
    }

    protected ChangeListener getReferencePointListener() {
        if (this.refPointListener_ == null) {
            this.refPointListener_ = new ReferencePointListener();
        }
        return this.refPointListener_;
    }

    protected ChangeListener getLocationListener() {
        if (this.locationListener_ == null) {
            this.locationListener_ = new LocationListener();
        }
        return this.locationListener_;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JPanel main = new JPanel(new BorderLayout());
        f.setContentPane(main);
        T3DViewport port1 = new T3DViewport();
        port1.setRenderStyle("MIP");
        port1.setPreferredSize(new Dimension(512, 512));
        main.add(port1);
        JSlider locationSlider = new JSlider();
        DMSession dms = new DMSession("file", args == null || args.length == 0 ? "/thesource/images/ThinClient/direct3d" : args[0], null);
        DMVolume xjv = DMVolume.buildVolume((String)"DMObjectVolume", (Object[])new Object[]{dms.getRelated("series")[0]});
        JPanel p = new JPanel();
        p.add(locationSlider);
        ViewResetAction sAction = new ViewResetAction("S");
        ViewResetAction iAction = new ViewResetAction("I");
        ViewResetAction aAction = new ViewResetAction("A");
        ViewResetAction pAction = new ViewResetAction("P");
        ViewResetAction lAction = new ViewResetAction("L");
        ViewResetAction rAction = new ViewResetAction("R");
        JButton sB = new JButton(sAction);
        JButton iB = new JButton(iAction);
        JButton aB = new JButton(aAction);
        JButton pB = new JButton(pAction);
        JButton lB = new JButton(lAction);
        JButton rB = new JButton(rAction);
        sB.setMargin(new Insets(0, 2, 0, 2));
        iB.setMargin(new Insets(0, 2, 0, 2));
        lB.setMargin(new Insets(0, 2, 0, 2));
        rB.setMargin(new Insets(0, 2, 0, 2));
        aB.setMargin(new Insets(0, 2, 0, 2));
        pB.setMargin(new Insets(0, 2, 0, 2));
        p.add(sB);
        p.add(iB);
        p.add(aB);
        p.add(pB);
        p.add(lB);
        p.add(rB);
        main.add((Component)p, "South");
        f.setDefaultCloseOperation(3);
        f.setTitle("T3DScrollController Demo");
        f.pack();
        port1.setVolume((XjVolumeInfo)xjv);
        DefaultCursor3DModel cursor = new DefaultCursor3DModel(port1);
        System.err.println(cursor.getPoint(null));
        final T3DComponent t3d = port1.getT3DComponent();
        final Cursor3DVc cursorVc1 = new Cursor3DVc(cursor, t3d);
        final OrientationCubeVc cube = new OrientationCubeVc(t3d);
        ((T3DTrackball)((RetargetableMouseController)port1.getMouseController()).getMouseController(1024)).setCursor3D(cursor);
        f.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                t3d.add(cursorVc1);
                t3d.add(cube);
                t3d.validate();
            }
        });
        double[] look1 = t3d.getLookPoint(null);
        double[] eye1 = t3d.getEyePoint(null);
        JnVector3d view1 = new JnVector3d(look1[0] - eye1[0], look1[1] - eye1[1], look1[2] - eye1[2]);
        view1.normalize();
        JnVector3d xv = new JnVector3d(xjv.getXDirectionRAS(null));
        DefaultSlabLocationRangeModel scroll1 = new DefaultSlabLocationRangeModel(cursor.getPoint(null), view1, (XjVolumeGeometry)xjv, xv.length() * 2.0);
        new T3DScrollController(t3d, scroll1, cursor);
        cube.setTrackballEnabled(true);
        locationSlider.setModel(scroll1);
        sAction.setCursor(cursor);
        iAction.setCursor(cursor);
        aAction.setCursor(cursor);
        pAction.setCursor(cursor);
        lAction.setCursor(cursor);
        rAction.setCursor(cursor);
        sAction.setTarget(t3d);
        iAction.setTarget(t3d);
        aAction.setTarget(t3d);
        pAction.setTarget(t3d);
        lAction.setTarget(t3d);
        rAction.setTarget(t3d);
    }

    protected class LocationListener
    implements ChangeListener {
        protected LocationListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (T3DScrollController.this.renderer_ == null) {
                return;
            }
            JnVector3d look = new JnVector3d(T3DScrollController.this.renderer_.getLookPoint(null));
            JnVector3d off = new JnVector3d(look.x, look.y, look.z);
            look.sub(T3DScrollController.this.locationModel_.getReferencePoint());
            JnVector3d normal = T3DScrollController.this.locationModel_.getPlaneNormal();
            double t1 = (double)T3DScrollController.this.locationModel_.getValue() * T3DScrollController.this.locationModel_.getStepSize();
            double t2 = look.dot(normal);
            double delta = t1 - t2;
            if (Math.abs(delta) > 0.001) {
                off.scaleAdd(delta, normal);
                T3DScrollController.this.renderer_.setCamera(new double[]{off.x - normal.x, off.y - normal.y, off.z - normal.z}, off.generateArray(), T3DScrollController.this.renderer_.getUp(null));
                T3DScrollController.this.renderer_.repaint();
            }
            CPoint refPt = T3DScrollController.this.locationModel_.getReferencePoint();
            refPt.scaleAdd((double)T3DScrollController.this.locationModel_.getValue() * T3DScrollController.this.locationModel_.getStepSize(), T3DScrollController.this.locationModel_.getPlaneNormal());
            T3DScrollController.this.refPoint_.setPoint(new CPoint(refPt.x, refPt.y, refPt.z, 2));
        }
    }

    protected class ReferencePointListener
    implements ChangeListener {
        protected ReferencePointListener() {
        }

        public void stateChanged(ChangeEvent e) {
            CPoint newPt = T3DScrollController.this.refPoint_.getPoint(null);
            T3DScrollController.this.locationModel_.setReferencePoint(newPt);
        }
    }

    protected class OrientationChangeListener
    implements PropertyChangeListener {
        protected OrientationChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            T3DCapable t3d = (T3DCapable)evt.getSource();
            double[] look = t3d.getLookPoint(null);
            double[] eye = t3d.getEyePoint(null);
            JnVector3d view = new JnVector3d(look[0] - eye[0], look[1] - eye[1], look[2] - eye[2]);
            view.normalize();
            T3DScrollController.this.locationModel_.setPlaneNormal(view);
        }
    }
}

