/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.j3d.J3DRenderEngine;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DImageBlitter;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class T3DRenderEngineTester
extends JPanel
implements KeyListener {
    private static final int WIDTH = 600;
    private static final int HEIGHT = 600;
    private ImagePanel ip = new ImagePanel();
    private T3DRenderEngine engine = null;
    private BufferedImage dispimg_rgb = null;
    private BufferedImage dispimg_lum = null;
    private int passno = 0;

    public T3DRenderEngineTester(String imgpath) {
        this.setLayout(new BorderLayout());
        this.engine = new J3DRenderEngine();
        DMSession dms = new DMSession(new String[]{"file", imgpath});
        DMObject[] dmo = dms.getRelated("series");
        DMVolume xjvol = DMVolume.buildVolume((String)"DMObjectVolume", (Object[])new Object[]{dmo[0]});
        J3DVolumeModel vm = new J3DVolumeModel((XjVolumeInfo)xjvol);
        vm.init();
        this.engine.setVolumeModel(vm);
        this.engine.setRenderStyle("VOLUME");
        this.ip.setT3DOutput(600, 600);
        XpMedicalImage rgbimg = this.ip.getBlitter().getRGBBuffer();
        XpMedicalImage lumimg = this.ip.getBlitter().getLuminanceBuffer();
        this.dispimg_rgb = (BufferedImage)rgbimg.getPixelData();
        int[] idata = ((DataBufferInt)this.dispimg_rgb.getRaster().getDataBuffer()).getData();
        this.dispimg_lum = (BufferedImage)lumimg.getPixelData();
        short[] sdata = ((DataBufferUShort)this.dispimg_lum.getRaster().getDataBuffer()).getData();
        this.engine.setOutput(idata, sdata, 600, 600);
        this.ip.setPreferredSize(new Dimension(600, 600));
        this.ip.requestFocus();
        this.ip.addKeyListener(this);
        this.ip.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                ((Component)e.getSource()).requestFocus();
            }
        });
        JPanel uipanel = new JPanel();
        this.add((Component)this.ip, "Center");
        this.add((Component)uipanel, "South");
        JButton stepButton = new JButton("Step");
        JButton resetButton = new JButton("Reset");
        JButton driveButton = new JButton("Drive");
        JButton driveoneButton = new JButton("Draw");
        final JComboBox<String> cb = new JComboBox<String>(this.engine.getSupportedRenderStyles());
        stepButton.setToolTipText("Press SPACE to advance 1 step");
        uipanel.add(stepButton);
        uipanel.add(resetButton);
        uipanel.add(driveButton);
        uipanel.add(driveoneButton);
        uipanel.add(cb);
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.err.println(">>> rstyle = " + cb.getSelectedItem());
                T3DRenderEngineTester.this.engine.setRenderStyle("" + cb.getSelectedItem());
                Object pbuffer = T3DRenderEngineTester.this.engine.getPixelBuffer();
                if (pbuffer instanceof short[]) {
                    T3DRenderEngineTester.this.ip.setMode(11);
                } else {
                    T3DRenderEngineTester.this.ip.setMode(1);
                }
            }
        });
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                T3DRenderEngineTester.this.reset();
            }
        });
        stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                T3DRenderEngineTester.this.dostep();
            }
        });
        driveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                T3DRenderEngineTester.this.drive();
            }
        });
        driveoneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                T3DRenderEngineTester.this.drive_onestep();
            }
        });
        this.engine.clearBuffers();
    }

    private void drive_onestep() {
        Runnable r = new Runnable(){

            public void run() {
                T3DRenderEngineTester.this.engine.initRender();
                T3DRenderEngineTester.this.engine.render(0);
                System.err.println("Done draw simulation in one step....");
                T3DRenderEngineTester.this.ip.refresh();
                T3DRenderEngineTester.this.repaint();
            }
        };
        Thread th = new Thread(r);
        th.start();
    }

    private void drive() {
        Runnable r = new Runnable(){

            public void run() {
                int remsteps;
                MultipassAlgorithm ma = T3DRenderEngineTester.this.engine.getMultipassAlgorithm(0);
                T3DRenderEngineTester.this.engine.initRender();
                int width = T3DRenderEngineTester.this.engine.getBufferWidth();
                int height = T3DRenderEngineTester.this.engine.getBufferHeight();
                Rectangle r = new Rectangle(0, 0, width, height);
                T3DRenderEngineTester.this.passno = 0;
                do {
                    remsteps = ma.render(r, 0, T3DRenderEngineTester.this.passno);
                    T3DRenderEngineTester.this.ip.refresh();
                    T3DRenderEngineTester.this.repaint();
                    T3DRenderEngineTester.this.passno++;
                } while (remsteps != 0);
                T3DRenderEngineTester.this.passno = 0;
                System.err.println("Done draw simulation....");
            }
        };
        Thread th = new Thread(r);
        th.start();
    }

    private void reset() {
        this.passno = 0;
        this.engine.clearBuffers();
        this.ip.refresh();
        this.repaint();
    }

    private void dostep() {
        MultipassAlgorithm ma = this.engine.getMultipassAlgorithm(0);
        if (this.passno == 0) {
            this.engine.initRender();
        }
        int width = this.engine.getBufferWidth();
        int height = this.engine.getBufferHeight();
        Rectangle r = new Rectangle(0, 0, width, height);
        int retval = ma.render(r, 0, this.passno);
        System.err.println(">>>> renderPass: passno=" + this.passno + "   return=" + retval);
        ++this.passno;
        this.ip.refresh();
        this.repaint();
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame("T3DRenderEngine Tester");
        T3DRenderEngineTester mat = new T3DRenderEngineTester(args[0]);
        jf.setContentPane(mat);
        jf.pack();
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 32) {
            this.dostep();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    private class ImagePanel
    extends JPanel {
        private T3DImageBlitter ib = new T3DImageBlitter();

        public ImagePanel() {
            this.setUI(this.ib);
            XpImageRenderAttributes ira = this.ib.getImageRenderAttributes();
            ira.setWindowing(750.0, 150.0);
            this.ib.setImageRenderAttributes(ira);
        }

        public void setMode(int mode) {
            this.ib.setMode(mode);
        }

        public void refresh() {
            this.ib.refreshImage();
        }

        public void setT3DOutput(int width, int height) {
            this.ib.updateSize(T3DRenderEngineTester.this.engine, T3DRenderEngineTester.this.engine.getNumOutputs(), width, height);
            this.setMode(1);
        }

        public T3DImageBlitter getBlitter() {
            return this.ib;
        }
    }
}

