/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.ActiveAnnotationCapable;
import com.ge.med.idc.Capable;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.XpDynamicGridLayout;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.j3d.Commons3D;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.ViewResetAction;
import com.ge.med.terra.jami.remote.RmRenderSession;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class T3DCompositePort
extends XpViewport
implements T3DCapable,
T3DRenderStyleCapable,
RowColCapable,
SelectionCapable,
ActiveAnnotationCapable,
AnnotCapable,
WindowLevelCapable,
PropertyChangeListener,
ColorMapCapable {
    public static final Border PRIMARY_SELECTION = BorderFactory.createLineBorder(Color.cyan, 1);
    protected final ViewResetAction sAction = new ViewResetAction(null, "S", null);
    protected final ViewResetAction iAction = new ViewResetAction(null, "I", null);
    protected final ViewResetAction aAction = new ViewResetAction(null, "A", null);
    protected final ViewResetAction pAction = new ViewResetAction(null, "P", null);
    protected final ViewResetAction lAction = new ViewResetAction(null, "L", null);
    protected final ViewResetAction rAction = new ViewResetAction(null, "R", null);
    private String renderEngineClass = null;
    private List portList = new Vector();
    private XjVolumeInfo vol = null;
    private XjVolumeModel vm = null;
    private int selPort = -1;
    private Border selBorder = PRIMARY_SELECTION;
    private XpDynamicGridLayout gridLayout = new XpDynamicGridLayout(2, 2);
    private boolean invalidatePending = false;
    private RmRenderSession serverSession = null;

    public T3DCompositePort() {
        this.init();
    }

    public T3DCompositePort(String renderEngineClass) {
        this.renderEngineClass = renderEngineClass;
        this.init();
    }

    public T3DCompositePort(RmRenderSession serverSession, String remoteRenderEngineClass) {
        this.renderEngineClass = remoteRenderEngineClass;
        this.serverSession = serverSession;
        this.init();
    }

    private void init() {
        this.setLayout(this.gridLayout);
        this.setRowCol(2, 2);
        this.initPorts();
    }

    private void initPorts() {
        int nports = this.getNumPorts();
        for (int i = 0; i < nports; ++i) {
            T3DViewport vp = this.getPort(i);
            vp.getAnnotationGenerator().reset();
        }
        this.setComponentSelection(0);
    }

    private void initViews() {
        this.setView(0, "A");
        this.setView(1, "A");
        this.setView(2, "R");
        this.setView(3, "I");
    }

    public void setVolume(XjVolumeInfo volume) {
        this.vol = volume;
        this.getPort(0).setVolume(volume);
        this.vm = this.getPort(0).getVolumeModel();
        for (int i = 1; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            vp.setVolumeModel(this.vm);
        }
        this.initViews();
        this.repaint();
    }

    public void setVolumeModel(XjVolumeModel volmodel) {
        this.vol = null;
        this.vm = volmodel;
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            vp.setVolumeModel(this.vm);
        }
        this.initViews();
        this.repaint();
    }

    public void setView(int portIdx, String view) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            String v = view.toLowerCase();
            ActionEvent ev = new ActionEvent(vp, portIdx, v);
            if (v.equals("a")) {
                this.aAction.setTarget(vp);
                this.aAction.actionPerformed(ev);
            } else if (v.equals("p")) {
                this.pAction.setTarget(vp);
                this.pAction.actionPerformed(ev);
            } else if (v.equals("s")) {
                this.sAction.setTarget(vp);
                this.sAction.actionPerformed(ev);
            } else if (v.equals("i")) {
                this.iAction.setTarget(vp);
                this.iAction.actionPerformed(ev);
            } else if (v.equals("l")) {
                this.lAction.setTarget(vp);
                this.lAction.actionPerformed(ev);
            } else if (v.equals("r")) {
                this.rAction.setTarget(vp);
                this.rAction.actionPerformed(ev);
            }
        }
    }

    public XjVolumeInfo getVolume() {
        return this.vol;
    }

    public XjVolumeModel getVolumeModel() {
        return this.vm;
    }

    public XpImage getImageAt(int idx) {
        if (this.selPort >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(this.selPort);
            return vp.getImageAt(idx);
        }
        return null;
    }

    public XpMedicalImage[] getImages() {
        if (this.selPort >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(this.selPort);
            return vp.getImages();
        }
        return null;
    }

    public Capable getCapable(String capableIFName) {
        Capable c = super.getCapable(capableIFName);
        if (c == null && this.selPort >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(this.selPort);
            c = vp.getCapable(capableIFName);
        }
        return c;
    }

    public void refreshContents() {
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            vp.refreshContents();
        }
    }

    public final T3DViewport getPort(int idx) {
        int len = this.portList.size();
        if (idx >= 0 && idx < len) {
            return (T3DViewport)this.portList.get(idx);
        }
        return null;
    }

    public final T3DViewport getSelectedPort() {
        return this.getPort(this.selPort);
    }

    public final int getSelectedPortIndex() {
        return this.selPort;
    }

    public final int getNumPorts() {
        return this.portList.size();
    }

    public final void addPort(T3DViewport vp) {
        this.portList.add(vp);
    }

    public final Iterator getPorts() {
        return this.portList.iterator();
    }

    protected void syncPorts() {
        T3DViewport vp;
        int portListLen;
        int rows = this.getRows();
        int cols = this.getCols();
        int idx = portListLen = this.getNumPorts();
        int configLen = rows * cols;
        if (portListLen < configLen) {
            int numberToCreate = configLen - portListLen;
            for (int i = 0; i < numberToCreate; ++i) {
                vp = this.createChildPort(idx++);
                this.addPort(vp);
            }
        }
        if (this.isVisible()) {
            for (int j = 0; j < configLen; ++j) {
                T3DViewport vp2 = this.getPort(j);
                vp2.setVisible(true);
            }
        }
        int nports = this.getNumPorts();
        for (int j = configLen; j < nports; ++j) {
            vp = this.getPort(j);
            boolean focus = vp.getT3DComponent().hasFocus();
            if (focus) {
                this.requestFocus();
            }
            vp.setVisible(false);
        }
        if (this.selPort >= configLen) {
            this.selPort = 0;
        }
        this.doInvalidate();
        this.callRepaint();
    }

    private T3DViewport createChildPort(int slotIdx) {
        T3DViewport vp = null;
        vp = this.serverSession != null ? new T3DViewport(this.serverSession, this.renderEngineClass) : (this.renderEngineClass != null ? new T3DViewport(Commons3D.createRenderEngine(this.renderEngineClass)) : new T3DViewport());
        if (this.vm != null) {
            vp.setVolumeModel(this.vm);
        }
        this.add(vp);
        vp.setRenderStyle("REFORMAT");
        SelectionMouseAdapter sma = new SelectionMouseAdapter(slotIdx);
        vp.getT3DComponent().addMouseListener(sma);
        vp.getT3DComponent().addMouseMotionListener(sma);
        vp.addPropertyChangeListener(this);
        return vp;
    }

    public String[] getSupportedRenderStyles() {
        if (this.selPort >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(this.selPort);
            return vp.getSupportedRenderStyles();
        }
        return null;
    }

    public void setRenderStyle(int portIdx, String style) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setRenderStyle(style);
        }
    }

    public void setRenderStyle(String style) {
        this.setRenderStyle(this.selPort, style);
    }

    public String getRenderStyle(int portIdx) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.getRenderStyle();
        }
        return null;
    }

    public String getRenderStyle() {
        return this.getRenderStyle(this.selPort);
    }

    public void getWorldBounds(double[] ulc, double[] xside, double[] yside, double[] zside) {
        this.getWorldBounds(this.selPort, ulc, xside, yside, zside);
    }

    public void setLookPoint(double[] point) {
        this.setLookPoint(this.selPort, point);
    }

    public double[] getLookPoint(double[] look_pt) {
        return this.getLookPoint(this.selPort, look_pt);
    }

    public void setEyePoint(double[] point) {
        this.setEyePoint(this.selPort, point);
    }

    public double[] getEyePoint(double[] eye_pt) {
        return this.getEyePoint(this.selPort, eye_pt);
    }

    public void setUp(double[] vec) {
        this.setUp(this.selPort, vec);
    }

    public double[] getUp(double[] up_vect) {
        return this.getUp(this.selPort, up_vect);
    }

    public void setCamera(double[] eyepoint, double[] lookpoint, double[] up) {
        this.setCamera(this.selPort, eyepoint, lookpoint, up);
    }

    public void setViewHeight(double height) {
        this.setViewHeight(this.selPort, height);
    }

    public double getViewHeight() {
        return this.getViewHeight(this.selPort);
    }

    public void setAspectRatio(double aspect) {
        this.setAspectRatio(this.selPort, aspect);
    }

    public double getAspectRatio() {
        return this.getAspectRatio(this.selPort);
    }

    public void setViewClip(double[] clipOffsets) {
        this.setViewClip(this.selPort, clipOffsets);
    }

    public double[] getViewClip(double[] viewClip) {
        return this.getViewClip(this.selPort, viewClip);
    }

    public void setPerspective(boolean b2) {
        this.setPerspective(this.selPort, b2);
    }

    public boolean isPerspective() {
        return this.isPerspective(this.selPort);
    }

    public void getWorldBounds(int portIdx, double[] ulc, double[] xside, double[] yside, double[] zside) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.getWorldBounds(ulc, xside, yside, zside);
        }
    }

    public void setLookPoint(int portIdx, double[] point) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setLookPoint(point);
        }
    }

    public double[] getLookPoint(int portIdx, double[] look_pt) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.getLookPoint(look_pt);
        }
        return look_pt;
    }

    public void setEyePoint(int portIdx, double[] point) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setEyePoint(point);
        }
    }

    public double[] getEyePoint(int portIdx, double[] eye_pt) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.getEyePoint(eye_pt);
        }
        return eye_pt;
    }

    public void setUp(int portIdx, double[] vec) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setUp(vec);
        }
    }

    public double[] getUp(int portIdx, double[] up_vect) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.getUp(up_vect);
        }
        return up_vect;
    }

    public void setCamera(int portIdx, double[] eyepoint, double[] lookpoint, double[] up) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setCamera(eyepoint, lookpoint, up);
        }
    }

    public void setViewHeight(int portIdx, double height) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setViewHeight(height);
        }
    }

    public double getViewHeight(int portIdx) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.getViewHeight();
        }
        return 0.0;
    }

    public void setAspectRatio(int portIdx, double aspect) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setAspectRatio(aspect);
        }
    }

    public double getAspectRatio(int portIdx) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.getAspectRatio();
        }
        return 1.0;
    }

    public void setViewClip(int portIdx, double[] clipOffsets) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setViewClip(clipOffsets);
        }
    }

    public double[] getViewClip(int portIdx, double[] viewClip) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.getViewClip(viewClip);
        }
        return null;
    }

    public void setPerspective(int portIdx, boolean b2) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setPerspective(b2);
        }
    }

    public boolean isPerspective(int portIdx) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.isPerspective();
        }
        return false;
    }

    private void fireRowColChangeEvent(int oldR, int oldC) {
        int r = this.gridLayout.getRows();
        int c = this.gridLayout.getColumns();
        Dimension oldD = new Dimension(oldC, oldR);
        Dimension newD = new Dimension(c, r);
        this.firePropertyChange("RowColumnProperty", oldD, newD);
    }

    public void setRowsAndColumns(int rows, int columns) {
        int oldR = this.gridLayout.getRows();
        int oldC = this.gridLayout.getColumns();
        this.gridLayout.setRows(rows);
        this.gridLayout.setColumns(columns);
        this.syncPorts();
        this.fireRowColChangeEvent(oldR, oldC);
    }

    public void setRows(int rows) {
        int oldR = this.gridLayout.getRows();
        int oldC = this.gridLayout.getColumns();
        this.gridLayout.setRows(rows);
        this.syncPorts();
        this.fireRowColChangeEvent(oldR, oldC);
    }

    public void setCols(int columns) {
        int oldR = this.gridLayout.getRows();
        int oldC = this.gridLayout.getColumns();
        this.gridLayout.setColumns(columns);
        this.syncPorts();
        this.fireRowColChangeEvent(oldR, oldC);
    }

    public void setRowCol(int row, int col) {
        this.setRowsAndColumns(row, col);
    }

    public final int getRows() {
        return this.gridLayout.getRows();
    }

    public final int getCols() {
        return this.gridLayout.getColumns();
    }

    public final int getNumComponents() {
        return this.getNumPorts();
    }

    public final int getComponentSelection() {
        return this.selPort;
    }

    public final void setComponentSelection(int selection) {
        int idx = this.getComponentSelection();
        int size = this.getNumPorts();
        if (idx != selection && selection < size) {
            this.setPortSelection(selection);
        } else if (idx == selection) {
            this.firePropertyChange("ComponentSelection", -99, selection);
        }
    }

    public final JComponent getViewportComponent(int selection) {
        T3DViewport comp = null;
        int size = this.getNumPorts();
        if (selection >= 0 && selection < size) {
            comp = this.getPort(selection);
        }
        return comp;
    }

    public final void setPortSelection(int portIdx) {
        this.selPort = portIdx;
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            if (this.selPort == i) {
                vp.setBorder(this.selBorder);
                continue;
            }
            vp.setBorder(null);
        }
        this.firePropertyChange("ComponentSelection", -1, portIdx);
    }

    public synchronized void setWindowing(double width, double level) {
        double min = level - width * 0.5;
        double max = level + width * 0.5;
        this.setWinMinMax(min, max);
    }

    public void setWinMinMax(double min, double max) {
        this.setWinMinMax(this.selPort, min, max);
    }

    public double getWinMin() {
        return this.getWinMin(this.selPort);
    }

    public final void setWinMin(double min) {
        this.setWinMin(this.selPort, min);
    }

    public double getWinMax() {
        return this.getWinMax(this.selPort);
    }

    public final void setWinMax(double max) {
        this.setWinMax(this.selPort, max);
    }

    public void resetWindowing() {
        this.resetWindowing(this.selPort);
    }

    public final void setWinUpperLimit(double wuLimit) {
        this.setWinUpperLimit(this.selPort, wuLimit);
    }

    public final double getWinUpperLimit() {
        return this.getWinUpperLimit(this.selPort);
    }

    public final void setWinLowerLimit(double wlLimit) {
        this.setWinLowerLimit(this.selPort, wlLimit);
    }

    public final double getWinLowerLimit() {
        return this.getWinLowerLimit(this.selPort);
    }

    public void setVideoInverted(boolean inverted) {
        this.setVideoInverted(this.selPort, inverted);
    }

    public boolean isVideoInverted() {
        return this.isVideoInverted(this.selPort);
    }

    public double[] getRange() {
        return this.getRange(this.selPort);
    }

    public void setWinMinMax(int portIdx, double min, double max) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setWinMinMax(min, max);
        }
    }

    public double getWinMin(int portIdx) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.getWinMin();
        }
        return 0.0;
    }

    public final void setWinMin(int portIdx, double min) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setWinMin(min);
        }
    }

    public double getWinMax(int portIdx) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.getWinMax();
        }
        return 0.0;
    }

    public final void setWinMax(int portIdx, double max) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setWinMax(max);
        }
    }

    public void resetWindowing(int portIdx) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.resetWindowing();
        }
    }

    public final void setWinUpperLimit(int portIdx, double wuLimit) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setWinUpperLimit(wuLimit);
        }
    }

    public final double getWinUpperLimit(int portIdx) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.getWinUpperLimit();
        }
        return 0.0;
    }

    public final void setWinLowerLimit(int portIdx, double wlLimit) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setWinLowerLimit(wlLimit);
        }
    }

    public final double getWinLowerLimit(int portIdx) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.getWinLowerLimit();
        }
        return 0.0;
    }

    public void setVideoInverted(int portIdx, boolean inverted) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            vp.setVideoInverted(inverted);
        }
    }

    public boolean isVideoInverted(int portIdx) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.isVideoInverted();
        }
        return false;
    }

    public double[] getRange(int portIdx) {
        if (portIdx >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(portIdx);
            return vp.getRange();
        }
        return null;
    }

    public String[] getAnnotationSegments() {
        if (this.selPort >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(this.selPort);
            return vp.getAnnotationSegments();
        }
        return null;
    }

    public void setActiveAnnotationListener(String annotSegment, MouseInputListener mil) {
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            vp.setActiveAnnotationListener(annotSegment, mil);
        }
    }

    public void setActiveAnnotationListener(String annotSegment, MouseInputListener mil, String tooltip) {
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            vp.setActiveAnnotationListener(annotSegment, mil, tooltip);
        }
    }

    public void clearActiveAnnotationListener(String annotSegment) {
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            vp.clearActiveAnnotationListener(annotSegment);
        }
    }

    public void clearActiveAnnotationListeners() {
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            vp.clearActiveAnnotationListeners();
        }
    }

    protected void applyAnnotationLanguage(String lang) {
        super.applyAnnotationLanguage(lang);
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            vp.setAnnotationLanguage(lang);
        }
    }

    public String[] getAnnotationGroups() {
        if (this.selPort >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(this.selPort);
            return vp.getAnnotationGroups();
        }
        return null;
    }

    public String[] getAnnotationItems() {
        if (this.selPort >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(this.selPort);
            return vp.getAnnotationItems();
        }
        return null;
    }

    public String[] getAnnotationItems(String agName) {
        if (this.selPort >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(this.selPort);
            return vp.getAnnotationItems(agName);
        }
        return null;
    }

    public void setAnnotationGroup(String agName, boolean activate) {
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            vp.setAnnotationGroup(agName, activate);
        }
    }

    public void setAnnotationItems(String[] annoItems, boolean activate) {
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            vp.setAnnotationItems(annoItems, activate);
        }
    }

    public void queryAnnotationItems(String[] annoItems, boolean[] queryRes) {
        if (this.selPort >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(this.selPort);
            vp.queryAnnotationItems(annoItems, queryRes);
        }
    }

    public boolean queryAnnotationItem(String aiName) {
        if (this.selPort >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(this.selPort);
            return vp.queryAnnotationItem(aiName);
        }
        return false;
    }

    public void setAnnotationVisible(boolean annotVisible) {
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            vp.setAnnotationVisible(annotVisible);
        }
    }

    public boolean isAnnotationVisible() {
        if (this.selPort >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(this.selPort);
            return vp.isAnnotationVisible();
        }
        return false;
    }

    public void setAnnotationColor(Color c) {
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            vp.setAnnotationColor(c);
        }
    }

    public Color getAnnotationColor() {
        if (this.selPort >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(this.selPort);
            return vp.getAnnotationColor();
        }
        return null;
    }

    public void setColorMap(int[] cmap) {
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DViewport vp = (T3DViewport)this.portList.get(i);
            vp.setColorMap(cmap);
        }
    }

    public int[] getColorMap() {
        if (this.selPort >= 0) {
            T3DViewport vp = (T3DViewport)this.portList.get(this.selPort);
            return vp.getColorMap();
        }
        return null;
    }

    protected void doInvalidate() {
        this.invalidatePending = true;
    }

    protected final void callRepaint() {
        if (this.invalidatePending) {
            this.invalidate();
            this.validate();
            this.invalidatePending = false;
        }
        this.request_repaint();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        Object newval = evt.getNewValue();
        Object oldval = evt.getOldValue();
        String propName = evt.getPropertyName();
        if (source instanceof T3DViewport) {
            this.firePropertyChange(propName, oldval, newval);
        }
    }

    private class SelectionMouseAdapter
    extends MouseInputAdapter {
        private int portno = -1;

        public SelectionMouseAdapter(int portno) {
            this.portno = portno;
        }

        public void mouseClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent e) {
            T3DCompositePort.this.getPort(this.portno).getT3DComponent().requestFocus();
            T3DCompositePort.this.setComponentSelection(this.portno);
        }
    }
}

