/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.jnu.JnVector3i;
import java.util.Arrays;
import java.util.LinkedList;

public class ProgressiveAutoSelect {
    protected LinkedList candidatePoints = new LinkedList();
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    protected int zMin;
    protected int zMax;
    short minValue;
    short maxValue;
    byte[] visitedMask_;
    byte[] growMask_;
    byte[] growMaskBuf_;
    short[] pixels;
    int[] dims;
    private int padding;
    static final byte[] MASK = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    int loop = 0;
    private boolean newSegment;
    static final int COPY_COUNT = 32;
    boolean stopRequested;

    public void setRange(short max, short min) {
        this.minValue = min;
        this.maxValue = max;
        this.initialize();
    }

    private void initialize() {
        if (this.pixels == null) {
            return;
        }
        int len = this.dims[0] * this.dims[1] * this.dims[2] >> 3;
        if (this.visitedMask_ == null || this.visitedMask_.length != len) {
            this.visitedMask_ = new byte[len];
            this.growMask_ = new byte[len];
            this.growMaskBuf_ = new byte[len];
            Arrays.fill(this.visitedMask_, 0, this.visitedMask_.length, (byte)0);
            Arrays.fill(this.growMask_, 0, this.visitedMask_.length, (byte)0);
            Arrays.fill(this.growMaskBuf_, 0, this.visitedMask_.length, (byte)0);
        }
    }

    public synchronized void reset() {
        if (this.visitedMask_ != null) {
            Arrays.fill(this.visitedMask_, 0, this.visitedMask_.length, (byte)0);
        }
        if (this.growMask_ != null) {
            Arrays.fill(this.growMask_, 0, this.growMask_.length, (byte)0);
        }
        if (this.growMaskBuf_ != null) {
            Arrays.fill(this.growMaskBuf_, 0, this.growMaskBuf_.length, (byte)0);
        }
    }

    private void setMask(int x, int y, int z, byte[] mask) {
        int off = x + y * this.dims[0] + z * this.dims[0] * this.dims[1];
        int n = off >> 3;
        mask[n] = (byte)(mask[n] | MASK[off & 7]);
    }

    private void setMask(int off, byte[] mask) {
        int n = off >> 3;
        mask[n] = (byte)(mask[n] | MASK[off & 7]);
    }

    private int getMask(int x, int y, int z, byte[] mask) {
        int off = x + y * this.dims[0] + z * this.dims[0] * this.dims[1];
        return this.getMask(off, mask);
    }

    private int getMask(int off, byte[] mask) {
        return mask[off >> 3] & MASK[off & 7];
    }

    public void setData(short[] pixels, int padding, int[] dims) {
        this.pixels = pixels;
        this.padding = padding;
        this.dims = dims;
        this.xMin = 0;
        this.xMax = dims[0];
        this.yMin = 0;
        this.yMax = dims[1];
        this.zMin = 0;
        this.zMax = dims[2];
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(JnVector3i seed) {
        int offset = seed.x + this.dims[0] * seed.y + this.dims[0] * this.dims[1] * seed.z;
        short value = this.pixels[offset + this.padding];
        this.setRange((short)(value + 100), (short)(value - 100));
        this.candidatePoints.clear();
        this.stopRequested = false;
        this.checkForGrow(seed.x, seed.y, seed.z);
        while (!this.candidatePoints.isEmpty() && !this.stopRequested) {
            JnVector3i p = (JnVector3i)this.candidatePoints.removeFirst();
            this.checkForGrow(p.x - 1, p.y, p.z);
            this.checkForGrow(p.x + 1, p.y, p.z);
            this.checkForGrow(p.x, p.y - 1, p.z);
            this.checkForGrow(p.x, p.y + 1, p.z);
            this.checkForGrow(p.x, p.y, p.z - 1);
            this.checkForGrow(p.x, p.y, p.z + 1);
            ++this.loop;
            if (this.loop % 32 != 0) continue;
            ProgressiveAutoSelect progressiveAutoSelect = this;
            synchronized (progressiveAutoSelect) {
                this.newSegment = true;
                System.arraycopy(this.growMask_, 0, this.growMaskBuf_, 0, this.growMask_.length);
            }
        }
        if (!this.stopRequested) {
            ProgressiveAutoSelect progressiveAutoSelect = this;
            synchronized (progressiveAutoSelect) {
                this.newSegment = true;
                System.arraycopy(this.growMask_, 0, this.growMaskBuf_, 0, this.growMask_.length);
            }
        }
        System.out.println("ProgressiveAutoSelect.execute() ends");
    }

    public void requestStop() {
        this.stopRequested = true;
    }

    public synchronized byte[] retrieveSegmentation() {
        this.newSegment = false;
        return this.growMaskBuf_;
    }

    public synchronized boolean hasNewSegmentation() {
        return this.newSegment;
    }

    protected void checkForGrow(int x, int y, int z) {
        int offset;
        if (x >= this.xMin && x < this.xMax && y >= this.yMin && y < this.yMax && z >= this.zMin && z < this.zMax && this.getMask(offset = z * this.dims[0] * this.dims[1] + y * this.dims[0] + x, this.visitedMask_) == 0) {
            this.setMask(offset, this.visitedMask_);
            if (this.pixels[offset + this.padding] >= this.minValue && this.pixels[offset + this.padding] <= this.maxValue) {
                this.setMask(offset, this.growMask_);
                this.candidatePoints.addLast(new JnVector3i(x, y, z));
            }
        }
    }
}

