/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DDepthCapable;
import com.ge.med.jnu.geom.ParametricCurve3D;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.j3d.T3DComponent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;

public class PolyLine3DVc
extends XpVisualComponent
implements MouseInputListener,
PropertyChangeListener {
    private static final int NOT_SELECTED = -1;
    private static final int CURVE_SELECTED = -2;
    private ParametricCurve3D curve = null;
    private CPoint[] controlPoints = null;
    private int selectedPoint = -1;
    private int selectedPointPopup = -1;
    private boolean updateDirty = true;
    private boolean mouseDown = false;
    private boolean onCurve = false;
    private Cursor handCursor = new Cursor(12);
    private static final int pointSize = 6;
    private static final int pointRadius = 3;
    private static final int pointSelectRadius = 4;
    private JPopupMenu curvePopup = new JPopupMenu();
    private List adjustedControlList = null;
    private Point previousPoint = null;
    private String deleteControlPointStr = "Delete control Point";
    private String deleteCurveStr = "Delete curve";

    public PolyLine3DVc() {
        this.enableMouse();
        this.initPopUpMenu();
    }

    protected void initPopUpMenu() {
        JMenuItem delCp = new JMenuItem(this.deleteControlPointStr);
        this.curvePopup.add(delCp);
        JMenuItem delCurve = new JMenuItem(this.deleteCurveStr);
        this.curvePopup.add(delCurve);
        delCurve.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PolyLine3DVc.this.deleteAllControlPoints();
            }
        });
        delCp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PolyLine3DVc.this.deleteControlPoint();
            }
        });
    }

    protected void enableMouse() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setCurve(ParametricCurve3D curve) {
        if (this.curve != curve) {
            if (this.curve != null) {
                this.curve.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.curve = curve;
            this.curve.addPropertyChangeListener("CURVE_PROPERTY", (PropertyChangeListener)this);
            this.updateDirty = true;
        }
    }

    protected void update() {
        this.updateDirty = false;
        if (false) {
            return;
        }
        this.updateDirty = false;
        if (this.curve == null) {
            this.controlPoints = new CPoint[0];
            return;
        }
        if (this.curve.getControlPoints() != null) {
            List controlList = this.curve.getControlPoints();
            this.controlPoints = new CPoint[controlList.size()];
            CPoint rasPoint = new CPoint(2);
            for (int i = 0; i < controlList.size() && (double[])controlList.get(i) != null; ++i) {
                rasPoint.set((double[])controlList.get(i));
                this.controlPoints[i] = this.transform(rasPoint, (byte)1);
            }
        }
    }

    public boolean contains(int x, int y) {
        if (this.mouseDown) {
            return true;
        }
        if (this.controlPoints != null) {
            for (int i = 0; i < this.controlPoints.length; ++i) {
                if (this.controlPoints[i] == null) {
                    XpLog.logger().warning("PolyLine3DVc: Null in contains while checking controlPoints[" + i + "]");
                    break;
                }
                if (!((double)x >= this.controlPoints[i].x - 4.0) || !((double)x < this.controlPoints[i].x + 4.0) || !((double)y >= this.controlPoints[i].y - 4.0) || !((double)y < this.controlPoints[i].y + 4.0)) continue;
                this.selectedPoint = i;
                this.selectedPointPopup = i;
                this.onCurve = false;
                return true;
            }
        }
        if (this.curve.getControlPoints() != null && this.curve.getControlPoints().size() > 1 && this.controlPoints != null) {
            int x1 = x - 2;
            int y1 = y - 2;
            int x2 = x + 2;
            int y2 = y + 2;
            CPoint prev = this.controlPoints[0];
            for (int i = 1; i < this.controlPoints.length; ++i) {
                if (this.controlPoints[i] == null) {
                    XpLog.logger().warning("PolyLine3DVc: Null in contains while checking controlPoints[" + i + "]");
                    break;
                }
                CPoint p = this.controlPoints[i];
                if (XpGeomUtils.intersects(x1, y1, x2, y2, (int)prev.x, (int)prev.y, (int)p.x, (int)p.y)) {
                    this.onCurve = true;
                    this.selectedPoint = -1;
                    return true;
                }
                this.onCurve = false;
                prev = p;
            }
        }
        this.selectedPoint = -1;
        this.onCurve = false;
        return false;
    }

    protected void paintComponent(Graphics g) {
        if (this.curve.getControlPoints() != null) {
            this.update();
            if (this.controlPoints.length > 1) {
                g.setColor(Color.yellow);
                CPoint p1 = this.controlPoints[0];
                for (int i = 1; i < this.controlPoints.length; ++i) {
                    CPoint p2 = this.controlPoints[i];
                    g.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
                    p1 = p2;
                }
            }
            for (int i = 0; i < this.controlPoints.length; ++i) {
                g.setColor(Color.red);
                g.fillRect((int)this.controlPoints[i].x - 3, (int)this.controlPoints[i].y - 3, 6, 6);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        boolean b3;
        int mod = e.getModifiers();
        boolean b1 = 0 != (mod & 0x10);
        boolean b2 = 0 != (mod & 8);
        boolean bl = b3 = 0 != (mod & 4);
        if (this.mouseDown || !b1 && !b2 && !b3) {
            this.setCursor(this.handCursor);
        }
    }

    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void mousePressed(MouseEvent e) {
        this.mouseDown = true;
        this.previousPoint = e.getPoint();
        this.adjustedControlList = this.curve.getControlPoints();
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseDown = false;
    }

    public void mouseClicked(MouseEvent e) {
        boolean b3;
        int mod = e.getModifiers();
        boolean bl = b3 = 0 != (mod & 4);
        if (b3) {
            this.curvePopup.show(this, e.getX(), e.getY());
        }
    }

    public void mouseDragged(MouseEvent e) {
        double[] tempRAS = null;
        int distX = 0;
        int distY = 0;
        T3DComponent t3dcomp = (T3DComponent)this.getParent();
        Point p = e.getPoint();
        int width = t3dcomp.getWidth();
        int height = t3dcomp.getHeight();
        if (this.onCurve && this.selectedPoint == -1) {
            if (p.x < 0 || p.y < 0 || p.x > width - 1 || p.y > height - 1) {
                return;
            }
            distX = p.x - this.previousPoint.x;
            distY = p.y - this.previousPoint.y;
            CPoint points = new CPoint();
            for (int i = 0; i < this.controlPoints.length; ++i) {
                points = this.controlPoints[i];
                points.x += (double)distX * 1.0;
                points.y += (double)distY * 1.0;
                tempRAS = this.transform(points, (byte)2).generateArray();
                if (tempRAS == null) {
                    XpLog.logger().warning("PolyLine3DVc: BAD CURVE TRANSFORM");
                }
                this.adjustedControlList.set(i, tempRAS);
            }
            this.previousPoint.y = p.y;
            this.previousPoint.x = p.x;
            this.curve.setControlPoints(this.adjustedControlList);
            this.repaint();
            return;
        }
        if (this.selectedPoint == -1) {
            return;
        }
        CPoint point = this.controlPoints[this.selectedPoint];
        point.x = p.x;
        point.y = p.y;
        if (p.x < 0 || p.y < 0 || p.x > width - 1 || p.y > height - 1) {
            return;
        }
        if (t3dcomp.getCapable(T3DDepthCapable.class.getCanonicalName()) != null) {
            T3DDepthCapable dc = (T3DDepthCapable)((Object)t3dcomp.getCapable(T3DDepthCapable.class.getCanonicalName()));
            tempRAS = dc.getRASCoords((int)point.x, (int)point.y, null);
        }
        if (tempRAS == null && (tempRAS = this.transform(point, (byte)2).generateArray()) == null) {
            XpLog.logger().warning("PolyLine3DVc: BAD POINT TRANSFORM");
        }
        this.adjustedControlList.set(this.selectedPoint, tempRAS);
        this.curve.setControlPoints(this.adjustedControlList);
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }

    public void deleteControlPoint() {
        ArrayList tempControlPointsSrc = new ArrayList();
        tempControlPointsSrc = (ArrayList)this.curve.getControlPoints();
        ArrayList tempControlPointsDest = (ArrayList)tempControlPointsSrc.clone();
        tempControlPointsDest.remove(this.selectedPointPopup);
        this.curve.setControlPoints((List)tempControlPointsDest);
        this.update();
        this.repaint();
    }

    public void deleteAllControlPoints() {
        ArrayList emptyControlList = new ArrayList();
        this.curve.setControlPoints(emptyControlList);
        this.update();
        this.repaint();
    }

    public boolean checkCurveBound(double distx, double disty, double height, double width) {
        double x = 0.0;
        double y = 0.0;
        CPoint p = new CPoint();
        for (int i = 0; i < this.controlPoints.length; ++i) {
            p = this.controlPoints[i];
            x = p.x + distx * 1.0;
            y = p.y + disty * 1.0;
            if (!(x < 0.0 || y < 0.0 || x > width - 1.0) && !(y > height - 1.0)) continue;
            return false;
        }
        return true;
    }
}

