/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpVisualComponent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class Plane3DVc
extends XpVisualComponent
implements PropertyChangeListener {
    public static final int PLANE_MODE = 0;
    public static final int INTERSECTION_MODE = 1;
    public static final int PLANE_AND_INTERSECTION_MODE = 2;
    protected T3DPlane t3dPlane = null;
    protected T3DCapable t3dCapable = null;
    protected int renderMode = 1;
    private CPoint[] pts = new CPoint[4];
    private Point2D[] pts2d = new Point2D[4];

    public Plane3DVc(T3DCapable t3dCapable) {
        this.t3dCapable = t3dCapable;
        this.t3dPlane = new T3DPlane(t3dCapable);
        this.t3dCapable.addPropertyChangeListener(this);
        this.setForeground(Color.green);
        for (int i = 0; i < 4; ++i) {
            this.pts[i] = new CPoint();
            this.pts2d[i] = new Point2D.Double();
        }
    }

    public void setRenderMode(int mode) {
        this.renderMode = mode;
    }

    public void paintComponent(Graphics g) {
        block13: {
            int i;
            Graphics2D g2;
            Line2D.Double l;
            CPoint dispt;
            block12: {
                block11: {
                    block10: {
                        dispt = new CPoint(1);
                        l = new Line2D.Double();
                        g2 = (Graphics2D)g;
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2.setColor(this.getForeground());
                        if (this.renderMode == 1) break block10;
                        if (this.renderMode != 2) break block11;
                    }
                    CPoint ul = new CPoint(2);
                    this.transform(new CPoint(0, 0, 0, 1), ul, (byte)2);
                    CPoint ur = new CPoint(2);
                    this.transform(new CPoint(this.getWidth(), 0, 0, 1), ur, (byte)2);
                    CPoint bl = new CPoint(2);
                    this.transform(new CPoint(0, this.getHeight(), 0, 1), bl, (byte)2);
                    if (this.t3dPlane.getIntersection(ul, ur, bl, this.pts[0], this.pts[1])) {
                        for (int i2 = 0; i2 < 2; ++i2) {
                            this.transform(this.pts[i2], dispt, (byte)1);
                            this.pts2d[i2].setLocation(dispt.x, dispt.y);
                        }
                        l.setLine(this.pts2d[0], this.pts2d[1]);
                        g2.draw(l);
                    }
                }
                if (this.renderMode == 0) break block12;
                if (this.renderMode != 2) break block13;
            }
            this.t3dPlane.getCorners(this.pts);
            for (i = 0; i < 4; ++i) {
                this.transform(this.pts[i], dispt, (byte)1);
                this.pts2d[i] = new Point2D.Double(dispt.x, dispt.y);
            }
            for (i = 0; i < 4; ++i) {
                int next = (i + 1) % 4;
                l.setLine(this.pts2d[i], this.pts2d[next]);
                g2.draw(l);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().compareTo("eyePoint") == 0) {
            this.t3dPlane.reloadEyePoint();
            this.repaint();
        } else if (evt.getPropertyName().compareTo("lookPoint") == 0) {
            this.t3dPlane.reloadLookPoint();
            this.repaint();
        } else if (evt.getPropertyName().compareTo("up") == 0) {
            this.t3dPlane.reloadUpVector();
            this.repaint();
        } else if (evt.getPropertyName().compareTo("viewHeight") == 0) {
            this.t3dPlane.reloadViewHeight();
            this.repaint();
        } else if (evt.getPropertyName().compareTo("aspectRatio") == 0) {
            this.t3dPlane.reloadAspectRatio();
            this.repaint();
        }
    }

    private class T3DPlane {
        protected JnVector3d lookPoint = null;
        protected JnVector3d eyePoint = null;
        protected JnVector3d upVector = null;
        protected double viewHeight;
        protected double aspectRatio;
        protected CPoint[] corners = new CPoint[4];
        protected T3DCapable t3d;
        private double[] look = new double[3];
        private double[] eye = new double[3];
        private double[] up = new double[3];
        private JnVector3d normal = new JnVector3d();
        private JnVector3d v0 = new JnVector3d();
        private JnVector3d v1 = new JnVector3d();
        private JnVector3d res = new JnVector3d();
        private boolean[] pos = new boolean[5];

        public T3DPlane(T3DCapable t3dCapable) {
            this.t3d = t3dCapable;
            this.lookPoint = new JnVector3d(this.t3d.getLookPoint(this.look));
            this.eyePoint = new JnVector3d(this.t3d.getEyePoint(this.eye));
            this.upVector = new JnVector3d(this.t3d.getUp(this.up));
            this.viewHeight = this.t3d.getViewHeight();
            this.aspectRatio = this.t3d.getAspectRatio();
            for (int i = 0; i < 4; ++i) {
                this.corners[i] = new CPoint(2);
            }
            this.loadCorners();
        }

        private void loadCorners() {
            double viewWidth = this.viewHeight * this.aspectRatio;
            JnVector3d lookVector = new JnVector3d();
            lookVector.sub(this.eyePoint, this.lookPoint);
            JnVector3d sideVector = JnVector3d.cross(this.upVector, lookVector);
            JnVector3d.cross(lookVector, sideVector);
            sideVector.scale(viewWidth / 2.0 / sideVector.magnitude());
            this.upVector.scale(this.viewHeight / 2.0 / this.upVector.magnitude());
            this.corners[0].set(this.lookPoint.x - sideVector.x + this.upVector.x, this.lookPoint.y - sideVector.y + this.upVector.y, this.lookPoint.z - sideVector.z + this.upVector.z);
            this.corners[1].set(this.lookPoint.x + sideVector.x + this.upVector.x, this.lookPoint.y + sideVector.y + this.upVector.y, this.lookPoint.z + sideVector.z + this.upVector.z);
            this.corners[2].set(this.lookPoint.x + sideVector.x - this.upVector.x, this.lookPoint.y + sideVector.y - this.upVector.y, this.lookPoint.z + sideVector.z - this.upVector.z);
            this.corners[3].set(this.lookPoint.x - sideVector.x - this.upVector.x, this.lookPoint.y - sideVector.y - this.upVector.y, this.lookPoint.z - sideVector.z - this.upVector.z);
        }

        private void rayPlane(double a, double b2, double c, double d, JnVector3d from, JnVector3d to, JnVector3d res) {
            double dx = to.x - from.x;
            double dy = to.y - from.y;
            double dz = to.z - from.z;
            double denom = a * dx + b2 * dy + c * dz;
            double num = d - a * from.x - b2 * from.y - c * from.z;
            double t = num / denom;
            res.set(from.x + t * dx, from.y + t * dy, from.z + t * dz);
        }

        public CPoint[] getIntersection(JnVector3d ul, JnVector3d ur, JnVector3d bl, CPoint[] result) {
            if (result == null || result.length < 2) {
                result = new CPoint[2];
            }
            if (result[0] == null) {
                result[0] = new CPoint();
            }
            if (result[1] == null) {
                result[1] = new CPoint();
            }
            if (!this.getIntersection(ul, ur, bl, result[0], result[1])) {
                return null;
            }
            return result;
        }

        public boolean getIntersection(JnVector3d ul, JnVector3d ur, JnVector3d bl, CPoint resultP1, CPoint resultP2) {
            this.v0.sub(ur, ul);
            this.v1.sub(bl, ul);
            JnVector3d.cross(this.v0, this.v1, this.normal);
            this.normal.normalize();
            double a = this.normal.x;
            double b2 = this.normal.y;
            double c = this.normal.z;
            double d = a * ul.x + b2 * ul.y + c * ul.z;
            int above = 0;
            int below = 0;
            for (int i = 0; i < 4; ++i) {
                boolean bl2 = this.pos[i] = d - a * this.corners[i].x - b2 * this.corners[i].y - c * this.corners[i].z > 0.0;
                if (this.pos[i]) {
                    ++above;
                    continue;
                }
                ++below;
            }
            int npts = 0;
            if (above != 4 && below != 4) {
                for (int j = 0; j < 4; ++j) {
                    if ((!this.pos[j % 4] || this.pos[(j + 1) % 4]) && (this.pos[j % 4] || !this.pos[(j + 1) % 4])) continue;
                    this.rayPlane(a, b2, c, d, this.corners[j % 4], this.corners[(j + 1) % 4], this.res);
                    if (npts == 0) {
                        resultP1.setPoint(this.res.x, this.res.y, this.res.z, (byte)2);
                    } else {
                        resultP2.setPoint(this.res.x, this.res.y, this.res.z, (byte)2);
                    }
                    ++npts;
                }
            }
            if (npts == 0) {
                resultP1.set(-1.0, -1.0, -1.0);
                resultP2.set(-1.0, -1.0, -1.0);
                return false;
            }
            return true;
        }

        public CPoint[] getCorners(CPoint[] points) {
            if (points == null) {
                points = new CPoint[4];
            }
            for (int i = 0; i < 4; ++i) {
                points[i] = new CPoint(this.corners[i]);
            }
            return points;
        }

        public void reloadEyePoint() {
            this.t3d.getEyePoint(this.eye);
            this.eyePoint.set(this.eye);
            this.loadCorners();
        }

        public void reloadLookPoint() {
            this.t3d.getLookPoint(this.look);
            this.lookPoint.set(this.look);
            this.loadCorners();
        }

        public void reloadUpVector() {
            this.t3d.getUp(this.up);
            this.upVector.set(this.up);
            this.loadCorners();
        }

        public void reloadViewHeight() {
            this.viewHeight = this.t3d.getViewHeight();
            this.loadCorners();
        }

        public void reloadAspectRatio() {
            this.aspectRatio = this.t3d.getAspectRatio();
            this.loadCorners();
        }
    }
}

