/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.Capable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpStackLayout;
import com.ge.med.terra.jami.capable.VrCapable;
import com.ge.med.terra.jami.j3d.DefaultT3DMouseController;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.vr.RayTracer;
import com.ge.med.terra.jami.j3d.vr.vr;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Icon3DViewport
extends JPanel
implements T3DCapable,
T3DRenderStyleCapable {
    private T3DComponent ic = new T3DComponent();

    public Icon3DViewport() {
        this.setLayout(new XpStackLayout());
        this.setRenderStyle("VOLUME");
        this.add(this.ic);
        this.ic.setIre(false);
        VrCapable vrc = (VrCapable)this.ic.getCapable("com.ge.med.terra.jami.capable.VrCapable");
        vrc.setRayTracer((RayTracer)new vr.RaySplitColorLut_i());
        DefaultT3DMouseController rmc = new DefaultT3DMouseController();
        this.ic.addMouseListener(rmc);
        this.ic.addMouseMotionListener(rmc);
        this.ic.addMouseWheelListener(rmc);
        rmc.setTarget(this.ic);
    }

    public void loadVolumeModelClone(J3DVolumeModel j3dvm) {
        J3DVolumeModel clonevm = (J3DVolumeModel)j3dvm.clone();
        this.ic.setVolumeModel(clonevm);
    }

    public T3DComponent getT3DComponent() {
        return this.ic;
    }

    public void setViewRegion(byte[] bgrid) {
        VrCapable vrc = (VrCapable)this.ic.getCapable(VrCapable.class.getCanonicalName());
        if (vrc != null) {
            vrc.clearSegmentation();
            vrc.applySegmentation(bgrid);
        }
    }

    public void setView(int[] origin, int[] dims) {
        J3DVolumeModel vm = (J3DVolumeModel)this.ic.getVolumeModel();
        if (vm != null) {
            double[] up = this.ic.getUp(null);
            double[] lp = this.ic.getLookPoint(null);
            double[] ep = this.ic.getEyePoint(null);
            double[] view = new double[3];
            JnVector3d.sub(ep, lp, view);
            int cx = origin[0] + (dims[0] >> 1);
            int cy = origin[1] + (dims[1] >> 1);
            int cz = origin[2] + (dims[2] >> 1);
            CPoint center = new CPoint(cx, cy, cz, 5);
            CPoint lpres = new CPoint(2);
            CTransform t = this.ic.getTransform((byte)5, (byte)2);
            t.transform(center, lpres);
            JnVector3d.add(lpres.generateArray(), view, ep);
            CPoint dims_p = new CPoint(dims[0], dims[1], dims[2], 5);
            CPoint raspt0 = new CPoint(2);
            t.transform(dims_p, raspt0);
            double height = JnVector3d.distance(raspt0.generateArray(), vm.xj_vol.getRASOfOrigin(null));
            this.ic.setViewHeight(height);
            this.ic.setCamera(ep, lp, up);
            this.repaint();
        }
    }

    public void setCamera(double[] eyepoint, double[] lookpoint, double[] up) {
        this.ic.setCamera(eyepoint, lookpoint, up);
    }

    public double[] getEyePoint(double[] eye_pt) {
        return this.ic.getEyePoint(eye_pt);
    }

    public double[] getLookPoint(double[] look_pt) {
        return this.ic.getLookPoint(look_pt);
    }

    public double[] getUp(double[] up_v) {
        return this.ic.getUp(up_v);
    }

    public double getViewHeight() {
        return this.ic.getViewHeight();
    }

    public void setVolumeModel(XjVolumeModel vm) {
        this.ic.setVolumeModel(vm);
    }

    public XjVolumeModel getVolumeModel() {
        return this.ic.getVolumeModel();
    }

    public void getWorldBounds(double[] ulc, double[] xside, double[] yside, double[] zside) {
        this.ic.getWorldBounds(ulc, xside, yside, zside);
    }

    public void setAspectRatio(double aspect) {
        this.ic.setAspectRatio(aspect);
    }

    public void setEyePoint(double[] point) {
        this.ic.setEyePoint(point);
    }

    public void setLookPoint(double[] point) {
        this.ic.setLookPoint(point);
    }

    public void setPerspective(boolean b2) {
        this.ic.setPerspective(b2);
    }

    public void setRenderStyle(String style) {
        this.ic.setRenderStyle(style);
    }

    public void setUp(double[] up) {
        this.ic.setUp(up);
    }

    public double[] getViewClip(double[] view_clip) {
        return this.ic.getViewClip(view_clip);
    }

    public void setViewClip(double[] clipOffsets) {
        this.ic.setViewClip(clipOffsets);
    }

    public void setViewHeight(double height) {
        this.ic.setViewHeight(height);
    }

    public boolean isPerspective() {
        return this.ic.isPerspective();
    }

    public double getAspectRatio() {
        return this.ic.getAspectRatio();
    }

    public String getRenderStyle() {
        return this.ic.getRenderStyle();
    }

    public String[] getSupportedRenderStyles() {
        return this.ic.getSupportedRenderStyles();
    }

    public Capable getCapable(String capableIFName) {
        Capable c = null;
        try {
            Class<?> cap = this.getClass();
            Class<?> cl = Class.forName(capableIFName);
            if (cl.isAssignableFrom(cap) && cl.isInstance(this)) {
                c = this;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (c == null && this.ic != null) {
            c = this.ic.getCapable(capableIFName);
        }
        return c;
    }

    public boolean isAutoRepaint() {
        return this.ic.isAutoRepaint();
    }

    public void setAutoRepaint(boolean autoRepaint) {
        this.ic.setAutoRepaint(autoRepaint);
    }

    public static void main(String[] args) {
        int DIM = 256;
        JFrame jf = new JFrame("Icon3DViewport");
        JPanel iconpanel = new JPanel();
        Icon3DViewport ic0 = new Icon3DViewport();
        Icon3DViewport ic1 = new Icon3DViewport();
        ic0.setPreferredSize(new Dimension(256, 256));
        ic1.setPreferredSize(new Dimension(256, 256));
        iconpanel.setLayout(new BorderLayout());
        DMSession dms = new DMSession(new String[]{"file", args[0]});
        DMObject[] dmo = dms.getRelated("series");
        DMVolume vol = DMVolume.buildVolume((String)"DMObjectVolume", (Object[])new Object[]{dmo[0]});
        J3DVolumeModel j3dvm = new J3DVolumeModel((XjVolumeInfo)vol);
        j3dvm.init();
        byte[] seg0 = new byte[j3dvm.vr_context.getBingrid().length];
        byte[] seg1 = new byte[j3dvm.vr_context.getBingrid().length];
        Arrays.fill(seg0, 0, seg0.length >> 1, (byte)-1);
        Arrays.fill(seg1, seg1.length >> 1, seg1.length - 1, (byte)-1);
        ic0.loadVolumeModelClone(j3dvm);
        ic1.loadVolumeModelClone(j3dvm);
        ic1.setViewRegion(seg1);
        int dx = j3dvm.j_vol.dx;
        int dy = j3dvm.j_vol.dy;
        int dz = j3dvm.j_vol.dz;
        ic1.setView(new int[]{0, 0, dz >> 1}, new int[]{dx, dy, dz >> 1});
        iconpanel.add((Component)ic0, "Center");
        iconpanel.add((Component)ic1, "East");
        jf.setContentPane(iconpanel);
        jf.setDefaultCloseOperation(3);
        jf.pack();
        jf.setVisible(true);
    }
}

