/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.jnu.geom.VolumeUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;

public class CrossHairCursor3DVc
extends Cursor3DVc {
    private static final int TOL = 5;
    private static final int CENTER_TOL = 20;
    boolean dragx;
    boolean dragy;

    public boolean contains(int x, int y) {
        boolean b2 = super.contains(x, y);
        if (!this.enabled_) {
            return false;
        }
        if (!(this.cursorModel_ == null || activeVc != this && this.cursorModel_.isOutOfObject())) {
            return b2 || Math.abs(x - this.centerx_) <= 5 || Math.abs(this.centery_ - y) <= 5;
        }
        return false;
    }

    public void mouseDragged(MouseEvent e) {
        int cy;
        int cx = this.dragx ? e.getX() - this.offsetX_ : this.centerx_;
        int n = cy = this.dragy ? e.getY() - this.offsetY_ : this.centery_;
        if (cx < 0 || cx >= this.getWidth() || cy < 0 || cy >= this.getHeight()) {
            return;
        }
        if (this.engine_ != null) {
            double[] projectionRAS = GeomUtils.DisplayToRAS((int[])new int[]{cx, cy, 0}, (double[])this.engine_.getEyePoint(null), (double[])this.engine_.getLookPoint(null), (double[])this.engine_.getUp(null), (double)this.engine_.getViewHeight(), (int)this.getWidth(), (int)this.getHeight(), (double[])new double[3]);
            double[] ulc = new double[3];
            double[] xside = new double[3];
            double[] yside = new double[3];
            double[] zside = new double[3];
            this.engine_.getWorldBounds(ulc, xside, yside, zside);
            if (!VolumeUtils.isInVolume((double[])projectionRAS, (double[])ulc, (double[])xside, (double[])yside, (double[])zside, (int[])new int[]{1, 1, 1})) {
                return;
            }
        }
        CPoint pt = this.computeNewCursorPosition(cx, cy, e.getComponent().getWidth(), e.getComponent().getHeight());
        if (this.isContinuousUpdateEnabled()) {
            if (pt == null) {
                System.err.println("Out of Object!!!!!!!!!!!");
                this.cursorModel_.setOutOfObject(true);
            } else {
                this.cursorModel_.setOutOfObject(false);
                this.cursorModel_.setPoint(new CPoint(pt.generateArray(), 2));
            }
        }
        this.centerx_ = cx;
        this.centery_ = cy;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (super.contains(e.getX(), e.getY())) {
            this.dragx = true;
            this.dragy = true;
        } else {
            this.dragx = Math.abs(e.getX() - this.centerx_) < 5;
            this.dragy = Math.abs(e.getY() - this.centery_) < 5;
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (!this.driving_ && !this.cursorModel_.isOutOfObject()) {
            this.compute(this.getWidth(), this.getHeight());
        }
        int thickness = 3;
        boolean halft = true;
        if (this.driving_ || !this.cursorModel_.isOutOfObject() || activeVc == this) {
            T3DRenderStyleCapable trc;
            g2d.setColor(SHADOW_COLOR);
            g2d.fillRect(this.centerx_ - 1, 0, 3, this.getHeight());
            g2d.fillRect(0, this.centery_ - 1, this.getWidth(), 3);
            double tol = 0.1;
            g2d.setColor(Math.abs(this.delta_.z * this.delta_.z) > 0.1 || !this.isContinuousUpdateEnabled() && this.driving_ ? this.offPlaneCursorColor_ : this.getCursorColor());
            if (this.engine_ instanceof T3DRenderStyleCapable && "VOLUME".equals((trc = (T3DRenderStyleCapable)((Object)this.engine_)).getRenderStyle())) {
                g2d.setColor(this.getCursorColor());
            }
            if (this.cursorModel_.isOutOfObject() && activeVc == this) {
                g2d.setColor(OOO_COLOR);
            }
            g2d.fillRect(this.centerx_ - 0, 0, 1, this.getHeight());
            g2d.fillRect(0, this.centery_ - 0, this.getWidth(), 1);
        } else if (activeVc != this) {
            graphics.setColor(Color.BLUE);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public CrossHairCursor3DVc(Cursor3DModel cursorModel, T3DCapable engine) {
        super(cursorModel, engine);
    }
}

