/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image;

import com.ge.med.terra.jami.XpLog;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class XpImageData {
    public static BufferedImage createCompatibleBufferedImage(RenderedImage base) {
        int w = base.getWidth();
        int h = base.getHeight();
        WritableRaster wr = base.getData().createCompatibleWritableRaster(w, h);
        return new BufferedImage(base.getColorModel(), wr, false, null);
    }

    public static DataBuffer getDataBuffer(RenderedImage ri) {
        if (ri instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)ri;
            return bi.getRaster().getDataBuffer();
        }
        return ri.getData().getDataBuffer();
    }

    public static BufferedImage createBufferedImage(Image image) {
        Object[] pixels;
        if (image instanceof RenderedImage) {
            return (BufferedImage)image;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            h = -1;
            w = -1;
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, w, h, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            XpLog.logger().severe("Interrupted waiting for pixels: " + e.getLocalizedMessage());
            return null;
        }
        if (0 != (pg.getStatus() & 0x80)) {
            XpLog.logger().severe("Image fetch aborted or errored");
            return null;
        }
        DataBuffer buffer = null;
        Object pgData = pg.getPixels();
        w = pg.getWidth();
        h = pg.getHeight();
        if (pgData instanceof int[]) {
            pixels = (int[])pgData;
            buffer = new DataBufferInt((int[])pixels, w * h);
        } else if (pgData instanceof byte[]) {
            pixels = (byte[])pgData;
            buffer = new DataBufferByte((byte[])pixels, w * h);
        } else if (pgData instanceof short[]) {
            pixels = (short[])pgData;
            buffer = new DataBufferShort((short[])pixels, w * h);
        } else {
            XpLog.logger().severe("Not usable pixels: " + pgData);
            return null;
        }
        SampleModel sm = pg.getColorModel().createCompatibleSampleModel(w, h);
        WritableRaster raster = Raster.createWritableRaster(sm, buffer, new Point(0, 0));
        return new BufferedImage(pg.getColorModel(), raster, false, null);
    }
}

