/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image;

import com.ge.med.idc.RemoteImage;
import com.ge.med.idc.XjImage;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.remote.XpRemoteMedicalImage;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.util.StringTokenizer;

public class XjMedicalImage
implements XpMedicalImage {
    private XjImage image = null;
    private XpSlice slice = null;
    private double deflevel = 0.0;
    private double defwidth = 0.0;
    private double rescaleIntercept = 0.0;
    private double rescaleSlope = 1.0;
    private double azimuth = 0.0;
    private boolean loadedDefWL = false;
    private boolean loadedDefWW = false;
    private double[] minmax = new double[2];
    private boolean init = false;

    public String getFilePath() {
        return this.image.getFilePath();
    }

    protected XjImage getXjImage() {
        return this.image;
    }

    public XjMedicalImage(XjImage image) {
        this.image = image;
    }

    public final int getValues(XpDicomElement[] values) {
        boolean allLoaded = true;
        for (int i = 0; i < values.length; ++i) {
            int result = this.getValue(values[i]);
            if (result != 1) continue;
            allLoaded = false;
        }
        if (allLoaded) {
            return 0;
        }
        return 1;
    }

    public final int getValue(XpDicomElement value) {
        value.value = this.image.getValue(value.group, value.element);
        return value.value != null ? 0 : 1;
    }

    public RenderedImage getPixelData() {
        this.initImage();
        return this.image.getImageData();
    }

    public final double getPixelDimensionX() {
        return this.getSlice().pixelSizeX;
    }

    public final double getPixelDimensionY() {
        return this.getSlice().pixelSizeY;
    }

    public final XpSlice getSlice() {
        this.initImage();
        return this.slice;
    }

    public final double getDefaultWindowWidth() {
        this.initImage();
        if (!this.loadedDefWW) {
            int subsample = 17;
            if (this.slice.width <= 128 && this.slice.height <= 128) {
                subsample = 5;
            }
            XpImageUtils.getMinMax(this, subsample, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.defwidth;
    }

    public final double getDefaultWindowLevel() {
        this.initImage();
        if (!this.loadedDefWL) {
            int subsample = 16;
            if (this.slice.width <= 128 && this.slice.height <= 128) {
                subsample = 4;
            }
            XpImageUtils.getMinMax(this, subsample, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.deflevel;
    }

    public final double getRescaleIntercept() {
        this.initImage();
        return this.rescaleIntercept;
    }

    public final double getRescaleSlope() {
        this.initImage();
        return this.rescaleSlope;
    }

    public final double getAzimuth() {
        this.initImage();
        return this.azimuth;
    }

    protected void initImage() {
        StringTokenizer st;
        String snum;
        StringTokenizer st2;
        if (this.init) {
            return;
        }
        this.slice = new XpSlice(this);
        Object obj = this.image.getValue(40, 4176);
        if (obj instanceof String) {
            st2 = new StringTokenizer((String)obj, "\\");
            try {
                this.deflevel = Float.parseFloat(st2.nextToken());
                this.loadedDefWL = true;
            }
            catch (Exception e) {
                XpLog.warning("Invalid tag in image (0x0028,0x1050)");
            }
        } else if (obj instanceof Integer) {
            this.deflevel = ((Integer)obj).intValue();
            this.loadedDefWL = true;
        }
        if ((obj = this.image.getValue(40, 4177)) instanceof String) {
            st2 = new StringTokenizer((String)obj, "\\");
            try {
                this.defwidth = Float.parseFloat(st2.nextToken());
                this.loadedDefWW = true;
            }
            catch (Exception e) {
                XpLog.warning("Invalid tag in image (0x0028,0x1051)");
            }
        } else if (obj instanceof Integer) {
            this.defwidth = ((Integer)obj).intValue();
            this.loadedDefWW = true;
        }
        if ((obj = this.image.getValue(40, 4178)) instanceof String) {
            snum = (String)obj;
            if (snum.length() <= 0) {
                snum = "0";
            }
            st = new StringTokenizer(snum, "\\");
            try {
                this.rescaleIntercept = Double.parseDouble(st.nextToken());
            }
            catch (Exception e) {
                XpLog.warning("Invalid tag in image (0x0028,0x1052)");
            }
        } else if (obj instanceof Number) {
            this.rescaleIntercept = ((Number)obj).doubleValue();
        }
        if ((obj = this.image.getValue(40, 4179)) instanceof String) {
            snum = (String)obj;
            if (snum.length() <= 0) {
                snum = "1";
            }
            st = new StringTokenizer(snum, "\\");
            try {
                this.rescaleSlope = Double.parseDouble(st.nextToken());
            }
            catch (Exception e) {
                XpLog.warning("Invalid tag in image (0x0028,0x1053)");
            }
        } else if (obj instanceof Number) {
            this.rescaleSlope = ((Number)obj).doubleValue();
        }
        if (this.rescaleSlope == 0.0) {
            this.rescaleSlope = 1.0;
        }
        this.azimuth = XpImageUtils.gehcAzimuth(this);
        if (this.slice.width == 0 || this.slice.height == 0) {
            this.slice.width = this.image.getWidth();
            this.slice.height = this.image.getHeight();
        }
        this.init = true;
    }

    public static XpMedicalImage[] createImages(XjImage[] imgs) {
        XpMedicalImage[] retimgs = new XpMedicalImage[imgs.length];
        for (int i = 0; i < imgs.length; ++i) {
            retimgs[i] = XjMedicalImage.createImage(imgs[i]);
        }
        return retimgs;
    }

    public static XpMedicalImage createImage(XjImage img) {
        if (img instanceof RemoteImage) {
            return new Remote((RemoteImage)img);
        }
        if (img != null) {
            return new XjMedicalImage(img);
        }
        return null;
    }

    private static class Remote
    extends XjMedicalImage
    implements XpRemoteMedicalImage {
        public Remote(RemoteImage img) {
            super(img);
        }

        public String getRemoteDescriptor() {
            return ((RemoteImage)this.getXjImage()).getRemoteDescriptor();
        }

        public double[] getStatistics(Shape s, double angle) {
            return ((RemoteImage)this.getXjImage()).getStatistics(s, angle);
        }

        public int[] getPixels(int x, int y, int w, int h, int[] pixels) {
            return ((RemoteImage)this.getXjImage()).getPixels(x, y, w, h, pixels);
        }
    }
}

