/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.annotation;

import com.ge.med.terra.jami.CPoint;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;

public class XpRASAnnotation {
    private static final DecimalFormat df = new DecimalFormat("###0");
    private static final double TOLERANCE = 0.1;
    private static final DeltaCmp deltacomp = new DeltaCmp();
    private CPoint bl = new CPoint(2);
    private CPoint center = new CPoint(2);
    private delta_s[] dnord = new delta_s[3];
    private delta_s[] dsud = new delta_s[3];
    private delta_s[] dest = new delta_s[3];
    private delta_s[] douest = new delta_s[3];
    private String nord = "";
    private String sud = "";
    private String est = "";
    private String ouest = "";

    public XpRASAnnotation() {
        for (int i = 0; i < this.dnord.length; ++i) {
            this.dnord[i] = new delta_s();
            this.dsud[i] = new delta_s();
            this.dest[i] = new delta_s();
            this.douest[i] = new delta_s();
        }
    }

    public final void set(CPoint ul, CPoint ur, CPoint br) {
        this.bl.x = br.x + (ul.x - ur.x);
        this.bl.y = br.y + (ul.y - ur.y);
        this.bl.z = br.z + (ul.z - ur.z);
        this.center.x = 0.25 * (ul.x + ur.x + br.x + this.bl.x);
        this.center.y = 0.25 * (ul.y + ur.y + br.y + this.bl.y);
        this.center.z = 0.25 * (ul.z + ur.z + br.z + this.bl.z);
        XpRASAnnotation.compute_edge_delta(ul, ur, this.center, this.dnord);
        XpRASAnnotation.compute_edge_delta(this.bl, br, this.center, this.dsud);
        XpRASAnnotation.compute_edge_delta(ur, br, this.center, this.dest);
        XpRASAnnotation.compute_edge_delta(ul, this.bl, this.center, this.douest);
        this.nord = XpRASAnnotation.edge_annotation(this.dnord, this.dsud);
        this.sud = XpRASAnnotation.edge_annotation(this.dsud, this.dnord);
        this.est = XpRASAnnotation.edge_annotation(this.dest, this.douest);
        this.ouest = XpRASAnnotation.edge_annotation(this.douest, this.dest);
    }

    public final String getNorth() {
        return this.nord;
    }

    public final String getSouth() {
        return this.sud;
    }

    public final String getEast() {
        return this.est;
    }

    public final String getWest() {
        return this.ouest;
    }

    private static boolean is_zero(double f) {
        return f < 0.1 && f > -0.1;
    }

    private static void compute_edge_delta(CPoint A, CPoint B, CPoint center, delta_s[] delta) {
        String[] letters = new String[]{"RL", "AP", "SI"};
        delta[0].diff = B.x - A.x;
        delta[0].absv = 0.5 * (B.x + A.x);
        delta[0].relv = delta[0].absv - center.x;
        delta[1].diff = B.y - A.y;
        delta[1].absv = 0.5 * (B.y + A.y);
        delta[1].relv = delta[1].absv - center.y;
        delta[2].diff = B.z - A.z;
        delta[2].absv = 0.5 * (B.z + A.z);
        delta[2].relv = delta[2].absv - center.z;
        for (int i = 0; i < 3; ++i) {
            delta[i].index = i;
            delta[i].absc = letters[i].charAt(delta[i].absv > 0.0 ? 0 : 1);
            delta[i].relc = letters[i].charAt(delta[i].relv > 0.0 ? 0 : 1);
        }
        Arrays.sort(delta, deltacomp);
    }

    private static delta_s find_delta(delta_s[] delta, int index) {
        for (int i = 0; i < 3; ++i) {
            if (index != delta[i].index) continue;
            return delta[i];
        }
        return delta[0];
    }

    private static String edge_annotation(delta_s[] delta, delta_s[] opposing_delta) {
        delta_s opp;
        int i;
        int which_delta = 0;
        int n_result = 0;
        int n_diff = 0;
        String res = "";
        for (i = 0; i < 3; ++i) {
            opp = XpRASAnnotation.find_delta(opposing_delta, delta[i].index);
            if (XpRASAnnotation.is_zero(delta[i].absv - opp.absv)) continue;
            if (XpRASAnnotation.is_zero(delta[i].diff)) {
                which_delta = i;
                res = res + delta[i].absc;
                ++n_result;
                continue;
            }
            ++n_diff;
        }
        if (n_result != 1 || n_diff > 0) {
            res = "";
            n_result = 0;
            for (i = 0; i < 3; ++i) {
                opp = XpRASAnnotation.find_delta(opposing_delta, delta[i].index);
                if (delta[i].relc == opp.relc || XpRASAnnotation.is_zero(delta[i].relv)) continue;
                which_delta = i;
                res = res + delta[i].relc;
                ++n_result;
            }
        } else {
            double v = Math.floor(Math.abs(delta[which_delta].absv) + 0.499);
            res = res + df.format(v);
        }
        return res;
    }

    private static class DeltaCmp
    implements Comparator {
        private DeltaCmp() {
        }

        public int compare(Object A, Object B) {
            double adiff;
            delta_s a = (delta_s)A;
            delta_s b2 = (delta_s)B;
            double bdiff = b2.diff > 0.0 ? b2.diff : -b2.diff;
            double diff = bdiff - (adiff = a.diff > 0.0 ? a.diff : -a.diff);
            if (XpRASAnnotation.is_zero(diff)) {
                double brelv;
                double arelv = a.relv > 0.0 ? a.relv : -a.relv;
                double d = brelv = b2.relv > 0.0 ? b2.relv : -b2.relv;
                if (!XpRASAnnotation.is_zero(arelv - brelv)) {
                    if (arelv > brelv) {
                        return -1;
                    }
                    return 1;
                }
                if (a.index < b2.index) {
                    return -1;
                }
                if (a.index > b2.index) {
                    return 1;
                }
                return 0;
            }
            return diff > 0.0 ? -1 : 1;
        }
    }

    private class delta_s {
        public double diff;
        public double absv;
        public double relv;
        public int index;
        public char absc;
        public char relc;

        private delta_s() {
        }
    }
}

