/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpStackLayout;
import com.ge.med.terra.jami.capable.CTransformCapable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class XpVisualComponent
extends JComponent
implements CTransformCapable,
ComponentListener {
    private static CTransform flipRAS2LPS = new CTransform();
    private Rectangle containBuf = new Rectangle();
    private Rectangle tempRect1 = new Rectangle();
    private CPoint imgPoint = new CPoint(0);
    private CPoint dispPoint = new CPoint(1);
    private CTransform normToDisplay = new CTransform();
    private CTransform dispToNorm = new CTransform();

    public XpVisualComponent(String name) {
        this.setName(name);
        this.setPreferredSize(new Dimension(256, 256));
        this.setLayout(new XpStackLayout());
        this.setOpaque(false);
        this.normToDisplay.loadIdentity();
        this.dispToNorm.loadIdentity();
        this.addComponentListener(this);
    }

    protected final CTransform getRAS2LPS() {
        return flipRAS2LPS;
    }

    public XpVisualComponent() {
        this("XpVisualComponent");
    }

    public final XpVisualComponent getXpVisualComponentParent() {
        Container c = this.getParent();
        if (c instanceof XpVisualComponent) {
            return (XpVisualComponent)c;
        }
        return null;
    }

    public boolean contains(int x, int y) {
        Component[] child = this.getComponents();
        for (int i = 0; i < child.length; ++i) {
            child[i].getBounds(this.containBuf);
            if (!child[i].contains(x - this.containBuf.x, y - this.containBuf.y)) continue;
            return true;
        }
        return false;
    }

    public final boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public final synchronized String getTreeDiagram() {
        String s = this.getName() + "[";
        Component[] child = this.getComponents();
        boolean first = true;
        for (int i = 0; i < child.length; ++i) {
            if (!(child[i] instanceof XpVisualComponent)) continue;
            XpVisualComponent vc = (XpVisualComponent)child[i];
            s = first ? s + vc.getClass().getName() + "(" + vc.getName() + ")" : s + ", " + vc.getName();
            first = false;
        }
        s = s + "]";
        return s;
    }

    public final boolean transformDisplayToImage(Point2D inPt, Point2D out) {
        this.dispPoint.setLocation(inPt.getX(), inPt.getY(), 0.0);
        this.transform(this.dispPoint, this.imgPoint, (byte)0);
        out.setLocation(this.imgPoint.x, this.imgPoint.y);
        return true;
    }

    public final boolean transformDisplayToImage(Point inPt, Point2D out) {
        this.dispPoint.setLocation(inPt.x, inPt.y, 0.0);
        this.transform(this.dispPoint, this.imgPoint, (byte)0);
        out.setLocation(this.imgPoint.x, this.imgPoint.y);
        return true;
    }

    public final boolean transformImageToDisplay(Point2D inPt, Point2D out) {
        this.imgPoint.setLocation(inPt.getX(), inPt.getY(), 0.0);
        this.transform(this.imgPoint, this.dispPoint, (byte)1);
        out.setLocation(this.dispPoint.x, this.dispPoint.y);
        return true;
    }

    public final boolean transform(CPoint inPt, CPoint out, byte csystem) {
        if (inPt.csystem == csystem) {
            out.setPoint(inPt);
            return true;
        }
        CTransform t = this.getTransform(inPt.csystem, csystem);
        if (t != null) {
            out.setPoint(inPt);
            t.transform(out);
            out.csystem = csystem;
            return true;
        }
        return false;
    }

    public final CPoint transform(CPoint inPt, byte csystem) {
        CPoint out = new CPoint();
        boolean res = this.transform(inPt, out, csystem);
        if (res) {
            return out;
        }
        return null;
    }

    public CTransform getTransform(byte inCoord, byte outCoord) {
        if (inCoord == outCoord) {
            return CTransform.Identity;
        }
        if (inCoord == 3) {
            this.getBounds(this.tempRect1);
            int dispWidth = this.tempRect1.width;
            int dispHeight = this.tempRect1.height;
            CTransform ct = this.getClassicTransform((byte)1, outCoord);
            this.normToDisplay.load(ct);
            this.normToDisplay.m[0] = this.normToDisplay.m[0] * (double)dispWidth;
            this.normToDisplay.m[4] = this.normToDisplay.m[4] * (double)dispWidth;
            this.normToDisplay.m[8] = this.normToDisplay.m[8] * (double)dispWidth;
            this.normToDisplay.m[12] = this.normToDisplay.m[12] * (double)dispWidth;
            this.normToDisplay.m[1] = this.normToDisplay.m[1] * (double)dispHeight;
            this.normToDisplay.m[5] = this.normToDisplay.m[5] * (double)dispHeight;
            this.normToDisplay.m[9] = this.normToDisplay.m[9] * (double)dispHeight;
            this.normToDisplay.m[13] = this.normToDisplay.m[13] * (double)dispHeight;
            return this.normToDisplay;
        }
        if (outCoord == 3) {
            this.getBounds(this.tempRect1);
            int dispWidth = this.tempRect1.width;
            int dispHeight = this.tempRect1.height;
            CTransform ct = this.getClassicTransform(inCoord, (byte)1);
            this.dispToNorm.load(ct);
            double sx = 1.0 / (double)dispWidth;
            double sy = 1.0 / (double)dispHeight;
            this.dispToNorm.m[0] = this.dispToNorm.m[0] * sx;
            this.dispToNorm.m[1] = this.dispToNorm.m[1] * sx;
            this.dispToNorm.m[2] = this.dispToNorm.m[2] * sx;
            this.dispToNorm.m[3] = this.dispToNorm.m[3] * sx;
            this.dispToNorm.m[4] = this.dispToNorm.m[4] * sy;
            this.dispToNorm.m[5] = this.dispToNorm.m[5] * sy;
            this.dispToNorm.m[6] = this.dispToNorm.m[6] * sy;
            this.dispToNorm.m[7] = this.dispToNorm.m[7] * sy;
            return this.dispToNorm;
        }
        return this.getClassicTransform(inCoord, outCoord);
    }

    private CTransform getClassicTransform(byte inCoord, byte outCoord) {
        if (inCoord == outCoord) {
            return CTransform.Identity;
        }
        if (inCoord == 2 && outCoord == 4) {
            return this.getRAS2LPS();
        }
        if (inCoord == 4 && outCoord == 2) {
            return this.getRAS2LPS();
        }
        XpVisualComponent parent = this.getXpVisualComponentParent();
        if (parent != null) {
            return parent.getTransform(inCoord, outCoord);
        }
        return CTransform.Identity;
    }

    public final Component findParentByClass(Component co, Class c) {
        Container parent = co.getParent();
        if (parent == null) {
            return null;
        }
        if (c.isInstance(parent)) {
            return parent;
        }
        return this.findParentByClass(parent, c);
    }

    public final XpVisualComponent findXpVisualComponentByName(String name) {
        Component[] child = this.getComponents();
        for (int i = 0; i < child.length; ++i) {
            if (!(child[i] instanceof XpVisualComponent)) continue;
            XpVisualComponent vc = (XpVisualComponent)child[i];
            if (vc.getName().equals(name)) {
                return vc;
            }
            if ((vc = vc.findXpVisualComponentByName(name)) == null) continue;
            return vc;
        }
        return null;
    }

    public final XpVisualComponent findXpVcByClass(Class c) {
        if (c.isInstance(this)) {
            return this;
        }
        Component[] child = this.getComponents();
        for (int i = 0; i < child.length; ++i) {
            if (!(child[i] instanceof XpVisualComponent)) continue;
            XpVisualComponent vc = (XpVisualComponent)child[i];
            if ((vc = vc.findXpVcByClass(c)) == null) continue;
            return vc;
        }
        return null;
    }

    public boolean isAutoRepaint() {
        return false;
    }

    public void setAutoRepaint(boolean autoRepaint) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public Capable getCapable(String capableIFName) {
        try {
            Class<Capable> cap = Capable.class;
            Class<?> cl = Class.forName(capableIFName);
            if (cap.isAssignableFrom(cl) && cl.isInstance(this)) {
                return this;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    static {
        flipRAS2LPS.loadIdentity();
        XpVisualComponent.flipRAS2LPS.m[0] = -1.0;
        XpVisualComponent.flipRAS2LPS.m[5] = -1.0;
    }
}

