/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.ComponentCreator;
import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpComponentCreator;
import com.ge.med.terra.jami.XpUserAnnotationVc;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Shape;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class XpUserAnnotationModel
implements Serializable,
Selectable,
KeyListener,
Replicable {
    public static final int POINTER_CIRCLE = 0;
    public static final int POINTER_ARROW = 1;
    private static Color dselColor = XpAppContext.getSelectedColor();
    private static Color duselColor = XpAppContext.getUnSelectedColor();
    private static Border duselBorder = BorderFactory.createLineBorder(duselColor);
    private static Border dselBorder = BorderFactory.createLineBorder(dselColor);
    private Color selectedColor = dselColor;
    private Color unselectedColor = duselColor;
    private Border unselectedBorder = duselBorder;
    private Border selectedBorder = dselBorder;
    private Font textFont = null;
    private transient XpUserAnnotationVc uavc = null;
    private String text = "";
    private CPoint textAnchor = new CPoint();
    private CPoint target = new CPoint();
    private double width = 100.0;
    private double height = 40.0;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean selected = false;
    private boolean showTarget = true;
    private boolean showBorder = true;
    private boolean resize = true;
    private boolean editable = true;
    private boolean bVisible = true;
    private boolean autoResize = true;
    private int pointerShape = 1;
    private List mListeners = new ArrayList();
    private List mmListeners = new ArrayList();
    private List keyListeners = new ArrayList();
    private List focusListeners = new ArrayList();
    private boolean moveHandleFilled = true;
    private boolean resizeHandleFilled = false;
    private transient Rectangle2D moveShape = new Rectangle2D.Double();
    private transient Rectangle2D resizeShape = new Rectangle2D.Double();
    private static Cursor resizeCursor = null;
    private static Cursor moveCursor = null;
    private static Cursor selectionCursor = null;

    public XpUserAnnotationModel(String text, CPoint textAnchor, CPoint target) {
        this.text = text;
        this.textAnchor = textAnchor;
        this.target = target;
    }

    public Dimension getSize() {
        return new Dimension((int)this.width, (int)this.height);
    }

    protected void copyObject(Object o) {
        XpUserAnnotationModel uam = (XpUserAnnotationModel)o;
        uam.text = this.uavc != null ? this.uavc.getTextArea().getText() : this.text;
        uam.textAnchor = (CPoint)this.textAnchor.clone();
        uam.target = (CPoint)this.target.clone();
        uam.width = this.width;
        uam.height = this.height;
        this.copyListeners("COMPONENT_SELECTED", uam);
        this.copyListeners("COMPONENT_UNSELECTED", uam);
        uam.selected = this.selected;
        uam.showTarget = this.showTarget;
        uam.showBorder = this.showBorder;
        uam.resize = this.resize;
        uam.editable = this.editable;
        uam.bVisible = this.bVisible;
        uam.setUnselectedColor(this.unselectedColor);
        uam.setSelectedColor(this.selectedColor);
    }

    private void copyListeners(String propertyName, XpUserAnnotationModel uam) {
        PropertyChangeListener[] pcl = this.pcs.getPropertyChangeListeners(propertyName);
        if (pcl != null) {
            for (int i = 0; i < pcl.length; ++i) {
                uam.pcs.addPropertyChangeListener(propertyName, pcl[i]);
            }
        }
    }

    public Object clone() {
        XpUserAnnotationModel uam = new XpUserAnnotationModel("", null, null);
        this.copyObject(uam);
        return uam;
    }

    public boolean isMoveHandleFilled() {
        return this.moveHandleFilled;
    }

    public void setMoveHandleFilled(boolean isFilled) {
        this.moveHandleFilled = isFilled;
    }

    public boolean isResizeHandleFilled() {
        return this.resizeHandleFilled;
    }

    public void setResizeHandleFilled(boolean isFilled) {
        this.resizeHandleFilled = isFilled;
    }

    public void setUserAnnotationVc(XpUserAnnotationVc new_uavc) {
        if (this.uavc != null) {
            this.uavc.getTextArea().removeKeyListener(this);
        }
        this.uavc = new_uavc;
        if (this.uavc != null) {
            this.uavc.getTextArea().addKeyListener(this);
        }
        if (this.uavc != null) {
            this.uavc.setVisible(this.isVisible());
        }
    }

    public final XpUserAnnotationVc getUserAnnotationVc() {
        return this.uavc;
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setEditable(boolean editable) {
        if (!editable && this.isSelected()) {
            this.setSelected(false);
        }
        this.editable = editable;
    }

    public final boolean isResize() {
        return this.resize;
    }

    public final void setResize(boolean resize) {
        this.resize = resize;
    }

    public final boolean isVisible() {
        return this.bVisible;
    }

    public final void setVisible(boolean visible) {
        this.bVisible = visible;
        if (this.uavc != null) {
            this.uavc.setVisible(visible);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPointerShape(int pShape) {
        this.pointerShape = pShape;
    }

    public final int getPointerShape() {
        return this.pointerShape;
    }

    public void setShowTarget(boolean showTarget) {
        this.showTarget = showTarget;
    }

    public final boolean isShowTarget() {
        return this.showTarget;
    }

    public void setShowBorder(boolean showBorder) {
        this.showBorder = showBorder;
    }

    public final boolean isShowBorder() {
        return this.showBorder;
    }

    public CPoint getTextAnchor() {
        return this.textAnchor;
    }

    public void setTextAnchor(CPoint textAnchor) {
        this.textAnchor.setPoint(textAnchor);
    }

    public CPoint getTarget() {
        return this.target;
    }

    public void setTarget(CPoint target) {
        this.target.setPoint(target);
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
        if (this.uavc != null) {
            this.uavc.getTextArea().setSize(this.getSize());
        }
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
        if (this.uavc != null) {
            this.uavc.getTextArea().setSize(this.getSize());
        }
    }

    public void removePropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propName, pcl);
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propName, pcl);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void setSelected(boolean selection) {
        if (!this.editable && selection) {
            return;
        }
        if (this.selected == selection) {
            return;
        }
        this.selected = selection;
        if (this.selected) {
            this.pcs.firePropertyChange("COMPONENT_SELECTED", null, this);
        } else {
            this.pcs.firePropertyChange("COMPONENT_UNSELECTED", null, this);
        }
    }

    public void setUnselectedColor(Color unselectedColor) {
        this.unselectedColor = unselectedColor;
        this.unselectedBorder = BorderFactory.createLineBorder(unselectedColor);
    }

    public void setFont(Font textFont) {
        this.textFont = textFont;
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
        this.selectedBorder = BorderFactory.createLineBorder(selectedColor);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new UserAnnoCreator();
        }
        return null;
    }

    public void addMouseListener(MouseListener listener) {
        this.mListeners.add(listener);
        if (this.uavc != null) {
            this.uavc.addMouseListener(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        this.mListeners.remove(listener);
        if (this.uavc != null) {
            this.uavc.removeMouseListener(listener);
        }
    }

    public List getMouseListeners() {
        return this.mListeners;
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        this.mmListeners.add(listener);
        if (this.uavc != null) {
            this.uavc.addMouseMotionListener(listener);
        }
    }

    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.mmListeners.remove(listener);
        if (this.uavc != null) {
            this.uavc.removeMouseMotionListener(listener);
        }
    }

    public List getMouseMotionListeners() {
        return this.mmListeners;
    }

    public void addKeyListener(KeyListener listener) {
        this.keyListeners.add(listener);
        if (this.uavc != null) {
            this.uavc.addKeyListener(listener);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        this.keyListeners.remove(listener);
        if (this.uavc != null) {
            this.uavc.removeKeyListener(listener);
        }
    }

    public List getKeyListeners() {
        return this.keyListeners;
    }

    public void addFocusListener(FocusListener listener) {
        this.focusListeners.add(listener);
        if (this.uavc != null) {
            this.uavc.addFocusListener(listener);
        }
    }

    public void removeFocusListener(FocusListener listener) {
        this.focusListeners.remove(listener);
        if (this.uavc != null) {
            this.uavc.removeFocusListener(listener);
        }
    }

    public List getFocusListeners() {
        return this.focusListeners;
    }

    public Border getUnselectedBorder() {
        return this.unselectedBorder;
    }

    public Color getUnselectedColor() {
        return this.unselectedColor;
    }

    public Font getFont() {
        return this.textFont;
    }

    public Border getSelectedBorder() {
        return this.selectedBorder;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void configUserAnnotation() {
        if (this.uavc == null) {
            return;
        }
        JTextArea textArea = this.uavc.getTextArea();
        if (this.isSelected()) {
            textArea.setCaretColor(this.getSelectedColor());
            if (this.isShowBorder()) {
                textArea.setBorder(this.getSelectedBorder());
            } else {
                textArea.setBorder(null);
            }
            textArea.setForeground(this.getSelectedColor());
        } else {
            textArea.setEditable(false);
            if (this.isShowBorder()) {
                textArea.setBorder(this.getUnselectedBorder());
            } else {
                textArea.setBorder(null);
            }
            textArea.setForeground(this.getUnselectedColor());
        }
    }

    public Shape getMoveHandleShape(int width, int height) {
        this.moveShape.setFrame(0.0, 0.0, width, height);
        return this.moveShape;
    }

    public Shape getResizeHandleShape(int width, int height) {
        this.resizeShape.setFrame(0.0, 0.0, width, height);
        return this.resizeShape;
    }

    public static void setResizeHandleCursor(Cursor cursor) {
        resizeCursor = cursor;
    }

    public static void setMoveHandleCursor(Cursor cursor) {
        moveCursor = cursor;
    }

    public static void setSelectionCursor(Cursor cursor) {
        selectionCursor = cursor;
    }

    public static Cursor getResizeHandleCursor() {
        return resizeCursor;
    }

    public static Cursor getMoveHandleCursor() {
        return moveCursor;
    }

    public static Cursor getSelectionCursor() {
        return selectionCursor;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeDouble(this.getTarget().x);
        stream.writeDouble(this.getTarget().y);
        stream.writeDouble(this.getTarget().z);
        stream.writeByte(this.getTarget().csystem);
        stream.writeDouble(this.getTextAnchor().x);
        stream.writeDouble(this.getTextAnchor().y);
        stream.writeDouble(this.getTextAnchor().z);
        stream.writeByte(this.getTextAnchor().csystem);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        double targetX = stream.readDouble();
        double targetY = stream.readDouble();
        double targetZ = stream.readDouble();
        byte targetCSystem = stream.readByte();
        double textAnchorX = stream.readDouble();
        double textAnchorY = stream.readDouble();
        double textAnchorZ = stream.readDouble();
        byte textAnchorCSystem = stream.readByte();
        this.setTarget(new CPoint(targetX, targetY, targetZ, targetCSystem));
        this.setTextAnchor(new CPoint(textAnchorX, textAnchorY, textAnchorZ, textAnchorCSystem));
        this.moveShape = new Rectangle2D.Double();
        this.resizeShape = new Rectangle2D.Double();
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void keyPressed(KeyEvent e) {
        if (this.uavc != null) {
            this.uavc.repaint();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private static class UserAnnoCreator
    extends XpComponentCreator {
        private UserAnnoCreator() {
        }

        public void mousePressed(MouseEvent me) {
            XpVisualComponent jc = (XpVisualComponent)me.getSource();
            int x = me.getX();
            int y = me.getY();
            UserAnnoCapable ua = (UserAnnoCapable)this.getComponentCapable(jc);
            if (ua != null) {
                CPoint img_pt = this.getImgPt(jc, x, y);
                int xx = (int)img_pt.x;
                int yy = (int)img_pt.y;
                CPoint target = new CPoint(xx, yy, 0, 0);
                CPoint textAnchor = new CPoint(x - 90, y - 60, 0, 1);
                XpUserAnnotationModel uam = new XpUserAnnotationModel("", textAnchor, target);
                ua.add(uam);
                if (!this.isPerpetual()) {
                    this.notifyAdditionListeners(ua);
                    this.notifyCreationListeners(ua);
                    this.removeFromAll();
                }
            }
        }
    }
}

