/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpVisualComponent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

public class XpMagnifierVc
extends XpVisualComponent {
    private AffineTransform at = new AffineTransform();
    private MagnifierMouseListener mml = new MagnifierMouseListener();
    private CPoint display_pt = new CPoint(1);
    private CPoint img_pt = new CPoint(0);
    private double mwidth = 150.0;
    private double mheight = 150.0;
    private Rectangle2D boundaryRect = new Rectangle2D.Double();
    private boolean draw = false;
    private boolean inPaint = false;
    private JComponent jc = null;
    private BufferedImage bi = null;
    private BufferedImage rbi = null;
    private double zoom = 2.0;
    private double rwidth = 0.0;
    private double rheight = 0.0;
    private int mouseMask = 16;
    private static String strMAG_GLASS_LOCATION = "";
    private final int imagGlXOffset = 2;
    private final int imagGlYOffset = 4;
    private static final int iTOP = 1;
    private static final int iRIGHT = 2;
    private static final int iBOTTOM = 3;
    private static final int iLEFT = 4;
    private static int imagGlLocation;

    public XpMagnifierVc(JComponent jc, double x, double y) {
        this.jc = jc;
        this.img_pt.x = x;
        this.img_pt.y = y;
        this.initMagGlass();
        this.addMouseListener(this.mml);
        this.addMouseMotionListener(this.mml);
    }

    private void initMagGlass() {
        this.bi = new BufferedImage((int)(this.mwidth - 2.0), (int)(this.mheight - 2.0), 1);
        this.rwidth = (this.mwidth - 2.0) / this.zoom;
        this.rheight = (this.mheight - 2.0) / this.zoom;
        this.rbi = new BufferedImage((int)this.rwidth, (int)this.rheight, 1);
    }

    public boolean contains(int x, int y) {
        return true;
    }

    public void paintComponent(Graphics g) {
        if (!this.inPaint) {
            this.inPaint = true;
            if (this.draw) {
                Graphics2D g2 = (Graphics2D)g;
                CTransform t = this.getTransform((byte)0, (byte)1);
                t.transform(this.img_pt, this.display_pt);
                double hw = this.mwidth / 2.0;
                double hh = this.mheight / 2.0;
                Graphics2D big = this.bi.createGraphics();
                this.at.setToIdentity();
                this.at.translate(hw, hh);
                this.at.scale(this.zoom, this.zoom);
                this.at.translate(-hw / this.zoom, -hh / this.zoom);
                big.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                big.drawRenderedImage(this.rbi, this.at);
                Color c = g2.getColor();
                double x = this.display_pt.x - hw;
                double y = this.display_pt.y - hh;
                this.boundaryRect.setFrame(x, y, this.mwidth, this.mheight);
                g2.setColor(Color.cyan);
                g2.draw(this.boundaryRect);
                this.at.setToIdentity();
                this.at.translate(x + 2.0, y + 2.0);
                g2.drawImage(this.bi, this.at, null);
                g2.setColor(c);
            }
        }
        this.inPaint = false;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setMagWidth(double width) {
        this.mwidth = width;
        this.initMagGlass();
    }

    public double getMagWidth() {
        return this.mwidth;
    }

    public void setMagHeight(double height) {
        this.mheight = height;
        this.initMagGlass();
    }

    public double getMagHeight() {
        return this.mheight;
    }

    private void paintOffscreen() {
        double hw = this.rwidth / 2.0;
        double hh = this.rheight / 2.0;
        Graphics2D rbig = this.rbi.createGraphics();
        rbig.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int biw = this.rbi.getWidth();
        int bih = this.rbi.getHeight();
        rbig.setBackground(Color.black);
        rbig.setColor(Color.black);
        rbig.fillRect(0, 0, biw, bih);
        int dx = (int)(this.display_pt.x - hw);
        int dy = (int)(this.display_pt.y - hh);
        this.at.setToIdentity();
        this.at.translate(-dx, -dy);
        rbig.transform(this.at);
        this.jc.paint(rbig);
    }

    public int getMouseMask() {
        return this.mouseMask;
    }

    public void setMouseMask(int mouseMask) {
        this.mouseMask = mouseMask;
    }

    private static void setMagGlassPosition(String strMagGlassPos) {
        strMAG_GLASS_LOCATION = strMagGlassPos;
    }

    public static String getMagGlassPosition() {
        return strMAG_GLASS_LOCATION;
    }

    static {
        if (XpMagnifierVc.getMagGlassPosition() == null) {
            XpMagnifierVc.setMagGlassPosition(XpPropertiesManager.getProperty("jami.magglasslocation"));
        }
        if (strMAG_GLASS_LOCATION.equalsIgnoreCase("LEFT")) {
            imagGlLocation = 4;
        } else if (strMAG_GLASS_LOCATION.equalsIgnoreCase("RIGHT")) {
            imagGlLocation = 2;
        } else if (strMAG_GLASS_LOCATION.equalsIgnoreCase("TOP")) {
            imagGlLocation = 1;
        } else if (strMAG_GLASS_LOCATION.equalsIgnoreCase("BOTTOM")) {
            imagGlLocation = 3;
        }
    }

    private class MagnifierMouseListener
    implements MouseInputListener {
        private MagnifierMouseListener() {
        }

        private void updateImageCoords(double x, double y) {
            if (strMAG_GLASS_LOCATION != null) {
                double hw = XpMagnifierVc.this.mwidth / 2.0;
                double hh = XpMagnifierVc.this.mheight / 2.0;
                switch (imagGlLocation) {
                    case 1: {
                        y = y - hh + 4.0;
                        break;
                    }
                    case 2: {
                        x = x + hw - 2.0;
                        break;
                    }
                    case 3: {
                        y = y + hh - 4.0;
                        break;
                    }
                    case 4: {
                        x = x - hw + 2.0;
                        break;
                    }
                }
            }
            CTransform t = XpMagnifierVc.this.getTransform((byte)1, (byte)0);
            ((XpMagnifierVc)XpMagnifierVc.this).display_pt.x = x;
            ((XpMagnifierVc)XpMagnifierVc.this).display_pt.y = y;
            t.transform(XpMagnifierVc.this.display_pt, XpMagnifierVc.this.img_pt);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            int mod = e.getModifiers() & XpMagnifierVc.this.mouseMask;
            if (mod == XpMagnifierVc.this.mouseMask) {
                this.updateImageCoords(e.getX(), e.getY());
                XpMagnifierVc.this.draw = true;
                XpMagnifierVc.this.paintOffscreen();
                XpMagnifierVc.this.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            XpMagnifierVc.this.draw = false;
            XpMagnifierVc.this.repaint();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            int mod = e.getModifiers() & XpMagnifierVc.this.mouseMask;
            if (mod == XpMagnifierVc.this.mouseMask) {
                this.updateImageCoords(e.getX(), e.getY());
                XpMagnifierVc.this.paintOffscreen();
                XpMagnifierVc.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class ImgPanel
    extends JPanel {
        public BufferedImage bi = null;

        private ImgPanel() {
        }

        public void paintComponent(Graphics g) {
            if (this.bi != null) {
                g.drawImage(this.bi, 0, 0, null);
            }
        }
    }
}

