/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpResponseCurve;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class XpImageMouseControls
implements XpMouseController {
    private static final int CONTRAST_WWWL = 0;
    private static final int CONTRAST_PET = 1;
    private static final int CONTRAST_MINMAX = 2;
    private static double wlSensitivity = 1.0;
    private static double wwSensitivity = 1.0;
    private static double zoomSensitivity = 0.01;
    private static final double IMG_SCOOTCH = 0.15;
    private static boolean init = true;
    private static Object dragInterpolation = null;
    private JComponent target = null;
    private XpResponseCurve wlResponse = new XpResponseCurve();
    private double startMin = 0.0;
    private double startMax = 0.0;
    private double startWW = 0.0;
    private double startWL = 0.0;
    private double startZoom = 1.0;
    private double startPanX = 0.0;
    private double startPanY = 0.0;
    private double startAngle = 0.0;
    private Dimension dim = new Dimension();
    private Object saveInterpolation = null;
    private XpDicomElement modality = new XpDicomElement(8, 96);
    private double rescaleSlope = 1.0;
    private int wwwlStyle = 0;
    private Point startMouse = null;
    private Point prevPoint = null;
    private double angleAccelerator = 0.1;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private boolean repaint = true;
    private boolean mPressed = false;

    public XpImageMouseControls() {
        if (init) {
            String wlStr = XpPropertiesManager.getProperty("jami.wlSensitivity", "1");
            String wwStr = XpPropertiesManager.getProperty("jami.wwSensitivity", "1");
            String zStr = XpPropertiesManager.getProperty("jami.zoomSensitivity", "0.01");
            String interp = XpPropertiesManager.getProperty("jami.draginterpolation", "none");
            Double wlD = new Double(wlStr);
            Double wwD = new Double(wwStr);
            Double zoD = new Double(zStr);
            wlSensitivity = wlD;
            wwSensitivity = wwD;
            zoomSensitivity = zoD;
            interp = interp.toLowerCase();
            XpLog.logger().info("JAMI DRAG INTERPOLATION = " + interp);
            XpLog.logger().config("JAMI ww/wl mouse sensitivity = [" + wwSensitivity + "/" + wlSensitivity + "]");
            XpLog.logger().config("JAMI zoom mouse sensitivity  = [" + zoomSensitivity + "]");
            dragInterpolation = interp.equals("nearest neighbor") || interp.equals("nearestneighbor") ? RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR : (interp.equals("bilinear") ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : (interp.equals("bicubic") ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : null));
            init = false;
        }
    }

    public final void setWWWLResponseCurve(XpResponseCurve rc) {
        this.wlResponse = rc;
    }

    public void setTarget(JComponent vc) {
        if (this.target != vc) {
            boolean fail = false;
            if (!(vc instanceof XpImageRenderAttributesOwner)) {
                fail = true;
            }
            if (!(vc instanceof PanZoomCapable)) {
                fail = true;
            }
            if (!(vc instanceof WindowLevelCapable)) {
                fail = true;
            }
            if (!(vc instanceof FrameOwner)) {
                fail = true;
            }
            this.target = vc;
        }
    }

    protected final JComponent getTarget() {
        return this.target;
    }

    public void mousePressed(MouseEvent e) {
        if (this.target == null) {
            return;
        }
        this.mPressed = true;
        this.prevPoint = this.startMouse = e.getPoint();
        XpImageRenderAttributesOwner irao = (XpImageRenderAttributesOwner)((Object)this.target);
        XpImageRenderAttributes ira = irao.getImageRenderAttributes();
        if (this.target instanceof WindowLevelCapable) {
            double max = ((WindowLevelCapable)((Object)this.target)).getWinMax();
            double min = ((WindowLevelCapable)((Object)this.target)).getWinMin();
            this.startWW = max - min;
            this.startWL = (max + min) * 0.5;
        } else {
            this.startWW = ira.getWindowWidth();
            this.startWL = ira.getWindowLevel();
        }
        this.startMin = this.startWL - this.startWW * 0.5;
        this.startMax = this.startWL + this.startWW * 0.5;
        this.startZoom = ira.getZoom();
        this.startPanX = ira.getPanX();
        this.startPanY = ira.getPanY();
        this.startAngle = ira.getAngle();
        this.target.getSize(this.dim);
        FrameOwner fo = (FrameOwner)((Object)this.target);
        XpImage xi = fo.getFrame();
        if (xi != null) {
            this.rescaleSlope = xi.getRescaleSlope();
            XpSlice slice = xi.getSlice();
            if (slice != null) {
                this.imgWidth = slice.width;
                this.imgHeight = slice.height;
            }
        }
        this.wwwlStyle = 0;
        if (xi instanceof XpDicomObject) {
            XpDicomObject dobj = (XpDicomObject)((Object)xi);
            dobj.getValue(this.modality);
            if (this.modality.value != null) {
                if (this.modality.value.equals("PT")) {
                    this.wwwlStyle = 1;
                } else if (this.modality.value.equals("IC")) {
                    this.wwwlStyle = 2;
                }
            }
        }
        if (dragInterpolation != null && this.target instanceof XpSingularPort) {
            XpSingularPort sp = (XpSingularPort)this.target;
            this.saveInterpolation = sp.getInterpolationHint();
            sp.setInterpolationHint(dragInterpolation);
        }
        this.target.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.mPressed = false;
        this.prevPoint = null;
        if (dragInterpolation != null && this.target instanceof XpSingularPort) {
            XpSingularPort sp = (XpSingularPort)this.target;
            sp.setInterpolationHint(this.saveInterpolation);
            sp.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        double dy;
        double dx;
        boolean res;
        if (this.target == null || !this.mPressed) {
            return;
        }
        Point cPoint = e.getPoint();
        if (this.startMouse != null && (res = this.dragDispatch(e, dx = cPoint.getX() - this.startMouse.getX(), dy = cPoint.getY() - this.startMouse.getY())) && this.repaint) {
            this.target.repaint();
        }
        this.prevPoint = cPoint;
    }

    protected boolean dragDispatch(MouseEvent e, double dx, double dy) {
        boolean shift;
        boolean res = false;
        int mod = e.getModifiers();
        boolean b1 = 0 != (mod & 0x10);
        boolean b2 = 0 != (mod & 8);
        boolean b3 = 0 != (mod & 4);
        boolean bl = shift = 0 != (mod & 1);
        if (b3 && !shift) {
            this.zoom(dx, dy);
            res = true;
        } else if (b1) {
            if (shift) {
                this.rotate(dx, dy);
            } else {
                this.pan(dx, dy);
            }
            res = true;
        } else if (b2 || b3 && shift) {
            this.wwwl(dx, dy);
            res = true;
        }
        return res;
    }

    protected void zoom(double dx, double dy) {
        double zoom = this.startZoom - dy * zoomSensitivity;
        if (zoom < 0.05) {
            zoom = 0.1;
        }
        if (zoom > 8.0) {
            zoom = 8.0;
        }
        PanZoomCapable pzc = (PanZoomCapable)((Object)this.target);
        pzc.setZoom(zoom);
    }

    protected void rotate(double dx, double dy) {
        double angle = Math.toDegrees(this.startAngle + dx * this.angleAccelerator);
        PanZoomCapable pzc = (PanZoomCapable)((Object)this.target);
        pzc.setRotate(angle);
    }

    protected void wwwl(double dx, double dy) {
        WindowLevelCapable wlc = (WindowLevelCapable)((Object)this.target);
        if (this.wwwlStyle == 0) {
            double wwdelta = wwSensitivity * dx;
            double wldelta = wlSensitivity * dy;
            double ww = this.wlResponse.response(this.startWW, wwdelta);
            double wl = this.wlResponse.response(this.startWL, wldelta);
            double hww = ww * 0.5;
            double min = wl - hww;
            double max = wl + hww;
            wlc.setWinMinMax(min, max);
        } else if (this.wwwlStyle == 1) {
            double maxdelta = -wlSensitivity * 20.0 * this.rescaleSlope * dy;
            double max = this.startMax + maxdelta;
            wlc.setWinMax(max);
        } else {
            double mindelta = wlSensitivity * dx;
            double maxdelta = -wlSensitivity * dy;
            double min = this.startMin + mindelta;
            double max = this.startMax + maxdelta;
            wlc.setWinMinMax(min, max);
        }
    }

    protected void pan(double dx, double dy) {
        JComponent jc = this.getTarget();
        PanZoomCapable pzc = (PanZoomCapable)((Object)jc);
        double zoom = pzc.getZoom();
        jc.getSize(this.dim);
        double rx = (double)this.imgWidth / this.dim.getWidth();
        double ry = (double)this.imgHeight / this.dim.getHeight();
        double ratio = Math.max(rx, ry) / zoom;
        double panx = this.startPanX + ratio * dx;
        double pany = this.startPanY + ratio * dy;
        int portwidth = jc.getWidth();
        int portheight = jc.getHeight();
        double limPanx = 0.0;
        double actualHZoom = zoom * (double)portwidth / (double)this.imgWidth;
        double actualVZoom = zoom * (double)portheight / (double)this.imgHeight;
        double actualZoom = actualHZoom > actualVZoom ? actualVZoom : actualHZoom;
        double limPany = 0.0;
        limPanx = this.imgWidth / 2;
        limPany = this.imgHeight / 2;
        double absPx = Math.abs(panx);
        double absPy = Math.abs(pany);
        if (absPx > limPanx) {
            double d = panx = panx < 0.0 ? -limPanx : limPanx;
        }
        if (absPy > limPany) {
            pany = pany < 0.0 ? -limPany : limPany;
        }
        pzc.setPan(panx, pany);
    }

    protected void oldpan(double dx, double dy) {
        JComponent jc = this.getTarget();
        PanZoomCapable pzc = (PanZoomCapable)((Object)jc);
        double zoom = pzc.getZoom();
        jc.getSize(this.dim);
        double dix = (double)this.imgWidth * dx / this.dim.getWidth();
        double diy = (double)this.imgHeight * dy / this.dim.getHeight();
        double panx = this.startPanX + dix / zoom;
        double pany = this.startPanY + diy / zoom;
        double panLimFactor = 1.0;
        if (zoom < 0.7) {
            panLimFactor = 1.3;
        } else if (zoom > 3.0) {
            panLimFactor = 0.5;
        }
        double LIMPANSCALE = 0.7 / (zoom * panLimFactor);
        double limPanx = (double)this.imgWidth * LIMPANSCALE;
        double limPany = (double)this.imgHeight * LIMPANSCALE;
        double absPx = Math.abs(panx);
        double absPy = Math.abs(pany);
        if (absPx > limPanx) {
            double d = panx = panx < 0.0 ? -limPanx : limPanx;
        }
        if (absPy > limPany) {
            pany = pany < 0.0 ? -limPany : limPany;
        }
        pzc.setPan(panx, pany);
    }

    public final void setRepaint(boolean repaint) {
        this.repaint = repaint;
    }

    public final boolean isRepaint() {
        return this.repaint;
    }

    protected final double getStartWW() {
        return this.startWW;
    }

    protected final double getStartWL() {
        return this.startWL;
    }

    protected final double getStartZoom() {
        return this.startZoom;
    }

    protected final double getStartPanX() {
        return this.startPanX;
    }

    protected final double getStartPanY() {
        return this.startPanY;
    }

    protected final double getStartAngle() {
        return this.startAngle;
    }

    protected final Point getStartMouse() {
        return this.startMouse;
    }

    protected final Point getPrevPoint() {
        return this.prevPoint;
    }
}

