/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpLog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class XpDynamicGridLayout
implements LayoutManager,
Serializable {
    private int rows = 1;
    private int cols = 1;
    private static final int PREFERRED_SIZE = 0;
    private static final int MINIMUM_SIZE = 1;
    private boolean squareComponents = false;

    public XpDynamicGridLayout(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        if (this.rows < 1) {
            this.rows = 1;
        }
        if (this.cols < 1) {
            this.cols = 1;
        }
    }

    public void addLayoutComponent(String name, Component comp) {
        XpLog.logger().info("Add Layout Component   : " + name + "  Component=" + comp.getClass());
    }

    public void removeLayoutComponent(Component comp) {
        XpLog.logger().info("Remove Layout Component: " + comp.getClass());
    }

    private Dimension getEffectiveDimension(Container parent) {
        Insets is = parent.getInsets();
        Dimension d = parent.getSize();
        Dimension pd = new Dimension((int)d.getWidth() - is.left - is.right, (int)d.getHeight() - is.top - is.bottom);
        return pd;
    }

    private Dimension getLayoutSize(Container parent, int sizeType) {
        Insets is = parent.getInsets();
        Component[] comps = parent.getComponents();
        int nComps = comps.length;
        int w = 0;
        int h = 0;
        int cIdx = 0;
        for (int i = 0; i < this.rows; ++i) {
            int maxH = 0;
            int rowW = 0;
            for (int j = 0; j < this.cols; ++j) {
                if (cIdx < nComps) {
                    Dimension dim = null;
                    switch (sizeType) {
                        case 0: {
                            dim = comps[cIdx].getPreferredSize();
                            break;
                        }
                        case 1: {
                            dim = comps[cIdx].getMinimumSize();
                            break;
                        }
                        default: {
                            dim = comps[cIdx].getSize();
                        }
                    }
                    int comp_h = (int)dim.getHeight();
                    int comp_w = (int)dim.getWidth();
                    if (comp_h > maxH) {
                        maxH = comp_h;
                    }
                    rowW += comp_w;
                }
                ++cIdx;
            }
            h += maxH;
            if (rowW <= w) continue;
            w = rowW;
        }
        Dimension d = new Dimension(w += is.left + is.right, h += is.bottom + is.top);
        return d;
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 0);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 1);
    }

    public void layoutContainer(Container parent) {
        Insets is = parent.getInsets();
        Dimension d = this.getEffectiveDimension(parent);
        Component[] comps = parent.getComponents();
        int nComps = comps.length;
        int w = (int)((d.getWidth() + 1.0) / (double)this.cols);
        int h = (int)((d.getHeight() + 1.0) / (double)this.rows);
        int startX = 0;
        int startY = 0;
        if (this.squareComponents) {
            if (w > h) {
                w = h;
                startX = (int)((d.getWidth() - (double)(this.cols * w)) * 0.5);
            } else {
                h = w;
                startY = (int)((d.getHeight() - (double)(this.rows * h)) * 0.5);
            }
        }
        int x = is.left + startX;
        int y = is.top + startY;
        int cIdx = 0;
        for (int i = 0; i < this.rows; ++i) {
            x = is.left + startX;
            for (int j = 0; j < this.cols; ++j) {
                if (cIdx < nComps) {
                    comps[cIdx].setLocation(x, y);
                    comps[cIdx].setSize(w, h);
                }
                ++cIdx;
                x += w;
            }
            y += h;
        }
    }

    public int getColumns() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public void setColumns(int cols) {
        if (cols < 1) {
            return;
        }
        this.cols = cols;
    }

    public void setRows(int rows) {
        if (rows < 1) {
            return;
        }
        this.rows = rows;
    }

    public final boolean isSquareComponents() {
        return this.squareComponents;
    }

    public final void setSquareComponents(boolean squareComponents) {
        this.squareComponents = squareComponents;
    }
}

