/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.ClipCapable;
import com.ge.med.jnu.JnMatrix;
import com.ge.med.jnu.JnVector;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.capable.GraphicEditable;
import com.ge.med.terra.jami.filter.XpImageLut;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.roi.XpPolygonRoi;
import com.ge.med.terra.jami.roi.XpRectangularRoi;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class XpCPI {
    private static final double EPSILON = 1.0E-4;
    private static JnMatrix m = new JnMatrix(3, 3);
    private static JnVector b = new JnVector(3);
    private static JnVector v0 = new JnVector(3);
    private static JnVector v1 = new JnVector(3);
    private static XpDicomElement sopUID = new XpDicomElement(8, 24);
    private static XpDicomElement sopClassUID = new XpDicomElement(8, 22);
    private static Point2D tempPt1 = new Point2D.Double();
    private static Point2D tempPt2 = new Point2D.Double();
    private static Point2D tempPt3 = new Point2D.Double();
    private static boolean debug = false;
    private static boolean editable = true;
    private static double SMALL_NUM = 0.001;
    private static final int VP_DIM = 512;
    public static final String SCALE_TO_FIT = "SCALE TO FIT";
    public static final String TRUE_SIZE = "TRUE SIZE";
    public static final String MAGNIFY = "MAGNIFY";
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final String CENTER = "CENTER";
    public static final String POINT = "POINT";
    public static final String POLYLINE = "POLYLINE";
    public static final String INTERPOLATED = "INTERPOLATED";
    public static final String CIRCLE = "CIRCLE";
    public static final String ELLIPSE = "ELLIPSE";
    public static final String RECTANGULAR = "RECTANGULAR";
    public static final String CIRCULAR = "CIRCULAR";
    public static final String POLYGONAL = "POLYGONAL";
    public static final String USER = "USER";
    public static final String AUTOMATED = "AUTOMATED";
    public static final String BITMAP = "BITMAP";
    public static final String IDENTITY = "IDENTITY";
    public static final String INVERSE = "INVERSE";
    private List displayedAreaModule = new ArrayList();
    private List graphicAnnoModule = new ArrayList();
    private List softcopyVoiModule = new ArrayList();
    private SoftcopyPresentationLut softPresModule = new SoftcopyPresentationLut();
    private ModalityLut modalityLutModule = new ModalityLut();
    private SpatialTransformation st = new SpatialTransformation();
    private DisplayShutter idShutter = null;
    private DisplayShutter dShutter = null;
    private BitmapDisplayShutter bdShutter = null;
    private int nImages = 0;

    public final List getDisplayedArea() {
        return this.displayedAreaModule;
    }

    public final DisplayShutter getDisplayShutter(int coordSystem) {
        if (coordSystem == 0) {
            return this.idShutter;
        }
        return this.dShutter;
    }

    public final void setDisplayShutter(DisplayShutter ds, int coordSystem) {
        if (coordSystem == 0) {
            this.idShutter = ds;
        } else {
            this.dShutter = ds;
        }
    }

    public final BitmapDisplayShutter getBitmapDisplayShutter() {
        return this.bdShutter;
    }

    public final List getGraphicAnnotation() {
        return this.graphicAnnoModule;
    }

    public final List getSoftcopyVoiLut() {
        return this.softcopyVoiModule;
    }

    public final SoftcopyPresentationLut getSoftcopyPresentationLut() {
        return this.softPresModule;
    }

    public final ModalityLut getModalityLut() {
        return this.modalityLutModule;
    }

    public static void setDebug(boolean db) {
        debug = db;
    }

    public static void setEditable(boolean edit) {
        editable = edit;
    }

    public final SpatialTransformation getSpatialTransformation() {
        return this.st;
    }

    public final void setSpatialTransformation(XpImageOrientation ior) {
        this.st.flipHorizontal = ior.getFlip();
        double angle = ior.getAngle();
        this.st.angle = this.st.flipHorizontal ? -angle : angle;
    }

    private static List dupPointList(List data) {
        ArrayList<Point2D.Double> dupdata = new ArrayList<Point2D.Double>();
        for (int i = 0; i < data.size(); ++i) {
            Point2D p = (Point2D)data.get(i);
            Point2D.Double np = new Point2D.Double();
            np.setLocation(p);
            dupdata.add(np);
        }
        return dupdata;
    }

    public static RoiActor createROI(String graphicType, List gdata, boolean filled, byte csystem) {
        XpStatisticsRoi ra = null;
        if (!graphicType.equals(POINT)) {
            if (graphicType.equals(POLYLINE)) {
                int npts = gdata.size();
                List rgdata = XpCPI.dupPointList(gdata);
                boolean isRect = false;
                if (npts == 5) {
                    Point2D p1 = (Point2D)rgdata.get(0);
                    Point2D p2 = (Point2D)rgdata.get(1);
                    Point2D p3 = (Point2D)rgdata.get(2);
                    Point2D p4 = (Point2D)rgdata.get(3);
                    Point2D p5 = (Point2D)rgdata.get(4);
                    if (p1.getX() == p5.getX() && p1.getY() == p5.getY()) {
                        double cx = (p1.getX() + p2.getX() + p3.getX() + p4.getX()) / 4.0;
                        double cy = (p1.getY() + p2.getY() + p3.getY() + p4.getY()) / 4.0;
                        double angle = Math.atan((p1.getY() - p2.getY()) / (p2.getX() - p1.getX()));
                        XpGeomUtils gu = new XpGeomUtils();
                        gu.getRotatedPoint(p1.getX(), p1.getY(), angle, cx, cy, p1);
                        gu.getRotatedPoint(p2.getX(), p2.getY(), angle, cx, cy, p2);
                        gu.getRotatedPoint(p3.getX(), p3.getY(), angle, cx, cy, p3);
                        gu.getRotatedPoint(p4.getX(), p4.getY(), angle, cx, cy, p4);
                        gu.getRotatedPoint(p5.getX(), p5.getY(), angle, cx, cy, p5);
                        double diff1 = Math.abs(p2.getX() - p3.getX());
                        double diff2 = Math.abs(p1.getX() - p4.getX());
                        if (diff1 < SMALL_NUM && diff2 < SMALL_NUM) {
                            if (debug) {
                                System.out.println("A RECTANGLE FOUND....");
                            }
                            double ulX = Double.MAX_VALUE;
                            double ulY = Double.MAX_VALUE;
                            double brX = Double.MIN_VALUE;
                            double brY = Double.MIN_VALUE;
                            for (int i = 0; i < rgdata.size(); ++i) {
                                Point2D p = (Point2D)rgdata.get(i);
                                double x = p.getX();
                                double y = p.getY();
                                if (x < ulX) {
                                    ulX = x;
                                }
                                if (x > brX) {
                                    brX = x;
                                }
                                if (y < ulY) {
                                    ulY = y;
                                }
                                if (!(y > brY)) continue;
                                brY = y;
                            }
                            double w = Math.abs(ulX - brX);
                            double h = Math.abs(ulY - brY);
                            Rectangle2D.Double r = new Rectangle2D.Double(ulX, ulY, w, h);
                            XpRectangularRoi.Rectangle xrr = new XpRectangularRoi.Rectangle(r);
                            xrr.setAngle(angle);
                            ra = xrr;
                            isRect = true;
                        }
                    }
                }
                if (!isRect) {
                    Point2D[] pts = new Point2D[npts];
                    for (int i = 0; i < npts; ++i) {
                        Point2D p = (Point2D)gdata.get(i);
                        double x = p.getX();
                        double y = p.getY();
                        pts[i] = new Point2D.Double(x, y);
                    }
                    boolean doHandles = true;
                    if (pts.length > 50) {
                        doHandles = false;
                    }
                    ra = new XpPolygonRoi(pts, false, doHandles);
                }
            } else if (graphicType.equals(INTERPOLATED)) {
                int npts = gdata.size();
                Point2D[] pts = new Point2D[npts];
                for (int i = 0; i < npts; ++i) {
                    Point2D p = (Point2D)gdata.get(i);
                    double x = p.getX();
                    double y = p.getY();
                    pts[i] = new Point2D.Double(x, y);
                }
                boolean doHandles = true;
                if (pts.length > 50) {
                    doHandles = false;
                }
                ra = new XpPolygonRoi(pts, false, doHandles);
            } else if (graphicType.equals(CIRCLE)) {
                Point2D center = (Point2D)gdata.get(0);
                Point2D circ = (Point2D)gdata.get(1);
                double cx = center.getX();
                double cy = center.getY();
                double dx = circ.getX() - cx;
                double dy = circ.getY() - cy;
                double radius = Math.sqrt(dx * dx + dy * dy);
                double x = cx - radius;
                double y = cy - radius;
                double dim = 2.0 * radius;
                Ellipse2D.Double e = new Ellipse2D.Double(x, y, dim, dim);
                ra = new XpRectangularRoi.Ellipse(e);
            } else if (graphicType.equals(ELLIPSE)) {
                List rgdata = XpCPI.dupPointList(gdata);
                double ulX = Double.MAX_VALUE;
                double ulY = Double.MAX_VALUE;
                double brX = Double.MIN_VALUE;
                double brY = Double.MIN_VALUE;
                Point2D p1 = (Point2D)rgdata.get(0);
                Point2D p2 = (Point2D)rgdata.get(1);
                Point2D p3 = (Point2D)rgdata.get(2);
                Point2D p4 = (Point2D)rgdata.get(3);
                double cx = (p1.getX() + p2.getX() + p3.getX() + p4.getX()) / 4.0;
                double cy = (p1.getY() + p2.getY() + p3.getY() + p4.getY()) / 4.0;
                double num = p1.getY() - p2.getY();
                double denom = p2.getX() - p1.getX();
                if (Math.abs(denom) > 1.0E-4 || Math.abs(num) > 1.0E-4) {
                    double angle = 0.0;
                    if (Math.abs(denom) > 1.0E-4) {
                        angle = Math.atan(num / denom);
                    }
                    XpGeomUtils gu = new XpGeomUtils();
                    gu.getRotatedPoint(p1.getX(), p1.getY(), angle, cx, cy, p1);
                    gu.getRotatedPoint(p2.getX(), p2.getY(), angle, cx, cy, p2);
                    gu.getRotatedPoint(p3.getX(), p3.getY(), angle, cx, cy, p3);
                    gu.getRotatedPoint(p4.getX(), p4.getY(), angle, cx, cy, p4);
                    for (int i = 0; i < rgdata.size(); ++i) {
                        Point2D p = (Point2D)rgdata.get(i);
                        double x = p.getX();
                        double y = p.getY();
                        if (x < ulX) {
                            ulX = x;
                        }
                        if (x > brX) {
                            brX = x;
                        }
                        if (y < ulY) {
                            ulY = y;
                        }
                        if (!(y > brY)) continue;
                        brY = y;
                    }
                    double w = Math.abs(ulX - brX);
                    double h = Math.abs(ulY - brY);
                    Ellipse2D.Double e = new Ellipse2D.Double(ulX, ulY, w, h);
                    XpRectangularRoi.Ellipse rr = new XpRectangularRoi.Ellipse(e);
                    rr.setAngle(angle);
                    ra = rr;
                }
            }
        }
        if (ra instanceof GraphicEditable) {
            GraphicEditable er = ra;
            er.setEditable(editable);
        }
        return ra;
    }

    public static XpCPI createCPI(List scenes, Dimension vpDim, boolean sharedIRA) {
        int len = scenes.size();
        boolean multiFrame = false;
        if (len > 1) {
            XpImageScene s1 = (XpImageScene)scenes.get(0);
            XpImageScene s2 = (XpImageScene)scenes.get(1);
            XpImage img1 = s1.getFrame();
            XpImage img2 = s2.getFrame();
            if (img1 instanceof XpMedicalImage && img2 instanceof XpMedicalImage) {
                XpMedicalImage mi1 = (XpMedicalImage)img1;
                XpMedicalImage mi2 = (XpMedicalImage)img2;
                mi1.getValue(sopUID);
                String sopuid1 = "" + XpCPI.sopUID.value;
                mi2.getValue(sopUID);
                String sopuid2 = "" + XpCPI.sopUID.value;
                if (sopuid1.equals(sopuid2)) {
                    multiFrame = true;
                }
            }
        }
        XpMedicalImage[] imgs = new XpMedicalImage[len];
        XpImageRenderAttributes[] iras = new XpImageRenderAttributes[len];
        List[] rois = new List[len];
        List[] uannos = new List[len];
        for (int i = 0; i < len; ++i) {
            XpImageScene is = (XpImageScene)scenes.get(i);
            imgs[i] = (XpMedicalImage)is.getFrame();
            iras[i] = is.getImageRenderAttributes();
            rois[i] = is.getRois();
            uannos[i] = is.getUserAnnos();
        }
        return XpCPI.createCPI(imgs, iras, rois, uannos, vpDim, sharedIRA, multiFrame);
    }

    public static XpCPI createCPI(XpMedicalImage[] imgs, XpImageRenderAttributes[] iras, List[] arois, List[] auannos, Dimension vpDim, boolean sharedIRA, boolean multiFrame) {
        XpCPI cpi = new XpCPI();
        XpCPI.add2CPI(imgs, iras, arois, auannos, vpDim, sharedIRA, multiFrame, cpi);
        return cpi;
    }

    public static void addDisplayShutter(Shape s, int coordSys, int shutterPValue, XpCPI cpi) {
        DisplayShutter dsh = null;
        if (coordSys == 1) {
            dsh = cpi.dShutter = new DisplayShutter();
        } else if (coordSys == 0) {
            dsh = cpi.idShutter = new DisplayShutter();
        }
        if (dsh != null) {
            dsh.coordSystem = coordSys;
            if (s instanceof Ellipse2D) {
                Ellipse2D e = (Ellipse2D)s;
                dsh.shutterShape = CIRCULAR;
                dsh.circularCenter.setLocation(e.getCenterX(), e.getCenterY());
                dsh.circularRadius = e.getWidth() / 2.0;
            } else if (s instanceof Rectangle2D || s instanceof RoundRectangle2D) {
                RectangularShape r = (RectangularShape)s;
                dsh.shutterShape = RECTANGULAR;
                dsh.rectULPoint.setLocation(r.getX(), r.getY());
                dsh.rectBRPoint.setLocation(r.getX() + r.getWidth(), r.getY() + r.getHeight());
            } else if (s instanceof Line2D) {
                Line2D l = (Line2D)s;
                dsh.shutterShape = POLYGONAL;
                dsh.polygonalVertices = new ArrayList();
                Point2D p1 = l.getP1();
                Point2D p2 = l.getP2();
                dsh.polygonalVertices.add(new Point2D.Double(p1.getX(), p1.getY()));
                dsh.polygonalVertices.add(new Point2D.Double(p2.getX(), p2.getY()));
            } else if (s instanceof GeneralPath) {
                GeneralPath gp = (GeneralPath)s;
                dsh.shutterShape = POLYGONAL;
                dsh.polygonalVertices = new ArrayList();
                AffineTransform identity = new AffineTransform();
                PathIterator pi = gp.getPathIterator(identity);
                double[] coords = new double[2];
                while (!pi.isDone()) {
                    pi.currentSegment(coords);
                    dsh.polygonalVertices.add(new Point2D.Double(coords[0], coords[1]));
                    pi.next();
                }
            }
            dsh.shutterPValue = shutterPValue;
        }
    }

    public static void applyBitmapDisplayShutter(BitmapDisplayShutter bds, XpImageRenderAttributes ira) {
        int[] cmap = new int[]{-16777216};
        int w = bds.overlayPlane.cols;
        int h = bds.overlayPlane.rows;
        byte[] idxmap = new byte[w * h];
        for (int i = 0; i < idxmap.length; ++i) {
            idxmap[i] = bds.overlayPlane.overlayData[i] != 0 ? 0 : -1;
        }
        XpColorOverlay co = new XpColorOverlay(idxmap, cmap, w, h);
        ira.setColorOverlay(co);
    }

    public static void setBitmapDisplayShutter(XpColorOverlay co, int shutterPValue, XpCPI cpi) {
        cpi.bdShutter = new BitmapDisplayShutter();
        System.out.println("Setting bmap display shutter...");
        int w = co.getWidth();
        int h = co.getHeight();
        int len = w * h;
        cpi.bdShutter.shutterPValue = shutterPValue;
        cpi.bdShutter.overlayPlane.cols = w;
        cpi.bdShutter.overlayPlane.rows = h;
        Object clayer = co.getOverlay();
        int layerOffset = co.getOffset();
        int layerLength = co.getLength();
        if (clayer instanceof byte[]) {
            byte[] idxmap = (byte[])clayer;
            byte[] bitmap = new byte[layerLength];
            cpi.bdShutter.overlayPlane.overlayData = bitmap;
            for (int i = 0; i < layerLength; ++i) {
                bitmap[i] = idxmap[i + layerOffset] < 0 ? (byte)0 : 1;
            }
        } else {
            short[] idxmap = (short[])clayer;
            byte[] bitmap = new byte[layerLength];
            cpi.bdShutter.overlayPlane.overlayData = bitmap;
            for (int i = 0; i < layerLength; ++i) {
                bitmap[i] = idxmap[i + layerOffset] < 0 ? (byte)0 : 1;
            }
        }
        cpi.bdShutter.overlayPlane.nBitAllocated = 1;
        cpi.bdShutter.overlayPlane.overlayOrigin.setLocation(1.0, 1.0);
        cpi.bdShutter.overlayPlane.overlaySubType = USER;
        cpi.bdShutter.overlayPlane.overlayType = "G";
        cpi.bdShutter.overlayPlane.overlayDescription = "BITMAP_SHUTTER";
        cpi.bdShutter.overlayPlane.overlayLabel = "BITMAP_SHUTTER";
    }

    public static void add2CPI(XpMedicalImage[] imgs, XpImageRenderAttributes[] iras, List[] arois, List[] auannos, Dimension vpDim, boolean sharedIRA, boolean multiFrame, XpCPI cpi) {
        Rectangle viewport = new Rectangle();
        XpGeomUtils gu = new XpGeomUtils();
        AffineTransform tx = new AffineTransform();
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        XpImageOrientation ior = new XpImageOrientation();
        viewport.width = (int)vpDim.getWidth();
        viewport.height = (int)vpDim.getHeight();
        viewport.width = 512;
        viewport.height = 512;
        int[] rgbs = null;
        Integer[] lutData = null;
        IndexColorModel prevLut = null;
        XpImageOrientation effOrientation = new XpImageOrientation();
        XpGeomUtils.getDisplayOrientation(imgs[0].getAzimuth(), iras[0].getImageOrientation(), effOrientation);
        cpi.setSpatialTransformation(effOrientation);
        DisplayedArea dispArea = null;
        GraphicAnnotation gAnnot = null;
        SoftcopyVoiLut voiLUT = null;
        boolean first = true;
        for (int i = 0; i < imgs.length; ++i) {
            XpImageRenderAttributes ira = iras[i];
            XpMedicalImage mi = imgs[i];
            double azimuth = mi.getAzimuth();
            int w = mi.getSlice().width;
            int h = mi.getSlice().height;
            mi.getValue(sopUID);
            mi.getValue(sopClassUID);
            GSPSFrame frame = new GSPSFrame();
            if (multiFrame) {
                frame.ReferencedFrameNum = i;
            }
            frame.SOPClassUID = "" + XpCPI.sopClassUID.value;
            frame.SOPInstanceUID = "" + XpCPI.sopUID.value;
            boolean create = false;
            if (!sharedIRA || first) {
                create = true;
            }
            if (create) {
                dispArea = new DisplayedArea();
                voiLUT = new SoftcopyVoiLut();
                cpi.getDisplayedArea().add(dispArea);
                cpi.getSoftcopyVoiLut().add(voiLUT);
            }
            dispArea.refImgSequence.add(frame);
            if (!sharedIRA || first) {
                dispArea.pixelMagnificationRatio = 1.0;
                switch (ira.getPresentationSizeMode()) {
                    case 102: {
                        dispArea.presSize = MAGNIFY;
                        break;
                    }
                    case 100: {
                        dispArea.presSize = SCALE_TO_FIT;
                        break;
                    }
                    case 101: {
                        dispArea.presSize = TRUE_SIZE;
                    }
                }
                double pdX = mi.getPixelDimensionX();
                double pdY = mi.getPixelDimensionY();
                dispArea.presPixelSpacing.setLocation(pdX, pdY);
                try {
                    if (debug) {
                        System.out.println("BUILD CPI: Saving pan (" + ira.getPanX() + "," + ira.getPanY() + ")");
                    }
                    gu.calcDisplayedAreaTransform(viewport, ira, w, h, true, tx);
                    if (debug) {
                        System.out.println("BUILD CPI: disp area tx=" + tx);
                    }
                    ((Point2D)p1).setLocation(1.0, 1.0);
                    tx.inverseTransform(p1, p2);
                    dispArea.tlDisplay.setLocation(p2);
                    ((Point2D)p1).setLocation(viewport.width, viewport.height);
                    tx.inverseTransform(p1, p2);
                    dispArea.brDisplay.setLocation(p2);
                    if (debug) {
                        System.out.println("BUILD CPI: tl=" + dispArea.tlDisplay + "  br=" + dispArea.brDisplay);
                    }
                }
                catch (NoninvertibleTransformException ex) {
                    System.err.println("GSPS: Cannot invert current Affine Transform !!!");
                }
            }
            voiLUT.refImgSequence.add(frame);
            if (!sharedIRA || first) {
                double wl;
                double ww = ira.getWindowWidth();
                voiLUT.windowCenter = wl = ira.getWindowLevel();
                voiLUT.windowWidth = ww;
                voiLUT.wwwlExplanation = "GEMS JAMI ww/wl setting";
            }
            boolean ivideo = ira.isVideoInverted();
            IndexColorModel lut = ira.getColormap();
            SoftcopyPresentationLut spl = cpi.getSoftcopyPresentationLut();
            if (cpi.nImages == 0) {
                String string = spl.pLutShape = ivideo ? INVERSE : IDENTITY;
                if (lut != null) {
                    int len = lut.getMapSize();
                    if (rgbs == null || rgbs.length != len) {
                        rgbs = new int[len];
                    }
                    lut.getRGBs(rgbs);
                    if (XpCPI.isGreyScaleMap(rgbs)) {
                        spl.lutExplanation = "" + lut;
                        spl.lutDescriptor = new Integer[3];
                        short ilen = (short)len;
                        if (len == 65536) {
                            ilen = 0;
                        }
                        spl.lutDescriptor[0] = new Integer(ilen);
                        spl.lutDescriptor[1] = new Integer(0);
                        spl.lutDescriptor[2] = new Integer(8);
                        if (lutData == null || prevLut != lut) {
                            lutData = XpCPI.getLutData(rgbs);
                        }
                        prevLut = lut;
                        spl.lutData = lutData;
                    }
                }
            } else {
                String spl_lut;
                String lutExplanation;
                boolean ivid = spl.pLutShape == INVERSE;
                String lutName = spl.lutExplanation;
                if (ivid != ivideo) {
                    spl.pLutShape = IDENTITY;
                }
                if (!(lutExplanation = "" + lut).equals(spl_lut = "" + spl.lutExplanation)) {
                    spl.lutData = null;
                    spl.lutDescriptor = null;
                    spl.lutExplanation = null;
                }
            }
            GraphicLayer roiLayer = new GraphicLayer("GRX LAYER 0");
            List uannot = auannos[i];
            List rois = arois[i];
            int nrois = rois.size();
            int nannos = uannot.size();
            if (nrois > 0 || nannos > 0) {
                int j;
                gAnnot = new GraphicAnnotation(roiLayer);
                cpi.getGraphicAnnotation().add(gAnnot);
                gAnnot.refImgSequence.add(frame);
                for (j = 0; j < rois.size(); ++j) {
                    Point2D[] pts;
                    RoiActor ra = (RoiActor)rois.get(j);
                    GraphicObject gobj = new GraphicObject();
                    gobj.graphicUnits = 0;
                    gobj.filled = false;
                    GSPSGraphic description = ra.gspsDescription();
                    if (description == null) continue;
                    if (debug) {
                        System.out.println("*** GSPS DESCRIPTION: " + description);
                    }
                    if ((pts = description.getPoints()) != null) {
                        for (int idx = 0; idx < pts.length; ++idx) {
                            Point2D.Double p = new Point2D.Double(pts[idx].getX(), pts[idx].getY());
                            gobj.graphicData.add(p);
                        }
                    }
                    gobj.graphicType = description.getGraphicType();
                    gobj.filled = description.isGraphicFilled();
                    gobj.graphicUnits = 0;
                    gAnnot.graphicSequence.add(gobj);
                }
                for (j = 0; j < uannot.size(); ++j) {
                    boolean showTarget;
                    XpUserAnnotationModel uam = (XpUserAnnotationModel)uannot.get(j);
                    TextObject tobj = new TextObject();
                    CPoint textPoint = uam.getTextAnchor();
                    CPoint target = uam.getTarget();
                    tobj.anchorUnits = target.csystem;
                    tobj.bboxUnits = textPoint.csystem;
                    tobj.anchorPoint.setLocation(target.x, target.y);
                    double bb_x = textPoint.x;
                    double bb_y = textPoint.y;
                    double bb_w = uam.getWidth();
                    double bb_h = uam.getHeight();
                    if (tobj.bboxUnits == 1) {
                        bb_x /= vpDim.getWidth();
                        bb_y /= vpDim.getHeight();
                        bb_w /= vpDim.getWidth();
                        bb_h /= vpDim.getHeight();
                        tobj.bboxUnits = (byte)3;
                    }
                    tobj.boundingBox.setFrame(bb_x, bb_y, bb_w, bb_h);
                    tobj.anchorVisibility = showTarget = uam.isShowTarget();
                    tobj.bboxJustification = LEFT;
                    tobj.textValue = uam.getText();
                    gAnnot.textSequence.add(tobj);
                }
            }
            if (first) {
                first = false;
            }
            ++cpi.nImages;
        }
    }

    private static boolean isGreyScaleMap(int[] rgbs) {
        for (int i = 0; i < rgbs.length; ++i) {
            int rgb = rgbs[i];
            int red = rgb & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb >> 16 & 0xFF;
            if (red == green && green == blue) continue;
            return false;
        }
        return true;
    }

    private static Integer[] getLutData(int[] rgbs) {
        Integer[] lutData = new Integer[rgbs.length];
        for (int i = 0; i < rgbs.length; ++i) {
            int rgb = rgbs[i];
            int red = rgb & 0xFF;
            lutData[i] = new Integer(red);
        }
        return lutData;
    }

    private static int[] getLutData(Integer[] data, Integer[] lutDesc) {
        int len = lutDesc[0];
        int nbits = lutDesc[2];
        int maxval = (int)Math.pow(2.0, nbits);
        int[] rgbs = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            int val = data[i];
            double n = (double)val / (double)maxval * 255.0;
            int grey = (int)n & 0xFF;
            rgbs[i] = grey << 16 & 0xFF0000 | grey << 8 & 0xFF00 | grey & 0xFF;
        }
        return rgbs;
    }

    public static void clearGraphics(List scenes) {
        int len = scenes.size();
        for (int i = 0; i < len; ++i) {
            XpImageScene is = (XpImageScene)scenes.get(i);
            is.getRois().clear();
            is.getUserAnnos().clear();
        }
    }

    private static Shape getShape(DisplayShutter ds) {
        Shape s = null;
        if (ds.shutterShape.equals(RECTANGULAR)) {
            Point2D ul = ds.rectULPoint;
            Point2D br = ds.rectBRPoint;
            double w = Math.abs(ul.getX() - br.getX());
            double h = Math.abs(ul.getY() - br.getY());
            s = new Rectangle2D.Double(ul.getX(), ul.getY(), w, h);
        } else if (ds.shutterShape.equals(CIRCULAR)) {
            double r = ds.circularRadius;
            double x = ds.circularCenter.getX() - r;
            double y = ds.circularCenter.getY() - r;
            s = new Ellipse2D.Double(x, y, 2.0 * r, 2.0 * r);
        }
        if (ds.shutterShape.equals(POLYGONAL)) {
            GeneralPath gp = new GeneralPath();
            gp.reset();
            int len = ds.polygonalVertices.size();
            for (int i = 0; i < len; ++i) {
                Point2D p = (Point2D)ds.polygonalVertices.get(i);
                if (i == 0) {
                    gp.moveTo((float)p.getX(), (float)p.getY());
                    continue;
                }
                gp.lineTo((float)p.getX(), (float)p.getY());
            }
            if (len > 2) {
                Point2D p = (Point2D)ds.polygonalVertices.get(0);
                gp.lineTo((float)p.getX(), (float)p.getY());
            }
            s = gp;
        }
        return s;
    }

    public static void applyCPI(XpCPI cpi, ClipCapable cc) {
        Shape s;
        DisplayShutter ds = cpi.getDisplayShutter(1);
        DisplayShutter ids = cpi.getDisplayShutter(0);
        if (ds != null && (s = XpCPI.getShape(ds)) != null) {
            cc.setClipShape(s);
        }
        if (ids != null && (s = XpCPI.getShape(ids)) != null) {
            cc.setImageClip(s);
        }
    }

    public static void putAllImages(List sceneList, List refImgSequence) {
        int nscenes = sceneList.size();
        XpDicomElement sopclassUID = new XpDicomElement(8, 22);
        XpDicomElement sopinstanceUID = new XpDicomElement(8, 24);
        for (int i = 0; i < nscenes; ++i) {
            XpImageScene is = (XpImageScene)sceneList.get(i);
            XpMedicalImage mimg = (XpMedicalImage)is.getFrame();
            int res0 = mimg.getValue(sopclassUID);
            int res1 = mimg.getValue(sopinstanceUID);
            GSPSFrame frame = new GSPSFrame();
            if (res0 == 0) {
                frame.SOPClassUID = "" + sopclassUID.value;
            }
            if (res1 == 0) {
                frame.SOPInstanceUID = "" + sopinstanceUID.value;
            }
            frame.ReferencedFrameNum = 0;
            refImgSequence.add(frame);
        }
    }

    public void applyCPI(List sceneList) {
        int len;
        List refImgSeq;
        int i;
        Dimension vpDim = new Dimension(512, 512);
        int nscenes = sceneList.size();
        DisplayedArea dispArea = null;
        GraphicAnnotation gAnnot = null;
        SoftcopyVoiLut voiLUT = null;
        List lda = this.getDisplayedArea();
        List svl = this.getSoftcopyVoiLut();
        List ga = this.getGraphicAnnotation();
        SpatialTransformation st = this.getSpatialTransformation();
        SoftcopyPresentationLut spl = this.getSoftcopyPresentationLut();
        int imgWidth = 0;
        int imgHeight = 0;
        PLutIndexColorModel icm = null;
        SceneCache scenes = new SceneCache(sceneList);
        for (i = 0; i < lda.size(); ++i) {
            dispArea = (DisplayedArea)lda.get(i);
            refImgSeq = dispArea.refImgSequence;
            if (refImgSeq.size() > 0) continue;
            XpCPI.putAllImages(sceneList, refImgSeq);
        }
        for (i = 0; i < svl.size(); ++i) {
            voiLUT = (SoftcopyVoiLut)svl.get(i);
            refImgSeq = voiLUT.refImgSequence;
            if (refImgSeq.size() > 0) continue;
            XpCPI.putAllImages(sceneList, refImgSeq);
        }
        for (i = 0; i < ga.size(); ++i) {
            gAnnot = (GraphicAnnotation)ga.get(i);
            refImgSeq = gAnnot.refImgSequence;
            if (refImgSeq.size() > 0) continue;
            XpCPI.putAllImages(sceneList, refImgSeq);
        }
        for (i = 0; i < nscenes; ++i) {
            XpImageScene is = scenes.get(i);
            XpImageRenderAttributes ira = is.getImageRenderAttributes();
            ira.setVideoInverted(spl.pLutShape.equals(INVERSE));
            String lutExplanation = spl.lutExplanation;
            Integer[] lutDesc = spl.lutDescriptor;
            Integer[] lutData = spl.lutData;
            if (lutExplanation != null) {
                IndexColorModel ic;
                if (lutExplanation.equals("g1")) {
                    ic = XpImageLut.g1().getLUT();
                    ira.setColormap(ic);
                } else if (lutExplanation.equals("g2")) {
                    ic = XpImageLut.g2().getLUT();
                    ira.setColormap(ic);
                } else if (lutExplanation.equals("g3")) {
                    ic = XpImageLut.g3().getLUT();
                    ira.setColormap(ic);
                } else if (lutData != null) {
                    if (icm == null) {
                        int[] rgbs = XpCPI.getLutData(lutData, lutDesc);
                        icm = new PLutIndexColorModel(lutExplanation, 16, rgbs.length, rgbs, 0, false, -1, 1);
                    }
                    ira.setColormap(icm);
                }
            }
            is.setImageRenderAttributes(ira);
            XpImage img = is.getFrame();
            imgWidth = img.getSlice().width;
            imgHeight = img.getSlice().height;
        }
        if (ga != null) {
            len = ga.size();
            for (int i2 = 0; i2 < len; ++i2) {
                gAnnot = (GraphicAnnotation)ga.get(i2);
                List rois = gAnnot.graphicSequence;
                List uannos = gAnnot.textSequence;
                int nframes = gAnnot.refImgSequence.size();
                for (int j = 0; j < nframes; ++j) {
                    GSPSFrame frame = (GSPSFrame)gAnnot.refImgSequence.get(j);
                    XpImageScene is = scenes.getScene(frame);
                    if (is == null) continue;
                    if (debug) {
                        System.out.println("ROI's: Found Image Scene: " + sceneList.indexOf(is));
                    }
                    int nrois = rois.size();
                    for (int k = 0; k < nrois; ++k) {
                        GraphicObject gobj = (GraphicObject)rois.get(k);
                        RoiActor ra = XpCPI.createROI(gobj.graphicType, gobj.graphicData, gobj.filled, gobj.graphicUnits);
                        if ("true".equalsIgnoreCase(XpPropertiesManager.getProperty("reset.roi.number.per.port", "true")) && ra instanceof XpStatisticsRoi) {
                            ((XpStatisticsRoi)ra).setRoiLabel("" + (k + 1));
                        }
                        if (ra == null) continue;
                        is.add(ra);
                    }
                    int nannos = uannos.size();
                    for (int k = 0; k < nannos; ++k) {
                        TextObject tobj = (TextObject)uannos.get(k);
                        double bbX = tobj.boundingBox.getX();
                        double bbY = tobj.boundingBox.getY();
                        byte csystem = tobj.bboxUnits;
                        CPoint anchor = new CPoint(bbX, bbY, 0.0, csystem);
                        CPoint target = new CPoint(tobj.anchorPoint.getX(), tobj.anchorPoint.getY(), 0.0, tobj.anchorUnits);
                        String text = tobj.textValue;
                        XpUserAnnotationModel uam = new XpUserAnnotationModel(text, anchor, target);
                        is.add(uam);
                        uam.setShowTarget(tobj.anchorVisibility);
                        if (!tobj.anchorVisibility) {
                            uam.setShowBorder(false);
                        }
                        if (editable) continue;
                        uam.setEditable(false);
                        uam.setResize(false);
                    }
                }
            }
        }
        if (lda != null) {
            len = lda.size();
            for (int i3 = 0; i3 < len; ++i3) {
                dispArea = (DisplayedArea)lda.get(i3);
                GSPSFrame firstframe = (GSPSFrame)dispArea.refImgSequence.get(0);
                XpImageScene scene = scenes.getScene(firstframe);
                if (scene != null) {
                    XpImage img = scene.getFrame();
                    imgWidth = img.getSlice().width;
                    imgHeight = img.getSlice().height;
                }
                if (debug) {
                    System.out.println("tlhc=" + dispArea.tlDisplay);
                }
                if (debug) {
                    System.out.println("brhc=" + dispArea.brDisplay);
                }
                double uzoom = dispArea.pixelMagnificationRatio;
                double tx = dispArea.tlDisplay.getX();
                double ty = dispArea.tlDisplay.getY();
                double bx = dispArea.brDisplay.getX();
                double by = dispArea.brDisplay.getY();
                double px = bx;
                double py = ty;
                double[] data = new double[]{tx, ty, 1.0, bx, by, 1.0, px, py, 1.0};
                double[] dataX = new double[]{1.0, vpDim.getWidth(), vpDim.getWidth()};
                double[] dataY = new double[]{1.0, vpDim.getHeight(), 1.0};
                m.set(data);
                try {
                    b.set(dataX);
                    m.LUDSolve(b, v0);
                    b.set(dataY);
                    m.LUDSolve(b, v1);
                }
                catch (Exception e) {
                    int j;
                    System.err.println("ERROR Solving Linear System.");
                    System.err.println("tlhc[" + i3 + "]=" + dispArea.tlDisplay);
                    System.err.println("brhc[" + i3 + "]=" + dispArea.brDisplay);
                    System.err.print("data: ");
                    for (j = 0; j < data.length; ++j) {
                        System.err.print("" + data[j] + " ");
                    }
                    System.err.println("");
                    System.err.print("dataX: ");
                    for (j = 0; j < dataX.length; ++j) {
                        System.err.print("" + dataX[j] + " ");
                    }
                    System.err.println("");
                    System.err.print("dataY: ");
                    for (j = 0; j < dataY.length; ++j) {
                        System.err.print("" + dataY[j] + " ");
                    }
                    System.err.println("");
                    continue;
                }
                double m00 = XpCPI.v0.data[0];
                double m01 = XpCPI.v0.data[1];
                double m02 = XpCPI.v0.data[2];
                double m10 = XpCPI.v1.data[0];
                double m11 = XpCPI.v1.data[1];
                double m12 = XpCPI.v1.data[2];
                AffineTransform at = new AffineTransform(m00, m10, m01, m11, m02, m12);
                double vp_tx = 0.5 * vpDim.getWidth();
                double vp_ty = 0.5 * vpDim.getHeight();
                double im_tx = 0.5 * (double)imgWidth;
                double im_ty = 0.5 * (double)imgHeight;
                tempPt1.setLocation(im_tx, im_ty);
                at.transform(tempPt1, tempPt2);
                tempPt1.setLocation(vpDim.getWidth() / 2.0, vpDim.getHeight() / 2.0);
                try {
                    at.inverseTransform(tempPt1, tempPt2);
                }
                catch (NoninvertibleTransformException ex1) {
                    ex1.printStackTrace();
                }
                double panx = im_tx - tempPt2.getX();
                double pany = im_ty - tempPt2.getY();
                if (debug) {
                    System.out.println("-------------------------------------------------------------");
                    System.out.println("APPLY CPI: tlhc[" + i3 + "]=" + dispArea.tlDisplay);
                    System.out.println("APPLY CPI: brhc[" + i3 + "]=" + dispArea.brDisplay);
                    System.out.println("APPLY CPI: panX =" + panx + " panY=" + pany);
                    System.out.println("APPLY CPI: imgWidth=" + imgWidth + "  imgHeight=" + imgHeight + "  txCenter=" + tempPt2);
                    System.out.println("APPLY CPI: vpDIM          =" + vpDim);
                    System.out.println("APPLY CPI: AffineTransform=" + at);
                    System.out.println("-------------------------------------------------------------");
                }
                double zoom = 1.0;
                try {
                    if (imgWidth >= imgHeight) {
                        tempPt1.setLocation(vpDim.getWidth(), vp_ty);
                        at.inverseTransform(tempPt1, tempPt2);
                        tempPt1.setLocation(0.0, vp_ty);
                        at.inverseTransform(tempPt1, tempPt3);
                        double px1 = tempPt2.getX();
                        double px2 = tempPt3.getX();
                        double diffX = Math.abs(px2 - px1);
                        zoom = (double)imgWidth / diffX;
                    } else {
                        tempPt1.setLocation(vp_tx, vpDim.getHeight());
                        at.inverseTransform(tempPt1, tempPt2);
                        tempPt1.setLocation(vp_tx, 0.0);
                        at.inverseTransform(tempPt1, tempPt3);
                        double diffY = Math.abs(tempPt3.getY() - tempPt2.getY());
                        zoom = (double)imgHeight / diffY;
                    }
                }
                catch (NoninvertibleTransformException ex) {
                    System.err.println("ERROR inverting affine transform....");
                    continue;
                }
                int psmode = 100;
                if (dispArea.presSize.equals(MAGNIFY)) {
                    zoom = uzoom;
                    psmode = 102;
                } else if (dispArea.presSize.equals(TRUE_SIZE)) {
                    psmode = 101;
                }
                if (debug) {
                    System.out.println("-- ZOOM = " + zoom + " PRES. SIZE=" + dispArea.presSize);
                }
                int nframes = dispArea.refImgSequence.size();
                for (int j = 0; j < nframes; ++j) {
                    double angle;
                    GSPSFrame frame = (GSPSFrame)dispArea.refImgSequence.get(j);
                    XpImageScene is = scenes.getScene(frame);
                    if (is == null) continue;
                    XpImageRenderAttributes ira = is.getImageRenderAttributes();
                    ira.setPan(panx, pany);
                    XpImageOrientation ior = ira.getImageOrientation();
                    double stangle = st.angle;
                    if (st.flipHorizontal) {
                        stangle = -stangle;
                    }
                    ior.apply(stangle, st.flipHorizontal);
                    if (debug) {
                        System.out.println("APPLY CPI: px=" + panx + "  py=" + pany + "  angle=" + st.angle + "  flip=" + st.flipHorizontal);
                    }
                    ira.setZoom(zoom);
                    ira.setPresentationSizeMode(psmode);
                    is.setImageRenderAttributes(ira);
                    XpImage img = is.getFrame();
                    if (img instanceof XpMedicalImage && (angle = XpImageUtils.gehcAzimuth((XpMedicalImage)img)) != 0.0) {
                        XpImageOrientation eff = new XpImageOrientation();
                        eff.rotate(-Math.toRadians(angle));
                        int iorstate = ior.getState();
                        if (angle == 270.0) {
                            System.err.println("iorstate=" + iorstate);
                            ior.setPan(-panx, -pany);
                            double tmpval = 0.0;
                            switch (iorstate) {
                                case 0: {
                                    tmpval = panx;
                                    panx = -pany;
                                    pany = tmpval;
                                    break;
                                }
                                case 1: {
                                    pany = -pany;
                                    panx = -panx;
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                                case 3: {
                                    tmpval = panx;
                                    panx = pany;
                                    pany = -tmpval;
                                    break;
                                }
                                case 4: {
                                    tmpval = panx;
                                    panx = pany;
                                    pany = tmpval;
                                    break;
                                }
                                case 5: {
                                    panx = -panx;
                                    break;
                                }
                                case 6: {
                                    pany = -pany;
                                    break;
                                }
                                case 7: {
                                    tmpval = panx;
                                    panx = -pany;
                                    pany = -tmpval;
                                }
                            }
                            ior.setPan(panx, pany);
                        }
                        eff.apply(ior);
                        ior.set(eff);
                    }
                    ira.setImageOrientation(ior);
                    is.setImageRenderAttributes(ira);
                }
                if (!debug) continue;
                System.out.println("-------------------------------------------");
            }
        }
        if (svl != null) {
            len = svl.size();
            for (int i4 = 0; i4 < len; ++i4) {
                voiLUT = (SoftcopyVoiLut)svl.get(i4);
                if (!voiLUT.wwwlSpecified) continue;
                double ww = voiLUT.windowWidth;
                double wl = voiLUT.windowCenter;
                int nframes = voiLUT.refImgSequence.size();
                for (int j = 0; j < nframes; ++j) {
                    GSPSFrame frame = (GSPSFrame)voiLUT.refImgSequence.get(j);
                    XpImageScene is = scenes.getScene(frame);
                    if (is == null) continue;
                    XpImageRenderAttributes ira = is.getImageRenderAttributes();
                    ira.setWindowing(ww, wl);
                    is.setImageRenderAttributes(ira);
                }
            }
        }
    }

    private static class PLutIndexColorModel
    extends IndexColorModel {
        private String plutName = "";

        public PLutIndexColorModel(String lutName, int bits, int size, int[] cmap, int start, boolean hasalpha, int trans, int transferType) {
            super(bits, size, cmap, start, hasalpha, trans, transferType);
            this.plutName = lutName;
        }

        public final String toString() {
            return this.plutName;
        }
    }

    private static class SceneCache {
        private boolean multiFrameCheck = false;
        private boolean isMultiFrame = false;
        private List scenes = null;
        private Map cache = new HashMap();
        private boolean cacheBuild = true;

        public SceneCache(List scenes) {
            this.scenes = scenes;
        }

        public XpImageScene getScene(GSPSFrame frame) {
            XpImageScene imgScene = null;
            int len = this.scenes.size();
            if (!this.multiFrameCheck) {
                this.multiFrameCheck = true;
                if (len > 1) {
                    XpImageScene is1 = (XpImageScene)this.scenes.get(0);
                    XpImageScene is2 = (XpImageScene)this.scenes.get(1);
                    XpImage img1 = is1.getFrame();
                    XpImage img2 = is2.getFrame();
                    if (img1 instanceof XpMedicalImage && img2 instanceof XpMedicalImage) {
                        XpMedicalImage mi1 = (XpMedicalImage)img1;
                        XpMedicalImage mi2 = (XpMedicalImage)img2;
                        mi1.getValue(sopUID);
                        String sopuid1 = "" + sopUID.value;
                        mi2.getValue(sopUID);
                        String sopuid2 = "" + sopUID.value;
                        if (sopuid1.equals(sopuid2)) {
                            this.isMultiFrame = true;
                        }
                    }
                }
            }
            if (this.isMultiFrame) {
                if (frame.ReferencedFrameNum < len && frame.ReferencedFrameNum >= 0) {
                    imgScene = (XpImageScene)this.scenes.get(frame.ReferencedFrameNum);
                }
            } else {
                if (this.cacheBuild) {
                    this.cacheBuild = false;
                    for (int i = 0; i < len; ++i) {
                        XpImageScene is = (XpImageScene)this.scenes.get(i);
                        XpImage img = is.getFrame();
                        if (!(img instanceof XpMedicalImage)) continue;
                        XpMedicalImage mimg = (XpMedicalImage)img;
                        mimg.getValue(sopUID);
                        if (sopUID.value == null) continue;
                        this.cache.put(sopUID.value, is);
                    }
                }
                imgScene = (XpImageScene)this.cache.get(frame.SOPInstanceUID);
            }
            return imgScene;
        }

        public XpImageScene get(int i) {
            return (XpImageScene)this.scenes.get(i);
        }

        public final int size() {
            return this.scenes.size();
        }
    }

    public static class SpatialTransformation {
        public double angle = 0.0;
        public boolean flipHorizontal = false;
    }

    public static class GraphicLayer {
        public String layerUID = "Graphic Layer";
        public int layerOrder = 1;
        public short recommendedLuminance = (short)-1;
        public short[] recommendedRGB = new short[3];
        public String layerDescription = null;

        public GraphicLayer(String description) {
            this.layerDescription = description;
            for (int i = 0; i < this.recommendedRGB.length; ++i) {
                this.recommendedRGB[i] = -1;
            }
        }
    }

    public static class GraphicObject {
        public byte graphicUnits = 0;
        public int graphicDim = 2;
        public List graphicData = new ArrayList();
        public String graphicType = "";
        public boolean filled = false;
    }

    public static class TextObject {
        public byte bboxUnits = 1;
        public byte anchorUnits = 0;
        public String textValue = null;
        public Rectangle2D boundingBox = new Rectangle2D.Double();
        public String bboxJustification = "LEFT";
        public Point2D anchorPoint = new Point2D.Double();
        public boolean anchorVisibility = false;
    }

    public static class LUTItem {
        public int numEntries = 0;
        public int firstValue = 0;
        public int numBits = 16;
        public String lutExplanation = "";
        public Vector lutData = new Vector();
    }

    public static class OverlayPlane {
        public int rows = 0;
        public int cols = 0;
        public String overlayType = "";
        public Point2D overlayOrigin = new Point2D.Double();
        public int nBitAllocated = 0;
        public byte[] overlayData = null;
        public String overlayDescription = "";
        public String overlaySubType = "";
        public String overlayLabel = "";
        public double roiArea = 0.0;
        public double roiMean = 0.0;
        public double roiStdDev = 0.0;
    }

    public static class BitmapDisplayShutter {
        public final String shutterShape = "BITMAP";
        public OverlayPlane overlayPlane = new OverlayPlane();
        public int shutterPValue = 0;
    }

    public static class DisplayShutter {
        public int coordSystem = 1;
        public String shutterShape = "";
        public Point2D rectULPoint = new Point2D.Double();
        public Point2D rectBRPoint = new Point2D.Double();
        public Point2D circularCenter = new Point2D.Double();
        public double circularRadius = 0.0;
        public List polygonalVertices = null;
        public int shutterPValue = 0;
    }

    public static class SoftcopyPresentationLut {
        public Integer[] lutDescriptor = null;
        public String lutExplanation = null;
        public Integer[] lutData = null;
        public String pLutShape = "IDENTITY";
    }

    public static class SoftcopyVoiLut
    extends GSPSItem {
        public LUTItem lItem = new LUTItem();
        public double windowCenter = 0.0;
        public double windowWidth = 0.0;
        public String wwwlExplanation = "";
        public boolean wwwlSpecified = false;
    }

    public static class ModalityLut {
        public Integer[] lutDescriptor = null;
        public String lutExplanation = null;
        public String modalityLUTType = "";
        public Integer[] lutData = null;
        public double rescaleIntercept = 0.0;
        public double rescaleSlope = 1.0;
    }

    public static class GraphicAnnotation
    extends GSPSItem {
        private static int uid = 0;
        public GraphicLayer grxLayer = null;
        public List textSequence = new ArrayList();
        public List graphicSequence = new ArrayList();

        public GraphicAnnotation(GraphicLayer grxLayer) {
            this.grxLayer = grxLayer;
        }
    }

    public static class DisplayedArea
    extends GSPSItem {
        public Point2D tlDisplay = new Point2D.Double();
        public Point2D brDisplay = new Point2D.Double();
        public String presSize = "SCALE TO FIT";
        public Point2D presPixelSpacing = new Point2D.Double();
        public Point2D presPixelAspectRatio = new Point2D.Double();
        public double pixelMagnificationRatio = 1.0;
    }

    public static abstract class GSPSItem {
        public List refImgSequence = new ArrayList();
    }

    public static class GSPSFrame {
        public String SOPClassUID = "";
        public String SOPInstanceUID = "";
        public int ReferencedFrameNum = 1;
    }
}

