/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpVisualComponent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;

public class FPSMonitorVc
extends XpVisualComponent {
    private static final int FPS_RENDERWINDOW = 64;
    private static Font f = new Font("Monospaced", 2, 12);
    private int fpsWidth = 128;
    private int fpsHeight = 64;
    private RoundRectangle2D rect = new RoundRectangle2D.Double();
    private double fps = 0.0;
    private int n_measurements = 1;
    private long time_msec = 0L;
    private long[] measurements = new long[64];
    private int idx = 0;
    private DecimalFormat nformat = new DecimalFormat("#0.##");

    public FPSMonitorVc() {
        this.setForeground(new Color(255, 0, 0, 128));
        this.setBackground(Color.black);
        this.setFont(f);
    }

    public boolean contains(int x, int y) {
        return false;
    }

    public void addMeasurement(long timemsec) {
        this.measurements[this.idx] = timemsec;
        this.idx = (this.idx + 1) % this.measurements.length;
        ++this.n_measurements;
        long sum = 0L;
        int nm = Math.min(this.measurements.length, this.n_measurements);
        for (int i = 0; i < nm; ++i) {
            sum += this.measurements[i];
        }
        this.fps = 1000.0 / ((double)sum / (double)nm);
        this.time_msec = (long)((double)sum / (double)nm);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        double width = this.getWidth();
        double height = this.getHeight();
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        double x = width * 0.7;
        double y = height - (double)this.fpsHeight - 5.0;
        this.rect.setRoundRect(x, y, this.fpsWidth, this.fpsHeight, 15.0, 10.0);
        g2.setColor(this.getForeground());
        g2.fill(this.rect);
        g2.setColor(this.getBackground());
        g2.draw(this.rect);
        g2.setFont(this.getFont());
        double xoffset = x + 3.0;
        double textHeight = this.drawString(g2, "FPS  : " + this.nformat.format(this.fps), xoffset, y);
        y += textHeight;
        textHeight = this.drawString(g2, "Draws: " + this.n_measurements, xoffset, y);
        y += textHeight;
        textHeight = this.drawString(g2, "Time : " + this.time_msec + "ms", xoffset, y);
    }

    private double drawString(Graphics2D g2, String label, double x, double y) {
        Rectangle2D bounds = this.getFont().getStringBounds(label, g2.getFontRenderContext());
        g2.drawString(label, (int)x, (int)(y + bounds.getHeight()));
        return bounds.getHeight();
    }
}

