/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.jnu.JnVector3d;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class CPoint
extends JnVector3d
implements Cloneable,
Serializable {
    public static final byte IMAGE = 0;
    public static final byte DISPLAY = 1;
    public static final byte RAS = 2;
    public static final byte NORMALIZED = 3;
    public static final byte LPS = 4;
    public static final byte VOXEL = 5;
    private static String[] csysname = new String[]{"IMAGE", "DISPLAY", "RAS", "NORMALIZED", "LPS", "VOXEL"};
    public byte csystem = (byte)2;

    public CPoint() {
    }

    public CPoint(byte csystem) {
        this.csystem = csystem;
    }

    public CPoint(double[] p, byte csystem) {
        this.setPoint(p[0], p[1], p[2], csystem);
    }

    public CPoint(double x, double y, double z, byte csystem) {
        this.setPoint(x, y, z, csystem);
    }

    public CPoint(Point2D p, byte csystem) {
        this(p.getX(), p.getY(), 0.0, csystem);
    }

    public CPoint(int x, int y, int z, byte csystem) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.csystem = csystem;
    }

    public CPoint(CPoint other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        this.csystem = other.csystem;
    }

    public CPoint(CPoint p0, CPoint p) {
        this(p);
        this.subtract(p0);
    }

    public CPoint(Point p0, Point p) {
        this.x = p.getX() - p0.getX();
        this.y = p.getY() - p0.getY();
        this.z = 0.0;
        this.csystem = 1;
    }

    public CPoint(Point p) {
        this.x = p.getX();
        this.y = p.getY();
        this.z = 0.0;
        this.csystem = 1;
    }

    public Object clone() {
        return new CPoint(this);
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CPoint) {
            if (((CPoint)other).csystem != this.csystem) {
                return false;
            }
            return super.equals(other);
        }
        return false;
    }

    public final CPoint cross(CPoint p, CPoint r) {
        r.csystem = this.csystem;
        r.x = this.y * p.z - p.y * this.z;
        r.y = -this.x * p.z + this.z * p.x;
        r.z = this.x * p.y - this.y * p.x;
        return r;
    }

    public final CPoint cross(CPoint p) {
        CPoint r = new CPoint(this.csystem);
        return this.cross(p, r);
    }

    public static String getCSystem(byte csystem_val) {
        return csysname[csystem_val];
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")_" + csysname[this.csystem];
    }

    public final void setPoint(CPoint cp) {
        this.setPoint(cp.x, cp.y, cp.z, cp.csystem);
    }

    public final void setPoint(double x, double y, double z, byte csystem) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.csystem = csystem;
    }

    public final void setPoint(Point p0, Point p) {
        this.x = p.getX() - p0.getX();
        this.y = p.getY() - p0.getY();
        this.z = 0.0;
        this.csystem = 1;
    }

    public final void setPoint(CPoint p0, CPoint p) {
        this.x = p.x - p0.x;
        this.y = p.y - p0.y;
        this.z = p.z - p0.z;
        this.csystem = p.csystem;
    }
}

