/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.border.CuiBorder;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import javax.swing.text.View;

public class CuiToggleButtonUI
extends MetalToggleButtonUI {
    protected static CuiToggleButtonUI ToggleButtonUI_ = null;
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery((String[])argv, (String)"@(#)ptk2 2.7 200609011020 (Sun Microsystems Inc.|1.4.2_05|48.0|Linux|2.6.7-2.2smp|i386|batbuild)");
    }

    public static ComponentUI createUI(JComponent c) {
        return ToggleButtonUI_ != null ? ToggleButtonUI_ : (ToggleButtonUI_ = new CuiToggleButtonUI());
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b2 = (AbstractButton)c;
        boolean rotate = b2.getClientProperty("vertical") == Boolean.TRUE;
        int gap = 0;
        rotate = rotate || !b2.getComponentOrientation().isHorizontal();
        gap = b2.getIconTextGap();
        Dimension pref = Utilities.getPreferredButtonSize(b2, gap, rotate ? 1 : 0);
        if (pref.height % 2 != 0) {
            ++pref.height;
        }
        Dimension min = (Dimension)UIManager.get("ToggleButton.minimumSize");
        Dimension max = (Dimension)UIManager.get("ToggleButton.maximumSize");
        if (max != null) {
            pref.setSize(Math.min(max.width, pref.width), Math.min(max.height, pref.height));
        }
        if (min != null) {
            pref.setSize(Math.max(min.width, pref.width), Math.max(min.height, pref.height));
        }
        return pref;
    }

    public void paint(Graphics g, JComponent c) {
        Utilities.antiAlias((Graphics2D)g);
        AbstractButton b2 = (AbstractButton)c;
        ButtonModel model = b2.getModel();
        Insets i = c.getInsets();
        CuiToggleButtonUI.viewRect.x = i.left;
        CuiToggleButtonUI.viewRect.y = i.top;
        CuiToggleButtonUI.viewRect.width = c.getWidth() - (i.left + i.right);
        CuiToggleButtonUI.viewRect.height = c.getHeight() - (i.top + i.bottom);
        CuiToggleButtonUI.textRect.height = 0;
        CuiToggleButtonUI.textRect.width = 0;
        CuiToggleButtonUI.textRect.y = 0;
        CuiToggleButtonUI.textRect.x = 0;
        CuiToggleButtonUI.iconRect.height = 0;
        CuiToggleButtonUI.iconRect.width = 0;
        CuiToggleButtonUI.iconRect.y = 0;
        CuiToggleButtonUI.iconRect.x = 0;
        boolean rotate = c.getClientProperty("vertical") == Boolean.TRUE || !c.getComponentOrientation().isHorizontal();
        int textIconGap = b2.getIconTextGap();
        Icon icon = b2.getIcon();
        Font font = b2.getFont();
        g.setFont(font);
        String text = Utilities.layoutCompoundLabel(c, g.getFontMetrics(), b2.getText(), icon, b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, textIconGap, rotate ? 1 : 0);
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b2);
        }
        if (icon != null) {
            this.paintIcon(g, c, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                Utilities.paintView(v, g, textRect, rotate ? 1 : 0);
            } else {
                this.paintText(g, b2, textRect, text);
            }
        }
        if (b2.isFocusPainted() && b2.hasFocus()) {
            this.paintFocus(g, b2, viewRect, textRect, iconRect);
        }
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b2) {
        if (!Utilities.paintButtonBackground(g, b2, "ToggleButton")) {
            super.paintButtonPressed(g, b2);
        }
    }

    protected void paintText(Graphics g, AbstractButton b2, Rectangle textRect, String text) {
        Utilities.paintText(g, b2, "ToggleButton", textRect, text);
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        Utilities.paintText(g, (AbstractButton)c, "ToggleButton", textRect, text);
    }

    protected void paintFocus(Graphics g, AbstractButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b2.isBorderPainted() && b2.getBorder() instanceof CuiBorder) {
            return;
        }
        super.paintFocus(g, b2, viewRect, textRect, iconRect);
    }

    public void update(Graphics g, JComponent c) {
        Utilities.paintButtonBackground(g, (AbstractButton)c, "ToggleButton");
        super.update(g, c);
    }
}

