/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class CuiTableCellRenderer
extends DefaultTableCellRenderer {
    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery((String[])argv, (String)"@(#)ptk2 2.7 200609011020 (Sun Microsystems Inc.|1.4.2_05|48.0|Linux|2.6.7-2.2smp|i386|batbuild)");
    }

    public boolean isOpaque() {
        return true;
    }

    protected void prepareComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
        this.setOpaque(true);
        if (row < 0) {
            JTableHeader header = table.getTableHeader();
            this.setHorizontalAlignment(0);
            this.setFont(header.getFont());
            Border border = Utilities.getUIPropertyBorder(header, "TableHeader.cellBorder");
            if (border != null) {
                this.setBorder(border);
            }
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
        } else {
            this.setHorizontalAlignment(2);
            this.setFont(table.getFont());
            Border border = null;
            if (focus) {
                border = Utilities.getUIPropertyBorder(table, "Table.focusCellBorder");
            }
            if (!focus || border == null) {
                border = Utilities.getUIPropertyBorder(table, "Table.cellBorder");
            }
            if (border != null) {
                this.setBorder(border);
            }
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                Color foreground = table.getForeground();
                Color background = table.getBackground();
                List rowColors = (List)table.getClientProperty("rowColors");
                if (rowColors != null && row >= 0 && row < rowColors.size()) {
                    this.setBackground((Color)rowColors.get(row));
                    this.setForeground(foreground);
                } else if (row % 2 == 0) {
                    this.setForeground(foreground);
                    this.setBackground(background);
                } else {
                    Color alternateForeground = foreground instanceof javax.swing.plaf.UIResource ? Utilities.getUIPropertyColor(table, "Table.alternateForeground") : null;
                    Color alternateBackground = background instanceof javax.swing.plaf.UIResource ? Utilities.getUIPropertyColor(table, "Table.alternateBackground") : null;
                    this.setForeground(alternateForeground != null ? alternateForeground : foreground);
                    this.setBackground(alternateBackground != null ? alternateBackground : background);
                }
            }
        }
        this.setValue(value);
    }

    protected void setValue(Object value) {
        Icon icon = null;
        Object text = value;
        if (value instanceof Icon) {
            icon = (Icon)value;
            text = null;
        } else if (value instanceof Object[] && ((Object[])value).length == 2) {
            icon = ((Object[])value)[0] instanceof Icon ? (Icon)((Object[])value)[0] : null;
            text = ((Object[])value)[1];
        }
        this.setIcon(icon);
        this.setText(text == null ? "" : text.toString());
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
        this.prepareComponent(table, value, selected, focus, row, column);
        return this;
    }

    public static class UIResource
    extends CuiTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }

    public static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                Color foreground = table.getForeground();
                Color background = table.getBackground();
                if (row % 2 == 0) {
                    this.setForeground(foreground);
                    this.setBackground(background);
                } else {
                    Color alternateForeground = foreground instanceof javax.swing.plaf.UIResource ? Utilities.getUIPropertyColor(table, "Table.alternateForeground") : null;
                    Color alternateBackground = background instanceof javax.swing.plaf.UIResource ? Utilities.getUIPropertyColor(table, "Table.alternateBackground") : null;
                    this.setForeground(alternateForeground != null ? alternateForeground : foreground);
                    this.setBackground(alternateBackground != null ? alternateBackground : background);
                }
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }

    public static class DateRenderer
    extends CuiTableCellRenderer {
        protected DateFormat formatter_;

        public void setValue(Object value) {
            if (this.formatter_ == null) {
                this.formatter_ = DateFormat.getDateInstance();
            }
            this.setText(value == null ? "" : this.formatter_.format(value));
        }
    }

    public static class DoubleRenderer
    extends NumberRenderer {
        protected NumberFormat formatter_;

        public void setValue(Object value) {
            if (this.formatter_ == null) {
                this.formatter_ = NumberFormat.getInstance();
            }
            this.setText(value == null ? "" : this.formatter_.format(value));
        }
    }

    public static class NumberRenderer
    extends CuiTableCellRenderer {
        protected void prepareComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
            super.prepareComponent(table, value, selected, focus, row, column);
            this.setHorizontalAlignment(4);
        }
    }
}

