/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.graphics.StretchedImageIcon;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalSeparatorUI;

public class CuiSeparatorUI
extends MetalSeparatorUI {
    protected static CuiSeparatorUI separatorUI_ = null;
    protected double interiorEdge_ = CuiLookAndFeel.getInteriorEdge();
    protected double exteriorEdge_ = CuiLookAndFeel.getExteriorEdge();

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery((String[])argv, (String)"@(#)ptk2 2.7 200609011020 (Sun Microsystems Inc.|1.4.2_05|48.0|Linux|2.6.7-2.2smp|i386|batbuild)");
    }

    public static ComponentUI createUI(JComponent c) {
        return separatorUI_ != null ? separatorUI_ : (separatorUI_ = new CuiSeparatorUI());
    }

    public void paint(Graphics g, JComponent c) {
        Color color;
        double edge = Utilities.getUIPropertyBoolean(c, "Separator.raised") ? this.exteriorEdge_ : this.interiorEdge_;
        Color color2 = color = c.getParent() == null || !c.getParent().isOpaque() ? new Color(0, true) : c.getParent().getBackground();
        if (c instanceof JSeparator && ((JSeparator)c).getOrientation() == 1) {
            edge = Math.min(edge, (double)(c.getWidth() / 2));
            int edgeI = (int)Math.ceil(edge);
            int offset = c.getWidth() / 2;
            Rectangle area = new Rectangle(offset - edgeI, 0, 2 * edgeI, c.getHeight());
            Rectangle2D.Double shape = new Rectangle2D.Double((double)edgeI - 0.001, 0.0, 0.002, 1.0);
            BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(2 * edgeI, 1), shape, new EdgeProfileRounded(0.0, edge), color, color, null);
            new StretchedImageIcon(renderedShape, area.width, area.height).paintIcon(c, g, area.x, area.y);
        } else {
            edge = Math.min(edge, (double)(c.getHeight() / 2));
            int edgeI = (int)Math.ceil(edge);
            int offset = c.getHeight() / 2;
            Rectangle area = new Rectangle(0, offset - edgeI, c.getWidth(), 2 * edgeI);
            Rectangle2D.Double shape = new Rectangle2D.Double(0.0, (double)edgeI - 0.001, 1.0, 0.002);
            BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(1, 2 * edgeI), shape, new EdgeProfileRounded(0.0, edge), color, color, null);
            new StretchedImageIcon(renderedShape, area.width, area.height).paintIcon(c, g, area.x, area.y);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        double edge;
        double d = edge = Utilities.getUIPropertyBoolean(c, "Separator.raised") ? this.exteriorEdge_ : this.interiorEdge_;
        if (c instanceof JSeparator && ((JSeparator)c).getOrientation() == 1) {
            return new Dimension(2 * (int)Math.ceil(edge), 0);
        }
        return new Dimension(0, 2 * (int)Math.ceil(edge));
    }
}

