/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.graphics.StretchedImageIcon;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.EdgeProfileOgee;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.shape.NamedShape;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalScrollBarUI;
import javax.swing.plaf.metal.MetalScrollButton;

public class CuiScrollBarUI
extends MetalScrollBarUI {
    protected double interiorEdge_;
    protected int textureStep_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery((String[])argv, (String)"@(#)ptk2 2.7 200609011020 (Sun Microsystems Inc.|1.4.2_05|48.0|Linux|2.6.7-2.2smp|i386|batbuild)");
    }

    public static ComponentUI createUI(JComponent c) {
        return new CuiScrollBarUI();
    }

    public void installUI(JComponent c) {
        this.interiorEdge_ = CuiLookAndFeel.getInteriorEdge();
        this.textureStep_ = Math.max(4, (int)Math.round(4.0 * CuiLookAndFeel.getScale()));
        super.installUI(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        Insets insets = c.getInsets();
        Dimension size = super.getPreferredSize(c);
        return new Dimension(size.width + (insets.left + insets.right), size.height + (insets.top + insets.bottom));
    }

    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new BasicScrollBarUI.TrackListener(){

            public void mousePressed(MouseEvent e) {
                boolean d = CuiScrollBarUI.this.isDragging;
                super.mousePressed(e);
                if (d != CuiScrollBarUI.this.isDragging) {
                    CuiScrollBarUI.this.scrollbar.repaint();
                }
            }

            public void mouseReleased(MouseEvent e) {
                boolean d = CuiScrollBarUI.this.isDragging;
                super.mouseReleased(e);
                if (d != CuiScrollBarUI.this.isDragging) {
                    CuiScrollBarUI.this.scrollbar.repaint();
                }
            }
        };
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(this.scrollbar.getParent() != null && this.scrollbar.getParent().getBackground() != null ? this.scrollbar.getParent().getBackground() : Utilities.getUIPropertyColor(this.scrollbar, "ScrollBar.track", Color.gray));
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
    }

    protected Dimension getMinimumThumbSize() {
        Dimension size = this.scrollbar.getSize();
        Insets insets = this.scrollbar.getInsets();
        int square = Math.min(size.height - (insets.top + insets.bottom), size.width - (insets.left + insets.right));
        return new Dimension(square, square);
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        block5: {
            Dimension size = new Dimension(thumbBounds.width, thumbBounds.height);
            if (size.width <= 0 || size.height <= 0) {
                return;
            }
            Rectangle shape = new Rectangle(0, 0, thumbBounds.width, thumbBounds.height);
            EdgeProfileRounded profile = new EdgeProfileRounded(this.interiorEdge_, 0.0);
            Color interiorColor = !this.scrollbar.isEnabled() && this.scrollbar.getParent() != null && this.scrollbar.getParent().getBackground() != null ? this.scrollbar.getParent().getBackground() : (this.isDragging ? UIManager.getColor("Button.select") : UIManager.getColor("ScrollBar.thumb"));
            Color exteriorColor = Color.white;
            int edge = (int)Math.ceil(this.interiorEdge_);
            int textureCount = ((this.scrollbar.getOrientation() == 1 ? size.height : size.width) - 2 * edge) / this.textureStep_;
            int cutoutTotal = Math.max(0, textureCount * this.textureStep_);
            Rectangle cutout = !this.scrollbar.isEnabled() ? null : (this.scrollbar.getOrientation() == 1 ? new Rectangle(0 + edge, 0 + (size.height - cutoutTotal) / 2, size.width - 2 * edge, cutoutTotal) : new Rectangle(0 + (size.width - cutoutTotal) / 2, 0 + edge, cutoutTotal, size.height - 2 * edge));
            BufferedImage renderedShapeB = RenderedShapeFactory.getRenderedShape(new Dimension(2 * edge + 1, 2 * edge + 1), new Rectangle(0, 0, 2 * edge + 1, 2 * edge + 1), profile, interiorColor, exteriorColor, null);
            new StretchedImageIcon(renderedShapeB, size.width, size.height).paintIcon(this.scrollbar, g, thumbBounds.x, thumbBounds.y);
            if (!this.scrollbar.isEnabled()) break block5;
            if (this.scrollbar.getOrientation() == 1) {
                BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(cutout.width, this.textureStep_), new Rectangle2D.Double((double)this.textureStep_ / 4.0, (double)this.textureStep_ / 4.0, (double)cutout.width - (double)this.textureStep_ / 2.0, (double)this.textureStep_ - (double)this.textureStep_ / 2.0), new EdgeProfileOgee((double)this.textureStep_ / 4.0, (double)this.textureStep_ / 4.0, -0.01), interiorColor, interiorColor, null);
                for (int i = 0; i < textureCount; ++i) {
                    g.drawImage(renderedShape, thumbBounds.x + cutout.x, thumbBounds.y + cutout.y + i * this.textureStep_, null);
                }
            } else {
                BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(this.textureStep_, cutout.height), new Rectangle2D.Double((double)this.textureStep_ / 4.0, (double)this.textureStep_ / 4.0, (double)this.textureStep_ - (double)this.textureStep_ / 2.0, (double)cutout.height - (double)this.textureStep_ / 2.0), new EdgeProfileOgee((double)this.textureStep_ / 4.0, (double)this.textureStep_ / 4.0, -0.01), interiorColor, interiorColor, null);
                for (int i = 0; i < textureCount; ++i) {
                    g.drawImage(renderedShape, thumbBounds.x + cutout.x + i * this.textureStep_, thumbBounds.y + cutout.y, null);
                }
            }
        }
    }

    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = this.createScrollButton(orientation);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = this.createScrollButton(orientation);
        return this.increaseButton;
    }

    protected MetalScrollButton createScrollButton(int orientation) {
        return new SSBSB(orientation, this.scrollBarWidth);
    }

    class SSBSB
    extends MetalScrollButton {
        public SSBSB(int orientation, int width) {
            super(orientation, width, false);
            this.setBackground(UIManager.getColor("Button.background"));
            this.setForeground(UIManager.getColor("Button.foreground"));
        }

        public Dimension getPreferredSize() {
            Dimension size = CuiScrollBarUI.this.scrollbar.getSize();
            Insets insets = CuiScrollBarUI.this.scrollbar.getInsets();
            int square = Math.min(size.height - (insets.top + insets.bottom), size.width - (insets.left + insets.right));
            return new Dimension(square, square);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public void paint(Graphics g) {
            Dimension size = new Dimension(this.getWidth(), this.getHeight());
            if (size.width <= 0 || size.height <= 0) {
                return;
            }
            Shape shape = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            EdgeProfileRounded profile = new EdgeProfileRounded(CuiScrollBarUI.this.interiorEdge_, 0.0);
            Color interiorColor = !CuiScrollBarUI.this.scrollbar.isEnabled() && CuiScrollBarUI.this.scrollbar.getParent() != null && CuiScrollBarUI.this.scrollbar.getParent().getBackground() != null ? CuiScrollBarUI.this.scrollbar.getParent().getBackground() : (this.getModel().isPressed() ? UIManager.getColor("Button.select") : this.getBackground());
            Color exteriorColor = Color.white;
            BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, new EdgeProfileRounded(CuiScrollBarUI.this.interiorEdge_, 0.0), interiorColor, exteriorColor, null);
            g.drawImage(renderedShape, 0, 0, null);
            int in = (int)Math.ceil((double)Math.min(this.getWidth(), this.getHeight()) / 8.0);
            int w = this.getWidth() - 2 * in;
            int h = this.getHeight() - 2 * in;
            size = new Dimension(w, h);
            if (size.width <= 0 || size.height <= 0) {
                return;
            }
            float[][] p = new float[][]{{0.0f, (float)h / 4.0f, w, (float)h / 4.0f, (float)w / 2.0f, (float)(h * 3) / 4.0f}, {0.0f, (float)(h * 3) / 4.0f, w, (float)(h * 3) / 4.0f, (float)w / 2.0f, (float)h / 4.0f}, {(float)w / 4.0f, 0.0f, (float)w / 4.0f, h, (float)(w * 3) / 4.0f, (float)h / 2.0f}, {(float)(w * 3) / 4.0f, 0.0f, (float)(w * 3) / 4.0f, h, (float)w / 4.0f, (float)h / 2.0f}};
            int i = this.direction == 5 ? 0 : (this.direction == 1 ? 1 : (this.direction == 3 ? 2 : 3));
            String shapeID = "ScrollButton[" + i + "," + w + "x" + h + "]";
            shape = (Shape)Utilities.shapeCache_.get(shapeID);
            if (shape == null) {
                GeneralPath path = new GeneralPath();
                path.moveTo(p[i][0], p[i][1]);
                path.lineTo(p[i][2], p[i][3]);
                path.lineTo(p[i][4], p[i][5]);
                path.closePath();
                shape = new NamedShape(shapeID, path);
                Utilities.shapeCache_.put(shapeID, shape);
            }
            Color arrowColor = !CuiScrollBarUI.this.scrollbar.isEnabled() ? UIManager.getColor("ScrollBar.disabledForeground") : (!this.getModel().isPressed() ? this.getForeground() : this.getBackground());
            renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, null, arrowColor, interiorColor, null);
            g.drawImage(renderedShape, in, in, null);
        }
    }
}

