/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.shape.NamedShape;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class CuiCheckBoxIcon
implements Icon,
UIResource,
Serializable {
    protected int size_;
    protected double exteriorEdge_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery((String[])argv, (String)"@(#)ptk2 2.7 200609011020 (Sun Microsystems Inc.|1.4.2_05|48.0|Linux|2.6.7-2.2smp|i386|batbuild)");
    }

    public CuiCheckBoxIcon() {
        this(12);
    }

    public CuiCheckBoxIcon(int size) {
        this.size_ = (int)Math.round((double)size * CuiLookAndFeel.getScale());
        this.exteriorEdge_ = CuiLookAndFeel.getExteriorEdge();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        AbstractButton b2 = (AbstractButton)c;
        ButtonModel model = b2.getModel();
        Container parent = b2.getParent();
        boolean menu = b2 instanceof JMenuItem;
        boolean selected = b2.isSelected();
        boolean enabled = model.isEnabled();
        boolean armed = model.isArmed();
        boolean pressed = model.isPressed();
        boolean filled = b2.isBorderPainted() && b2.isContentAreaFilled();
        String classKey = menu ? "CheckBoxMenuItem" : "CheckBox";
        int exteriorEdge = (int)Math.ceil(this.exteriorEdge_);
        Dimension size = new Dimension(this.size_ + 2 * exteriorEdge, this.size_ + 2 * exteriorEdge);
        if (size.width <= 0 || size.height <= 0) {
            return;
        }
        EdgeProfileRounded profile = new EdgeProfileRounded(0.0, this.exteriorEdge_);
        Color exteriorColor = null;
        if (filled && enabled && !menu && pressed) {
            exteriorColor = UIManager.getColor(classKey + ".press");
        } else if (filled && enabled && !menu && selected || menu && armed) {
            exteriorColor = UIManager.getColor(classKey + ".select");
        } else if (filled && enabled || c.isOpaque()) {
            exteriorColor = c.getBackground();
        } else if (parent != null && parent.isOpaque()) {
            exteriorColor = parent.getBackground();
        }
        if (exteriorColor == null) {
            exteriorColor = new Color(0, true);
        }
        Color interiorColor = null;
        if (enabled) {
            interiorColor = pressed && armed ? UIManager.getColor(classKey + ".press") : UIManager.getColor(classKey + ".boxBackground");
        }
        if (interiorColor == null) {
            interiorColor = exteriorColor;
        }
        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, new Rectangle2D.Double(exteriorEdge, exteriorEdge, this.size_, this.size_), new EdgeProfileRounded(0.0, this.exteriorEdge_), interiorColor, exteriorColor, null);
        g.drawImage(renderedShape, x, y, null);
        if (selected) {
            double s = (double)this.size_ / 8.0;
            int[][] p = new int[][]{{1, 4}, {3, 7}, {7, 2}, {7, 1}, {3, 5}, {2, 3}};
            String shapeID = "Check[" + this.size_ + "]";
            Shape shape = (Shape)Utilities.shapeCache_.get(shapeID);
            if (shape == null) {
                GeneralPath path = new GeneralPath();
                path.moveTo((float)((double)p[0][0] * s), (float)((double)p[0][1] * s));
                for (int i = 1; i < p.length; ++i) {
                    path.lineTo((float)((double)p[i][0] * s), (float)((double)p[i][1] * s));
                }
                path.closePath();
                shape = new NamedShape(shapeID, path);
                Utilities.shapeCache_.put(shapeID, shape);
            }
            renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(this.size_, this.size_), shape, null, UIManager.getColor(classKey + (enabled ? ".foreground" : ".disabledText")), interiorColor, null);
            g.drawImage(renderedShape, x + exteriorEdge, y + exteriorEdge, null);
        }
    }

    public int getIconWidth() {
        return this.size_ + 2 * (int)Math.ceil(this.exteriorEdge_);
    }

    public int getIconHeight() {
        return this.size_ + 2 * (int)Math.ceil(this.exteriorEdge_);
    }
}

