/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.border.CuiBorder;
import com.ge.med.ptk.laf.Utilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class ContextualProperty {
    protected static Logger logger_ = Logger.getLogger((class$com$ge$med$ptk$laf$ContextualProperty == null ? (class$com$ge$med$ptk$laf$ContextualProperty = ContextualProperty.class$("com.ge.med.ptk.laf.ContextualProperty")) : class$com$ge$med$ptk$laf$ContextualProperty).getName());
    protected static Resolver defaultResolver_;
    protected static Set installedContextualDefaults_;
    static /* synthetic */ Class class$com$ge$med$ptk$laf$ContextualProperty;

    public static Resolver getDefaultResolver() {
        return defaultResolver_ != null ? defaultResolver_ : (defaultResolver_ = new PtkScaleResolver());
    }

    public static void setDefaultResolver(Resolver resolver) {
        defaultResolver_ = resolver;
    }

    public static void updateComponentTreeUI(Component component) {
        ContextualProperty.updateComponentTreeUI0(component);
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private static void updateComponentTreeUI0(Component component) {
        if (component instanceof JComponent) {
            JComponent c = (JComponent)component;
            ContextualProperty.setContext(c);
            if (c.getFont() instanceof Font) {
                c.setFont(((Font)c.getFont()).resolve());
            }
            if (c.getBorder() instanceof Border) {
                c.setBorder(((Border)c.getBorder()).resolve());
            }
            if (c.getPreferredSize() instanceof Dimension) {
                c.setPreferredSize(((Dimension)c.getPreferredSize()).resolve());
            }
            if (c.getMinimumSize() instanceof Dimension) {
                c.setMinimumSize(((Dimension)c.getMinimumSize()).resolve());
            }
            if (c.getMaximumSize() instanceof Dimension) {
                c.setMaximumSize(((Dimension)c.getMaximumSize()).resolve());
            }
            if (c instanceof JTextComponent && ((JTextComponent)c).getMargin() instanceof Insets) {
                ((JTextComponent)c).setMargin(((Insets)((JTextComponent)c).getMargin()).resolve());
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getMargin() instanceof Insets) {
                ((AbstractButton)c).setMargin(((Insets)((AbstractButton)c).getMargin()).resolve());
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getIcon() instanceof Icon) {
                ((AbstractButton)c).setIcon(((Icon)((AbstractButton)c).getIcon()).resolve());
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getRolloverIcon() instanceof Icon) {
                ((AbstractButton)c).setRolloverIcon(((Icon)((AbstractButton)c).getRolloverIcon()).resolve());
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getPressedIcon() instanceof Icon) {
                ((AbstractButton)c).setPressedIcon(((Icon)((AbstractButton)c).getPressedIcon()).resolve());
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getSelectedIcon() instanceof Icon) {
                ((AbstractButton)c).setSelectedIcon(((Icon)((AbstractButton)c).getSelectedIcon()).resolve());
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getRolloverSelectedIcon() instanceof Icon) {
                ((AbstractButton)c).setRolloverSelectedIcon(((Icon)((AbstractButton)c).getRolloverSelectedIcon()).resolve());
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getDisabledIcon() instanceof Icon) {
                ((AbstractButton)c).setDisabledIcon(((Icon)((AbstractButton)c).getDisabledIcon()).resolve());
            }
            if (c instanceof JLabel && ((JLabel)c).getIcon() instanceof Icon) {
                ((JLabel)c).setIcon(((Icon)((JLabel)c).getIcon()).resolve());
            }
            c.updateUI();
            ContextualProperty.setContext(null);
        }
        Component[] children = null;
        if (component instanceof JMenu) {
            children = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            children = ((Container)component).getComponents();
        }
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                ContextualProperty.updateComponentTreeUI0(children[i]);
            }
        }
    }

    public static void setContext(Object context) {
        UIManager.put("ContextualProperty.context", context);
    }

    public static Object getContext() {
        return UIManager.get("ContextualProperty.context");
    }

    public static void installSmartDefaults() {
        ContextualProperty.installContextualDefaults();
    }

    public static void installContextualDefaults() {
        long t0 = System.currentTimeMillis();
        ContextualProperty.installContextualDefaults2(UIManager.getLookAndFeelDefaults());
        System.out.println("=============================== " + (System.currentTimeMillis() - t0));
    }

    public static void installSmartDefaults(String[] keys) {
        ContextualProperty.installContextualDefaults(keys);
    }

    public static void installContextualDefaults(String[] keys) {
        long t0 = System.currentTimeMillis();
        ContextualProperty.installSmartDefaults(UIManager.getLookAndFeelDefaults(), keys);
        System.out.println("=============================== " + (System.currentTimeMillis() - t0));
    }

    public static void installSmartDefaults(UIDefaults table, String[] keys) {
        ContextualProperty.installContextualDefaults(table, keys);
    }

    public static void installContextualDefaults(UIDefaults table, String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            UIManager.put(keys[i], new ActiveValue(keys[i]));
        }
    }

    public static void installContextualDefaults2(UIDefaults table) {
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (installedContextualDefaults_.contains(key) || !installedContextualDefaults_.add(key)) continue;
            UIManager.put(key, new ActiveValue(key));
        }
    }

    public static void installContextualDefaults3(UIDefaults table) {
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = table.get(key);
            if (!(value instanceof java.awt.Font) && !(value instanceof javax.swing.border.Border) && !(value instanceof java.awt.Insets) && !(value instanceof Integer)) continue;
            UIManager.put(key, new ActiveValue(key));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        installedContextualDefaults_ = new HashSet();
    }

    public static class PtkScaleResolver
    extends AbstractResolver {
        public Object resolve(Object rawValue, Object context) {
            try {
                return this.scaleToScreen(rawValue, (JComponent)context, this.getScreen((JComponent)context));
            }
            catch (Exception ex) {
                logger_.log(Level.WARNING, "" + ex, ex);
                return rawValue;
            }
        }

        public int getScreen(JComponent component) {
            int i;
            Rectangle bounds;
            Window window;
            if (component == null || (window = SwingUtilities.getWindowAncestor(component)) == null || (bounds = window.getBounds()) == null) {
                return this.getDefaultScreen();
            }
            GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            for (i = 0; i < devices.length; ++i) {
                if (!devices[i].getDefaultConfiguration().getBounds().contains(bounds.getLocation())) continue;
                return i;
            }
            for (i = 0; i < devices.length; ++i) {
                if (!devices[i].getDefaultConfiguration().getBounds().intersects(bounds)) continue;
                return i;
            }
            return this.getDefaultScreen();
        }

        public int getDefaultScreen() {
            return 0;
        }

        public Object scaleToScreen(Object rawValue, JComponent component, int screen) {
            if (rawValue instanceof double[]) {
                double[] d = (double[])rawValue;
                double[] dd = new double[d.length];
                for (int i = 0; i < d.length; ++i) {
                    dd[i] = Utilities.monitor(d[i], screen);
                }
                return dd;
            }
            if (rawValue instanceof Integer) {
                Integer i = (Integer)rawValue;
                return new Integer(Utilities.monitor((int)i, screen));
            }
            if (rawValue instanceof Double) {
                Double d = (Double)rawValue;
                return new Double(Utilities.monitor(d, screen));
            }
            if (rawValue instanceof Number) {
                Number n = (Number)rawValue;
                return new Double(Utilities.monitor(n.doubleValue(), screen));
            }
            if (rawValue instanceof java.awt.Dimension) {
                java.awt.Dimension d = (java.awt.Dimension)rawValue;
                return Utilities.monitor(d, screen);
            }
            if (rawValue instanceof java.awt.Insets) {
                java.awt.Insets i = (java.awt.Insets)rawValue;
                return Utilities.monitor(i, screen);
            }
            if (rawValue instanceof java.awt.Font) {
                java.awt.Font f = (java.awt.Font)rawValue;
                return f.deriveFont((float)Utilities.monitor(f.getSize2D(), screen));
            }
            if (rawValue instanceof javax.swing.border.Border) {
                double factor = Utilities.monitor(1.0, screen);
                return this.getScaledBorder((javax.swing.border.Border)rawValue, component, factor);
            }
            if (rawValue instanceof javax.swing.Icon) {
                double factor = Utilities.monitor(1.0, screen);
                return this.getScaledIcon((javax.swing.Icon)rawValue, component, factor);
            }
            return rawValue;
        }
    }

    public static abstract class AbstractResolver
    implements Resolver {
        public Object resolve(Object rawValue, Object context, boolean uiResource) {
            Object v = this.resolve(rawValue, context);
            if (!uiResource || v instanceof UIResource) {
                return v;
            }
            if (v instanceof java.awt.Font) {
                return new FontUIResource((java.awt.Font)v);
            }
            if (v instanceof javax.swing.border.Border) {
                return new BorderUIResource((javax.swing.border.Border)v);
            }
            if (v instanceof java.awt.Insets) {
                return new InsetsUIResource(((java.awt.Insets)v).top, ((java.awt.Insets)v).left, ((java.awt.Insets)v).bottom, ((java.awt.Insets)v).right);
            }
            return v;
        }

        public abstract Object resolve(Object var1, Object var2);

        protected javax.swing.border.Border getScaledBorder(javax.swing.border.Border border, JComponent component, double scale) {
            if (border instanceof CuiBorder) {
                CuiBorder cb = (CuiBorder)border;
                double[] r = cb.getCornerRadii();
                java.awt.Insets m = cb.getMinimumMargin();
                return border instanceof UIResource ? new CuiBorder.UIResource(cb.getInteriorEdge() * scale, cb.getExteriorEdge() * scale, new double[]{r[0] * scale, r[1] * scale, r[2] * scale, r[3] * scale}, cb.getInteriorEdgeVisible(), cb.getExteriorEdgeVisible(), new java.awt.Insets((int)Math.ceil((double)m.top * scale), (int)Math.ceil((double)m.left * scale), (int)Math.ceil((double)m.bottom * scale), (int)Math.ceil((double)m.right * scale)), cb.getInsetRule()) : new CuiBorder.UIResource(cb.getInteriorEdge() * scale, cb.getExteriorEdge() * scale, new double[]{r[0] * scale, r[1] * scale, r[2] * scale, r[3] * scale}, cb.getInteriorEdgeVisible(), cb.getExteriorEdgeVisible(), new java.awt.Insets((int)Math.ceil((double)m.top * scale), (int)Math.ceil((double)m.left * scale), (int)Math.ceil((double)m.bottom * scale), (int)Math.ceil((double)m.right * scale)), cb.getInsetRule());
            }
            if (border instanceof CompoundBorder) {
                return new CompoundBorder(this.getScaledBorder(((CompoundBorder)border).getOutsideBorder(), component, scale), this.getScaledBorder(((CompoundBorder)border).getInsideBorder(), component, scale));
            }
            if (border instanceof MatteBorder) {
                java.awt.Insets i = border.getBorderInsets(component);
                return new MatteBorder((int)Math.ceil((double)i.top * scale), (int)Math.ceil((double)i.left * scale), (int)Math.ceil((double)i.bottom * scale), (int)Math.ceil((double)i.right * scale), ((MatteBorder)border).getMatteColor());
            }
            if (border instanceof EmptyBorder) {
                java.awt.Insets i = border.getBorderInsets(component);
                return new EmptyBorder((int)Math.ceil((double)i.top * scale), (int)Math.ceil((double)i.left * scale), (int)Math.ceil((double)i.bottom * scale), (int)Math.ceil((double)i.right * scale));
            }
            return border;
        }

        protected javax.swing.Icon getScaledIcon(javax.swing.Icon icon, JComponent component, double scale) {
            return new ScaledIcon(icon, scale);
        }

        public static class ScaledIcon
        implements javax.swing.Icon {
            protected javax.swing.Icon raw_;
            protected double scale_;

            public ScaledIcon(javax.swing.Icon raw, double scale) {
                this.raw_ = raw;
                this.scale_ = scale;
            }

            public int getIconWidth() {
                return (int)Math.round(this.scale_ * (double)this.raw_.getIconWidth());
            }

            public int getIconHeight() {
                return (int)Math.round(this.scale_ * (double)this.raw_.getIconHeight());
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (this.getIconWidth() < 1 || this.getIconHeight() < 1) {
                    return;
                }
                BufferedImage rawImage_ = new BufferedImage(this.raw_.getIconWidth(), this.raw_.getIconHeight(), 2);
                Graphics2D rawGraphics = rawImage_.createGraphics();
                this.raw_.paintIcon(c, rawGraphics, 0, 0);
                g.drawImage(rawImage_, x, y, this.getIconWidth(), this.getIconHeight(), null);
            }
        }
    }

    public static interface Resolver {
        public Object resolve(Object var1, Object var2, boolean var3);
    }

    public static class Icon
    implements javax.swing.Icon {
        protected javax.swing.Icon rawValue_;
        protected javax.swing.Icon resolvedValue_;
        protected Resolver resolver_;

        public javax.swing.Icon getRawValue() {
            return this.rawValue_;
        }

        public Icon(javax.swing.Icon rawValue) {
            this(rawValue, null);
        }

        public Icon(javax.swing.Icon rawValue, Resolver resolver) {
            this((javax.swing.Icon)(resolver != null ? resolver : ContextualProperty.getDefaultResolver()).resolve(rawValue, ContextualProperty.getContext(), false), rawValue, resolver);
        }

        protected Icon(javax.swing.Icon resolvedValue, javax.swing.Icon rawValue, Resolver resolver) {
            this.resolvedValue_ = resolvedValue;
            this.rawValue_ = rawValue;
            this.resolver_ = resolver;
        }

        public Icon resolve() {
            return new Icon(this.rawValue_, this.resolver_);
        }

        public int getIconWidth() {
            return this.resolvedValue_.getIconWidth();
        }

        public int getIconHeight() {
            return this.resolvedValue_.getIconHeight();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.resolvedValue_.paintIcon(c, g, x, y);
        }
    }

    public static class Border
    implements javax.swing.border.Border {
        protected javax.swing.border.Border rawValue_;
        protected javax.swing.border.Border resolvedValue_;
        protected Resolver resolver_;

        public javax.swing.border.Border getRawValue() {
            return this.rawValue_;
        }

        public Border(javax.swing.border.Border rawValue) {
            this(rawValue, null);
        }

        public Border(javax.swing.border.Border rawValue, Resolver resolver) {
            this((javax.swing.border.Border)(resolver != null ? resolver : ContextualProperty.getDefaultResolver()).resolve(rawValue, ContextualProperty.getContext(), false), rawValue, resolver);
        }

        protected Border(javax.swing.border.Border resolvedValue, javax.swing.border.Border rawValue, Resolver resolver) {
            this.resolvedValue_ = resolvedValue;
            this.rawValue_ = rawValue;
            this.resolver_ = resolver;
        }

        public Border resolve() {
            return new Border(this.rawValue_, this.resolver_);
        }

        public java.awt.Insets getBorderInsets(Component c) {
            return this.resolvedValue_.getBorderInsets(c);
        }

        public boolean isBorderOpaque() {
            return this.resolvedValue_.isBorderOpaque();
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            this.resolvedValue_.paintBorder(c, g, x, y, w, h);
        }
    }

    public static class Dimension
    extends java.awt.Dimension {
        protected java.awt.Dimension rawValue_;
        protected Resolver resolver_;

        public java.awt.Dimension getRawValue() {
            return this.rawValue_;
        }

        public Dimension(java.awt.Dimension rawValue) {
            this(rawValue, null);
        }

        public Dimension(java.awt.Dimension rawValue, Resolver resolver) {
            this((java.awt.Dimension)(resolver != null ? resolver : ContextualProperty.getDefaultResolver()).resolve(rawValue, ContextualProperty.getContext(), false), rawValue, resolver);
        }

        protected Dimension(java.awt.Dimension resolvedValue, java.awt.Dimension rawValue, Resolver resolver) {
            super(resolvedValue.width, resolvedValue.height);
            this.rawValue_ = rawValue;
            this.resolver_ = resolver;
        }

        public Dimension resolve() {
            return new Dimension(this.rawValue_, this.resolver_);
        }
    }

    public static class Insets
    extends java.awt.Insets {
        protected java.awt.Insets rawValue_;
        protected Resolver resolver_;

        public java.awt.Insets getRawValue() {
            return this.rawValue_;
        }

        public Insets(java.awt.Insets rawValue) {
            this(rawValue, null);
        }

        public Insets(java.awt.Insets rawValue, Resolver resolver) {
            this((java.awt.Insets)(resolver != null ? resolver : ContextualProperty.getDefaultResolver()).resolve(rawValue, ContextualProperty.getContext(), false), rawValue, resolver);
        }

        protected Insets(java.awt.Insets resolvedValue, java.awt.Insets rawValue, Resolver resolver) {
            super(resolvedValue.top, resolvedValue.left, resolvedValue.bottom, resolvedValue.right);
            this.rawValue_ = rawValue;
            this.resolver_ = resolver;
        }

        public Insets resolve() {
            return new Insets(this.rawValue_, this.resolver_);
        }
    }

    public static class Font
    extends java.awt.Font {
        protected java.awt.Font rawValue_;
        protected Resolver resolver_;

        public java.awt.Font getRawValue() {
            return this.rawValue_;
        }

        public Font(java.awt.Font rawValue) {
            this(rawValue, null);
        }

        public Font(java.awt.Font rawValue, Resolver resolver) {
            this((java.awt.Font)(resolver != null ? resolver : ContextualProperty.getDefaultResolver()).resolve(rawValue, ContextualProperty.getContext(), false), rawValue, resolver);
        }

        protected Font(java.awt.Font resolvedValue, java.awt.Font rawValue, Resolver resolver) {
            this(resolvedValue.getName(), resolvedValue.getStyle(), resolvedValue.getSize(), rawValue, resolver);
        }

        protected Font(String name, int style, int size, java.awt.Font rawValue, Resolver resolver) {
            super(name, style, size);
            this.rawValue_ = rawValue;
            this.resolver_ = resolver;
        }

        public Font resolve() {
            return new Font(this.rawValue_, this.resolver_);
        }
    }

    public static class ActiveValue
    implements UIDefaults.ActiveValue {
        protected Object key_;
        protected Resolver resolver_;

        public ActiveValue(Object key) {
            this(key, null);
        }

        public ActiveValue(Object key, Resolver resolver) {
            this.key_ = key;
            this.resolver_ = resolver;
        }

        public Object createValue(UIDefaults table) {
            Object rawValue = UIManager.getLookAndFeelDefaults().get(this.key_);
            if (Boolean.TRUE.equals(UIManager.getLookAndFeelDefaults().get(this.key_ + ".contextual"))) {
                return rawValue;
            }
            return (this.resolver_ != null ? this.resolver_ : ContextualProperty.getDefaultResolver()).resolve(rawValue, ContextualProperty.getContext(), true);
        }
    }
}

