/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.graphics;

import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class StretchedImageIcon
implements Icon {
    static Map corners_ = new HashMap();
    protected BufferedImage image_;
    protected int rw_;
    protected int rh_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery((String[])argv, (String)"@(#)ptk2 2.7 200609011020 (Sun Microsystems Inc.|1.4.2_05|48.0|Linux|2.6.7-2.2smp|i386|batbuild)");
    }

    public StretchedImageIcon(BufferedImage image, int width, int height) {
        this.image_ = image;
        this.rw_ = width;
        this.rh_ = height;
    }

    public int getIconWidth() {
        return this.rw_;
    }

    public int getIconHeight() {
        return this.rh_;
    }

    public void paintIcon(Component c, Graphics g, int rx, int ry) {
        int alpha;
        int rgb;
        int i;
        int iw = this.image_.getWidth();
        int ih = this.image_.getHeight();
        int iw2 = iw / 2;
        int ih2 = ih / 2;
        Image[] corners = (Image[])corners_.get(this.image_);
        if (corners == null) {
            corners = new Image[4];
            corners_.put(this.image_, corners);
            if (iw2 > 0 && ih2 > 0) {
                int[] x1 = new int[]{0, iw - iw2, 0, iw - iw2};
                int[] y1 = new int[]{0, 0, ih - ih2, ih - ih2};
                for (int i2 = 0; i2 < 4; ++i2) {
                    int imageTransparency = this.image_.getColorModel().getTransparency();
                    int cornerTransparency = 1;
                    for (int x = x1[i2]; x < x1[i2] + iw2 && imageTransparency > cornerTransparency; ++x) {
                        for (int y = y1[i2]; y < y1[i2] + ih2 && imageTransparency > cornerTransparency; ++y) {
                            int alpha2 = this.image_.getRGB(x, y) >>> 24;
                            if (alpha2 < 255) {
                                cornerTransparency = 3;
                            }
                            if (alpha2 != 0) continue;
                            cornerTransparency = 2;
                        }
                    }
                    corners[i2] = cornerTransparency == 1 && c != null ? new BufferedImage(iw2, ih2, 1) : new BufferedImage(iw2, ih2, 2);
                    corners[i2].getGraphics().drawImage(this.image_, -x1[i2], -y1[i2], null);
                }
            }
        }
        int rw2 = Math.min(iw2, this.rw_ / 2);
        int rh2 = Math.min(ih2, this.rh_ / 2);
        if (rw2 > 0 && rh2 > 0) {
            if (rw2 == iw2 && rh2 == ih2) {
                if (g.hitClip(rx, ry, rw2, rh2)) {
                    g.drawImage(corners[0], rx, ry, null);
                }
                if (g.hitClip(rx + this.rw_ - rw2, ry, rw2, rh2)) {
                    g.drawImage(corners[1], rx + this.rw_ - rw2, ry, null);
                }
                if (g.hitClip(rx, ry + this.rh_ - rh2, rw2, rh2)) {
                    g.drawImage(corners[2], rx, ry + this.rh_ - rh2, null);
                }
                if (g.hitClip(rx + this.rw_ - rw2, ry + this.rh_ - rh2, rw2, rh2)) {
                    g.drawImage(corners[3], rx + this.rw_ - rw2, ry + this.rh_ - rh2, null);
                }
            } else {
                g.drawImage(this.image_.getSubimage(0, 0, rw2, rh2), rx, ry, null);
                g.drawImage(this.image_.getSubimage(iw - rw2, 0, rw2, rh2), rx + this.rw_ - rw2, ry, null);
                g.drawImage(this.image_.getSubimage(0, ih - rh2, rw2, rh2), rx, ry + this.rh_ - rh2, null);
                g.drawImage(this.image_.getSubimage(iw - rw2, ih - rh2, rw2, rh2), rx + this.rw_ - rw2, ry + this.rh_ - rh2, null);
            }
        }
        int sw = this.rw_ - (iw2 + iw2);
        int sh = this.rh_ - (ih2 + ih2);
        if (sw > 0) {
            if (g.hitClip(rx + iw2, ry, sw, rh2)) {
                for (i = 0; i < rh2; ++i) {
                    rgb = this.image_.getRGB(rw2, i);
                    alpha = rgb >>> 24;
                    if (alpha == 0) continue;
                    g.setColor(new Color(rgb, alpha < 255));
                    g.fillRect(rx + iw2, ry + i, sw, 1);
                }
            }
            if (g.hitClip(rx + iw2, ry + this.rh_ - rh2, sw, rh2)) {
                for (i = 0; i < rh2; ++i) {
                    rgb = this.image_.getRGB(rw2, ih - rh2 + i);
                    alpha = rgb >>> 24;
                    if (alpha == 0) continue;
                    g.setColor(new Color(rgb, alpha < 255));
                    g.fillRect(rx + iw2, ry + this.rh_ - rh2 + i, sw, 1);
                }
            }
        }
        if (sh > 0) {
            if (g.hitClip(rx, ry + ih2, rw2, sh)) {
                for (i = 0; i < rw2; ++i) {
                    rgb = this.image_.getRGB(i, rh2);
                    alpha = rgb >>> 24;
                    if (alpha == 0) continue;
                    g.setColor(new Color(rgb, alpha < 255));
                    g.fillRect(rx + i, ry + ih2, 1, sh);
                }
            }
            if (g.hitClip(rx + this.rw_ - rw2, ry + ih2, rw2, sh)) {
                for (i = 0; i < rw2; ++i) {
                    rgb = this.image_.getRGB(iw - rw2 + i, rh2);
                    alpha = rgb >>> 24;
                    if (alpha == 0) continue;
                    g.setColor(new Color(rgb, alpha < 255));
                    g.fillRect(rx + this.rw_ - rw2 + i, ry + ih2, 1, sh);
                }
            }
        }
        if (sw > 0 && sh > 0 && g.hitClip(rx + rw2, ry + rh2, sw, sh) && (alpha = (rgb = this.image_.getRGB(rw2, rh2)) >>> 24) > 0) {
            g.setColor(new Color(rgb, alpha < 255));
            g.fillRect(rx + rw2, ry + rh2, sw, sh);
        }
    }
}

