/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.List;
import java.util.logging.Logger;

public class JnUtils {
    private static final DecimalFormat df = new DecimalFormat("####.##");
    public static final double ZERO = 1.0E-10;

    public static final boolean zero(double val) {
        return Math.abs(val) < 1.0E-10;
    }

    public static final boolean one(double val) {
        double diff = 1.0 - val;
        return Math.abs(diff) < 1.0E-10;
    }

    public static String format(double d) {
        return df.format(d);
    }

    public static final float fastInvSqrt(float x) {
        float xhalf = 0.5f * x;
        int i = JnUtils.floatToIntBits(x);
        i = 1597463007 - (i >> 1);
        x = JnUtils.intBitsToFloat(i);
        x *= 1.5f - xhalf * x * x;
        return x;
    }

    public static float fastSqrt(float val) {
        int tmp = JnUtils.floatToIntBits(val);
        tmp -= 0x800000;
        tmp >>= 1;
        return JnUtils.intBitsToFloat(tmp += 0x20000000);
    }

    public static double det3x3(double a1, double a2, double a3, double b1, double b2, double b3, double c1, double c2, double c3) {
        double ans = a1 * JnUtils.det2x2(b2, b3, c2, c3) - b1 * JnUtils.det2x2(a2, a3, c2, c3) + c1 * JnUtils.det2x2(a2, a3, b2, b3);
        return ans;
    }

    public static double det2x2(double a, double b2, double c, double d) {
        double ans = a * d - b2 * c;
        return ans;
    }

    public static double log2(double val) {
        return Math.log(val) / 0.69314718;
    }

    public static boolean isDyadic(int x) {
        return (x & x - 1) == 0;
    }

    public static int log2(int x) {
        int n = 0;
        for (int prod = 1; prod <= x; prod *= 2) {
            ++n;
        }
        return n - 1;
    }

    public static int pow2(int x) {
        return 1 << x;
    }

    public static double area(List points) {
        double sum = 0.0;
        int N = points.size();
        for (int i = 0; i < N - 1; ++i) {
            Point2D a0 = (Point2D)points.get(i);
            Point2D a1 = (Point2D)points.get(i + 1);
            sum = sum + a0.getX() * a1.getY() - a0.getY() * a1.getX();
        }
        if (N > 2) {
            Point2D a0 = (Point2D)points.get(N - 1);
            Point2D a1 = (Point2D)points.get(0);
            sum = sum + a0.getX() * a1.getY() - a0.getY() * a1.getX();
        }
        return 0.5 * sum;
    }

    public static void centroid(List points, Point2D result) {
        double cx = 0.0;
        double cy = 0.0;
        int N = points.size();
        for (int i = 0; i < N - 1; ++i) {
            Point2D a0 = (Point2D)points.get(i);
            Point2D a1 = (Point2D)points.get(i + 1);
            cx += (a0.getX() + a1.getX()) * (a0.getX() * a1.getY() - a0.getY() * a1.getX());
            cy += (a0.getY() + a1.getY()) * (a0.getX() * a1.getY() - a0.getY() * a1.getX());
        }
        if (N > 2) {
            Point2D a0 = (Point2D)points.get(N - 1);
            Point2D a1 = (Point2D)points.get(0);
            cx += (a0.getX() + a1.getX()) * (a0.getX() * a1.getY() - a0.getY() * a1.getX());
            cy += (a0.getY() + a1.getY()) * (a0.getX() * a1.getY() - a0.getY() * a1.getX());
        }
        double ar = JnUtils.area(points);
        result.setLocation(cx /= 6.0 * ar, cy /= 6.0 * ar);
    }

    public static Logger getLogger() {
        return Logger.getLogger("com.ge.med.jnu");
    }

    public static long doubleToLongBits(double val) {
        return Double.doubleToLongBits(val);
    }

    public static int floatToIntBits(float val) {
        return Float.floatToIntBits(val);
    }

    public static float intBitsToFloat(int bits) {
        return Float.intBitsToFloat(bits);
    }

    public static void main(String[] args) {
        System.out.println(1.0 / Math.sqrt(2.0));
        System.out.println(JnUtils.fastInvSqrt(2.0f));
    }
}

