/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.XjDicomObject;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.Icon;

public class CvImageFusionUtils {
    public static final DMTag IMAGE_TYPE_DMTAG = new DMTag(8, 8);
    public static final DMTag MODALITY_DMTAG = new DMTag(8, 96);
    public static final DMTag SERIES_DESC_DMTAG = new DMTag(8, 4158);
    public static final DMTag FRAME_PHASE_PERCENT = new DMTag(9, 4323);
    public static final DMTag PHASE_PERCENTAGE_DURATION = new DMTag(9, 4329);
    public static final DMTag SLICE_THICKNESS_DMTAG = new DMTag(24, 80);
    public static final DMTag TRIGGER_TIME_DMTAG = new DMTag(24, 4192);
    public static final DMTag FRAME_TIME_DMTAG = new DMTag(24, 4195);
    public static final DMTag FRAMING_TYPE_DMTAG = new DMTag(24, 4196);
    public static final DMTag IMAGE_POSITION_DMTAG = new DMTag(32, 50);
    public static final DMTag PATIENT_ORIENTATION_DMTAG = new DMTag(32, 55);
    public static final DMTag FRAME_REFERENCE_UID_DMTAG = new DMTag(32, 82);
    public static final DMTag SLICE_LOCATION_DMTAG = new DMTag(32, 4161);
    public static final DMTag PET_SERIES_TYPE_DMTAG = new DMTag(84, 4096);
    public static final DMTag PET_AC_DMTAG = new DMTag(84, 4353);
    public static final DMTag NUM_OF_TIME_SLOT_DMTAG = new DMTag(84, 113);
    public static final DMTag FRAME_REFERENCE_TIME_DMTAG = new DMTag(84, 4864);
    public static final DMTag NUM_OF_TIME_SLICE_DMTAG = new DMTag(84, 257);
    public static final DMTag NUM_OF_SLICES_DMTAG = new DMTag(84, 129);
    private static final double[] SI_UNIT_VECTOR = new double[]{0.0, 0.0, 1.0};
    private static final double[] PA_UNIT_VECTOR = new double[]{0.0, 1.0, 0.0};
    private static final double[] LR_UNIT_VECTOR = new double[]{1.0, 0.0, 0.0};
    public static final int PHASE_GATED_PCNT = 1111;
    public static final int PHASE_GATED_FOR = 1112;
    public static final int NON_PHASE_GATED = 1113;
    public static final int PET_AXIAL_AC = 2001;
    public static final int PET_AXIAL_NAC = 2002;
    public static final int PET_SAGITAL = 2003;
    public static final int PET_CORONAL = 2004;
    public static final int PET_MIP = 2005;
    public static final int PET_OT = 2000;
    public static final int CT_SCOUT = 1001;
    public static final int CT_AXIAL = 1002;
    public static final int CT_SAGITAL = 1003;
    public static final int CT_CORONAL = 1004;
    public static final int CT_OT = 1000;

    public static boolean isPETSeries(DMObject dmo) {
        return dmo != null && "PT".equalsIgnoreCase((String)dmo.getValue(MODALITY_DMTAG));
    }

    public static boolean isCTSeries(DMObject dmo) {
        return dmo != null && "CT".equalsIgnoreCase((String)dmo.getValue(MODALITY_DMTAG));
    }

    public static boolean isPETSeriesTypeSTATIC(Object petSeries) {
        Object val = CvImageFusionUtils.getDMTagValue(petSeries, PET_SERIES_TYPE_DMTAG);
        return val != null && val.toString().indexOf("STATIC") >= 0;
    }

    public static boolean isPETSeriesTypeWHOLEBODY(Object petSeries) {
        Object val = CvImageFusionUtils.getDMTagValue(petSeries, PET_SERIES_TYPE_DMTAG);
        return val != null && (val.toString().indexOf("WHOLE BODY") >= 0 || val.toString().indexOf("WHOLEBODY") >= 0);
    }

    public static boolean isPETSeriesTypeGATED(Object petSeries) {
        Object val = CvImageFusionUtils.getDMTagValue(petSeries, PET_SERIES_TYPE_DMTAG);
        return val != null && val.toString().indexOf("GATED") >= 0;
    }

    public static boolean isPETSeriesTypeDYNAMIC(Object petSeries) {
        Object val = CvImageFusionUtils.getDMTagValue(petSeries, PET_SERIES_TYPE_DMTAG);
        return val != null && val.toString().indexOf("DYNAMIC") >= 0;
    }

    public static void sortImagesByLocation(DMObject[] imageDMObjects) {
        Arrays.sort(imageDMObjects, CvUtils.getDoubleComparator(SLICE_LOCATION_DMTAG.getGroup(), SLICE_LOCATION_DMTAG.getElement()));
    }

    public static void sortImagesByLocation(XjDicomObject[] imageDicomObjects) {
        Arrays.sort(imageDicomObjects, CvUtils.getDoubleComparator(SLICE_LOCATION_DMTAG.getGroup(), SLICE_LOCATION_DMTAG.getElement()));
    }

    public static void sortImagesByPhase(DMObject[] imageDMObjects) {
        if (CvImageFusionUtils.isPETSeriesTypeGATED(imageDMObjects[0])) {
            int framingType = CvImageFusionUtils.getFramingType(imageDMObjects[0]);
            if (framingType == 1113 || framingType == 1112) {
                Arrays.sort(imageDMObjects, CvUtils.getDoubleComparator(TRIGGER_TIME_DMTAG.getGroup(), TRIGGER_TIME_DMTAG.getElement()));
            } else {
                Object val = CvImageFusionUtils.getDMTagValue(imageDMObjects[0], FRAME_PHASE_PERCENT);
                if (val != null && val.toString().trim() != "") {
                    Arrays.sort(imageDMObjects, CvUtils.getDoubleComparator(FRAME_PHASE_PERCENT.getGroup(), FRAME_PHASE_PERCENT.getElement()));
                } else {
                    CvImageFusionUtils.sortPercentPhaseExplicitly(imageDMObjects);
                }
            }
        } else {
            Arrays.sort(imageDMObjects, CvUtils.getDoubleComparator(FRAME_REFERENCE_TIME_DMTAG.getGroup(), FRAME_REFERENCE_TIME_DMTAG.getElement()));
        }
    }

    public static void sortImagesByPhase(XjDicomObject[] imageDMObjects) {
        if (CvImageFusionUtils.isPETSeriesTypeGATED(imageDMObjects[0])) {
            int framingType = CvImageFusionUtils.getFramingType(imageDMObjects[0]);
            if (framingType == 1113 || framingType == 1112) {
                Arrays.sort(imageDMObjects, CvUtils.getDoubleComparator(TRIGGER_TIME_DMTAG.getGroup(), TRIGGER_TIME_DMTAG.getElement()));
            } else {
                Object val = CvImageFusionUtils.getDMTagValue(imageDMObjects[0], FRAME_PHASE_PERCENT);
                if (val != null && val.toString().trim() != "") {
                    Arrays.sort(imageDMObjects, CvUtils.getDoubleComparator(FRAME_PHASE_PERCENT.getGroup(), FRAME_PHASE_PERCENT.getElement()));
                } else {
                    CvImageFusionUtils.sortPercentPhaseExplicitly(imageDMObjects);
                }
            }
        } else {
            Arrays.sort(imageDMObjects, CvUtils.getDoubleComparator(FRAME_REFERENCE_TIME_DMTAG.getGroup(), FRAME_REFERENCE_TIME_DMTAG.getElement()));
        }
    }

    private static void sortPercentPhaseExplicitly(Object[] imageDMObjects) {
        Arrays.sort(imageDMObjects, new PercentPhaseComparator());
    }

    public static Object getDMTagValue(Object dmObject, DMTag tag2) {
        if (dmObject instanceof DMObject) {
            return ((DMObject)dmObject).getValue(tag2);
        }
        if (dmObject instanceof XjDicomObject) {
            return ((XjDicomObject)dmObject).getValue(tag2.getGroup(), tag2.getElement());
        }
        if (dmObject instanceof XpDicomObject) {
            XpDicomElement de = new XpDicomElement(tag2.getGroup(), tag2.getElement());
            ((XpDicomObject)dmObject).getValue(de);
            return de.value;
        }
        return null;
    }

    public static int getFramingType(Object petSeries) {
        Object val = CvImageFusionUtils.getDMTagValue(petSeries, FRAMING_TYPE_DMTAG);
        if (val != null) {
            if (val.toString().indexOf("PCNT") >= 0) {
                return 1111;
            }
            if (val.toString().indexOf("FOR") >= 0) {
                return 1112;
            }
        }
        return 1113;
    }

    public static int getCTSeriesType(DMObject seriesDMObject) {
        String imageType = (String)seriesDMObject.getValue(IMAGE_TYPE_DMTAG);
        if (imageType != null) {
            if (imageType.indexOf("ORIGINAL") >= 0 && imageType.indexOf("PRIMARY") >= 0 && imageType.indexOf("AXIAL") >= 0) {
                return 1002;
            }
            if (imageType.indexOf("ORIGINAL") >= 0 && imageType.indexOf("PRIMARY") >= 0 && imageType.indexOf("LOCALIZER") >= 0) {
                return 1001;
            }
            if (imageType.indexOf("DERIVED") >= 0 && imageType.indexOf("SECONDARY") >= 0 && imageType.indexOf("REFORMATTED") >= 0) {
                int i;
                String orientation = (String)seriesDMObject.getValue(PATIENT_ORIENTATION_DMTAG);
                StringTokenizer st = new StringTokenizer(orientation, "\\");
                double[] rowDirCosines = new double[3];
                double[] colDirCosines = new double[3];
                for (i = 0; i < 3; ++i) {
                    rowDirCosines[i] = Double.parseDouble(st.nextToken());
                }
                for (i = 0; i < 3; ++i) {
                    colDirCosines[i] = Double.parseDouble(st.nextToken());
                }
                int zeroCountRow = 0;
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (rowDirCosines[i2] != 0.0) continue;
                    ++zeroCountRow;
                }
                int zeroCountCol = 0;
                for (int i3 = 0; i3 < 3; ++i3) {
                    if (colDirCosines[i3] != 0.0) continue;
                    ++zeroCountCol;
                }
                if (zeroCountRow < 2 || zeroCountCol < 2) {
                    return 1000;
                }
                JnVector3d directionVector = JnVector3d.cross(rowDirCosines, colDirCosines);
                double[] directionArray = directionVector.toArray();
                if (Math.abs(JnVector3d.dot(SI_UNIT_VECTOR, directionArray)) == 1.0) {
                    return 1002;
                }
                if (Math.abs(JnVector3d.dot(PA_UNIT_VECTOR, directionArray)) == 1.0) {
                    return 1004;
                }
                if (Math.abs(JnVector3d.dot(LR_UNIT_VECTOR, directionArray)) == 1.0) {
                    return 1003;
                }
            }
        }
        return 1000;
    }

    public static int getPETSeriesType(DMObject seriesDMObject) {
        String petSeriesType;
        String imageType = (String)seriesDMObject.getValue(IMAGE_TYPE_DMTAG);
        if (imageType != null && (petSeriesType = (String)seriesDMObject.getValue(PET_SERIES_TYPE_DMTAG)) != null) {
            if (imageType.indexOf("ORIGINAL") >= 0 && imageType.indexOf("PRIMARY") >= 0) {
                if (petSeriesType.indexOf("IMAGE") >= 0) {
                    String seriesDesc = (String)seriesDMObject.getValue(SERIES_DESC_DMTAG);
                    if (seriesDesc != null && seriesDesc.indexOf("MIP") >= 0) {
                        return 2005;
                    }
                    Object ac_field = seriesDMObject.getValue(PET_AC_DMTAG);
                    if (ac_field != null && ac_field.toString().trim() != "") {
                        return 2001;
                    }
                    return 2002;
                }
                if (petSeriesType.indexOf("REPROJECTION") >= 0) {
                    return 2005;
                }
            } else if (imageType.indexOf("DERIVED") >= 0 && imageType.indexOf("PRIMARY") >= 0 && imageType.indexOf("REFORMATTED") >= 0) {
                int i;
                String orientation = (String)seriesDMObject.getValue(PATIENT_ORIENTATION_DMTAG);
                StringTokenizer st = new StringTokenizer(orientation, "\\");
                double[] rowDirCosines = new double[3];
                double[] colDirCosines = new double[3];
                for (i = 0; i < 3; ++i) {
                    rowDirCosines[i] = Double.parseDouble(st.nextToken());
                }
                for (i = 0; i < 3; ++i) {
                    colDirCosines[i] = Double.parseDouble(st.nextToken());
                }
                int zeroCountRow = 0;
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (rowDirCosines[i2] != 0.0) continue;
                    ++zeroCountRow;
                }
                int zeroCountCol = 0;
                for (int i3 = 0; i3 < 3; ++i3) {
                    if (colDirCosines[i3] != 0.0) continue;
                    ++zeroCountCol;
                }
                if (zeroCountRow < 2 || zeroCountCol < 2) {
                    return 2000;
                }
                JnVector3d directionVector = JnVector3d.cross(rowDirCosines, colDirCosines);
                double[] directionArray = directionVector.toArray();
                if (Math.abs(JnVector3d.dot(SI_UNIT_VECTOR, directionArray)) == 1.0) {
                    return 2001;
                }
                if (Math.abs(JnVector3d.dot(PA_UNIT_VECTOR, directionArray)) == 1.0) {
                    return 2004;
                }
                if (Math.abs(JnVector3d.dot(LR_UNIT_VECTOR, directionArray)) == 1.0) {
                    return 2003;
                }
            } else if (imageType.indexOf("DERIVED") >= 0 && imageType.indexOf("SECONDARY") >= 0 && imageType.indexOf("MIP") >= 0) {
                return 2005;
            }
        }
        return 2000;
    }

    public static DMObject[] getAllCTSeries(DMObject ctPetStudyDMObject) {
        DMObject[] series = ctPetStudyDMObject.getRelated("series", new DMQuery("(0x8, 0x60) = \"CT\""));
        return series;
    }

    public static DMObject[] getAllPETSeries(DMObject ctPetStudyDMObject) {
        DMObject[] series = ctPetStudyDMObject.getRelated("series", new DMQuery("(0x8, 0x60) = \"PT\""));
        return series;
    }

    public static DMObject[] getFusableCTSeries(DMObject[] ctSeries) {
        ArrayList<DMObject> list = new ArrayList<DMObject>();
        for (DMObject dmObject : ctSeries) {
            int type = CvImageFusionUtils.getCTSeriesType(dmObject);
            if (type == 1001 || type == 1000) continue;
            list.add(dmObject);
        }
        return list.toArray(new DMObject[list.size()]);
    }

    public static DMObject[] getFusablePETSeries(DMObject[] petSeries) {
        ArrayList<DMObject> list = new ArrayList<DMObject>();
        for (DMObject dmObject : petSeries) {
            int type = CvImageFusionUtils.getPETSeriesType(dmObject);
            if (type == 2005 || type == 2000) continue;
            list.add(dmObject);
        }
        return list.toArray(new DMObject[list.size()]);
    }

    public static boolean isValidCTPETStudy(DMObject studyDMObject) {
        DMObject[] ctSeries = CvImageFusionUtils.getAllCTSeries(studyDMObject);
        if (ctSeries == null || ctSeries.length == 0) {
            return false;
        }
        DMObject[] petSeries = CvImageFusionUtils.getAllPETSeries(studyDMObject);
        if (petSeries == null || petSeries.length == 0) {
            return false;
        }
        ctSeries = CvImageFusionUtils.getFusableCTSeries(ctSeries);
        petSeries = CvImageFusionUtils.getFusablePETSeries(petSeries);
        int ctSeriesSize = ctSeries.length;
        int petSeriesSize = petSeries.length;
        for (int i = 0; i < ctSeriesSize; ++i) {
            for (int j = 0; j < petSeriesSize; ++j) {
                if (!CvImageFusionUtils.isValidFusionCombination(ctSeries[i], petSeries[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidFusionCombination(DMObject ctSeriesDMObject, DMObject petSeriesDMObject) {
        String ptFrameRefUID;
        Object obj = null;
        obj = CvImageFusionUtils.getDMTagValue(ctSeriesDMObject, FRAME_REFERENCE_UID_DMTAG);
        String ctFrameRefUID = obj != null ? obj.toString() : "CT";
        obj = CvImageFusionUtils.getDMTagValue(petSeriesDMObject, FRAME_REFERENCE_UID_DMTAG);
        String string = ptFrameRefUID = obj != null ? obj.toString() : "PT";
        if (!ctFrameRefUID.equals(ptFrameRefUID)) {
            return false;
        }
        int ctType = CvImageFusionUtils.getCTSeriesType(ctSeriesDMObject);
        int petType = CvImageFusionUtils.getPETSeriesType(petSeriesDMObject);
        switch (ctType) {
            case 1002: {
                if (petType != 2001 && petType != 2002) break;
                return true;
            }
            case 1003: {
                if (petType != 2003) break;
                return true;
            }
            case 1004: {
                if (petType != 2004) break;
                return true;
            }
        }
        return false;
    }

    public static DMImage[][] filterOutMatchingSlices(DMImage[] ctimages, DMImage[] petimages) {
        ArrayList<DMImage> ctimgList = new ArrayList<DMImage>();
        ArrayList<DMImage> ptimgList = new ArrayList<DMImage>();
        CvImageFusionUtils.sortImagesByLocation(ctimages);
        CvImageFusionUtils.sortImagesByPhase(petimages);
        CvImageFusionUtils.sortImagesByLocation(petimages);
        double ctSliceThickness = Double.parseDouble((String)ctimages[0].getValue(SLICE_THICKNESS_DMTAG));
        double petSliceThickness = Double.parseDouble((String)petimages[0].getValue(SLICE_THICKNESS_DMTAG));
        double avgThickness = (ctSliceThickness + petSliceThickness) / 2.0;
        int ctframe = 0;
        int petframe = 0;
        while (ctframe < ctimages.length && petframe < petimages.length) {
            double petLoc;
            double ctLoc = Double.parseDouble((String)ctimages[ctframe].getValue(SLICE_LOCATION_DMTAG));
            double locDiff = Math.abs(ctLoc - (petLoc = Double.parseDouble((String)petimages[petframe].getValue(SLICE_LOCATION_DMTAG))));
            if (locDiff <= avgThickness) {
                ctimgList.add(ctimages[ctframe++]);
                ptimgList.add(petimages[petframe++]);
                continue;
            }
            if (ctLoc < petLoc) {
                ++ctframe;
                continue;
            }
            ++petframe;
        }
        if (!ctimgList.isEmpty()) {
            DMImage[][] ctpet = new DMImage[2][ctimgList.size()];
            ctpet[0] = ctimgList.toArray(new DMImage[0]);
            ctpet[1] = ptimgList.toArray(new DMImage[0]);
            return ctpet;
        }
        return null;
    }

    public static DMObject[][] filterOutMatchingSlices(DMObject[] ctimages, DMObject[] petimages) {
        ArrayList<DMObject> ctimgList = new ArrayList<DMObject>();
        ArrayList<DMObject> ptimgList = new ArrayList<DMObject>();
        CvImageFusionUtils.sortImagesByLocation(ctimages);
        CvImageFusionUtils.sortImagesByPhase(petimages);
        CvImageFusionUtils.sortImagesByLocation(petimages);
        double ctSliceThickness = Double.parseDouble((String)ctimages[0].getValue(SLICE_THICKNESS_DMTAG));
        double petSliceThickness = Double.parseDouble((String)petimages[0].getValue(SLICE_THICKNESS_DMTAG));
        double avgThickness = (ctSliceThickness + petSliceThickness) / 2.0;
        int ctframe = 0;
        int petframe = 0;
        while (ctframe < ctimages.length && petframe < petimages.length) {
            double petLoc;
            double ctLoc = Double.parseDouble((String)ctimages[ctframe].getValue(SLICE_LOCATION_DMTAG));
            double locDiff = Math.abs(ctLoc - (petLoc = Double.parseDouble((String)petimages[petframe].getValue(SLICE_LOCATION_DMTAG))));
            if (locDiff <= avgThickness) {
                ctimgList.add(ctimages[ctframe++]);
                ptimgList.add(petimages[petframe++]);
                continue;
            }
            if (ctLoc < petLoc) {
                ++ctframe;
                continue;
            }
            ++petframe;
        }
        if (!ctimgList.isEmpty()) {
            DMObject[][] ctpet = new DMObject[2][ctimgList.size()];
            ctpet[0] = ctimgList.toArray(new DMObject[0]);
            ctpet[1] = ptimgList.toArray(new DMObject[0]);
            return ctpet;
        }
        return null;
    }

    public static DMObject[] sortCTseries(DMObject ctSeries) {
        DMObject[] images = ctSeries.getRelated("image");
        return CvImageFusionUtils.sortCTseries(images);
    }

    public static DMObject[] sortCTseries(DMObject[] ctImages) {
        CvImageFusionUtils.sortImagesByLocation(ctImages);
        return ctImages;
    }

    public static DMObject[][] sortPETseries(DMObject petSeries) {
        DMObject[] images = petSeries.getRelated("image");
        return CvImageFusionUtils.sortPETImages(images);
    }

    public static DMObject[][] sortPETImages(DMObject[] petimages) {
        DMObject[][] result = null;
        if (CvImageFusionUtils.isPETSeriesTypeSTATIC(petimages[0])) {
            CvImageFusionUtils.sortImagesByLocation(petimages);
            result = new DMObject[][]{petimages};
            return result;
        }
        if (CvImageFusionUtils.isPETSeriesTypeDYNAMIC(petimages[0]) || CvImageFusionUtils.isPETSeriesTypeWHOLEBODY(petimages[0])) {
            CvImageFusionUtils.sortImagesByLocation(petimages);
            int noOfTimeSlice = Integer.parseInt(petimages[0].getValue(NUM_OF_TIME_SLICE_DMTAG).toString());
            int noOfSlices = Integer.parseInt(petimages[0].getValue(NUM_OF_SLICES_DMTAG).toString());
            if (noOfTimeSlice * noOfSlices == petimages.length) {
                CvImageFusionUtils.sortImagesByPhase(petimages);
                result = new DMObject[noOfTimeSlice][noOfSlices];
                for (int i = 0; i < noOfTimeSlice; ++i) {
                    System.arraycopy(petimages, i * noOfSlices, result[i], 0, noOfSlices);
                }
                return result;
            }
            TreeMap<Double, ArrayList> sortedList = new TreeMap<Double, ArrayList>();
            for (int i = 0; i < petimages.length; ++i) {
                Double val = Double.valueOf((String)petimages[i].getValue(FRAME_REFERENCE_TIME_DMTAG));
                ArrayList list = sortedList.get(val) == null ? new ArrayList() : (ArrayList)sortedList.get(val);
                list.add(petimages[i]);
                sortedList.put(val, list);
            }
            Set keySet = sortedList.keySet();
            result = new DMObject[keySet.size()][];
            int phaseCount = 0;
            for (Double frt : keySet) {
                ArrayList phaseList = (ArrayList)sortedList.get(frt);
                result[phaseCount++] = phaseList.toArray(new DMObject[0]);
            }
            return result;
        }
        if (CvImageFusionUtils.isPETSeriesTypeGATED(petimages[0])) {
            int noOfSlices;
            CvImageFusionUtils.sortImagesByLocation(petimages);
            Object val = petimages[0].getValue(NUM_OF_TIME_SLICE_DMTAG);
            int noOfTimeSlice = val == null ? 0 : Integer.parseInt(val.toString());
            val = petimages[0].getValue(NUM_OF_SLICES_DMTAG);
            int n = noOfSlices = val == null ? 0 : Integer.parseInt(val.toString());
            if (noOfTimeSlice * noOfSlices == petimages.length) {
                CvImageFusionUtils.sortImagesByPhase(petimages);
                result = new DMObject[noOfTimeSlice][noOfSlices];
                for (int i = 0; i < noOfTimeSlice; ++i) {
                    System.arraycopy(petimages, i * noOfSlices, result[i], 0, noOfSlices);
                }
                return result;
            }
            DMTag phaseTag = TRIGGER_TIME_DMTAG;
            int framingType = CvImageFusionUtils.getFramingType(petimages[0]);
            if (framingType == 1111 && (val = CvImageFusionUtils.getDMTagValue(petimages[0], FRAME_PHASE_PERCENT)) != null && val.toString().trim() != "") {
                phaseTag = FRAME_PHASE_PERCENT;
            }
            TreeMap<Double, ArrayList> sortedList = new TreeMap<Double, ArrayList>();
            for (int i = 0; i < petimages.length; ++i) {
                Double dval = Double.valueOf(petimages[i].getValue(phaseTag).toString());
                ArrayList list = sortedList.get(dval) == null ? new ArrayList() : (ArrayList)sortedList.get(dval);
                list.add(petimages[i]);
                sortedList.put(dval, list);
            }
            Set keySet = sortedList.keySet();
            result = new DMObject[keySet.size()][];
            int phaseCount = 0;
            for (Double frt : keySet) {
                ArrayList phaseList = (ArrayList)sortedList.get(frt);
                result[phaseCount++] = phaseList.toArray(new DMObject[0]);
            }
            return result;
        }
        CvImageFusionUtils.sortImagesByLocation(petimages);
        result = new DMObject[][]{petimages};
        return result;
    }

    public static int[] loadRGBColorTable(InputStream is) throws IOException, NumberFormatException {
        InputStreamReader ir = new InputStreamReader(is);
        LineNumberReader lnr = new LineNumberReader(ir);
        int[] map = new int[256];
        for (int i = 0; i < map.length; ++i) {
            String str = lnr.readLine();
            if (str == null) {
                throw new IOException("Invalid Color map file.");
            }
            map[i] = Integer.parseInt(str.substring(1), 16);
        }
        return map;
    }

    public static Icon createColorMapIcon(int[] cmap) {
        return new CMapIcon(cmap, new Dimension(30, 30));
    }

    public static Icon createColorMapIcon(int[] cmap, Dimension size) {
        return new CMapIcon(cmap, size);
    }

    public static class CMapIcon
    implements Icon {
        BufferedImage mapimage;
        Dimension size;

        public CMapIcon(int[] colormap, Dimension size) {
            this.size = size;
            this.mapimage = new BufferedImage(colormap.length, 1, 1);
            int[] imap = ((DataBufferInt)this.mapimage.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < colormap.length; ++i) {
                imap[colormap.length - i - 1] = colormap[i];
            }
        }

        public int getIconHeight() {
            return this.size.height;
        }

        public int getIconWidth() {
            return this.size.width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawImage(this.mapimage, x, y, this.size.width, this.size.height, null);
            g.drawRect(x, y, this.size.width, this.size.height);
        }
    }

    static class PercentPhaseComparator
    implements Comparator {
        PercentPhaseComparator() {
        }

        public int compare(Object o1, Object o2) {
            double phasePercent1 = 0.0;
            double phasePercent2 = 0.0;
            if (o1 instanceof DMObject && o2 instanceof DMObject) {
                DMObject dmi1 = (DMObject)o1;
                DMObject dmi2 = (DMObject)o2;
                double triggerTime = Double.parseDouble(dmi1.getValue(TRIGGER_TIME_DMTAG.getGroup(), TRIGGER_TIME_DMTAG.getElement()).toString());
                double frameTime = Double.parseDouble(dmi1.getValue(FRAME_TIME_DMTAG.getGroup(), FRAME_TIME_DMTAG.getElement()).toString());
                double noOfTimeSlot = Double.parseDouble(dmi1.getValue(NUM_OF_TIME_SLOT_DMTAG.getGroup(), NUM_OF_TIME_SLOT_DMTAG.getElement()).toString());
                phasePercent1 = (triggerTime + frameTime / 2.0) / (frameTime + noOfTimeSlot);
                triggerTime = Double.parseDouble(dmi2.getValue(TRIGGER_TIME_DMTAG.getGroup(), TRIGGER_TIME_DMTAG.getElement()).toString());
                frameTime = Double.parseDouble(dmi2.getValue(FRAME_TIME_DMTAG.getGroup(), FRAME_TIME_DMTAG.getElement()).toString());
                noOfTimeSlot = Double.parseDouble(dmi2.getValue(NUM_OF_TIME_SLOT_DMTAG.getGroup(), NUM_OF_TIME_SLOT_DMTAG.getElement()).toString());
                phasePercent2 = (triggerTime + frameTime / 2.0) / (frameTime + noOfTimeSlot);
            } else if (o1 instanceof XjDicomObject && o2 instanceof XjDicomObject) {
                XjDicomObject dmi1 = (XjDicomObject)o1;
                XjDicomObject dmi2 = (XjDicomObject)o2;
                double triggerTime = Double.parseDouble(dmi1.getValue(TRIGGER_TIME_DMTAG.getGroup(), TRIGGER_TIME_DMTAG.getElement()).toString());
                double frameTime = Double.parseDouble(dmi1.getValue(FRAME_TIME_DMTAG.getGroup(), FRAME_TIME_DMTAG.getElement()).toString());
                double noOfTimeSlot = Double.parseDouble(dmi1.getValue(NUM_OF_TIME_SLOT_DMTAG.getGroup(), NUM_OF_TIME_SLOT_DMTAG.getElement()).toString());
                phasePercent1 = (triggerTime + frameTime / 2.0) / (frameTime + noOfTimeSlot);
                triggerTime = Double.parseDouble(dmi2.getValue(TRIGGER_TIME_DMTAG.getGroup(), TRIGGER_TIME_DMTAG.getElement()).toString());
                frameTime = Double.parseDouble(dmi2.getValue(FRAME_TIME_DMTAG.getGroup(), FRAME_TIME_DMTAG.getElement()).toString());
                noOfTimeSlot = Double.parseDouble(dmi2.getValue(NUM_OF_TIME_SLOT_DMTAG.getGroup(), NUM_OF_TIME_SLOT_DMTAG.getElement()).toString());
                phasePercent2 = (triggerTime + frameTime / 2.0) / (frameTime + noOfTimeSlot);
            }
            if (phasePercent1 > phasePercent2) {
                return 1;
            }
            if (phasePercent1 < phasePercent2) {
                return -1;
            }
            return 0;
        }
    }
}

