/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.CineCapable;
import com.ge.med.terra.jami.PaintListener;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class CvCineMotor {
    private int origfps = 10;
    private int actualfps = -1;
    private int prevfps = -1;
    private int cineInterval = 1;
    private int cineMode = 0;
    private boolean noskip = true;
    private boolean cineOn = false;
    private boolean pauseCine = false;
    private Timer cineThread = null;
    private Timer cineRateUpdateThread = null;
    private int rateUpdateFreq = 2;
    private long startTime = 0L;
    private long endTime = 0L;
    private long pauseTime = 0L;
    private XPscreen screen = null;
    private XpViewport[] viewer = null;
    private Vector<XpViewport> viewerList = new Vector();
    private int[] frame;
    private int[] startframes;
    private int[] endframes;
    private final int paintTimePerFrame = Integer.parseInt(CvPropertiesManager.getProperty("cvf.cine.avgPaintTimePerFrame", "10"));
    private static final Logger logger = Logger.getLogger(CvCineMotor.class.getName());
    private static final TransactionLogName tln = new TransactionLogName("TID=CV_cine");
    private Thread pauseThread = null;
    private long expectedpaintCount = 0L;
    private long paintCount = 0L;
    private int paintFor = -1;
    PaintListener plsnr = new PaintListener(){

        public void paintComplete(JComponent source) {
            if (CvCineMotor.this.cineOn && CvCineMotor.this.viewer[0] instanceof CineCapable && CvCineMotor.this.paintFor != ((CineCapable)((Object)CvCineMotor.this.viewer[0])).getOffset()) {
                CvCineMotor.this.paintCount++;
                CvCineMotor.this.paintFor = ((CineCapable)((Object)CvCineMotor.this.viewer[0])).getOffset();
                if (!CvCineMotor.this.pauseCine && CvCineMotor.this.noskip) {
                    CvCineMotor.this.cineThread.restart();
                }
            }
        }
    };

    public CvCineMotor() {
        String val = CvPropertiesManager.getProperty("cvf.cine.noskip", "false");
        this.noskip = "true".equalsIgnoreCase(val);
    }

    public synchronized void attachViewer(XpViewport vp) throws UnsupportedOperationException {
        if (this.viewerList.contains(vp)) {
            return;
        }
        if (!(vp instanceof CineCapable)) {
            throw new UnsupportedOperationException("Cine not supported on this Viewport");
        }
        this.viewerList.add(vp);
        this.screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, vp);
    }

    public synchronized void detachViewer(XpViewport vp) throws UnsupportedOperationException {
        if (vp instanceof CineCapable) {
            if (!this.viewerList.contains(vp)) {
                return;
            }
        } else {
            throw new UnsupportedOperationException("Cine not supported on this Viewport");
        }
        this.viewerList.remove(vp);
    }

    public void setCineRate(int fps) {
        this.origfps = fps;
        if (this.cineThread != null) {
            int delay = (int)((1000.0 - (double)(this.origfps * this.paintTimePerFrame)) / (double)this.origfps);
            if (delay < 0) {
                delay = 0;
            }
            if (this.noskip) {
                this.cineThread.setInitialDelay(delay);
            } else {
                this.cineThread.setDelay(delay);
            }
        }
        this.paintCount = 0L;
        this.expectedpaintCount = 0L;
        this.startTime = System.currentTimeMillis();
        this.pauseTime = 0L;
        this.endTime = 0L;
    }

    public int getActualFps() {
        if (this.cineOn) {
            long eTime = System.currentTimeMillis();
            long timediff = eTime - this.startTime - this.pauseTime;
            if (timediff != 0L) {
                this.actualfps = (int)(this.paintCount * 1000L / timediff);
            }
            return this.actualfps;
        }
        return this.actualfps;
    }

    public void setCineSkip(int interval) {
        this.cineInterval = interval;
    }

    public int getFramesSkipped() {
        return (int)(this.expectedpaintCount - this.paintCount);
    }

    public void setCineMode(int mode) {
        this.cineMode = mode;
    }

    public void start() {
        logger.log(Level.INFO, "{0} begin", tln);
        int size = this.viewerList.size();
        if (size == 0) {
            return;
        }
        if (this.cineThread == null) {
            int delay;
            this.frame = new int[size];
            this.startframes = new int[size];
            this.endframes = new int[size];
            this.viewer = new XpViewport[size];
            for (int i = 0; i < this.viewer.length; ++i) {
                this.viewer[i] = this.viewerList.get(i);
                if (!(this.viewer[i] instanceof CineCapable)) continue;
                this.startframes[i] = ((CineCapable)((Object)this.viewer[i])).getStartOffset();
                this.endframes[i] = ((CineCapable)((Object)this.viewer[i])).getEndOffset();
                this.frame[i] = this.startframes[i];
                ((CineCapable)((Object)this.viewer[i])).setOffset(this.frame[i]);
            }
            this.reset();
            if (this.noskip) {
                this.viewer[0].addPaintListener(this.plsnr);
            }
            this.cineOn = true;
            int n = delay = this.noskip ? 0 : (int)((1000.0 - (double)(this.origfps * this.paintTimePerFrame)) / (double)this.origfps);
            if (delay < 0) {
                delay = 0;
            }
            this.cineThread = new Timer(delay, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CvCineMotor.this.expectedpaintCount++;
                    for (int i = CvCineMotor.this.viewer.length - 1; i >= 0; --i) {
                        int[] nArray = CvCineMotor.this.frame;
                        int n = i;
                        nArray[n] = nArray[n] + CvCineMotor.this.cineInterval;
                        if (CvCineMotor.this.cineMode == 0) {
                            if (CvCineMotor.this.frame[i] > CvCineMotor.this.endframes[i]) {
                                ((CvCineMotor)CvCineMotor.this).frame[i] = CvCineMotor.this.startframes[i];
                                CvCineMotor.this.reset();
                                CvCineMotor.this.expectedpaintCount++;
                                CvCineMotor.this.startTime = System.currentTimeMillis();
                            }
                            if (CvCineMotor.this.frame[i] < CvCineMotor.this.startframes[i]) {
                                ((CvCineMotor)CvCineMotor.this).frame[i] = CvCineMotor.this.endframes[i];
                                CvCineMotor.this.reset();
                                CvCineMotor.this.expectedpaintCount++;
                                CvCineMotor.this.startTime = System.currentTimeMillis();
                            }
                        } else if (CvCineMotor.this.frame[i] > CvCineMotor.this.endframes[i]) {
                            CvCineMotor.this.cineInterval = -Math.abs(CvCineMotor.this.cineInterval);
                            int[] nArray2 = CvCineMotor.this.frame;
                            int n2 = i;
                            nArray2[n2] = nArray2[n2] + 2 * CvCineMotor.this.cineInterval;
                            CvCineMotor.this.reset();
                            CvCineMotor.this.expectedpaintCount++;
                            CvCineMotor.this.startTime = System.currentTimeMillis();
                        } else if (CvCineMotor.this.frame[i] < CvCineMotor.this.startframes[i]) {
                            CvCineMotor.this.cineInterval = Math.abs(CvCineMotor.this.cineInterval);
                            int[] nArray3 = CvCineMotor.this.frame;
                            int n3 = i;
                            nArray3[n3] = nArray3[n3] + 2 * CvCineMotor.this.cineInterval;
                            CvCineMotor.this.reset();
                            CvCineMotor.this.expectedpaintCount++;
                            CvCineMotor.this.startTime = System.currentTimeMillis();
                        }
                        if (CvCineMotor.this.viewer[i] instanceof CineCapable) {
                            ((CineCapable)((Object)CvCineMotor.this.viewer[i])).setOffset(CvCineMotor.this.frame[i]);
                        }
                        CvCineMotor.this.viewer[i].repaint();
                    }
                }
            });
            this.cineThread.setCoalesce(!this.noskip);
            this.cineThread.setRepeats(!this.noskip);
            this.cineThread.start();
            if (this.noskip) {
                this.restartCineRateUpdate();
            }
            if (this.noskip) {
                this.cineThread.setInitialDelay((int)((1000.0 - (double)(this.origfps * this.paintTimePerFrame)) / (double)this.origfps));
            } else {
                this.cineThread.setDelay(delay);
            }
            this.startTime = System.currentTimeMillis();
        } else {
            for (int i = 0; i < this.viewer.length; ++i) {
                if (!(this.viewer[i] instanceof CineCapable)) continue;
                this.frame[i] = ((CineCapable)((Object)this.viewer[i])).getOffset();
                this.startframes[i] = ((CineCapable)((Object)this.viewer[i])).getStartOffset();
                this.endframes[i] = ((CineCapable)((Object)this.viewer[i])).getEndOffset();
                if (this.frame[i] > this.endframes[i]) {
                    this.frame[i] = this.endframes[i];
                    this.reset();
                    ++this.expectedpaintCount;
                    this.startTime = System.currentTimeMillis();
                    ((CineCapable)((Object)this.viewer[i])).setOffset(this.frame[i]);
                    continue;
                }
                if (this.frame[i] >= this.startframes[i]) continue;
                this.frame[i] = this.startframes[i];
                this.reset();
                ++this.expectedpaintCount;
                this.startTime = System.currentTimeMillis();
                ((CineCapable)((Object)this.viewer[i])).setOffset(this.frame[i]);
            }
            this.cineThread.restart();
            if (this.noskip) {
                this.restartCineRateUpdate();
            }
        }
    }

    public void stop() {
        if (this.viewerList.size() == 0) {
            return;
        }
        XpViewport port = this.viewerList.get(0);
        this.cineOn = false;
        this.pauseCine = false;
        if (this.cineThread != null) {
            this.cineThread.stop();
            for (int i = 0; i < this.viewerList.size(); ++i) {
                this.viewerList.get(i).repaint();
            }
        }
        this.cineThread = null;
        port.removePaintListener(this.plsnr);
        this.frame = null;
        this.startframes = null;
        this.endframes = null;
        this.viewer = null;
        if (this.pauseThread != null) {
            this.pauseThread.interrupt();
        }
        this.pauseThread = null;
        if (this.cineRateUpdateThread != null) {
            this.cineRateUpdateThread.stop();
            this.cineRateUpdateThread = null;
        }
        this.endTime = System.currentTimeMillis();
        long timediff = this.endTime - this.startTime - this.pauseTime;
        if (timediff != 0L) {
            this.actualfps = (int)(this.paintCount * 1000L / timediff);
        }
        int width = 0;
        int height = 0;
        int numFrames = 0;
        if (port instanceof FrameOwner) {
            width = ((FrameOwner)((Object)port)).getFrame().getSlice().width;
            height = ((FrameOwner)((Object)port)).getFrame().getSlice().height;
        }
        if (port instanceof CineCapable) {
            numFrames = Math.abs((((CineCapable)((Object)port)).getEndOffset() - ((CineCapable)((Object)port)).getStartOffset() + 1) / ((CineCapable)((Object)port)).getCineSkip());
        }
        logger.log(Level.INFO, "{0} end , NUMIMAGES=" + numFrames + " IMAGESIZE=" + width + "x" + height + " SETFRAMERATE=" + 1000 / this.origfps + " ACTUALFRAMERATE=" + this.getActualFps() + " FRAMESSKIPPED=" + this.getFramesSkipped(), tln);
    }

    public void pause() {
        if (this.viewerList.size() == 0) {
            return;
        }
        this.pauseCine = true;
        this.startPauseThread();
    }

    public void resume() {
        if (this.viewerList.size() == 0) {
            return;
        }
        this.pauseCine = false;
        if (this.pauseThread != null) {
            this.pauseThread.interrupt();
        }
        this.pauseThread = null;
        if (this.cineOn) {
            this.start();
        }
    }

    private void reset() {
        this.paintCount = 0L;
        this.expectedpaintCount = 0L;
        this.paintFor = -1;
        this.startTime = 0L;
        this.pauseTime = 0L;
        this.endTime = 0L;
    }

    public boolean isPaused() {
        return this.pauseCine;
    }

    private void startPauseThread() {
        if (this.viewerList.size() == 0) {
            return;
        }
        if (this.pauseThread == null) {
            if (this.cineThread != null) {
                this.cineThread.stop();
            }
            if (this.cineRateUpdateThread != null) {
                this.cineRateUpdateThread.stop();
            }
            final long t1 = System.currentTimeMillis();
            this.pauseThread = new Thread(new Runnable(){

                public void run() {
                    while (CvCineMotor.this.pauseCine && CvCineMotor.this.cineOn) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {}
                    }
                    long dt = System.currentTimeMillis() - t1;
                    CvCineMotor.this.pauseTime += dt;
                }
            });
            this.pauseThread.start();
        }
    }

    public void restartCineRateUpdate() {
        if (this.cineRateUpdateThread != null) {
            this.cineRateUpdateThread.restart();
        } else {
            this.cineRateUpdateThread = new Timer(this.rateUpdateFreq * 1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int fps = CvCineMotor.this.getActualFps();
                    if (fps > 0 && fps < CvCineMotor.this.origfps - 3) {
                        CvCineMotor.this.screen.firePropertyChange("NO_SKIP_RATE", CvCineMotor.this.origfps, fps);
                    } else {
                        CvCineMotor.this.screen.firePropertyChange("NO_SKIP_RATE", CvCineMotor.this.origfps, -1);
                    }
                }
            });
            this.cineRateUpdateThread.start();
        }
    }
}

