/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.comparators.NumberComparator;
import com.ge.med.cse.cvf.idc.XpClipRoiActor;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpCPI;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.CPICapable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import com.ge.med.terra.jami.platform.dm.XpDMgsps;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMiSeqItem;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import java.awt.Dimension;
import java.awt.Shape;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CPIUtils {
    private static Logger logger = Logger.getLogger(CPIUtils.class.getName());
    private static final boolean enable_gsps = CvPropertiesManager.getBoolean("cvf.enable_gsps", true);
    private static byte[] bbuff = new byte[32768];
    private static final XpDicomElement suid = new XpDicomElement(32, 14);
    private static final String VIGNETTE_SIGNATURE = "SdCv";
    private static final int VIGNETTE_SIGNATURE_LENGTH = 4;
    private static final String GSPS_SOP_CLASS_UID = "1.2.840.10008.5.1.4.1.1.11.1";

    public static InputStream doSaveState(XpViewport xpViewport, DMObject refObject, XpDicomElement[] overrideDicomElements) {
        XpDMgsps gspsFactory = new XpDMgsps(xpViewport, refObject);
        return gspsFactory.getGSPS(overrideDicomElements);
    }

    public static String getGSPSSeriesUID(DMObject refObject) {
        DMObject[] dmo;
        String SeriesUID = null;
        DMSession session = refObject.getSession();
        String examid = (String)refObject.getValue(32, 16);
        String examuid = (String)refObject.getValue(32, 13);
        int gspsSeriesNo = CPIUtils.getGSPSSeriesNo(refObject);
        String query = "(0x0020, 0x000D) = " + examuid;
        if (examid != null && examid.trim().length() > 0) {
            query = query + " AND (0x0020, 0x0010) = " + examid;
        }
        SeriesUID = (dmo = session.getRelated("series", new DMQuery(query = query + " AND (0x0020, 0x0011) = " + gspsSeriesNo))) == null || dmo.length == 0 ? UidGenerator.newInstanceUID() : (String)dmo[0].getValue(32, 14);
        return SeriesUID;
    }

    public static String getGSPSUIDFromAuxTag(DMObject dmObject) {
        boolean gspsAuxFlag = CvPropertiesManager.getBoolean("GSPS_AUX_TAG", false);
        if (gspsAuxFlag) {
            String gspsUID = (String)dmObject.getValue(1, 5000);
            if (gspsUID == null) {
                return null;
            }
            return gspsUID.split(":", 2)[1];
        }
        return null;
    }

    public static void setAuxTag(DMObject object, String save_state_uid) {
        DMObject series = null;
        if (object.getType().equals("study")) {
            series = object.getRelated("series")[0];
        } else if (object.getType().equals("series")) {
            series = object;
        } else if (object.getType().equals("image")) {
            series = object.getRelated("series")[0];
        }
        DMElement[] elements = new DMElement[]{new DMElement()};
        elements[0].group = 1;
        elements[0].element = 5000;
        elements[0].value = save_state_uid;
        if (series != null) {
            series.setValues(elements);
        }
    }

    public static InputStream doSaveState(XpViewport xpViewport, int fromImage, int toImage, DMObject refObject, XpDicomElement[] overrideDicomElements) {
        int numFrames;
        if (fromImage == 0 && toImage == 0) {
            CPIUtils.doSaveState(xpViewport, refObject, overrideDicomElements);
        }
        if (fromImage > (numFrames = xpViewport.getImages().length)) {
            fromImage = numFrames;
        }
        if (fromImage <= 0) {
            fromImage = 1;
        }
        if (toImage > numFrames) {
            toImage = numFrames;
        }
        if (toImage < 1) {
            toImage = 1;
        }
        return CPIUtils.saveStateForImageRange_Part2(xpViewport, refObject, overrideDicomElements, fromImage, toImage);
    }

    public static InputStream doSaveState(XpViewport xpViewport, int[] indices, DMObject refObject, XpDicomElement[] overrideDicomElements) {
        CPIUtils.saveStateForSelectedImages(xpViewport, refObject, overrideDicomElements, indices);
        return null;
    }

    public static InputStream doSaveState(XpViewport viewport, int index, DMObject refObject, XpDicomElement[] overrideDicomElements) {
        if (!(viewport instanceof CPICapable)) {
            return null;
        }
        return CPIUtils.saveStateForSingleImage(viewport, refObject, overrideDicomElements, index);
    }

    public static int getGSPSSeriesNo(DMObject dmObject) {
        String refSeriesNo = (String)dmObject.getValue(new DMTag(32, 17));
        int gspsSeriesNo = Integer.parseInt(refSeriesNo) + 100000;
        return gspsSeriesNo;
    }

    public static boolean isGSPS(DMTagValueInterface dmo) {
        return GSPS_SOP_CLASS_UID.equals(dmo.getValue(new DMTag(8, 22)));
    }

    public static DMObject[] getRelatedGSPSObjectsBySeriesNumber(DMObject series) {
        DMObject exam = series.getRelated("study")[0];
        int gspsSerNo = CPIUtils.getGSPSSeriesNo(series);
        DMQuery query = new DMQuery("(0x0020,0x0011) = " + gspsSerNo);
        DMObject[] gspsSeries = exam.getRelated("series", query);
        if (gspsSeries != null && gspsSeries.length > 0) {
            return gspsSeries[0].getRelated("image");
        }
        return null;
    }

    public static DMObject[] getAllRelatedGSPSObjects(DMObject series) {
        DMObject exam = null;
        String seriesUID = (String)series.getValue(new DMTag(32, 14));
        exam = series.getRelated("study")[0];
        DMObject[] seriesInExam = exam.getRelated("series");
        int numSeries = seriesInExam.length;
        int iCount = 0;
        int jCount = 0;
        for (iCount = 0; iCount < numSeries; ++iCount) {
            if (!CPIUtils.isGSPS(seriesInExam[iCount])) continue;
            ++jCount;
        }
        DMObject[] gspsSeries = new DMObject[jCount];
        jCount = 0;
        for (iCount = 0; iCount < numSeries; ++iCount) {
            if (!CPIUtils.isGSPS(seriesInExam[iCount])) continue;
            gspsSeries[jCount] = seriesInExam[iCount];
            System.out.println("series path=" + gspsSeries[jCount].getComposites()[0].getFilePath());
            ++jCount;
        }
        for (jCount = 0; jCount < gspsSeries.length; ++jCount) {
            XpMedicalImage[] medicalImage = CPIUtils.getRefImages(gspsSeries[jCount], true);
            if (medicalImage == null) continue;
            for (iCount = 0; iCount < medicalImage.length; ++iCount) {
                XpDicomElement dicomElement = new XpDicomElement(32, 14);
                int retVal = medicalImage[iCount].getValue(dicomElement);
                String serUIDFromImg = null;
                if (retVal == 0) {
                    serUIDFromImg = (String)dicomElement.value;
                }
                if (!seriesUID.equalsIgnoreCase(serUIDFromImg)) continue;
                return gspsSeries[jCount].getRelated("image");
            }
        }
        return null;
    }

    public static Object getLatestRelatedGSPSObject(DMObject series) {
        DMObject[] gspsSeries = CPIUtils.getAllRelatedGSPSObjects(series);
        if (gspsSeries != null) {
            Arrays.sort(gspsSeries, new NumberComparator(8, 19));
            Arrays.sort(gspsSeries, new NumberComparator(8, 18));
            return gspsSeries[gspsSeries.length - 1];
        }
        return CPIUtils.getGSPSFilePath(series);
    }

    public static String getGSPSFilePath(DMObject series) {
        String[] gspsfile;
        String path = series.getComposites()[0].getFilePath();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("v") && name.endsWith(".prdc");
            }
        };
        File file = new File(path);
        File parent = file.getParentFile();
        if (parent != null && (gspsfile = parent.list(filter)).length > 0) {
            String fullpath = parent.getPath() + File.separator + gspsfile[0];
            return fullpath;
        }
        return null;
    }

    public static Object getLatestRelatedGSPSObjectFromAuxTag(DMObject series) {
        boolean gspsAuxFlag = CvPropertiesManager.getBoolean("GSPS_AUX_TAG", false);
        if (gspsAuxFlag) {
            String gspsUID = (String)series.getValue(1, 5000);
            if (gspsUID == null) {
                return null;
            }
            String[] gspsUIDType = gspsUID.split(":", 2);
            if (gspsUIDType[0].equalsIgnoreCase("UID")) {
                DMQuery query = new DMQuery("(0x0008,0x0018) = " + gspsUIDType[1]);
                DMObject[] exam = series.getRelated("exam");
                DMObject[] gspsObjs = exam[0].getRelated("image", query);
                if (gspsObjs != null && gspsObjs.length > 0) {
                    return gspsObjs[0];
                }
                return null;
            }
            return CPIUtils.getGSPSFilePath(series);
        }
        return null;
    }

    public static void setLatestRelatedGSPSObjectToAuxTag(DMObject series, Object latestGSPS) {
        boolean gspsAuxFlag = CvPropertiesManager.getBoolean("GSPS_AUX_TAG", false);
        if (gspsAuxFlag) {
            if (latestGSPS instanceof DMObject && CPIUtils.isGSPS((DMObject)latestGSPS)) {
                String gspsUIDType = (String)((DMObject)latestGSPS).getValue(8, 24);
                CPIUtils.setAuxTag(series, "UID:" + gspsUIDType);
            } else if (latestGSPS instanceof String) {
                CPIUtils.setAuxTag(series, "PATH:" + latestGSPS);
            } else {
                logger.log(Level.INFO, "Latest GSPS is not in acceptable form");
            }
        }
    }

    private static InputStream saveStateForImageRange(XpViewport xpViewport, DMObject refObject, XpDicomElement[] overrides, int startImg, int endImg) {
        int numImages = endImg - startImg + 1;
        XpMedicalImage[] imgs = new XpMedicalImage[numImages];
        if (xpViewport instanceof FrameCapable) {
            int fromImage = startImg - 1;
            for (int iCount = 0; iCount < numImages; ++iCount) {
                imgs[iCount] = (XpMedicalImage)((FrameCapable)((Object)xpViewport)).getFrame(fromImage);
                ++fromImage;
            }
        }
        XpDMgsps gspsFactory = new XpDMgsps(imgs, ((CPICapable)((Object)xpViewport)).getCPI(), refObject);
        return gspsFactory.getGSPS(overrides);
    }

    private static InputStream saveStateForSelectedImages(XpViewport xpViewport, DMObject refObject, XpDicomElement[] overrides, int[] indices) {
        int numImages = indices.length;
        XpMedicalImage[] imgs = new XpMedicalImage[numImages];
        if (xpViewport instanceof FrameCapable) {
            for (int iCount = 0; iCount < numImages; ++iCount) {
                imgs[iCount] = (XpMedicalImage)((FrameCapable)((Object)xpViewport)).getFrame(indices[iCount]);
            }
        }
        XpDMgsps gspsFactory = new XpDMgsps(imgs, ((CPICapable)((Object)xpViewport)).getCPI(), refObject);
        return gspsFactory.getGSPS(overrides);
    }

    private static InputStream saveStateForImageRange_Part2(XpViewport xpViewport, DMObject refObject, XpDicomElement[] overrides, int startImg, int endImg) {
        int numImages = endImg - startImg + 1;
        XpMedicalImage[] imgs = new XpMedicalImage[numImages];
        int fromImage = startImg - 1;
        logger.log(Level.INFO, "Creating GSPS for " + numImages + " images. Start Image= " + fromImage + "End Image= " + (endImg - 1));
        for (int iCount = 0; iCount < numImages; ++iCount) {
            imgs[iCount] = (XpMedicalImage)((FrameCapable)((Object)xpViewport)).getFrame(fromImage);
            ++fromImage;
        }
        ArrayList<XpImageScene> scenes = new ArrayList<XpImageScene>();
        int index = -1;
        fromImage = startImg - 1;
        if (xpViewport instanceof XpCompositePort) {
            for (int iCount = 0; iCount < numImages; ++iCount) {
                XpImageScene sc = ((XpCompositePort)xpViewport).getScene(fromImage);
                scenes.add(sc);
                imgs[++index] = (XpMedicalImage)sc.getFrame();
                ++fromImage;
            }
            XpFrameVisualizer frameVisualizer = ((XpCompositePort)xpViewport).getPort(0);
            Dimension d = frameVisualizer.getMedicalImageVc().getImageVc().getSize();
            XpCPI cpi = XpCPI.createCPI(scenes, d, false);
            XpImageRenderAttributes imageRenderAttributes = frameVisualizer.getImageRenderAttributes();
            XpColorOverlay co = imageRenderAttributes.getColorOverlay();
            if (co != null) {
                XpCPI.setBitmapDisplayShutter(co, 0, cpi);
            }
            List[] rois = new List[1];
            int idx = ((XpCompositePort)xpViewport).getSelectedSceneIndex();
            if (idx != -1 && (idx < startImg - 1 || idx >= startImg - 1 + numImages)) {
                idx = startImg - 1;
            }
            XpImageScene rsc = ((XpCompositePort)xpViewport).getScene(idx);
            rois[0] = rsc.getRois();
            Shape ics = null;
            for (RoiActor ra : rois[0]) {
                if (!(ra instanceof XpClipRoiActor)) continue;
                ics = ((XpClipRoiActor)ra).getImageClip();
                break;
            }
            if (ics != null) {
                XpCPI.addDisplayShutter(ics, 0, 0, cpi);
            }
            XpDMgsps gspsFactory = new XpDMgsps(imgs, cpi, refObject);
            return gspsFactory.getGSPS(overrides);
        }
        return null;
    }

    private static InputStream saveStateForSingleImage(XpViewport xpViewport, DMObject refObject, XpDicomElement[] overrides, int index) {
        XpImage image = null;
        if (xpViewport instanceof FrameCapable) {
            XpDMgsps gsps;
            InputStream gspsStream;
            XpColorOverlay co;
            image = ((FrameCapable)((Object)xpViewport)).getFrame(index);
            int imageHeight = image.getSlice().height;
            int imageWidth = image.getSlice().width;
            Dimension dimension = new Dimension(imageHeight, imageWidth);
            XpMedicalImage[] imgs = new XpMedicalImage[1];
            XpImageRenderAttributes[] iras = new XpImageRenderAttributes[1];
            List[] rois = new List[1];
            List[] uannos = new List[1];
            imgs[0] = (XpMedicalImage)image;
            if (xpViewport instanceof XpImageRenderAttributesOwner) {
                iras[0] = ((XpImageRenderAttributesOwner)((Object)xpViewport)).getImageRenderAttributes();
            }
            if (xpViewport instanceof ROICapable) {
                rois[0] = ((ROICapable)((Object)xpViewport)).getRois();
            }
            if (xpViewport instanceof UserAnnoCapable) {
                uannos[0] = ((UserAnnoCapable)((Object)xpViewport)).getUserAnnos();
            }
            XpCPI cpi = XpCPI.createCPI(imgs, iras, rois, uannos, dimension, false, false);
            if (iras[0] != null && (co = iras[0].getColorOverlay()) != null) {
                XpCPI.setBitmapDisplayShutter(co, 0, cpi);
            }
            Shape ics = null;
            for (RoiActor ra : rois[0]) {
                if (!(ra instanceof XpClipRoiActor)) continue;
                ics = ((XpClipRoiActor)ra).getImageClip();
                break;
            }
            if (ics != null) {
                XpCPI.addDisplayShutter(ics, 0, 0, cpi);
            }
            if ((gspsStream = (gsps = new XpDMgsps(imgs, cpi, refObject)).getGSPS(overrides)) != null) {
                return gspsStream;
            }
            return null;
        }
        return null;
    }

    private static XpMedicalImage[] getRefImages(DMObject gspsObject, boolean allImages) {
        try {
            DMObject[] selectedDmo = null;
            if (allImages) {
                selectedDmo = CPIUtils.getSerImages(gspsObject);
            } else {
                DMSession session = gspsObject.getSession();
                Object seqObj = gspsObject.getValue(40, 12560);
                if (seqObj instanceof DMSequence) {
                    DMiSequence peer = ((DMSequence)seqObj).getPeer();
                    int count = peer.getNumberOfItems();
                    selectedDmo = new DMObject[count];
                    int ctr = 0;
                    DMObject[] dmos = null;
                    for (int i = 0; i < count; ++i) {
                        DMQuery dmq;
                        DMiSeqItem item;
                        Object val;
                        Object obj = peer.getValue(i, new DMTag(8, 4416));
                        if (!(obj instanceof DMiSequence) || (val = (item = ((DMiSequence)obj).getItem(0)).getValue(new DMTag(8, 4437))) == null || (dmos = session.getRelated("image", dmq = new DMQuery("(0x0008,0x0018) = " + val))) == null || dmos.length <= 0) continue;
                        selectedDmo[ctr] = dmos[0];
                        ++ctr;
                    }
                }
            }
            XpMedicalImage[] imgs = CPIUtils.getXpImages(selectedDmo);
            return imgs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DMObject[] getRefDMObjects(DMComposite gspsObject) {
        DMSession session = gspsObject.getSession();
        Object seqObj = gspsObject.getValue(40, 12560);
        if (seqObj instanceof DMSequence) {
            DMiSequence peer = ((DMSequence)seqObj).getPeer();
            int count = peer.getNumberOfItems();
            DMObject[] selectedDmo = new DMObject[count];
            int ctr = 0;
            DMObject[] dmos = null;
            for (int i = 0; i < count; ++i) {
                DMQuery dmq;
                DMiSeqItem item;
                Object val;
                Object obj = peer.getValue(i, new DMTag(8, 4416));
                if (!(obj instanceof DMiSequence) || (val = (item = ((DMiSequence)obj).getItem(0)).getValue(new DMTag(8, 4437))) == null || (dmos = session.getRelated("image", dmq = new DMQuery("(0x0008,0x0018) = " + val))) == null || dmos.length <= 0) continue;
                selectedDmo[ctr] = dmos[0];
                ++ctr;
            }
            return selectedDmo;
        }
        return null;
    }

    private static XpMedicalImage[] getXpImages(DMObject[] dmo) {
        if (dmo == null || dmo.length == 0) {
            return null;
        }
        DMImage[] imgs = CPIUtils.getDMImages(dmo, null);
        if (imgs == null || imgs.length == 0) {
            return null;
        }
        XpMedicalImage[] xpimgs = new XpMedicalImage[imgs.length];
        if (imgs == null || imgs.length == 0) {
            return null;
        }
        for (int i = 0; i < imgs.length; ++i) {
            xpimgs[i] = new XpMedicalDmImage(imgs[i]);
        }
        return xpimgs;
    }

    private static DMImage[] getDMImages(DMObject[] dmos, DMTag[] tags) {
        ArrayList imgs = new ArrayList();
        CPIUtils.getDMImagesList(dmos, tags, imgs);
        if (imgs.size() == 0) {
            return null;
        }
        return imgs.toArray(new DMImage[imgs.size()]);
    }

    private static void getDMImagesList(DMObject[] dmos, DMTag[] tags, List dmimgs) {
        if (dmos == null || dmos.length == 0 || dmimgs == null) {
            return;
        }
        dmimgs.clear();
        for (int i = 0; i < dmos.length; ++i) {
            DMObject[] imgs = dmos[i].getRelated("image");
            if (imgs == null || imgs.length <= 0) continue;
            for (int j = 0; j < imgs.length; ++j) {
                DMImage[] dmis = imgs[j].getImages(tags);
                if (dmis == null || dmis.length <= 0) continue;
                for (int k = 0; k < dmis.length; ++k) {
                    dmimgs.add(dmis[k]);
                }
            }
        }
    }

    private static DMObject[] getSerImages(DMObject gspsObject) {
        DMSession session = gspsObject.getSession();
        Object seqObj = gspsObject.getValue(40, 12560);
        if (seqObj instanceof DMSequence) {
            DMiSeqItem item;
            Object val;
            DMiSequence peer = ((DMSequence)seqObj).getPeer();
            DMObject[] dmos = null;
            Object obj = peer.getValue(0, new DMTag(8, 4416));
            if (obj instanceof DMiSequence && (val = (item = ((DMiSequence)obj).getItem(0)).getValue(new DMTag(8, 4437))) != null) {
                DMQuery dmq = new DMQuery("(0x0008,0x0018) = " + val);
                dmos = session.getRelated("image", dmq);
                String refSerUID = (String)dmos[0].getValue(32, 14);
                dmq = new DMQuery("(0x0020,0x000E) = " + refSerUID);
                return session.getRelated("image", dmq);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveGSPSToFile(InputStream gspsDicomStream, DMObject refObject) throws IOException {
        String serid = "v" + refObject.getValue(32, 17).toString().trim() + ".prdc";
        String path = refObject.getComposites()[0].getFilePath();
        FileLock _lock = null;
        File newFile = null;
        RandomAccessFile raf = null;
        try {
            File file = new File(path);
            newFile = new File(file.getParentFile(), serid);
            if (!newFile.exists()) {
                newFile.createNewFile();
            }
            raf = new RandomAccessFile(newFile, "rw");
            _lock = raf.getChannel().lock();
            int len = 1;
            while (len != -1) {
                len = gspsDicomStream.read(bbuff);
                if (len <= 0) continue;
                raf.write(bbuff, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (_lock != null) {
                _lock.release();
            }
            if (raf != null) {
                raf.close();
            }
            gspsDicomStream.close();
        }
        return newFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveVignetteFiles(XpViewport cpiViewport) {
        if (cpiViewport instanceof XpCompositePort) {
            String vignetteFilePath = null;
            XpCompositePort comport = (XpCompositePort)cpiViewport;
            int numScenes = comport.getNumScenes();
            for (int i = 0; i < numScenes; ++i) {
                XpImageScene scene = comport.getScene(i);
                XpImage frame = scene.getFrame();
                if (!(frame instanceof XpMedicalDmImage)) {
                    return false;
                }
                String imgPath = ((XpMedicalDmImage)frame).getDMImage().getFilePath();
                vignetteFilePath = CPIUtils.getVignetteFilePath(imgPath);
                if (vignetteFilePath == null) continue;
                FileOutputStream fo = null;
                FilterOutputStream os = null;
                try {
                    fo = new FileOutputStream(vignetteFilePath);
                    os = new DataOutputStream(fo);
                    XpImageRenderAttributes ira = scene.getImageRenderAttributes();
                    String state = CPIUtils.getState(ira);
                    ByteBuffer bbuf = ByteBuffer.wrap(VIGNETTE_SIGNATURE.getBytes());
                    os.write(bbuf.array());
                    bbuf = ByteBuffer.wrap(CPIUtils.intToByteArray(2));
                    bbuf.order(ByteOrder.LITTLE_ENDIAN);
                    os.write(bbuf.array());
                    bbuf = ByteBuffer.wrap(CPIUtils.intToByteArray(state.length()));
                    bbuf.order(ByteOrder.LITTLE_ENDIAN);
                    os.write(bbuf.array());
                    bbuf = ByteBuffer.wrap(state.getBytes());
                    os.write(bbuf.array());
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    boolean bl = false;
                    return bl;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        os.close();
                        fo.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static byte[] intToByteArray(int i) {
        byte[] barray = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
        return barray;
    }

    private static String getState(XpImageRenderAttributes ira) {
        double winScale = 0.0;
        double winBias = 0.0;
        String value = "SB" + winScale + File.separator + winBias + ":Z" + ira.getZoom() + ":P" + ira.getPanX() + "," + ira.getPanY() + "\nwindowing" + " " + ira.getWindowWidth() + " " + ira.getWindowLevel() + "\n";
        return value;
    }

    private static String getVignetteFilePath(String imgPath) {
        String vDir;
        if (imgPath == null) {
            return null;
        }
        int index = imgPath.indexOf("images");
        String vpesipath = imgPath.substring(index + 6).replace("i", "v");
        String sdcImgPoolPath = System.getenv("SdC_IMAGE_POOL");
        String string = vDir = sdcImgPoolPath != null ? sdcImgPoolPath + File.separator + "meta" : null;
        if (vDir == null) {
            vDir = System.getProperty("VIGNETTE_DIR", System.getProperty("java.io.tmpdir"));
        }
        int len = vDir.length();
        String vpath = vDir + vpesipath;
        String path = vpath.substring(0, vpath.indexOf("v", len));
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        File vfile = new File(vpath);
        logger.log(Level.WARNING, "vpath :: " + vpath);
        boolean success = false;
        if (!vfile.exists()) {
            try {
                success = vfile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!success) {
            logger.log(Level.WARNING, "Could not create Vignette file");
            return null;
        }
        return vfile.getAbsolutePath();
    }
}

