/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.roi;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DefaultHandleFactory;
import com.ge.med.cse.cvf.util.HandleFactory;
import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpUserAnnotationVc;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpAnnotationPolicy;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class CvUserAnnotationModel
extends XpUserAnnotationModel {
    public static Color unselectionTextColor = CvUtils.getColor(CvPropertiesManager.getProperty("cvf.userAnnotation.unselectionColor", "white"));
    private UaDragListener uaDragListenr = new UaDragListener();
    private UaMouseListener uaMouseListenr = new UaMouseListener();
    public static Shape MOVEHANDLE_CROSSHAIR = new DefaultHandleFactory().getHandleShape(HandleFactory.HandleStyle.CROSSHAIR);
    public static Shape MOVEHANDLE_ANGLECROSSHAIR = new DefaultHandleFactory().getHandleShape(HandleFactory.HandleStyle.ANGLECROSSHAIR);
    public static Shape MOVEHANDLE_BOX = new DefaultHandleFactory().getHandleShape(HandleFactory.HandleStyle.BOX);
    public static Shape MOVEHANDLE_CONTAINMENT = new DefaultHandleFactory().getContainmentShape();
    public static Shape userAnnotationMoveHandleShape;
    public static boolean resizeTextAreaEnable;
    public static boolean autoResizeEnable;
    public static boolean showUnSelectedBorder;
    private boolean edited = false;
    private boolean isDirty = false;
    private TextEditListener textEditListener = new TextEditListener();
    private UaFocusListener uaFocusListener = new UaFocusListener();

    public CvUserAnnotationModel(String text, CPoint textAnchor, CPoint target) {
        super(text, textAnchor, target);
        this.addMouseMotionListener(this.uaDragListenr);
        this.addMouseListener(this.uaMouseListenr);
        this.setUnselectedColor(unselectionTextColor);
    }

    public Object clone() {
        CvUserAnnotationModel uam = new CvUserAnnotationModel("", null, null);
        this.copyObject(uam);
        uam.setUnselectedColor(unselectionTextColor);
        uam.setTextEdited(this.isTextEdited());
        return uam;
    }

    protected void copyObject(Object o) {
        super.copyObject(o);
    }

    public void setSelected(boolean selection) {
        super.setSelected(selection);
        if (!selection && this.getUserAnnotationVc() != null) {
            this.getUserAnnotationVc().getTextArea().select(-1, -1);
        } else if (selection && this.getUserAnnotationVc() != null) {
            this.getUserAnnotationVc().getTextArea().select(this.getText().length(), this.getText().length());
        }
    }

    public void setUserAnnotationVc(XpUserAnnotationVc new_uavc) {
        int i;
        List mlsnrs;
        XpUserAnnotationVc vc;
        if (this.getUserAnnotationVc() != null) {
            vc = this.getUserAnnotationVc();
            vc.getTextArea().removeKeyListener(this.textEditListener);
            vc.removeFocusListener(this.uaFocusListener);
            vc.getTextArea().removeFocusListener(this.uaFocusListener);
            mlsnrs = this.getMouseListeners();
            if (mlsnrs != null) {
                for (i = 0; i < mlsnrs.size(); ++i) {
                    vc.removeMouseListener((MouseListener)mlsnrs.get(i));
                }
            }
        }
        super.setUserAnnotationVc(new_uavc);
        if (this.getUserAnnotationVc() != null) {
            vc = this.getUserAnnotationVc();
            vc.getTextArea().setLineWrap(true);
            vc.getTextArea().addKeyListener(this.textEditListener);
            vc.addFocusListener(this.uaFocusListener);
            vc.getTextArea().addFocusListener(this.uaFocusListener);
            mlsnrs = this.getMouseListeners();
            if (mlsnrs != null) {
                for (i = 0; i < mlsnrs.size(); ++i) {
                    vc.addMouseListener((MouseListener)mlsnrs.get(i));
                }
            }
        }
    }

    public Font getFont() {
        Component mivc;
        XpUserAnnotationVc uavc = this.getUserAnnotationVc();
        if (uavc != null && (mivc = uavc.findParentByClass(uavc, XpMedicalImage2DVc.class)) != null) {
            XpAnnotationPolicy ap = XpAnnotationModel.getAnnotationPolicy();
            Font afont = ap.getAnnotationFont(mivc.getWidth(), mivc.getHeight());
            Font tfont = this.getUserAnnotationVc().getTextArea().getFont();
            if (afont.getSize() != tfont.getSize()) {
                Font newFont = tfont.deriveFont(afont.getSize2D());
                this.setFont(newFont);
                return newFont;
            }
        }
        return super.getFont();
    }

    public void configUserAnnotation() {
        XpUserAnnotationVc uavc = this.getUserAnnotationVc();
        if (uavc == null) {
            return;
        }
        JTextArea textArea = uavc.getTextArea();
        if (this.isSelected()) {
            textArea.setCaretColor(this.getSelectedColor());
            textArea.setForeground(this.getSelectedColor());
            textArea.setBorder(this.getSelectedBorder());
            textArea.setEditable(true);
            textArea.setFocusable(true);
        } else {
            textArea.setEditable(false);
            textArea.setForeground(this.getUnselectedColor());
            if (this.isShowUnSelectedBorder()) {
                textArea.setBorder(this.getUnselectedBorder());
            } else {
                textArea.setBorder(null);
            }
            textArea.setFocusable(false);
            this.wrapToText(textArea);
        }
    }

    private void wrapToText(JTextArea textArea) {
        int lineCount = textArea.getLineCount();
        int maxLineLen = 0;
        int boxWidth = (int)textArea.getSize().getWidth();
        int[] charWidths = textArea.getFontMetrics(textArea.getFont()).getWidths();
        for (int i = 0; i < lineCount; ++i) {
            try {
                String text = textArea.getText(textArea.getLineStartOffset(i), textArea.getLineEndOffset(i) - textArea.getLineStartOffset(i));
                int len = textArea.getFontMetrics(textArea.getFont()).stringWidth(text);
                if (len <= maxLineLen) continue;
                maxLineLen = len;
                continue;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        Arrays.sort(charWidths);
        if (boxWidth <= charWidths[charWidths.length - 1]) {
            boxWidth = charWidths[charWidths.length - 1];
        }
        if (maxLineLen >= boxWidth) {
            maxLineLen = boxWidth;
        }
        this.resizeTextArea(maxLineLen, textArea.getSize().height);
    }

    public void keyPressed(KeyEvent e) {
        this.getUserAnnotationVc().repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CvUserAnnotationModel.this.getUserAnnotationVc() != null) {
                    CvUserAnnotationModel.this.getUserAnnotationVc().getTextArea().requestFocusInWindow();
                }
            }
        });
    }

    public void resizeTextArea(int width, int height) {
        Dimension di = new Dimension(width, height);
        if (this.getUserAnnotationVc() != null) {
            this.getUserAnnotationVc().getTextArea().setSize(di);
        }
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setTextEdited(boolean textEdited) {
        this.edited = textEdited;
    }

    private boolean isTextEdited() {
        return this.edited;
    }

    public boolean isResizeTextAreaEnable() {
        return resizeTextAreaEnable;
    }

    public void setResizeTextAreaEnable(boolean resizeTextAreaEnable) {
        CvUserAnnotationModel.resizeTextAreaEnable = resizeTextAreaEnable;
    }

    public boolean isAutoResizeEnable() {
        return autoResizeEnable;
    }

    public void setAutoResizeEnable(boolean autoResizeEnable) {
        CvUserAnnotationModel.autoResizeEnable = autoResizeEnable;
    }

    public void editUserAnnotation(String defaultText, CvUserAnnotationModel uam) {
        if (!uam.getUserAnnotationVc().getText().equalsIgnoreCase(defaultText)) {
            uam.setTextEdited(true);
        }
    }

    public boolean isShowUnSelectedBorder() {
        return showUnSelectedBorder;
    }

    public Shape getMoveHandleShape(int width, int height) {
        if (userAnnotationMoveHandleShape == MOVEHANDLE_CROSSHAIR) {
            return MOVEHANDLE_CROSSHAIR;
        }
        if (userAnnotationMoveHandleShape == MOVEHANDLE_ANGLECROSSHAIR) {
            return MOVEHANDLE_ANGLECROSSHAIR;
        }
        if (userAnnotationMoveHandleShape == MOVEHANDLE_CONTAINMENT) {
            return MOVEHANDLE_CONTAINMENT;
        }
        return MOVEHANDLE_BOX;
    }

    public static CvUserAnnotationModel getCVUserAnnotationModel(CPoint textAnchor, CPoint target) {
        String defaultText = CvPropertiesManager.getProperty("cvf.userAnnotation.defaultText", "");
        CvUserAnnotationModel.setUserAnnotationHandleShape(MOVEHANDLE_BOX);
        CvUserAnnotationModel uam = new CvUserAnnotationModel(defaultText, textAnchor, target);
        if (uam.getUserAnnotationVc() != null && uam.isResizeTextAreaEnable()) {
            int width = Integer.parseInt(CvPropertiesManager.getProperty("cvf.userAnnotation.resizeTextArea.minwidth", "60"));
            int height = Integer.parseInt(CvPropertiesManager.getProperty("cvf.userAnnotation.resizeTextArea.minheight", "20"));
            uam.resizeTextArea(width, height);
        } else if (uam.getUserAnnotationVc() != null && !uam.isResizeTextAreaEnable()) {
            if (uam.isAutoResizeEnable()) {
                uam.setAutoResize(true);
            } else {
                uam.setAutoResize(false);
            }
        }
        return uam;
    }

    public static Shape getUserAnnotationHandleShape() {
        return userAnnotationMoveHandleShape;
    }

    public static void setUserAnnotationHandleShape(Shape userAnnotationHandleShape) {
        userAnnotationMoveHandleShape = userAnnotationHandleShape;
    }

    static {
        resizeTextAreaEnable = Boolean.getBoolean(CvPropertiesManager.getProperty("cvf.userAnnotation.defaultTextShown", "true"));
        autoResizeEnable = Boolean.getBoolean(CvPropertiesManager.getProperty("cvf.userAnnotation.autoResize", "false"));
        showUnSelectedBorder = Boolean.getBoolean(CvPropertiesManager.getProperty("cvf.userAnnotation.showUnselectedBorder", "true"));
        XpAppContext.setShadowed(true);
    }

    class UaMouseListener
    extends MouseAdapter
    implements Serializable {
        UaMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            CvUserAnnotationModel.this.setAutoResize(false);
        }

        public void mouseReleased(MouseEvent e) {
            CvUserAnnotationModel.this.setAutoResize(true);
        }
    }

    class UaFocusListener
    implements FocusListener,
    Serializable {
        UaFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            XpUserAnnotationVc uavc;
            UserAnnoCapable uac;
            if (e.getOppositeComponent() instanceof XpUserAnnotationVc || e.getOppositeComponent() instanceof JTextComponent) {
                return;
            }
            if (e.getOppositeComponent() != null && e.getOppositeComponent() instanceof JFrame && CvUserAnnotationModel.this.isSelected() && CvUserAnnotationModel.this.isVisible()) {
                e.getComponent().requestFocusInWindow();
            } else if ((CvUserAnnotationModel.this.getText() == null || CvUserAnnotationModel.this.getText().trim().length() == 0) && CvUserAnnotationModel.this.getUserAnnotationVc() != null && (uac = (UserAnnoCapable)((Object)(uavc = CvUserAnnotationModel.this.getUserAnnotationVc()).findParentByClass(uavc, UserAnnoCapable.class))) != null) {
                uac.remove(CvUserAnnotationModel.this);
            }
        }
    }

    class TextEditListener
    extends KeyAdapter
    implements Serializable {
        TextEditListener() {
        }

        public void keyTyped(KeyEvent e) {
            JTextArea textarea = (JTextArea)e.getSource();
            if (!CvUserAnnotationModel.this.isTextEdited()) {
                textarea.setText("");
                CvUserAnnotationModel.this.setTextEdited(true);
            } else {
                textarea.setCaretPosition(textarea.getCaretPosition());
            }
        }

        private void deleteTheSelectable(Selectable s, Object source) {
            UserAnnoCapable uac;
            XpUserAnnotationModel uam = null;
            XpUserAnnotationVc uavc = null;
            try {
                uam = (XpUserAnnotationModel)s;
                uavc = uam.getUserAnnotationVc();
            }
            catch (ClassCastException exp) {
                return;
            }
            if (uavc != null && (uac = (UserAnnoCapable)((Object)uavc.findParentByClass(uavc, UserAnnoCapable.class))) != null) {
                uac.remove(uam);
            }
        }
    }

    class UaDragListener
    extends MouseMotionAdapter
    implements Serializable {
        UaDragListener() {
        }

        public void mouseDragged(MouseEvent e) {
            CPoint textAnchor = CvUserAnnotationModel.this.getTextAnchor();
            if (textAnchor.x < 0.01) {
                CvUserAnnotationModel.this.setTextAnchor(new CPoint(0.01, CvUserAnnotationModel.this.getTextAnchor().y, 0.0, 3));
            } else if (textAnchor.x > 0.98) {
                CvUserAnnotationModel.this.setTextAnchor(new CPoint(0.98, CvUserAnnotationModel.this.getTextAnchor().y, 0.0, 3));
            } else if (textAnchor.y < 0.01) {
                CvUserAnnotationModel.this.setTextAnchor(new CPoint(CvUserAnnotationModel.this.getTextAnchor().x, 0.01, 0.0, 3));
            } else if (textAnchor.y > 0.98) {
                CvUserAnnotationModel.this.setTextAnchor(new CPoint(CvUserAnnotationModel.this.getTextAnchor().x, 0.98, 0.0, 3));
            }
        }
    }
}

